#!/bin/sh

set -e

readonly version="0.21.2"
readonly sha256sum="422912aa851458bc9bf37a458b75890cb5a4e2a7e5216dcee7df91507fc594d9"
readonly basename="cargo-audit-x86_64-unknown-linux-musl-v$version"
readonly filename="$basename.tgz"

cd .gitlab

echo "$sha256sum  $filename" > cargo-audit.sha256sum
curl -OL "https://github.com/rustsec/rustsec/releases/download/cargo-audit%2Fv$version/$filename"
sha256sum --check cargo-audit.sha256sum
tar --strip-components=1 -xf "$filename" "$basename/cargo-audit"
chmod +x cargo-audit
