'\"
'\" Copyright (c) 1992-1995 Karl Lehenbauer and Mark Diekhans.
'\" Copyright (c) 1995-1997 Sun Microsystems, Inc.
'\" Copyright (c) 1998-1999 Scriptics Corporation
'\" Copyright (c) 2002 ActiveState Corporation
'\"
'\" This documentation is derived from the time and date facilities of
'\" TclX, by Mark Diekhans and Karl Lehenbauer.
'\" 
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) Id
'\" 
.so man.macros
.TH clock n 8.4 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
clock \- Obtain and manipulate time
.SH SYNOPSIS
\fBclock \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command performs one of several operations that may obtain
or manipulate strings or values that represent some notion of
time.  The \fIoption\fR argument determines what action is carried
out by the command.  The legal \fIoptions\fR (which may be
abbreviated) are:
.TP
.VS 8.3
\fBclock clicks\fR ?\fB\-milliseconds\fR?
Return a high-resolution time value as a system-dependent integer
value.  The unit of the value is system-dependent but should be the
highest resolution clock available on the system such as a CPU cycle
counter. If \fB\-milliseconds\fR is specified, then the value is
guaranteed to be of millisecond granularity.
This value should only be used for the relative measurement
of elapsed time.
.VE 8.3
.TP
\fBclock format \fIclockValue\fR ?\fB\-format \fIstring\fR? ?\fB\-gmt \fIboolean\fR?
Converts an integer time value, typically returned by
\fBclock seconds\fR, \fBclock scan\fR, or the \fBatime\fR, \fBmtime\fR,
or \fBctime\fR options of the \fBfile\fR command, to human-readable
form.  If the \fB\-format\fR argument is present the next argument is a
string that describes how the date and time are to be formatted.
Field descriptors consist of a \fB%\fR followed by a field
descriptor character.  All other characters are copied into the result.
Valid field descriptors are:
.RS
.IP \fB%%\fR
Insert a %.
.IP \fB%a\fR
Abbreviated weekday name (Mon, Tue, etc.).
.IP \fB%A\fR
Full weekday name (Monday, Tuesday, etc.).
.IP \fB%b\fR
Abbreviated month name (Jan, Feb, etc.).
.IP \fB%B\fR
Full month name.
.VS 8.4
.IP \fB%c\fR
Locale specific date and time.  The format for date and time
in the default "C" locale on Unix/Mac is "%a %b %d %H:%M:%S %Y".
On Windows, this value is the locale specific long date and time, as
specified in the Regional Options control panel settings.
.IP \fB%C\fR
First two digits of the four-digit year (19 or 20).
.VE 8.4
.IP \fB%d\fR
Day of month (01 - 31).
.VS 8.4
'\" Since the inclusion of compat/strftime.c, %D, %e, %h should work on all
'\" platforms.
.IP \fB%D\fR
Date as %m/%d/%y.
.IP \fB%e\fR
Day of month (1 - 31), no leading zeros.
.IP \fB%h\fR
Abbreviated month name.
.VE 8.4
.IP \fB%H\fR
Hour in 24-hour format (00 - 23).
.VS 8.4
.IP \fB%I\fR
Hour in 12-hour format (01 - 12).
.VE 8.4
.IP \fB%j\fR
Day of year (001 - 366).
.VS 8.4
.IP \fB%k\fR
Hour in 24-hour format, without leading zeros (0 - 23).
.IP \fB%l\fR
Hour in 12-hour format, without leading zeros (1 - 12).
.VE 8.4
.IP \fB%m\fR
Month number (01 - 12).
.IP \fB%M\fR
Minute (00 - 59).
.VS 8.4
.IP \fB%n\fR
Insert a newline.
.VE 8.4
.IP \fB%p\fR
AM/PM indicator.
.VS 8.4
.IP \fB%r\fR
Time in a locale-specific "meridian" format.  The "meridian"
format in the default "C" locale is "%I:%M:%S %p".
.IP \fB%R\fR
Time as %H:%M.
.IP \fB%s\fR
Count of seconds since the epoch, expressed as a decimal integer.
.VE 8.4
.IP \fB%S\fR
Seconds (00 - 59).
.VS 8.4
.IP \fB%t\fR
Insert a tab.
.IP \fB%T\fR
Time as %H:%M:%S.
.IP \fB%u\fR
Weekday number (Monday = 1, Sunday = 7).
.VE 8.4
.IP \fB%U\fR
Week of year (00 - 52), Sunday is the first day of the week.
.VS 8.4
.IP \fB%V\fR
Week of year according to ISO-8601 rules.  Week 1 of a given
year is the week containing 4 January.
.IP \fB%w\fR
Weekday number (Sunday = 0, Saturday = 6).
.VE 8.4
.IP \fB%W\fR
Week of year (00 - 52), Monday is the first day of the week.
.VS 8.4
.IP \fB%x\fR
Locale specific date format.  The format for a date in the default "C"
locale for Unix/Mac is "%m/%d/%y".
On Windows, this value is the locale specific short date format, as
specified in the Regional Options control panel settings.
.IP \fB%X\fR
Locale specific 24-hour time format.  The format for a 
24-hour time in the default "C" locale for Unix/Mac is "%H:%M:%S".
On Windows, this value is the locale specific time format, as
specified in the Regional Options control panel settings.
.VE 8.4
.IP \fB%y\fR
Year without century (00 - 99).
.IP \fB%Y\fR
Year with century (e.g. 1990)
.IP \fB%Z\fR
Time zone name.
.RE
.VS 8.4
.sp
'\" All the field descriptors should be portable now that
'\" compat/strftime.c is in place, with the possible exception
'\" of the time zone name.
'\".RS
'\"In addition, the following field descriptors may be supported on some
'\"systems (e.g. Unix but not Windows):
'\".IP \fB%D\fR
'\"Date as %m/%d/%y.
'\".IP \fB%e\fR
'\"Day of month (1 - 31), no leading zeros.
'\".IP \fB%h\fR
'\"Abbreviated month name.
'\".IP \fB%n\fR
'\"Insert a newline.
'\".IP \fB%r\fR
'\"Time as %I:%M:%S %p.
'\".IP \fB%R\fR
'\"Time as %H:%M.
'\".IP \fB%t\fR
'\"Insert a tab.
'\".IP \fB%T\fR
'\"Time as %H:%M:%S.
'\".RE
'\".sp
.VE 8.4
.RS
If the \fB\-format\fR argument is not specified, the format string 
\fB"%a %b %d %H:%M:%S %Z %Y"\fR is used.  If the \fB\-gmt\fR argument
is present the next argument must be a boolean which if true specifies
that the time will be formatted as Greenwich Mean Time. If false
then the local timezone will be used as defined by the operating
environment.
.RE
.TP
\fBclock scan \fIdateString\fR ?\fB\-base \fIclockVal\fR? ?\fB\-gmt \fIboolean\fR?
Convert \fIdateString\fR to an integer clock value (see \fBclock seconds\fR).
This command can parse and convert virtually any standard date and/or time
string, which can include standard time zone mnemonics.  If only a time is
specified, the current date is assumed.  If the string does not contain a
time zone mnemonic, the local time zone is assumed, unless the \fB\-gmt\fR 
argument is true, in which case the clock value is calculated assuming
that the specified time is relative to Greenwich Mean Time.
\fB-gmt\fR, if specified, affects only the computed time value; it does not
impact the interpretation of \fB-base\fR.
.sp
If the \fB\-base\fR flag is specified, the next argument should contain
an integer clock value.  Only the date in this value is used, not the
time.  This is useful for determining the time on a specific day or
doing other date-relative conversions.
.sp
The \fIdateString\fR consists of zero or more specifications of the
following form:
.RS
.TP
\fItime\fR
A time of day, which is of the form: \fIhh\fR?\fI:mm\fR?\fI:ss\fR?? 
?\fImeridian\fR? ?\fIzone\fR? or \fIhhmm \fR?\fImeridian\fR? 
?\fIzone\fR?. If no meridian is specified, \fIhh\fR is interpreted on
a 24-hour clock.
.TP
\fIdate\fR
A specific month and day with optional year.  The
acceptable formats are \fImm/dd\fR?\fI/yy\fR?, \fImonthname dd\fR
?, \fIyy\fR?, \fIdd monthname \fR?\fIyy\fR?, \fIday, dd monthname
yy\fR, \fI?CC?yymmdd\fR, \fI?CC?yy-mm-dd\fR, \fIdd-monthname-?CC?yy\fR.
The default year is the current year.  If the year is less
.VS
than 100, we treat the years 00-68 as 2000-2068 and the years 69-99
as 1969-1999.  Not all platforms can represent the years 38-70, so
an error may result if these years are used.
.VE
.TP
\fIISO 8601 point-in-time\fR
An ISO 8601 point-in-time specification, such as \fICCyymmddThhmmss\fR, where
T is the literal T, \fICCyymmdd hhmmss\fR, or 
\fICCyymmddThh:mm:ss\fR.
.TP
\fIrelative time\fR
A specification relative to the current time.  The format is \fInumber
unit\fR acceptable units are \fByear\fR, \fBfortnight\fR, \fBmonth\fR, \fBweek\fR, \fBday\fR,
\fBhour\fR, \fBminute\fR (or \fBmin\fR), and \fBsecond\fR (or \fBsec\fR).  The
unit can be specified as a singular or plural, as in \fB3 weeks\fR.
These modifiers may also be specified:
\fBtomorrow\fR, \fByesterday\fR, \fBtoday\fR, \fBnow\fR,
\fBlast\fR, \fBthis\fR, \fBnext\fR, \fBago\fR.
.RE
.sp
.RS
The actual date is calculated according to the following steps.
First, any absolute date and/or time is processed and converted.
Using that time as the base, day-of-week specifications are added.
Next, relative specifications are used.  If a date or day is
specified, and no absolute or relative time is given, midnight is
used.  Finally, a correction is applied so that the correct hour of
the day is produced after allowing for daylight savings time
differences and the correct date is given when going from the end
of a long month to a short month.
.sp
Daylight savings time correction is applied only when the relative time
is specified in units of days or more, ie, days, weeks, fortnights, months or
years.  This means that when crossing the daylight savings time boundary,
different results will be given for \fBclock scan "1 day"\fR and
\fBclock scan "24 hours"\fR:
.CS
.ta 6c
\fB% clock scan "1 day" -base [clock scan 1999-10-31]
941443200
% clock scan "24 hours" -base [clock scan 1999-10-31]
941439600\fR
.CE
.RE
.TP
\fBclock seconds\fR
Return the current date and time as a system-dependent integer value.  The
unit of the value is seconds, allowing it to be used for relative time
calculations.  The value is usually defined as total elapsed time from
an ``epoch''.  You shouldn't assume the value of the epoch.

.SH "SEE ALSO"
date(1), time(n)

.SH KEYWORDS
clock, date, time
