/*=========================================================================

  Program:   ParaView
  Module:    vtkPVMPIProcessModule.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkPVMPIProcessModule
// .SECTION Description
// A class to encapaulate all of the process initialization,
// distributed data model and duplication  of the pipeline.
// Filters and compositers will still need a controller, 
// but every thing else should be handled here.  This class 
// sets up the default MPI processes with the user interface
// running on process 0.  I plan to make an alternative module
// for client server mode, where the client running the UI 
// is not in the MPI group but links to the MPI group through 
// a socket connection.

#ifndef __vtkPVMPIProcessModule_h
#define __vtkPVMPIProcessModule_h

#include "vtkPVProcessModule.h"
class vtkPVPart;
class vtkPVApplication;
class vtkMultiProcessController;
class vtkMapper;
class vtkDataSet;

class VTK_EXPORT vtkPVMPIProcessModule : public vtkPVProcessModule
{
public:
  static vtkPVMPIProcessModule* New();
  vtkTypeRevisionMacro(vtkPVMPIProcessModule,vtkPVProcessModule);
  void PrintSelf(ostream& os, vtkIndent indent);

  // ParaView.cxx (main) calls this method to setup the processes.
  // It currently creates the application, but I will try to pass
  // the application as an argument.  Start calls Initialize
  // which calls vtkPVApplication::Start();
  virtual int Start(int argc, char **argv);
  void Initialize();
  
  // Description:
  // This breaks rmi loops and cleans up processes.`                
  virtual void Exit();

  // Send the current vtkClientServerStream contents to the client.
  // Also reset the vtkClientServerStream object.
  virtual void SendStreamToClient();

  // Send the current vtkClientServerStream contents to the server.
  // Also reset the vtkClientServerStream object.
  virtual void SendStreamToServer();

  // Send the current vtkClientServerStream contents to the server
  // root node.  Also reset the vtkClientServerStream object.
  virtual void SendStreamToServerRoot();

  // Description:
  // Send current ClientServerStream data to the server and the client.
  // Also reset the vtkClientServerStream object.
  virtual void SendStreamToClientAndServer();

  // Description:
  // Send current ClientServerStream data to the server root and the client.
  // Also reset the vtkClientServerStream object.
  virtual void SendStreamToClientAndServerRoot();

  // Description:
  // A method for getting generic information from the server.
  virtual void GatherInformationInternal(const char* infoClassName,
                                         vtkObject* object);
    
  // Description:
  // Get the partition number. -1 means no assigned partition.
  virtual int GetPartitionId();

  // Description:
  // Get the number of processes participating in sharing the data.
  virtual int GetNumberOfPartitions();

  // Description:
  // Used internally.  Do not call.  Use LoadModule instead.
  virtual int LoadModuleInternal(const char* name);
protected:
  vtkPVMPIProcessModule();
  ~vtkPVMPIProcessModule();

  virtual void SendStreamToServerNodeInternal(int remoteId);
  virtual void SendStreamToServerInternal();

  // To pass arguments through controller single method.
  int    ArgumentCount;
  char** Arguments;
  int    ReturnValue;

private:  
  vtkPVMPIProcessModule(const vtkPVMPIProcessModule&); // Not implemented
  void operator=(const vtkPVMPIProcessModule&); // Not implemented
};

#endif
