/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License",
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

=========================================================================*/

#include "imstkMath.h"
#include "imstkLogger.h"
#include "imstkVecDataArray.h"

using namespace imstk;

std::pair<std::shared_ptr<VecDataArray<double, 3>>, std::shared_ptr<VecDataArray<int, 3>>>
getBunny()
{
    std::vector<double> buffVertices
    {
        -7.54836941, 4.80296516, 3.98409724,
        1.96049738, 2.10436249, 3.07408285,
        -7.51325989, 4.28600407, 4.48443222,
        4.00396872, 0.531559169, 1.09580469,
        -5.39809895, -5.83303165, 4.51194954,
        -0.916336358, 2.15743351, -1.10614133,
        4.07273054, 0.290464878, 1.93908608,
        -4.69352341, 5.76267767, 0.793864846,
        -1.01823282, 0.98005116, 4.21656132,
        -7.13229465, 6.36770296, -1.46091282,
        -4.30722046, 6.58275795, 0.386705339,
        -1.5027914, -5.65539932, 5.08153343,
        -7.79874754, 1.76831543, -0.489386469,
        -0.0882063061, 2.43317366, 3.31053686,
        -4.48883343, -5.78009129, 4.33845711,
        -2.26118922, -5.42806578, 5.12007523,
        0.135558411, -5.6130228, 4.75126076,
        -2.96750736, -1.13024569, -2.83392882,
        -2.51439023, 7.89432096, -0.991773784,
        -4.25442553, -5.2697525, 3.95192981,
        -3.47552657, 2.52875233, -0.26893428,
        -0.959657907, -5.38754129, 4.83199215,
        -7.49270296, 3.75889206, 4.86047983,
        -1.7969048, -5.2889533, 4.93717003,
        -1.27517247, -4.8903017, 4.96009922,
        -0.776118994, 2.32686782, 3.38570452,
        -2.09379339, -5.05825758, 4.67595816,
        3.0640645, -5.1852479, 3.3612442,
        3.85481, -5.02096748, 3.19320178,
        -2.53821015, 8.10519695, -1.63697946,
        -5.04848766, -5.19011688, 3.88091373,
        0.196377173, -4.72267771, 5.26748991,
        -5.88712931, 5.34011984, 2.88336277,
        -4.57634163, -4.37667847, 3.81409073,
        -4.00677395, -4.68520689, 3.88748741,
        -6.55612373, 5.94842339, -1.55851412,
        -0.643900573, -4.20360756, 5.39440155,
        -3.47420311, -4.40349913, 3.76745272,
        0.236023426, 1.112149, 4.1663065,
        -8.070961, 5.10526371, 3.25309324,
        -1.92450237, 1.91238284, 3.38199377,
        -6.25289726, 5.11347342, 3.50276566,
        -2.43237877, 8.31996155, -1.21801496,
        -7.4378767, 5.90609074, -0.816587925,
        -1.71815121, 1.35224319, 3.89853525,
        -3.7399807, 6.87897491, 0.0642780513,
        3.41443992, -3.96188283, 3.59480929,
        -3.82572579, -3.83834028, 3.99248838,
        -9.34880447, 1.94560337, 2.18091607,
        1.55363488, 2.88188791, 1.52055252,
        -6.28177357, 7.01224709, -5.06197023,
        1.40165555, 1.17583323, 3.92013717,
        -5.05560017, 3.57984495, 2.52188778,
        -3.15575957, -3.85094476, 3.81533718,
        0.974324346, -3.76870298, 5.37540483,
        -1.31990635, 2.46972871, 3.0112617,
        -1.87059104, 2.29811454, 2.92407823,
        -2.9048183, 7.58992863, -0.611207008,
        -3.83779836, 2.79239035, 0.376184583,
        3.92162085, -3.69458961, 3.19517088,
        -2.40380526, 2.65655971, 0.938035429,
        -3.34225893, -3.23092461, 3.95727396,
        0.0749290958, 3.09604096, 1.36592019,
        -4.98966122, -3.35614729, 3.72018456,
        3.60344601, 1.14953053, 2.04520941,
        0.330061555, -2.87174463, 5.61650085,
        -8.6582098, 0.345381916, 0.713565946,
        -6.03796196, -1.19784296, -1.93914032,
        -0.954714477, -3.36217046, 5.44244576,
        0.281574249, 3.05250263, 2.07566476,
        4.58991718, -3.44829249, 2.70706606,
        -4.69571686, -2.91438556, 4.12377977,
        -4.07773161, -3.11037612, 4.1101346,
        -2.58496881, -3.16543698, 4.24222612,
        4.32278633, -2.78755784, 2.65527582,
        0.00502982875, 2.8473537, 2.71001339,
        -1.04262221, 6.92363834, -1.93338561,
        -0.564059258, -2.55940557, 5.77119303,
        -6.7500596, 4.7093153, 3.99646044,
        -8.38701344, 0.311670542, 2.69915581,
        -5.33760452, -2.80676126, 4.01522779,
        -1.49980879, 1.8407495, 3.60841608,
        -7.99047947, 2.33541346, 5.16736746,
        -7.40868759, 3.16974425, 5.13347149,
        4.38950491, -0.433140516, 1.49193728,
        -7.53857279, 5.56625938, 1.56747425,
        -3.64962506, 7.4205184, -0.250189245,
        -6.26618814, -6.39552832, 4.21107531,
        0.198480844, -2.24771762, 5.67873526,
        -2.95403481, -2.2476182, 4.21315193,
        -3.22075391, 7.71841669, -0.577287793,
        -0.998007774, 1.59312439, 3.92220902,
        -2.88039017, 5.50749063, -0.449995995,
        -4.34655476, 2.65583467, 2.00491166,
        -3.0086422, 2.21958423, 2.4495225,
        -6.49106741, -1.52182007, 4.17248774,
        -5.37758493, -2.02442455, 4.32791615,
        -4.38605833, -1.798123, 4.29715967,
        -3.58939624, -2.37126017, 4.15427685,
        -8.5024519, 0.9826594, 2.35980916,
        -0.836105347, -1.72648859, 5.76800156,
        -0.252800703, -1.90409303, 5.72053719,
        -1.47801208, 6.24622822, -1.09099913,
        0.244940519, -1.39715505, 5.64762926,
        -6.55318069, 5.39229774, 3.06351352,
        -3.72315598, -1.328866, 4.38063669,
        -1.53286505, -1.63840914, 5.67083549,
        -0.255434632, 2.02001214, 3.69559073,
        0.766480923, -1.81639147, 5.57776737,
        -4.44147015, 1.65560269, 3.18821216,
        -6.9911375, 5.97947693, -0.802412331,
        -3.08318996, -1.48664796, 4.392869,
        -0.356970251, -1.27379906, 5.6845293,
        0.857996821, -0.742102504, 5.28840828,
        -7.77580452, 6.49865818, -2.73024607,
        -4.88938951, -0.704554796, 4.39227581,
        -4.21930552, -0.630669534, 4.23564672,
        -3.36440277, -0.930788159, 4.42191315,
        2.62727356, 2.24178886, 1.83274221,
        -0.947640777, -1.02858818, 5.6607666,
        -2.62991929, -0.931135833, 4.70709944,
        -0.384230137, -0.606512964, 5.49998808,
        0.0996810943, -0.737908483, 5.50991535,
        -0.934539795, 2.97602844, 1.45438457,
        -6.26621771, -0.582990587, 4.32428074,
        -3.69920254, -0.449534088, 4.30244684,
        -6.82400179, 5.59550953, 2.27250004,
        -6.51839876, 5.38545275, -0.360853642,
        -1.05891967, -0.433419764, 5.37190962,
        -3.1296792, 1.57493639, 3.31850481,
        2.12480736, 2.56648278, 1.92102933,
        -5.27430677, 4.86506271, 1.97360349,
        -2.89168572, -0.26089263, 4.43626404,
        1.66648483, -0.581014574, 4.85073805,
        4.76606321, -3.11211109, 2.4269712,
        -0.648907542, -0.0861278996, 4.95855904,
        -0.0827087834, -0.142789304, 5.0640831,
        0.488793075, -0.170482635, 5.02547073,
        1.09308124, -0.181077123, 4.87105656,
        -2.68962407, 8.05431938, -0.806348443,
        -4.2957201, 2.99642444, 0.811220706,
        -7.06887197, 6.70729303, -2.36165714,
        -1.85906208, 2.75792456, 1.26346374,
        -7.57954836, 5.10182428, -1.43196797,
        -5.45609474, 0.369486719, 4.12491083,
        -4.63847637, 0.265499175, 4.14757442,
        0.203205347, 0.0642428249, 4.64645958,
        1.16188335, 0.346654326, 4.56490231,
        -5.76780844, 5.47962379, 2.13588333,
        -7.19359922, 2.12160802, 5.24781227,
        -3.54731226, 0.269912034, 4.08688641,
        -2.62205315, 0.382106245, 4.24591351,
        0.233421758, 1.77240884, 3.82865906,
        3.08499146, 1.54988062, 2.70390058,
        0.193065181, 0.556862712, 4.31105947,
        0.661315084, 0.198507562, 4.5867033,
        -7.55081654, 2.60740805, 5.26459837,
        -6.37073231, 0.41034019, 4.0255475,
        -3.08854294, 0.760019064, 3.88439369,
        -2.33907056, 0.852297843, 4.03287983,
        1.55651343, 0.69292593, 4.18900156,
        -4.00096321, 7.03943682, 0.0981250852,
        2.43984652, 2.26208901, 2.35624051,
        -6.99865532, 0.72925669, 3.79853582,
        -5.75339746, 0.958138108, 3.77544451,
        -1.74878216, 0.626871645, 4.22783279,
        2.29284382, 0.670721948, 3.94473505,
        -5.75686836, 1.68426907, 3.75560451,
        1.93161249, 0.779425263, -1.6313858,
        -0.408745766, 1.34112215, 4.09016562,
        -0.414668292, 0.790702879, 4.32379103,
        0.839928865, 0.800645888, 4.10596895,
        1.85876501, 1.13225567, 3.83681297,
        -4.58089828, 6.16180897, 0.601297498,
        -2.42126369, 1.38766289, 3.61076188,
        -3.42393303, 7.44855165, -0.209693044,
        -6.54892063, 5.63245726, -0.817152619,
        0.853958547, 2.97303247, 2.21453071,
        -3.18716121, 7.08335543, -0.371214986,
        -4.23018789, 0.809024453, 3.74876547,
        -3.76892996, 1.24762404, 3.48775172,
        -5.4385581, 5.03909588, -0.206642985,
        -0.679836154, -5.92314768, 4.90963221,
        -4.56899023, -6.36914778, 4.42811584,
        2.18139195, -5.79989052, 3.85878015,
        -4.84383678, -6.01907063, 4.50043011,
        -3.95305037, 5.23591566, 0.393140018,
        -6.95611382, 0.61309278, -1.28307486,
        -4.98758888, 3.01162195, 2.91128302,
        -2.16287351, 7.65219593, -1.40347064,
        3.57254386, -0.769361079, 3.66987658,
        -1.8432548, 8.52760792, -1.71814656,
        -4.99558973, -5.67132807, 4.37342644,
        -4.08458042, 5.69005871, 0.582090497,
        -7.02803898, 3.48768902, 4.8305459,
        1.28338861, -5.34136486, 4.54505396,
        -5.44211292, 4.73043728, 2.59810138,
        -2.05653143, 8.21376419, -1.43682313,
        3.06379986, 0.413279593, 3.64316797,
        2.09722233, -4.84337854, 4.32287264,
        -5.41694307, 4.12076569, 2.84784174,
        -3.5621438, 6.5654459, -0.188066259,
        -3.50802135, 5.67058611, 0.246833086,
        -3.00588274, 5.86740065, 0.0988845974,
        -1.32401228, 7.24609327, -1.90650237,
        -6.85236835, 1.37095356, 4.55021954,
        0.936729491, 1.53460383, 3.82475567,
        -2.75492883, 7.28644657, -0.897606552,
        -2.82590365, 6.53225327, -0.644391477,
        2.11456776, -4.08437729, 4.68251514,
        4.97223091, -4.24118137, 3.01995373,
        -3.06809425, 6.04361629, -1.29013884,
        1.14747179, -4.57641792, 5.03971529,
        1.60596919, -4.18330574, 4.94988632,
        -6.71702385, 2.65214539, 4.89573193,
        3.18875909, -0.23916541, 3.87064981,
        -9.22232723, 1.97375584, 1.36243141,
        -1.94979084, 6.71212769, -1.15790296,
        -5.69489956, 4.57212687, 3.1485219,
        -4.68020725, 4.7344408, 0.826917231,
        -1.68359196, 6.0236187, -1.09259629,
        -6.48585558, 2.14693189, 4.52510738,
        -6.35749197, 4.12742424, 3.8406179,
        1.73406315, -3.40125155, 5.01371908,
        2.79422665, -4.20047617, 4.08659554,
        -6.91317511, 4.11609793, 4.45887756,
        5.73608446, -3.79211903, 2.24636626,
        -6.68642855, 3.4317584, 4.45735407,
        -2.23814702, 5.81700706, -0.651439071,
        -3.73506093, 6.03811169, 0.137039438,
        -5.39590931, 3.51470351, 3.11608124,
        5.19877005, -3.34494281, 2.60703182,
        3.70773697, 0.576628923, 2.74711943,
        5.92420578, -3.40066814, 1.61773968,
        4.09069347, -2.09435248, -0.906853557,
        -1.79726291, 5.97136307, -0.850080729,
        2.63073182, -3.18882537, 4.39389515,
        5.69938469, -3.21221733, 2.19987345,
        -6.2628231, 3.37056446, 3.82555079,
        3.89738274, -2.76906109, 3.36755657,
        3.37276268, -2.56767225, 3.97532511,
        -0.270506918, 0.0486412346, 4.60401821,
        4.19137239, -0.334491879, 2.45829201,
        -1.38452291, 6.64899349, -1.44014406,
        -4.21899843, 5.95890617, 0.474370629,
        2.15120864, -2.51341248, 4.95319462,
        -6.27778912, 4.75900173, -1.26152468,
        -1.68020225, 7.48099947, -1.7781167,
        1.38410246, -2.50661922, 5.40650892,
        4.28067207, -0.393683404, 0.360040963,
        -3.96529937, 6.36489344, 0.273011893,
        -4.29737902, 4.82259417, 0.401911169,
        -5.86204481, 4.02249765, 3.34933281,
        -5.17945147, 2.46902108, 3.39357543,
        1.70141673, 1.67804456, 3.59343839,
        4.15455198, -2.07084036, 2.89387012,
        -1.76636159, 6.26523924, -0.832332909,
        -4.98356247, 4.91385984, 1.20717597,
        2.06662083, -1.87115419, 5.02366304,
        3.68365097, -1.73029852, 3.64734864,
        -4.52642632, 5.24853945, 0.807371438,
        -6.39174271, 1.40057576, 4.09307671,
        -2.48440623, 6.1097331, -0.347498685,
        2.6075387, -2.00765324, 4.6549511,
        2.46771193, -0.132499903, 4.38793564,
        -5.04139423, 1.93466914, 3.22664714,
        -0.517580807, 0.822360754, -2.11358166,
        3.77061653, 0.63333261, 0.0136221256,
        2.21835804, -1.09313262, 4.81450462,
        -5.74485826, 3.41190958, 3.53385329,
        -5.17758512, 5.03834152, 1.52481604,
        -6.45575285, 1.08388937, 3.76784325,
        -5.46235371, 3.10173154, 3.39919901,
        1.51119149, -1.32410192, 5.20759201,
        3.12825537, -1.23301017, 4.30144215,
        3.67267799, -0.116349086, 3.26177406,
        -5.82993555, 2.51407647, 3.95771742,
        2.37314677, 1.45287347, 3.46581173,
        4.02298355, -1.02520895, 3.09727025,
        -2.27905083, 7.05137873, -1.21802831,
        1.76002741, 0.117811404, 4.57832479,
        -6.00959206, 4.59384918, 3.57769108,
        -1.7683444, 8.1132822, -1.73601329,
        3.10883951, 1.16975331, 3.07567382,
        -4.69927025, 2.45162392, 2.6936512,
        -3.23226333, 6.19783258, -0.153776363,
        1.04947841, 2.19776154, 3.4119978,
        -3.84402275, 0.00139881717, -2.16059136,
        -7.04218531, -0.139616802, -1.48375678,
        -7.63879776, 0.494346023, -0.887497246,
        2.0064218, -6.33162403, -0.694223404,
        -6.14161301, 7.27803993, -5.93719769,
        3.85544372, -6.10018158, 0.518295944,
        -4.84164906, 3.77843428, 0.989848316,
        -0.991044164, 7.76757908, -2.78956604,
        -3.26949048, -0.427239507, -2.35811067,
        -6.48549175, 2.67126656, -0.853108406,
        -5.06049252, 3.86422658, 0.241787359,
        1.8747561, -5.91898584, -1.71785474,
        4.59061384, -5.70984983, 0.473888844,
        2.16487646, -5.91094303, -1.16756415,
        -9.04302692, 3.99726415, 1.97661018,
        -3.60562301, 5.20519495, 0.0162021555,
        -7.58189058, 1.78173947, 5.12911844,
        3.93368816, -0.871297061, -1.0000118,
        -0.927668214, 7.48852015, -2.76916671,
        5.07673264, -5.43473291, 1.50144029,
        2.45607495, -5.32099628, -1.58515882,
        -1.37183499, 6.26078701, -1.44123244,
        -5.11693811, 4.50380087, 1.72594333,
        -6.25569725, 5.24890804, -1.47209787,
        5.70606232, -4.72305107, 0.994686186,
        2.83258486, -5.44810438, -0.833913386,
        5.17045021, -5.01628017, 0.16731441,
        5.67516184, -4.80483246, 1.92987442,
        -3.74205637, -6.63423634, -2.81289268,
        -1.00756156, 7.5402565, -2.50895429,
        -6.27550793, 7.30278397, -5.63255405,
        -4.8922348, 4.32927227, 0.681457341,
        2.80923033, -4.88577127, -1.76707983,
        -4.82314348, 3.50562787, 0.530039489,
        3.06032038, -4.81226397, -1.31635237,
        -6.39126158, 5.52360773, -3.93061423,
        -5.00817585, 4.33830452, 1.27705264,
        5.51068401, -4.50319433, 0.130309969,
        3.07814717, -4.57752037, -1.52008295,
        3.00104618, -4.21878147, -1.80283833,
        -6.2105689, 5.91053772, -2.96988893,
        -5.99229813, 1.70521104, -1.15303075,
        -6.30082178, 6.31236458, -4.60447454,
        -6.30540752, 4.97061443, -0.833253801,
        5.96107912, -4.14678669, 1.5268954,
        5.89374399, -3.89262605, 0.743768513,
        3.50835729, -4.06193209, -1.23627901,
        -5.28903437, 4.2731657, 2.24037123,
        -6.19488907, 5.49336624, -2.0565846,
        -8.79300308, 1.23080945, 1.1537621,
        -6.19061613, 4.48168135, -0.548740149,
        -8.93129539, 1.4514761, 2.60363579,
        -6.14437962, 6.98891592, -5.78439045,
        -3.13877439, 2.63395166, 0.49862805,
        -4.84536791, 3.77579093, 1.42901826,
        -3.55415058, -6.3354764, 4.66590405,
        4.00294924, -3.18563914, -0.785185695,
        -0.978277445, 6.87997198, -2.30331111,
        -8.88987923, 1.82653379, 0.625038743,
        3.51375866, -3.14229822, -1.48381352,
        -8.61503029, 3.65670109, 0.308150381,
        -9.23178482, 2.16027284, 3.0369606,
        4.48469591, -1.45883894, 2.04059625,
        -6.23743916, 6.13963318, -3.70512009,
        -3.23601604, 5.339324, -0.27955544,
        -6.2751317, 4.97560644, -1.79671431,
        -4.00288963, 4.94859028, 0.146370992,
        -4.94977188, 3.91403747, 0.565049767,
        -1.08910728, 8.03305435, -2.90333033,
        3.38954639, -2.07319641, -1.67021883,
        -8.33700943, 0.125314921, -0.245022163,
        -7.16950893, 7.44973183, -5.33097935,
        -8.64305305, 0.436233521, 1.94280291,
        -8.78891754, -0.624851942, 1.92579138,
        -1.53604841, -6.20910215, 5.12569475,
        -6.34534359, 6.44177628, -3.1860528,
        -6.63259411, 5.64659214, -5.28676319,
        -7.62681341, 4.48013353, -0.544141293,
        -6.46083498, 6.70618343, -3.99709511,
        -6.36639833, 6.24547672, -2.47232342,
        -5.72862577, 2.23804879, -0.858817816,
        4.47346354, -1.28806973, 0.381092787,
        -6.42706013, 7.82498169, -5.79925537,
        -6.93353939, 8.06121254, -5.54933786,
        -3.7257092, 2.04017711, 2.85780668,
        -1.55057251, 2.73715997, 2.14356518,
        -7.28480005, 7.97645473, -5.37232399,
        -6.6445303, 7.64918518, -5.15410805,
        -5.54719257, 5.44254017, 1.55750036,
        -4.69073009, 3.05897593, 2.30376816,
        -2.27714372, 2.51608396, 2.06057811,
        -7.17684793, 7.9124012, -5.00320101,
        -1.31885445, 8.14082527, -2.42121291,
        2.91265583, 0.0875125676, -1.55648661,
        -8.29991436, 5.31593609, 2.24434042,
        0.620766759, 2.64629149, 3.01782846,
        -6.18755341, 5.57274675, 1.63118649,
        -2.42170477, 2.06482649, 2.93102813,
        -2.96482205, 2.50116491, 1.58180308,
        1.53217649, 2.66056633, 2.54176116,
        -7.50336885, 7.67939091, -4.58654213,
        -7.65112114, 5.46554947, 2.50517654,
        -7.26747227, 5.34371519, 3.06263185,
        -7.15625429, 5.72335386, -0.212486655,
        -6.9901495, 7.45713663, -4.44846821,
        -2.72911382, 2.35107851, -0.367515326,
        -7.5401516, 5.40837669, -1.75852299,
        -1.56973147, 8.57938671, -2.19607306,
        -7.76226425, -0.250298828, -0.937005162,
        -7.62040424, 7.86658812, -5.07599831,
        -4.09326696, 2.77300811, 1.45306313,
        -7.66410398, 6.74773073, -4.08687019,
        0.330158055, 2.27640724, 3.46222639,
        -6.8486681, 5.10230494, 3.65233827,
        5.72991896, -3.12151051, 0.791236579,
        -6.78344822, 5.59433937, 1.16154671,
        -7.38939857, 7.39360619, -3.97955418,
        -5.86717415, 5.72562075, 0.782319188,
        -6.78906631, 5.67731953, -0.473937184,
        -5.16535521, 5.99477768, 0.701395154,
        -1.99197602, 8.5513134, -1.55395865,
        -2.16477513, 8.53647423, -1.64461517,
        -6.9336257, 7.02861214, -3.30466151,
        4.63093948, -2.24835372, 1.14469135,
        -5.1701045, 5.32730436, 1.20622277,
        -4.62645292, 3.3190074, 1.05057514,
        -1.35063934, -0.203769043, 4.92709494,
        -4.5872798, 3.23038483, 1.62281203,
        -4.94619799, 3.71248817, 1.94689012,
        -7.39911127, 7.02981949, -3.22019172,
        -7.21148825, 5.55421114, 2.04877615,
        5.38387489, -2.8003118, 1.42106307,
        -3.61843038, 2.75913835, 1.14582407,
        -5.55791616, 5.657125, 1.13330138,
        -7.61174202, 5.49376488, -0.0196253899,
        5.0061574, -2.7361083, 1.57276416,
        4.79475355, -2.66667557, 1.38078916,
        -7.33540201, 5.56259489, 0.7115587,
        3.52550387, 1.32338095, 0.978595197,
        2.87967157, 2.02671409, 0.710245371,
        2.0260334, 2.58468747, 0.66234237,
        -8.44883823, 1.40608287, 0.151872516,
        -4.11910486, 6.64523029, -1.05735815,
        -6.80326414, 5.49149752, 0.23495467,
        0.732179582, 3.01263833, 0.583440006,
        -7.98090172, 1.0373168, -0.293480486,
        -0.330767959, 3.00930738, 2.13678455,
        -6.28956127, 5.56233883, 2.33000827,
        -3.16677833, 7.74505138, -1.17456496,
        4.71479607, -2.81238556, 1.98682439,
        4.5377965, -2.39555645, 2.07065296,
        -8.0130806, 5.42954111, 1.23946476,
        -3.65698266, 2.48653436, 2.00114632,
        2.54923987, 2.35233784, 1.30604184,
        -0.554916441, 2.99167824, 0.446998298,
        -7.40088367, 6.65446711, -2.22523355,
        -4.24426889, 2.20383024, 2.58935618,
        -0.903372943, 2.81057048, 2.55978775,
        -6.97475863, 7.83954859, -5.71839809,
        5.00310612, -2.90610147, 2.11072588,
        3.14473677, 1.7923317, 1.77333999,
        1.00037575, 3.05680561, 1.27086985,
        -6.31206274, -6.52469683, 2.71909571,
        -6.59906244, -6.39101171, 3.29211044,
        -1.03567159, 0.339500219, 4.36617804,
        -7.91235542, 0.813644946, 3.34996295,
        -5.86038685, 2.90265179, -0.686560452,
        -7.0149889, -6.50666618, 0.990970969,
        -6.4003334, -6.11520624, 2.67006803,
        -3.84323359, -6.23293781, 4.34301901,
        -2.3176384, -6.17746878, 5.31960917,
        -6.06341219, -6.11884022, 2.10632467,
        -6.4142108, -6.12641335, 4.0195837,
        -7.15861034, -6.22528887, 0.60294956,
        -6.75131226, -6.12444115, 1.21152484,
        -3.53559518, -5.97914076, 4.59135294,
        -6.79044867, 1.90838122, -0.857710242,
        -6.50281477, -5.94357872, 3.66518521,
        -4.00301123, -5.77914715, 4.17082405,
        -6.70385695, -5.70357895, 0.785790741,
        -7.8427515, 0.190311924, 3.36465168,
        -6.33531475, -5.76751804, 1.28673053,
        -6.26606655, -5.70098305, 3.95624495,
        -3.01104593, -5.51106405, 4.83939838,
        -8.81998825, 2.33867788, 4.6438942,
        -2.20719552, -0.943131626, 5.20734739,
        -5.58467627, -5.2781353, 4.00712395,
        -2.24564767, -2.27807379, 5.29624462,
        -2.620682, -1.59994316, 4.9618845,
        -8.64754486, 4.87951756, 2.91863227,
        -6.09692526, -5.42461824, 0.936552107,
        -5.79998398, -5.47051859, 1.31241512,
        -2.18024659, -0.472247243, 4.7268548,
        -5.43834829, -5.10462475, 3.31636024,
        -3.482517, -5.36712313, 4.1363225,
        -4.34144974, 7.03063965, -0.129518926,
        -5.60620022, -5.05806065, 0.999420583,
        -5.03126574, -4.87561321, 3.37368321,
        -4.68637753, 6.60551548, 0.311795503,
        -7.02551603, 0.0477419794, 3.90411639,
        -7.65409851, 5.76818562, -1.21988475,
        -2.79022431, -5.03642702, 4.24499559,
        -7.39688683, -2.18359494, 3.63458371,
        -5.11900806, -4.49815178, 3.05427217,
        -4.91329479, -4.57314968, 3.47664022,
        -7.73069811, 7.47586441, -4.32678413,
        -8.12842178, -0.606379747, 3.22298789,
        -5.40325832, -4.26972389, 2.31496143,
        -1.68242204, -4.25711679, 5.08220387,
        -7.76284647, 7.18444967, -3.89069247,
        -6.90041685, 5.95478535, -5.21512938,
        -5.23845959, -3.9307642, 2.97398949,
        -4.9027338, -4.05079985, 3.50145125,
        -2.39166451, -4.11366844, 4.20142889,
        -7.42581797, -0.69166851, 3.92754745,
        -8.98790741, 4.58249378, 2.48459125,
        -7.76762342, 6.86626196, -3.3165288,
        -4.62227583, -3.65379095, 3.88439131,
        -7.55468607, 6.21173429, -1.65215397,
        -2.05940533, -3.72455883, 4.77702427,
        -1.99333537, 0.11155206, 4.35691404,
        -7.89628649, -1.32222295, 3.42798328,
        -1.61790729, -0.737394989, 5.4229908,
        -6.75758266, 7.80761766, -5.89083481,
        -8.07010269, 2.90790606, 5.1879158,
        -2.12225699, -2.94624925, 5.0634079,
        -3.09654975, -6.17896652, 5.0769434,
        -9.20176983, 2.06186938, 3.99906659,
        -2.04110861, -1.4600265, 5.53797817,
        -6.49634361, 3.71201324, -0.777491212,
        -8.481534, 4.22134495, 3.98291874,
        -8.37763786, 1.84255672, 4.88305664,
        -2.56265855, -2.41065407, 4.68701172,
        -8.57558346, -0.331746489, 2.59688449,
        -4.7210803, 5.55931997, -0.68645066,
        -7.90256977, -2.07621431, 3.03908801,
        -8.44746971, 3.38540697, 4.68288136,
        -9.04568291, 3.02432013, 3.98884153,
        -8.41306782, -1.35476172, 2.61963916,
        -7.44853306, -1.10852408, -1.3866818,
        -1.60960495, -2.59631109, 5.53030443,
        -4.74632168, -6.32052708, -1.41154552,
        -9.29721642, 2.75004578, 2.04123902,
        -4.74425316, -0.939034462, -2.16470861,
        -7.47406006, 7.01820707, -4.5491991,
        -3.9205327, 7.29994488, -0.707361221,
        -7.57367563, 7.65957785, -5.12481976,
        -4.34039354, -6.10202217, -2.31435537,
        -4.52514839, -6.17414474, -2.04454446,
        -4.60223103, -6.14800692, -1.68729591,
        -6.62198162, -5.79907656, -0.186811328,
        -7.24810886, 6.29470158, -4.40397644,
        -7.75880289, 7.60755444, -4.69216204,
        -5.27374792, 6.26528978, 0.256306708,
        -4.08003855, -6.04071808, -2.62951756,
        -5.88382339, -5.95554495, 1.85866332,
        -5.75829506, -5.59141541, 2.50911188,
        -8.22834015, 5.10298824, 0.438898087,
        -4.18315649, -5.80302525, -2.33342481,
        -4.41504717, -5.93647051, -1.95895541,
        -4.48274374, -5.8486681, -1.5777427,
        -4.48006248, -5.50083113, -1.18431342,
        -3.94492054, -5.73991966, -2.51704645,
        -6.4041934, -5.46144247, 0.2572909,
        -6.01328373, -5.37163115, 3.29272151,
        -9.17932987, 3.1908896, 2.71014905,
        -7.65300846, 6.4100256, -3.65317011,
        -3.91700506, -5.43054771, -2.1612649,
        -4.21049261, -5.54828644, -1.79028058,
        -5.43122387, -5.34918928, -0.662280381,
        -5.68747663, -5.27148676, -0.317984581,
        -5.92644501, -5.20265484, 0.202936321,
        -6.11274624, -5.31446695, 0.604896128,
        -3.77851844, -5.23515844, -1.72736347,
        -4.20742702, -5.08589411, -1.15747881,
        -5.22459269, -4.94271803, 1.60161626,
        -5.31924677, -5.04501438, 2.77830958,
        -3.56541753, -5.25800848, -2.06998181,
        -3.39889908, -5.08511734, -1.64994693,
        -5.4099679, -5.16473532, 2.13646865,
        -4.87748718, 6.57808208, -0.237298489,
        -7.7778244, 6.23506355, -2.811975,
        -3.2028091, -5.11269665, -2.04505992,
        4.53692102, -3.35601902, 0.0362803787,
        -7.32572842, 4.27986526, -0.892998457,
        -7.15804863, 5.39287043, -4.34335661,
        -2.83357263, -4.80772591, -2.32719827,
        -3.09093833, -4.86265421, -1.82429957,
        -5.54606676, -4.66243172, -0.341447383,
        -5.69331694, -4.8270278, 0.666869998,
        -7.88602161, 4.86263847, -0.147592187,
        -9.04691219, 2.76919675, 0.712486863,
        -8.68735504, -0.9612391, 0.505123913,
        -5.22482538, -4.7843008, 2.31082416,
        -4.02444792, 1.02577329, -1.85657895,
        -5.25211525, -4.50458479, -0.735012949,
        -5.70627737, -4.58044815, 0.0358867347,
        -5.69107771, -4.50068426, 0.499473035,
        -5.51065636, -4.38829374, 0.972980738,
        -5.40789032, -4.39337254, 1.58769441,
        -7.26151896, 5.76390362, -3.69326711,
        -5.77288675, -4.25413465, 0.313919544,
        -7.36519909, 5.14013386, -3.23702383,
        -2.24592781, 7.84882164, -2.06423116,
        -3.12143707, -4.23018837, -1.75177348,
        -3.20759583, -4.35184002, -1.34458995,
        -6.37940979, 6.80049181, -6.00041866,
        -7.77707195, 7.29087734, -4.54168177,
        -7.56580353, 7.32582283, -4.85526752,
        -2.88846469, -4.34338379, -2.31205177,
        -5.67665911, 5.85216713, 0.180274934,
        -8.63659, 5.1617775, 1.21480608,
        -7.39677477, 3.89993739, -0.706605911,
        -4.48974848, 6.84494495, -0.615136206,
        -2.77593851, -3.86258817, -2.82368135,
        -3.72936916, -6.2030654, -2.9288764,
        -5.21657372, 5.99763393, -0.274408787,
        -7.8182354, 7.0685792, -4.24880743,
        -3.05348301, -3.77039313, -2.18261743,
        -7.73801851, 5.88917923, -2.0755353,
        -1.78550315, 8.14198494, -2.42392039,
        -7.73680639, -2.82721376, 0.115943879,
        -7.19117212, 1.12940633, -0.913113475,
        -2.04828691, 2.10432053, -0.880739927,
        -4.45650291, 0.215035275, -2.12397242,
        -7.96992111, -2.86468983, 1.21112204,
        -2.56994343, -0.659594119, -2.79782176,
        -7.07576466, -3.12894011, -0.498019397,
        4.96742868, -3.49866247, -0.0875236765,
        -3.11317515, -3.2499361, -2.48024845,
        -9.12773705, 3.3673501, 1.4780364,
        -7.54515171, 6.0297823, -3.01251268,
        -6.46499205, 7.13205385, -5.98086882,
        -8.74671459, 4.59732008, 0.874539495,
        -3.26005197, -2.65543914, -2.57931352,
        -7.42207718, 5.34513092, -2.57095981,
        -7.75594759, -2.40323663, -0.58277899,
        -7.04120636, 4.52817154, -1.72066617,
        -7.69788837, 5.18251657, -0.800557375,
        -3.33967876, -5.32174635, -2.44550061,
        -3.01658535, -2.45558572, -3.17790818,
        -8.37142372, -2.02571297, 0.365688086,
        -8.56697655, -1.80424583, 1.45819974,
        -7.40353584, 4.92789745, -2.08805132,
        -5.46944189, 1.68960917, -1.35730863,
        -7.72186327, 6.24359751, -3.05809116,
        -2.19032121, 1.7782129, -1.35042715,
        -7.41485262, 4.69872427, -1.22677934,
        -2.88585067, -1.52405024, -3.29809451,
        -5.96875191, -6.24101019, 4.41702986,
        -7.56690073, 5.7344346, -2.38184357,
        -9.06998825, 1.37719572, 1.88648069,
        -8.37691021, 3.0526278, -0.2153503,
        -8.94839287, 3.89794707, 3.1655376,
        -8.74764919, 4.13840294, 0.885703981,
        -3.24139237, -1.79096222, -2.70446968,
        -8.13868999, -1.42528272, -0.627608776,
        -8.32887077, 4.49765396, 0.318197966,
        -7.87196827, 6.63482666, -3.34107161,
        -8.33057404, -0.890879631, -0.510241866,
        -6.96266937, 6.92714071, -5.20487452,
        -5.03425312, -6.25767374, -1.20539451,
        -0.144921616, -0.0999247506, -2.54016852,
        -2.08345008, 8.44622803, -1.92578769,
        -1.87708628, 8.67722702, -1.89863944,
        2.8786931, -1.21086955, -2.10412788,
        -1.7610631, 8.58519459, -2.21251297,
        4.93106127, -2.75098109, 0.969772816,
        -1.23977709, 1.40870643, -1.75209618,
        -1.86278462, -6.27595854, -2.7419467,
        -3.58054137, 7.03716898, -1.29751968,
        -2.83309889, 7.50403309, -1.71940863,
        -1.07001638, -0.28806904, -2.97938776,
        -1.4510982, 8.34128952, -2.68219876,
        -6.20315838, 5.56163645, 0.534658432,
        -1.14043128, 8.1928997, -2.75299692,
        -2.2441802, 0.008530505, -2.38324881,
        -6.17457151, -5.54660892, -0.264688104,
        -1.48046064, 8.02667809, -2.69168973,
        -5.93589783, 5.3367486, 0.0235132296,
        -5.57766628, 5.55529451, -0.130755618,
        -1.41285503, 7.66109276, -2.65356302,
        -6.34971476, 5.23745775, -0.0792439654,
        -4.05316305, -5.2748003, -1.41669774,
        5.46346092, -3.75778461, 0.0242529325,
        0.907830834, -0.28010568, -2.50684834,
        -5.82596064, 4.80470705, -0.159517035,
        -0.144561499, -0.543165505, -3.20371723,
        -6.2084198, 4.8460865, -0.402093053,
        2.1299274, 2.23458242, -0.271394849,
        -4.01044226, -6.34521961, -2.81000471,
        -5.8079114, -5.74893236, -0.716523647,
        -3.49020791, -5.62387133, -2.7550683,
        -5.20929813, 2.19926023, -0.989081681,
        3.01533866, 1.42829967, -0.389589369,
        -3.09802818, -5.48256159, -2.74776506,
        -1.77062643, -0.638838291, -3.24510574,
        -3.07198238, -6.45368195, -2.96915293,
        -3.23146701, 1.57872605, -1.43986714,
        0.426027715, 2.15682268, -1.21962667,
        -0.767102003, 1.7614162, -1.51952255,
        -3.6746552, -5.43992281, -2.45556521,
        4.4806385, -2.66528153, 0.043451637,
        -1.2140913, -0.925686419, -3.60877538,
        -3.75444508, 2.20592141, -0.985806286,
        -4.54539442, 2.26142001, -1.03185928,
        -5.81158924, 4.33647346, -0.312518299,
        -4.06048536, 1.75984073, -1.38252008,
        -3.01298642, 2.05582833, -0.912332356,
        0.314671159, -1.17238688, -3.33338261,
        -1.73981857, 0.729326427, -2.14747047,
        4.16386795, -3.55898738, -0.293951958,
        -1.16859412, 2.62565565, -0.379551232,
        -5.87471199, 3.86703897, -0.505066454,
        -2.31010389, 1.32405543, -1.77060175,
        -5.0145669, 3.51710987, 0.0628562048,
        -4.54050779, 3.0012424, 0.238237277,
        1.33639276, 2.12989831, -0.999154091,
        -5.51279211, 3.25519013, -0.454565942,
        1.94746614, -1.61667132, -2.72355771,
        -1.56562269, 2.80399084, 0.485093057,
        4.6489234, -4.04330254, -0.438151807,
        -4.61897421, 1.62230718, -1.48754251,
        1.95660937, -0.536148429, -2.32180214,
        -1.13052821, 0.223075747, -2.3426888,
        -5.41517782, 2.59907031, -0.632766843,
        -2.17816806, 2.50083303, 0.0049429019,
        1.21261287, 2.66328526, -0.261308193,
        1.07473505, -6.19696426, -2.22529507,
        -4.99157429, 2.9294827, -0.291065782,
        4.98645687, -2.94146419, 0.517844319,
        -4.88313437, 2.50299883, -0.703582227,
        -4.3083086, 2.69638515, -0.398762822,
        -6.28731012, 7.5797267, -6.06706047,
        -5.50737953, -6.45749092, -1.14135122,
        -0.0103893746, 2.70872688, -0.453187227,
        -0.248129562, -6.55740738, -2.25495172,
        -0.525027215, -6.25281429, -2.48549056,
        -2.47435093, -6.53566504, -2.80605483,
        0.150462419, -6.17280197, -2.45372772,
        -5.53103447, -0.0269888118, -2.08516693,
        -2.21671271, -5.84479713, -2.84531808,
        -3.727283, -5.89227867, -2.8021338,
        -4.74975443, -6.12354326, -1.33064544,
        -7.8381753, 3.16524363, -0.546228588,
        -0.9267869, -5.81945133, -2.66736031,
        -2.87536383, -5.97358227, -2.94880414,
        -3.40508986, -5.97210026, -2.94567966,
        0.444993436, 1.06517804, -2.00702071,
        -5.3458252, -5.97363806, -1.05404258,
        0.559676886, -5.60763693, -2.53845596,
        -6.36547804, -5.91752052, -0.567182899,
        3.3934865, -5.84591579, -0.334077567,
        -6.26437473, -6.24091053, 1.82820296,
        -0.26586923, -5.77400875, -2.57356215,
        -1.31431472, -5.52499866, -2.76982927,
        -6.45893526, 1.06058192, -1.31895959,
        -1.72811627, -5.74599028, -2.75300932,
        -4.9163723, -5.85418415, -1.15285504,
        1.88069367, -5.00866556, -2.38150978,
        1.31207323, -5.46963501, -2.46107459,
        0.0172523502, -5.18197155, -2.92318034,
        -2.12998438, -5.40674639, -2.78248143,
        -2.6389432, -5.47195864, -2.77295303,
        -1.80239117, 7.68880987, -2.38738799,
        4.0909543, -5.50518131, -0.324038148,
        -0.735857427, -5.24167252, -2.96352696,
        -1.63325119, -5.18059206, -2.98313165,
        -5.0049715, -5.49470091, -0.962784529,
        -2.55451798, -5.05414915, -2.63099718,
        -2.9485507, -5.24082661, -2.50085974,
        -4.69627523, -5.04641867, -0.988072932,
        -4.18968105, 5.87851524, -1.00960517,
        -3.61188531, 5.88584518, -1.19559026,
        -8.00780106, 2.42500377, -0.512883425,
        -8.11651421, 3.86771274, -0.254719794,
        -0.943787456, -4.50323391, -3.31552839,
        -5.05144739, -5.02661848, -0.865851998,
        -2.2642498, 7.04398251, -1.91980052,
        4.6837039, -4.97073221, -0.317892104,
        -0.300921917, -4.61777496, -3.18201256,
        -2.55956411, -4.46716499, -2.79305601,
        -3.22731566, -4.92169666, -1.38730478,
        -3.62596321, -4.993999, -1.18386376,
        -6.74418259, -0.533028603, -1.66700339,
        3.57645488, -5.02887392, -0.595324993,
        2.45071602, -4.73908424, -2.18371463,
        0.81297648, -4.97440815, -2.82521152,
        -1.3586278, -4.87897587, -3.17108178,
        -1.99779058, -4.73663521, -3.07481837,
        -6.6518259, 6.05961132, -5.64827776,
        4.18715811, -4.64690256, -0.656245887,
        1.30669153, -4.7721591, -2.80063725,
        -6.96785164, 3.3206749, -0.818929911,
        -3.89844966, -4.59886742, -1.11869931,
        -8.81603622, 1.28791809, 3.51004529,
        5.10742283, -4.32594252, -0.28338328,
        -1.25020802, -6.21567249, -2.62312555,
        -4.39252806, -4.57321692, -1.0840683,
        -6.30178738, -2.61971927, 3.92707014,
        0.704284668, -4.31749344, -3.03086901,
        -5.30100012, 4.39161158, -0.0702707171,
        -3.56575012, -4.45933723, -1.09403133,
        -4.76935005, -4.52560234, -1.04022765,
        3.78465557, -4.23661375, -0.622273564,
        1.59631455, -4.05555487, -2.81581211,
        0.126481593, -3.76157117, -3.34221959,
        -1.52939856, -4.18980742, -3.46162605,
        -2.26567841, -4.02366972, -3.2512517,
        -4.28411007, -4.15788174, -1.19466305,
        4.20024681, -4.09292936, -0.433761835,
        -6.74692011, 7.48991919, -5.82720852,
        -3.2547276, -4.07290268, -1.32742405,
        -3.7041707, -4.27530766, -1.13572013,
        -4.89303303, 0.938924491, -1.82868731,
        -0.509239078, -4.02867603, -3.4189496,
        -5.78748512, 0.902789176, -1.68155801,
        -1.17312169, -3.39634037, -3.6367228,
        -3.31219745, -3.61669683, -1.62773347,
        -4.21957445, -3.51047683, -1.40234566,
        -5.67841148, -3.98389649, -0.253337175,
        -6.41232777, -3.60978317, -0.44398129,
        -2.46370435, -6.37791681, 5.17117739,
        -3.00442052, 0.645298362, -2.14067268,
        1.02263141, -3.30776024, -3.14401793,
        -4.93391895, -3.99809289, -1.10620856,
        -8.46985722, 2.09816289, -0.140005365,
        -5.34021759, -3.92035508, -0.811949909,
        2.60872936, -3.37986994, -2.25224566,
        -0.331109285, -3.20249939, -3.48488808,
        -2.01077271, -3.31384039, -3.67861271,
        -2.66997886, -3.28466511, -3.19969296,
        -3.8835907, 5.51095581, -0.906699836,
        -5.761199, -3.32061696, -1.05364311,
        -6.18285084, 3.30848837, -0.726166189,
        -3.59957385, 6.39087391, -1.38490295,
        -4.74327421, -2.92055845, -1.60666919,
        -5.0271759, -3.35539293, -1.2713809,
        -6.5455389, -3.01877332, -1.06923234,
        -1.08329737, 7.65391874, -2.87408638,
        -2.48656392, -2.65805793, -3.63875341,
        -3.3373394, -3.13437557, -1.97256541,
        -3.89145422, -2.97935605, -1.65301943,
        -5.48150873, -2.94618177, -1.49473798,
        -6.07619143, -2.7642107, -1.56323171,
        0.386963189, -2.82729053, -3.4232707,
        -6.42485428, 6.10899878, -5.71367979,
        -7.02541542, -2.45858812, -1.08759105,
        -0.144488871, -2.22575092, -3.6202867,
        -0.936437547, -2.48593068, -3.76160169,
        -3.61067486, -2.52921557, -1.89421058,
        -4.5272665, -2.4536531, -1.83955836,
        1.86340737, -2.80477405, -2.76920605,
        -5.43332672, -2.47542071, -1.82471919,
        1.19224489, -2.2242713, -3.14761949,
        0.485448062, -1.93062615, -3.40495896,
        -1.94788837, -2.41133738, -3.8155973,
        -2.45897245, -1.96855772, -3.74245024,
        -4.70324087, 6.21293068, -0.695496917,
        -6.59996843, -2.22674394, -1.6560781,
        2.43840551, -2.18770194, -2.49193478,
        -3.50614762, -2.13244009, -2.22183466,
        -6.91711426, 3.90061641, -0.787992716,
        -1.67835033, -1.80796754, -3.88179111,
        -4.32039356, -1.81008995, -2.03201175,
        -6.04643345, -2.0103848, -1.91984487,
        -6.36788034, 0.276292086, -1.73160934,
        -0.696384668, -1.52112234, -3.77685976,
        -2.16693926, -1.41086674, -3.77173185,
        -6.62328911, 6.5224824, -5.73823023,
        1.15893924, -1.31986773, -2.99993634,
        -5.27642584, 5.4501853, -0.319808513,
        -1.67027843, 7.04842329, -2.17569947,
        -5.19532013, -1.750175, -2.06553364,
        -7.32473469, 2.55924773, -0.807514071,
        -5.09247589, -6.44120359, 4.47640038,
        -2.33865714, -1.0690608, -3.45110536,
        -2.87518144, 6.55793428, -1.5536927,
        -3.78759813, -1.28893828, -2.24257517,
        -3.56250405, -6.55090904, -3.00909352,
        -3.36324143, -6.63562346, -2.787323,
        -2.89557171, -6.64692211, -2.6391747,
        -2.46217442, -6.64482069, -2.51068354,
        -2.13199258, -6.64650488, -2.48691654,
        -1.4327637, -6.62457132, -2.35679007,
        -0.884118557, -6.61186075, -2.23737764,
        0.312641412, -6.58237457, -1.94426715,
        -4.12968969, -6.61979961, -2.63447475,
        -3.22899342, -6.63346052, -2.42569327,
        -3.56291556, -6.64160252, -2.51660299,
        -0.521277368, -6.56284666, -1.85590744,
        0.941761374, -6.54556847, -1.48897624,
        -3.87963963, -6.63889885, -2.33323812,
        -2.43281007, -6.46125793, -1.96260357,
        -1.39041209, -6.5119648, -1.94121528,
        -0.983015954, -6.3846755, -1.56216061,
        0.333918929, -6.45008039, -1.47659683,
        -4.4031558, -6.48672867, -2.36051464,
        -4.22572279, -6.64302111, -2.12635899,
        -3.59996676, -6.63469505, -2.2219584,
        -3.29054499, -6.5468359, -1.95925581,
        -2.81689668, -6.56338978, -2.14362431,
        -0.330139279, -6.36913252, -1.5480144,
        1.71477818, -6.35760736, -1.28391778,
        -4.56201267, -6.53217125, -2.08546615,
        -3.9973259, -6.63022566, -2.06810856,
        1.29127395, -6.56470919, -0.937975109,
        -4.48178148, -6.63438368, -1.74681377,
        -2.86626387, -6.36053276, -1.89994955,
        -1.46926236, -6.28223562, -1.65254331,
        0.828504205, -6.40869331, -0.991453767,
        -4.64536333, -6.42977524, -1.81987202,
        -4.21371698, -6.62497902, -1.77421308,
        -3.74372172, -6.58426094, -1.82232392,
        -2.54488158, -6.15657616, -1.58554566,
        -1.97787035, -6.26056528, -1.77524996,
        -0.0162240639, -6.13848352, -1.22225118,
        -3.84512234, -6.53590631, -1.43187976,
        -3.44291902, -6.35916805, -1.67373753,
        0.518508911, -6.24053335, -0.954302609,
        -4.75486708, -6.55854177, -1.57268918,
        -4.61188936, -6.64150667, -1.27618754,
        -4.30160284, -6.62969828, -1.42119157,
        -3.0408082, -6.14902115, -1.38481045,
        -2.22650528, -6.13850021, -1.12693286,
        -0.636314809, -6.135674, -1.01389825,
        0.793939114, -6.42837715, -0.664527833,
        1.40539396, -6.52726507, -0.243473321,
        2.13064408, -6.51743221, -0.0217773672,
        -5.05953312, -6.63042021, -1.16177511,
        -3.9603231, -6.44725466, -1.02349925,
        -1.68356156, -6.13665295, -1.19785368,
        -1.13680589, -6.1251049, -0.969088078,
        0.827485204, -6.48263407, 0.0809862763,
        2.66806746, -6.14778376, -0.235986516,
        -5.25431681, -6.64827156, -0.780559778,
        -4.78380203, -6.64577293, -0.930105925,
        -4.44184017, -6.63274336, -1.00672615,
        -3.54174829, -6.23223019, -1.18295729,
        -2.83710265, -6.15571833, -1.08499146,
        -1.82099187, -6.13636971, -0.568528891,
        0.045249749, -6.12172508, -0.51766485,
        3.11210775, -6.39472485, 0.692990899,
        -5.95762873, -6.6488905, -0.777766705,
        -4.0803895, -6.44820023, -0.570043921,
        -2.58414984, -6.15553141, -0.618391275,
        -0.946904659, -6.122859, -0.336332351,
        1.55462706, -6.43673182, 0.468952537,
        -4.87060213, -6.64140034, -0.510937452,
        -3.67688084, -6.22566271, -0.576466084,
        -3.21775866, -6.1566906, -0.585271955,
        -0.124222204, -6.20967102, 0.297015965,
        2.26926851, -6.49002552, 0.77417767,
        -6.59776258, -6.63248348, -0.439102501,
        -5.58896828, -6.6543293, -0.375943393,
        -3.78070903, -6.44779778, -0.112353519,
        -2.35851073, -6.16409397, -0.11346744,
        -1.03642857, -6.14642048, 0.436912864,
        -5.06696892, -6.64370632, 0.0800200254,
        -3.45728302, -6.21735096, -0.191416442,
        -2.833004, -6.16364956, -0.148178145,
        0.718784511, -6.53752327, 1.01826775,
        3.33620262, -6.3307209, 1.3791616,
        4.00417757, -6.01987457, 1.69838822,
        -6.30033445, -6.64759207, 0.366664737,
        -6.03032541, -6.65073204, -0.206752867,
        -4.40488243, -6.61617088, 0.0494934507,
        -3.7403512, -6.60509872, 0.475848913,
        -1.72433686, -6.15901041, 0.29033795,
        -7.45945024, -3.26525331, 1.889485,
        -7.00375462, -6.34980297, -0.121004313,
        -4.78943348, -6.63745308, 0.460118532,
        -2.49008727, -6.19282675, 0.409063071,
        2.62987924, -6.4938283, 1.38523078,
        -5.75776052, -6.64979267, 0.171624571,
        -4.39178371, -6.61576319, 0.603950143,
        -0.750173807, -6.15906048, 0.990428746,
        -6.8241663, -6.62336969, 0.320649385,
        -3.20193172, -6.54756546, 0.87369293,
        -1.48414314, -6.17085886, 1.06415081,
        -0.143976197, -6.26266098, 1.36658978,
        -5.26481819, -6.63914204, 0.64681834,
        -2.82713032, -6.29252911, 0.893239617,
        2.86127281, -6.33432484, 2.00460672,
        -5.89944363, -6.64337444, 1.01396704,
        -4.70050335, -6.44392443, 0.972494543,
        -4.04369116, -6.45554638, 1.00664639,
        -2.19888783, -6.1969533, 0.993850052,
        2.13171434, -6.43130255, 2.40809488,
        -3.79599285, -6.54646587, 1.57434726,
        -3.0874958, -6.5227356, 1.71253753,
        -1.94235528, -6.1814537, 1.74339247,
        -6.64605522, -6.59440231, 0.9694314,
        -2.71945572, -6.26389027, 1.36660469,
        -0.357877851, -6.14501333, 2.46537495,
        0.330196917, -6.379848, 1.9768573,
        1.37180209, -6.52330589, 2.3134656,
        -5.26093435, -6.62288284, 1.47843707,
        -2.5199995, -6.20309687, 2.06815934,
        0.499219328, -6.31802225, 2.52665401,
        2.46472502, -6.13505363, 3.02451897,
        -6.2168951, -6.5828824, 1.59536791,
        -1.12283504, -6.16217089, 1.88999569,
        -5.80223036, -6.61673546, 1.9073838,
        1.90698445, -6.43956709, 3.1983304,
        3.34169531, -5.77247238, 2.75015616,
        4.45440578, -5.39501762, 2.59512901,
        -6.80538273, -3.18470168, 3.10114789,
        -5.27441645, -6.62829685, 2.26895642,
        -3.84862089, -6.50794077, 2.15797377,
        1.25685048, -6.46443272, 3.31770897,
        -7.68642759, 1.06535244, 4.11339569,
        -6.52896309, -6.4545989, 1.63786292,
        0.742703795, -6.43972635, 3.5625658,
        -6.32182312, -6.45947742, 2.24462271,
        -6.12882185, -6.5673418, 2.19346142,
        -4.64460564, -6.6056571, 2.44150925,
        -4.04371643, -6.54696178, 2.92712593,
        -3.17530274, -6.36084557, 2.38703513,
        -2.48673725, -6.24178314, 2.93202758,
        0.350264192, -6.16784668, 3.20782995,
        -6.82206964, -3.57261729, 2.35891485,
        -6.22585058, -3.93343878, 0.237632528,
        -6.13712835, -3.631598, 2.81196499,
        -5.13592052, -6.58857203, 2.99932265,
        -1.83857465, -6.15977478, 2.51008821,
        0.0242422353, -6.35537577, 3.77944231,
        -5.55330849, -3.38674426, 3.46423078,
        -8.32740021, 1.06023252, 3.2543149,
        -7.52963686, -2.86650658, 2.68046284,
        -1.19987082, -6.1166625, 3.07226396,
        -0.337217271, -6.48359871, 4.09182882,
        -8.15759468, -2.42815423, 2.11855888,
        -6.15253067, -4.09520864, 1.06787002,
        -5.85333204, -6.58342075, 2.69527316,
        -3.20065379, -6.44727612, 3.37386966,
        -1.90943265, -6.17441368, 3.44674063,
        1.2378788, -6.02446842, 4.46885014,
        -7.04616356, 1.02859068, 3.94037437,
        -7.82147026, 1.38524413, 4.77078199,
        -6.81140709, 4.79187584, -3.00725389,
        -6.97997475, -3.56976938, 0.192300498,
        -0.541924, -6.13845778, 3.38588524,
        -8.25231934, 1.12942576, 4.13832998,
        -6.76965046, -3.85496712, 0.795826793,
        -5.33064842, -6.54883003, 3.62060165,
        -4.56882191, -6.54468441, 3.52239943,
        0.269505143, -6.22797108, 4.65750265,
        -1.37013686, -6.16040611, 3.87032604,
        -1.48613751, -6.4900856, 4.35389423,
        -6.69187593, 5.08976603, -3.699193,
        -2.40317774, -6.39205599, 3.93222618,
        -6.09975243, -6.55062723, 3.37787938,
        -4.21317863, -6.47495794, 4.16290998,
        -3.85176492, -6.50584698, 4.01372004,
        -3.14216733, -6.50095654, 4.34340763,
        -0.736083508, -6.41601181, 4.79528475,
        -7.37642288, -3.46300173, 1.28902984,
        -6.09037304, -6.53641748, 3.79555655,
        -4.68947554, -6.50872946, 4.09232235,
        -7.51053429, 0.544124067, 3.66879368,
        -7.51151085, -3.29081106, 0.719495952,
        -6.74668694, -3.84816217, 1.63681269,
        -6.10019779, -4.04316235, 1.90639424,
        -6.55175209, -6.31696463, 3.79966831,
        -6.42629719, -6.40823746, 4.00880337,
        -5.47835159, -6.54744148, 3.97369432,
        -4.26376438, -6.12258196, 4.33460712,
        -6.18935442, -3.14568353, 3.55155492,
        -3.91985631, 5.16122055, -0.419287652,
        -1.79720116, 6.12011814, -1.34371161,
        -4.89579678, 4.57645941, -0.0615538284,
        -6.5288763, 4.41118002, -1.34852445,
        -6.42996979, 5.88298035, -5.36085415,
        -6.62871122, 5.28250837, -4.39949703,
        -2.16375494, 5.92644358, -1.12020314,
        -4.35460329, 5.22983837, -0.631333232,
        -4.97997761, 4.30176735, 0.274792582,
        -1.41883206, 6.71487427, -2.06530166,
        -6.37791729, 6.3468895, -5.8608942,
        -6.24300909, 6.65132523, -6.02086926,
        -4.64138985, 4.54797697, 0.314209938,
        -4.88807249, 5.07110834, -0.374791294,
        -6.85925961, 4.61960697, -2.27095747,
        -6.91760302, 4.24473858, -1.04959118,
        -6.564888, 4.18898296, -0.905241251,
        -1.2259618, 6.39209414, -1.68973994,
        -4.40974331, 4.76381874, -0.0991682485,
        -1.21601713, 7.21321106, -2.54715753,
        -1.91826975, 6.38868141, -1.66786861,
        -7.08377647, 4.73856449, -2.47178459,
        -2.85328794, 5.68367481, -0.982156336,
        -6.93322563, 4.93203259, -3.76342344,
        -2.48300147, 6.13359118, -1.41920388,
        -6.55065441, 4.66058779, -2.06766915,
        -6.31618404, 4.3312583, -0.755867541,
        -6.18414879, 7.13554859, -6.14704704,
        -6.32598782, 5.16774273, -2.68699503,
        -6.25009584, 6.51462364, -5.45646858,
        -5.38974571, 3.92437482, -0.173382431,
        -3.33253932, 5.60930967, -0.992623091,
        -3.31334376, 5.3340764, -0.564087093,
        -6.52914333, 5.62624264, -4.85890865,
        -1.01549172, -6.45209408, 4.04961586,
        -0.763845503, -6.28355789, 3.87921476,
        -4.54924059, -6.47812557, 1.40448165,
        -3.4138484, -6.46504593, 0.422240496,
        1.90225625, -6.48711014, 1.57954288,
        -1.68372548, -6.34895372, 4.07012033,
        -3.22586942, -6.31791353, 0.376564473,
        -5.02817535, 1.09894454, 3.62117648,
        -4.53305721, -6.58669806, 1.95076466,
        -3.32283092, -6.24876165, -2.99568701,
        -4.26007223, -6.33571339, -2.53990436
    };

    std::vector<int> buffFaces
    {
        708, 124, 442,
        57, 378, 385,
        57, 373, 378,
        67, 360, 337,
        649, 908, 917,
        392, 388, 404,
        630, 526, 361,
        445, 373, 56,
        434, 445, 76,
        778, 1067, 834,
        14, 76, 26,
        296, 288, 811,
        1076, 669, 827,
        1067, 1068, 1086,
        544, 543, 459,
        157, 83, 150,
        142, 417, 443,
        83, 157, 512,
        407, 421, 8,
        383, 76, 14,
        579, 814, 346,
        575, 770, 592,
        391, 431, 406,
        599, 545, 621,
        758, 574, 757,
        124, 708, 143,
        4, 268, 426,
        533, 91, 436,
        771, 782, 790,
        790, 782, 801,
        761, 1088, 820,
        250, 4, 85,
        164, 487, 158,
        3, 79, 1,
        432, 63, 449,
        487, 96, 125,
        63, 434, 70,
        618, 553, 302,
        124, 434, 63,
        124, 445, 434,
        70, 434, 76,
        1061, 834, 1086,
        235, 690, 344,
        369, 85, 350,
        378, 61, 386,
        378, 386, 95,
        125, 158, 487,
        250, 369, 305,
        708, 61, 143,
        348, 640, 579,
        787, 97, 96,
        96, 97, 125,
        125, 145, 158,
        170, 153, 108,
        97, 116, 125,
        116, 145, 125,
        145, 165, 158,
        378, 143, 61,
        787, 81, 97,
        1098, 165, 145,
        39, 153, 170,
        355, 1065, 319,
        123, 137, 122,
        165, 266, 168,
        161, 52, 172,
        797, 801, 786,
        5, 193, 474,
        116, 146, 145,
        145, 146, 1098,
        75, 71, 135,
        168, 254, 277,
        31, 15, 20,
        781, 732, 600,
        97, 98, 116,
        66, 109, 89,
        47, 28, 29,
        625, 1072, 635,
        385, 378, 95,
        729, 734, 751,
        156, 147, 138,
        1082, 1085, 353,
        143, 378, 373,
        1098, 180, 110,
        17, 32, 22,
        97, 72, 98,
        72, 97, 81,
        146, 180, 1098,
        171, 39, 170,
        174, 407, 8,
        186, 15, 193,
        124, 63, 442,
        155, 39, 171,
        573, 1090, 1062,
        8, 245, 174,
        98, 117, 116,
        506, 10, 443,
        35, 492, 20,
        442, 63, 432,
        63, 70, 449,
        70, 76, 178,
        15, 31, 193,
        807, 800, 797,
        72, 73, 98,
        180, 126, 151,
        108, 26, 92,
        15, 466, 20,
        34, 38, 48,
        116, 117, 146,
        789, 298, 1087,
        15, 184, 1055,
        31, 20, 485,
        34, 48, 505,
        99, 98, 73,
        372, 444, 110,
        89, 104, 102,
        66, 55, 249,
        155, 242, 147,
        117, 180, 146,
        126, 180, 117,
        1089, 93, 352,
        106, 126, 117,
        104, 114, 123,
        123, 138, 137,
        106, 117, 98,
        181, 180, 151,
        181, 372, 110,
        180, 181, 110,
        11, 46, 162,
        38, 34, 35,
        99, 106, 98,
        126, 106, 118,
        126, 133, 151,
        151, 152, 159,
        159, 181, 151,
        89, 78, 66,
        162, 176, 87,
        159, 130, 181,
        90, 99, 62,
        112, 106, 99,
        1069, 220, 319,
        153, 287, 400,
        271, 376, 132,
        48, 62, 73,
        118, 133, 126,
        340, 1086, 1068,
        55, 66, 37,
        54, 48, 38,
        90, 112, 99,
        106, 112, 118,
        385, 175, 41,
        181, 130, 372,
        179, 176, 46,
        54, 62, 48,
        62, 99, 73,
        133, 121, 480,
        130, 385, 95,
        148, 161, 172,
        143, 373, 124,
        1073, 1072, 1060,
        367, 328, 363,
        179, 58, 176,
        445, 26, 76,
        152, 151, 133,
        148, 172, 156,
        118, 121, 133,
        175, 130, 159,
        4, 65, 7,
        148, 156, 139,
        176, 58, 91,
        445, 124, 373,
        74, 62, 54,
        142, 443, 10,
        14, 108, 400,
        112, 121, 118,
        133, 508, 152,
        170, 108, 92,
        134, 281, 139,
        489, 54, 38,
        62, 74, 90,
        389, 86, 382,
        152, 160, 159,
        160, 175, 159,
        129, 122, 136,
        22, 37, 25,
        23, 84, 195,
        113, 123, 122,
        207, 153, 39,
        86, 389, 418,
        175, 385, 130,
        172, 39, 155,
        522, 1064, 1070,
        1075, 1064, 1057,
        156, 155, 147,
        152, 508, 166,
        166, 160, 152,
        41, 45, 82,
        172, 155, 156,
        93, 1089, 1079,
        14, 26, 108,
        178, 449, 70,
        508, 133, 480,
        32, 196, 213,
        449, 178, 50,
        410, 142, 367,
        344, 690, 699,
        232, 71, 211,
        138, 147, 137,
        24, 27, 16,
        232, 135, 71,
        432, 428, 715,
        428, 432, 449,
        175, 45, 41,
        89, 102, 78,
        120, 113, 122,
        830, 838, 829,
        439, 382, 86,
        229, 1079, 1063,
        109, 104, 89,
        37, 66, 69,
        1077, 1058, 1081,
        211, 71, 60,
        25, 27, 24,
        361, 67, 580,
        101, 528, 78,
        160, 45, 175,
        104, 123, 113,
        24, 12, 25,
        166, 9, 45,
        45, 160, 166,
        47, 237, 225,
        211, 60, 29,
        27, 496, 501,
        501, 496, 507,
        452, 9, 166,
        56, 373, 57,
        107, 510, 516,
        170, 9, 171,
        45, 92, 82,
        114, 138, 123,
        25, 496, 27,
        107, 120, 510,
        178, 76, 383,
        101, 120, 107,
        26, 82, 92,
        510, 120, 129,
        1059, 1075, 1069,
        92, 45, 9,
        102, 104, 113,
        29, 60, 47,
        496, 25, 37,
        171, 9, 452,
        12, 22, 25,
        37, 69, 496,
        69, 78, 528,
        102, 113, 101,
        101, 113, 120,
        9, 170, 92,
        138, 139, 156,
        122, 129, 120,
        12, 183, 22,
        37, 22, 32,
        55, 37, 32,
        69, 66, 78,
        78, 102, 101,
        1083, 517, 1073,
        240, 71, 75,
        264, 259, 246,
        229, 1063, 236,
        852, 866, 849,
        908, 649, 529,
        150, 215, 157,
        84, 215, 195,
        278, 255, 173,
        215, 84, 157,
        230, 286, 202,
        150, 222, 215,
        195, 226, 23,
        195, 215, 228,
        23, 226, 3,
        566, 771, 770,
        228, 226, 195,
        277, 222, 262,
        222, 150, 206,
        228, 239, 223,
        223, 226, 228,
        260, 256, 279,
        223, 79, 226,
        214, 213, 200,
        279, 191, 260,
        216, 199, 265,
        165, 272, 158,
        262, 222, 206,
        215, 222, 228,
        239, 222, 277,
        249, 259, 274,
        272, 262, 1026,
        282, 79, 223,
        286, 209, 202,
        165, 168, 272,
        228, 222, 239,
        253, 282, 223,
        221, 1063, 1058,
        260, 275, 241,
        216, 191, 276,
        262, 272, 168,
        223, 239, 253,
        79, 282, 42,
        103, 309, 244,
        168, 277, 262,
        236, 257, 229,
        77, 205, 244,
        277, 273, 270,
        277, 270, 239,
        198, 19, 190,
        349, 553, 530,
        287, 153, 207,
        254, 168, 266,
        270, 253, 239,
        231, 253, 270,
        196, 1025, 185,
        280, 190, 208,
        132, 376, 149,
        282, 219, 42,
        270, 273, 231,
        254, 273, 277,
        201, 219, 253,
        282, 253, 219,
        197, 33, 219,
        263, 93, 229,
        55, 224, 249,
        219, 201, 197,
        232, 227, 238,
        278, 167, 284,
        199, 233, 284,
        256, 260, 240,
        253, 231, 201,
        259, 264, 269,
        259, 269, 274,
        224, 237, 246,
        283, 198, 190,
        618, 642, 348,
        32, 213, 55,
        5, 474, 470,
        22, 183, 17,
        280, 248, 190,
        821, 831, 825,
        281, 161, 148,
        273, 254, 189,
        201, 335, 197,
        257, 263, 229,
        216, 265, 275,
        248, 380, 283,
        189, 231, 273,
        231, 189, 53,
        1082, 1028, 1085,
        544, 567, 543,
        276, 279, 243,
        241, 275, 264,
        213, 196, 200,
        281, 148, 139,
        263, 218, 209,
        249, 224, 246,
        266, 285, 254,
        285, 189, 254,
        42, 219, 33,
        114, 274, 134,
        276, 243, 233,
        265, 281, 134,
        198, 192, 408,
        241, 47, 60,
        266, 444, 285,
        189, 285, 377,
        189, 377, 53,
        103, 257, 236,
        317, 663, 380,
        205, 317, 380,
        216, 276, 199,
        208, 58, 179,
        994, 211, 29,
        191, 216, 275,
        179, 209, 208,
        210, 237, 224,
        248, 218, 205,
        1083, 331, 338,
        815, 825, 813,
        517, 1083, 701,
        285, 94, 377,
        210, 224, 214,
        200, 196, 185,
        1065, 1069, 319,
        204, 263, 286,
        28, 200, 185,
        600, 572, 850,
        352, 204, 203,
        109, 274, 114,
        1057, 1089, 303,
        314, 325, 312,
        209, 280, 208,
        258, 412, 271,
        93, 1079, 229,
        1060, 625, 1082,
        1077, 1074, 1058,
        1060, 353, 247,
        760, 820, 1064,
        52, 207, 172,
        205, 218, 244,
        220, 324, 319,
        134, 274, 269,
        994, 307, 315,
        324, 220, 258,
        820, 760, 761,
        483, 533, 601,
        208, 19, 58,
        438, 350, 256,
        71, 240, 60,
        200, 28, 225,
        298, 321, 703,
        258, 220, 261,
        227, 234, 238,
        174, 251, 11,
        17, 196, 32,
        167, 278, 173,
        274, 109, 249,
        314, 784, 325,
        342, 413, 294,
        314, 307, 300,
        300, 951, 293,
        213, 214, 55,
        286, 230, 203,
        58, 140, 91,
        82, 26, 56,
        1026, 164, 272,
        438, 75, 437,
        303, 352, 203,
        309, 103, 221,
        753, 300, 293,
        204, 286, 203,
        204, 93, 263,
        279, 276, 191,
        275, 260, 191,
        438, 256, 75,
        517, 850, 1073,
        28, 47, 225,
        241, 240, 260,
        237, 47, 241,
        275, 269, 264,
        28, 988, 993,
        17, 1025, 196,
        220, 252, 261,
        245, 251, 174,
        294, 321, 355,
        114, 134, 139,
        1075, 354, 252,
        209, 286, 263,
        269, 265, 134,
        252, 1069, 1075,
        276, 233, 199,
        831, 821, 832,
        235, 369, 690,
        52, 161, 173,
        252, 187, 261,
        230, 245, 194,
        194, 8, 261,
        245, 8, 194,
        354, 187, 252,
        203, 230, 194,
        280, 209, 218,
        41, 57, 385,
        256, 240, 75,
        278, 284, 154,
        257, 244, 218,
        771, 561, 671,
        207, 39, 172,
        187, 194, 261,
        167, 161, 281,
        265, 167, 281,
        232, 211, 227,
        395, 192, 283,
        187, 203, 194,
        230, 251, 245,
        11, 251, 46,
        264, 246, 237,
        827, 295, 306,
        218, 248, 280,
        255, 52, 173,
        248, 283, 190,
        187, 303, 203,
        940, 916, 922,
        671, 562, 771,
        209, 179, 202,
        114, 139, 138,
        259, 249, 246,
        200, 225, 210,
        218, 263, 257,
        200, 210, 214,
        265, 269, 275,
        230, 202, 251,
        562, 782, 771,
        103, 244, 257,
        224, 55, 214,
        202, 179, 46,
        242, 171, 452,
        255, 207, 52,
        241, 264, 237,
        199, 167, 265,
        225, 237, 210,
        242, 155, 171,
        249, 109, 66,
        192, 198, 283,
        240, 241, 60,
        930, 740, 293,
        360, 80, 100,
        565, 561, 566,
        302, 621, 642,
        1085, 328, 336,
        560, 467, 478,
        324, 294, 319,
        563, 567, 581,
        77, 309, 1074,
        323, 351, 328,
        221, 103, 236,
        30, 43, 409,
        294, 324, 342,
        317, 205, 77,
        336, 353, 1085,
        311, 336, 36,
        247, 311, 331,
        311, 36, 177,
        1062, 323, 1038,
        366, 410, 363,
        679, 931, 739,
        299, 301, 891,
        294, 355, 319,
        1064, 820, 1057,
        351, 363, 328,
        330, 366, 351,
        605, 493, 595,
        327, 334, 326,
        618, 579, 530,
        978, 1006, 997,
        301, 922, 291,
        323, 330, 351,
        363, 351, 366,
        1076, 827, 306,
        77, 345, 317,
        67, 337, 429,
        1084, 292, 340,
        337, 346, 429,
        716, 299, 891,
        326, 334, 322,
        326, 322, 320,
        323, 1090, 330,
        388, 493, 404,
        878, 724, 874,
        185, 988, 28,
        221, 236, 1063,
        322, 773, 313,
        1006, 1005, 997,
        873, 724, 878,
        618, 530, 553,
        21, 393, 696,
        456, 459, 1002,
        992, 988, 185,
        308, 301, 299,
        922, 301, 313,
        800, 592, 593,
        992, 1025, 998,
        645, 642, 621,
        340, 292, 318,
        288, 582, 811,
        697, 858, 843,
        429, 346, 814,
        694, 676, 674,
        353, 311, 247,
        347, 344, 334,
        312, 333, 332,
        724, 873, 725,
        18, 866, 296,
        848, 357, 816,
        370, 318, 292,
        327, 347, 334,
        357, 235, 347,
        860, 1076, 1066,
        1085, 1038, 323,
        630, 580, 629,
        308, 299, 747,
        774, 327, 320,
        250, 305, 268,
        543, 567, 479,
        839, 838, 830,
        960, 948, 944,
        320, 322, 308,
        305, 369, 235,
        1086, 340, 51,
        581, 564, 491,
        227, 332, 234,
        354, 303, 187,
        308, 322, 313,
        867, 316, 678,
        852, 849, 838,
        331, 676, 338,
        320, 327, 326,
        874, 724, 727,
        690, 369, 411,
        479, 567, 563,
        1074, 345, 77,
        279, 350, 243,
        336, 311, 353,
        1058, 1074, 309,
        1074, 1077, 1066,
        347, 235, 344,
        301, 291, 891,
        330, 1086, 51,
        350, 279, 256,
        252, 220, 1069,
        347, 327, 816,
        308, 313, 301,
        243, 7, 233,
        312, 307, 314,
        85, 243, 350,
        85, 7, 243,
        383, 14, 400,
        335, 132, 197,
        917, 722, 649,
        792, 322, 334,
        625, 1060, 1072,
        416, 310, 335,
        994, 315, 211,
        211, 315, 227,
        85, 4, 7,
        324, 258, 310,
        381, 268, 305,
        335, 310, 132,
        201, 53, 335,
        315, 307, 312,
        312, 332, 315,
        315, 332, 227,
        310, 258, 271,
        621, 545, 645,
        324, 310, 342,
        643, 866, 18,
        380, 395, 283,
        328, 367, 336,
        234, 333, 402,
        234, 419, 238,
        1098, 110, 266,
        457, 1041, 1042,
        317, 306, 295,
        333, 234, 332,
        1065, 355, 298,
        65, 233, 7,
        369, 250, 85,
        318, 51, 340,
        342, 310, 416,
        333, 312, 325,
        662, 403, 405,
        149, 384, 435,
        33, 105, 42,
        1078, 631, 590,
        412, 258, 261,
        140, 58, 19,
        100, 453, 1016,
        1035, 17, 183,
        419, 447, 238,
        164, 1026, 1048,
        56, 26, 445,
        380, 663, 395,
        375, 392, 51,
        485, 492, 491,
        234, 402, 419,
        330, 51, 366,
        348, 642, 645,
        93, 204, 352,
        419, 655, 423,
        419, 423, 447,
        232, 447, 135,
        391, 422, 425,
        423, 437, 447,
        424, 423, 655,
        423, 424, 437,
        437, 135, 447,
        75, 135, 437,
        545, 439, 422,
        197, 149, 33,
        411, 438, 424,
        407, 405, 421,
        424, 438, 437,
        663, 295, 356,
        599, 477, 382,
        411, 350, 438,
        663, 317, 295,
        411, 369, 350,
        288, 866, 531,
        714, 341, 61,
        137, 136, 122,
        655, 411, 424,
        491, 500, 499,
        415, 413, 342,
        100, 639, 360,
        164, 158, 272,
        832, 847, 853,
        503, 599, 621,
        177, 111, 406,
        406, 111, 391,
        613, 629, 1049,
        444, 266, 110,
        59, 704, 141,
        390, 389, 40,
        1015, 499, 64,
        398, 413, 415,
        390, 418, 389,
        493, 388, 540,
        51, 318, 375,
        33, 435, 105,
        662, 670, 431,
        398, 415, 94,
        335, 53, 416,
        177, 36, 111,
        384, 405, 403,
        384, 403, 127,
        111, 44, 391,
        415, 377, 94,
        91, 140, 436,
        311, 177, 331,
        504, 417, 497,
        174, 11, 486,
        141, 413, 398,
        420, 398, 440,
        114, 104, 109,
        420, 386, 341,
        398, 94, 440,
        321, 141, 704,
        367, 142, 36,
        1, 79, 401,
        41, 82, 57,
        410, 392, 404,
        59, 420, 341,
        341, 386, 61,
        416, 377, 415,
        380, 248, 205,
        403, 86, 418,
        403, 418, 127,
        431, 425, 403,
        36, 10, 111,
        376, 271, 412,
        418, 390, 127,
        127, 105, 435,
        107, 516, 475,
        177, 406, 128,
        149, 376, 384,
        544, 459, 456,
        42, 105, 401,
        382, 439, 599,
        141, 420, 59,
        401, 79, 42,
        57, 82, 56,
        53, 201, 231,
        202, 46, 251,
        371, 374, 379,
        177, 128, 331,
        894, 914, 898,
        284, 167, 199,
        483, 486, 162,
        86, 403, 425,
        379, 392, 375,
        91, 533, 87,
        19, 198, 43,
        128, 406, 431,
        310, 271, 132,
        413, 321, 294,
        80, 360, 521,
        4, 250, 268,
        65, 426, 448,
        65, 284, 233,
        105, 127, 390,
        8, 412, 261,
        154, 284, 65,
        409, 43, 408,
        533, 483, 87,
        440, 444, 372,
        448, 154, 65,
        1089, 1088, 1079,
        439, 86, 425,
        486, 407, 174,
        154, 448, 163,
        444, 440, 94,
        371, 375, 370,
        404, 417, 410,
        43, 436, 140,
        132, 149, 197,
        598, 662, 405,
        405, 384, 421,
        448, 426, 427,
        87, 483, 162,
        356, 661, 663,
        379, 375, 371,
        141, 398, 420,
        105, 390, 401,
        367, 363, 410,
        130, 95, 372,
        431, 391, 425,
        704, 59, 720,
        431, 403, 662,
        448, 119, 163,
        417, 142, 410,
        410, 366, 392,
        382, 40, 389,
        431, 670, 128,
        372, 95, 440,
        44, 111, 10,
        384, 127, 435,
        452, 166, 508,
        51, 392, 366,
        370, 375, 318,
        426, 682, 427,
        448, 441, 119,
        330, 1061, 1086,
        302, 642, 618,
        427, 441, 448,
        1077, 766, 860,
        421, 384, 376,
        79, 3, 226,
        416, 53, 377,
        119, 131, 163,
        142, 10, 36,
        386, 420, 440,
        173, 161, 167,
        346, 337, 217,
        108, 153, 400,
        131, 441, 50,
        141, 321, 413,
        163, 2, 154,
        1079, 1081, 1063,
        8, 421, 412,
        412, 421, 376,
        379, 397, 388,
        46, 176, 162,
        401, 390, 1,
        427, 428, 441,
        441, 131, 119,
        149, 435, 33,
        441, 428, 50,
        163, 131, 387,
        428, 449, 50,
        163, 387, 2,
        242, 136, 137,
        147, 242, 137,
        136, 242, 452,
        760, 823, 761,
        428, 677, 715,
        427, 677, 428,
        49, 349, 530,
        582, 288, 612,
        11, 162, 486,
        91, 87, 176,
        131, 50, 387,
        387, 287, 2,
        2, 287, 255,
        136, 452, 414,
        136, 414, 129,
        814, 762, 13,
        1066, 345, 1074,
        415, 342, 416,
        379, 388, 392,
        255, 287, 207,
        586, 585, 577,
        50, 178, 387,
        178, 383, 387,
        383, 400, 287,
        287, 387, 383,
        36, 336, 367,
        470, 552, 465,
        850, 572, 1072,
        69, 507, 496,
        520, 513, 475,
        399, 504, 497,
        16, 489, 471,
        1055, 466, 15,
        809, 826, 821,
        1084, 340, 1068,
        865, 766, 1081,
        511, 721, 799,
        417, 504, 443,
        31, 474, 193,
        506, 443, 115,
        473, 510, 480,
        912, 928, 933,
        1083, 338, 701,
        488, 506, 607,
        1073, 850, 1072,
        637, 470, 460,
        343, 463, 457,
        476, 121, 112,
        473, 121, 476,
        34, 492, 35,
        499, 500, 64,
        510, 414, 480,
        44, 10, 506,
        44, 506, 488,
        823, 760, 430,
        212, 823, 865,
        495, 491, 499,
        899, 536, 892,
        414, 508, 480,
        463, 482, 466,
        495, 1011, 1051,
        505, 48, 73,
        184, 15, 186,
        1038, 1080, 1062,
        485, 564, 481,
        810, 458, 514,
        80, 468, 100,
        1065, 1059, 1069,
        637, 5, 470,
        90, 476, 112,
        1062, 1090, 323,
        482, 35, 20,
        1061, 778, 834,
        518, 524, 3,
        492, 34, 500,
        500, 491, 492,
        480, 121, 473,
        489, 27, 501,
        507, 69, 513,
        512, 23, 524,
        507, 513, 74,
        587, 495, 1051,
        573, 498, 364,
        472, 512, 524,
        501, 507, 74,
        83, 519, 304,
        1067, 778, 857,
        186, 863, 184,
        455, 461, 958,
        587, 581, 495,
        581, 491, 495,
        519, 83, 472,
        472, 83, 512,
        457, 466, 1055,
        734, 683, 751,
        516, 510, 473,
        518, 525, 524,
        399, 646, 504,
        12, 24, 16,
        517, 822, 781,
        485, 20, 492,
        1, 390, 40,
        458, 471, 514,
        728, 772, 854,
        524, 23, 3,
        29, 28, 993,
        505, 64, 500,
        476, 475, 516,
        84, 512, 157,
        476, 90, 520,
        1058, 309, 221,
        457, 463, 466,
        455, 462, 461,
        461, 462, 467,
        477, 40, 382,
        462, 469, 467,
        865, 658, 659,
        489, 482, 471,
        519, 515, 1031,
        3, 1, 518,
        38, 482, 489,
        513, 520, 74,
        462, 1000, 741,
        523, 1020, 1017,
        74, 520, 90,
        516, 473, 476,
        790, 593, 770,
        831, 841, 824,
        515, 519, 472,
        80, 494, 468,
        809, 821, 808,
        54, 501, 74,
        443, 504, 115,
        1067, 594, 1068,
        526, 521, 361,
        34, 505, 500,
        479, 469, 543,
        474, 552, 470,
        471, 482, 463,
        501, 54, 489,
        502, 1048, 468,
        482, 38, 35,
        471, 458, 16,
        885, 536, 535,
        518, 477, 641,
        966, 977, 974,
        835, 847, 826,
        68, 853, 847,
        493, 540, 595,
        297, 862, 781,
        526, 523, 509,
        521, 526, 494,
        190, 19, 208,
        482, 20, 466,
        528, 475, 513,
        651, 409, 652,
        512, 84, 23,
        520, 475, 476,
        741, 469, 462,
        467, 469, 478,
        931, 941, 739,
        510, 129, 414,
        685, 726, 869,
        27, 489, 16,
        1060, 1082, 353,
        484, 560, 478,
        526, 509, 494,
        509, 523, 490,
        494, 80, 521,
        73, 72, 505,
        815, 813, 583,
        69, 528, 513,
        469, 741, 543,
        484, 479, 563,
        484, 577, 560,
        470, 465, 460,
        841, 861, 839,
        761, 823, 212,
        1088, 1089, 820,
        1088, 212, 1079,
        826, 847, 832,
        950, 951, 971,
        830, 829, 806,
        543, 741, 459,
        469, 479, 478,
        577, 484, 586,
        1078, 1071, 625,
        68, 772, 728,
        509, 502, 494,
        494, 502, 468,
        518, 40, 477,
        44, 422, 391,
        508, 414, 452,
        407, 541, 405,
        100, 468, 453,
        801, 800, 593,
        790, 801, 593,
        464, 329, 744,
        515, 472, 525,
        407, 486, 541,
        422, 626, 578,
        479, 484, 478,
        586, 484, 563,
        490, 502, 509,
        823, 658, 865,
        1081, 212, 865,
        524, 525, 472,
        518, 1, 40,
        83, 304, 150,
        723, 715, 687,
        432, 715, 723,
        620, 721, 1084,
        721, 292, 1084,
        620, 648, 799,
        446, 359, 374,
        799, 359, 446,
        371, 446, 374,
        857, 498, 648,
        857, 648, 620,
        397, 374, 534,
        534, 374, 359,
        444, 94, 285,
        648, 359, 799,
        596, 534, 359,
        359, 648, 596,
        648, 539, 532,
        596, 540, 534,
        532, 596, 648,
        540, 397, 534,
        539, 648, 498,
        532, 595, 596,
        30, 436, 43,
        1070, 1075, 1059,
        525, 641, 553,
        532, 605, 595,
        588, 539, 573,
        539, 498, 573,
        532, 399, 605,
        526, 630, 1020,
        595, 540, 596,
        590, 588, 573,
        539, 399, 532,
        525, 518, 641,
        539, 588, 554,
        399, 539, 554,
        419, 718, 655,
        603, 867, 678,
        446, 371, 511,
        588, 623, 619,
        646, 399, 554,
        504, 646, 115,
        590, 623, 588,
        588, 619, 554,
        828, 628, 845,
        554, 633, 646,
        552, 544, 456,
        643, 636, 628,
        619, 633, 554,
        819, 628, 828,
        633, 638, 569,
        633, 569, 646,
        646, 569, 115,
        819, 622, 628,
        602, 769, 597,
        631, 623, 590,
        198, 408, 43,
        623, 638, 619,
        481, 544, 552,
        708, 700, 714,
        564, 544, 481,
        1017, 490, 523,
        657, 872, 871,
        964, 990, 967,
        638, 633, 619,
        535, 542, 1101,
        550, 730, 542,
        622, 819, 617,
        656, 688, 267,
        697, 673, 858,
        757, 574, 769,
        602, 617, 819,
        643, 622, 849,
        569, 638, 607,
        569, 607, 115,
        546, 542, 535,
        546, 550, 542,
        602, 606, 617,
        628, 622, 643,
        1101, 875, 885,
        535, 547, 546,
        374, 397, 379,
        570, 758, 627,
        570, 574, 758,
        769, 574, 597,
        602, 597, 606,
        617, 838, 622,
        622, 838, 849,
        623, 394, 638,
        607, 506, 115,
        565, 570, 627,
        617, 606, 829,
        302, 553, 641,
        726, 734, 729,
        591, 608, 752,
        556, 555, 546,
        575, 570, 566,
        575, 574, 570,
        597, 592, 606,
        617, 829, 838,
        660, 664, 712,
        1071, 1028, 1082,
        547, 535, 536,
        574, 575, 597,
        544, 564, 567,
        651, 608, 591,
        537, 547, 536,
        546, 547, 556,
        561, 565, 555,
        829, 606, 806,
        555, 556, 561,
        566, 570, 565,
        605, 399, 497,
        481, 31, 485,
        30, 651, 591,
        548, 547, 537,
        623, 144, 394,
        732, 640, 763,
        556, 548, 549,
        966, 978, 977,
        631, 1078, 625,
        631, 144, 623,
        529, 899, 908,
        548, 556, 547,
        331, 128, 676,
        597, 575, 592,
        394, 607, 638,
        599, 439, 545,
        564, 485, 491,
        659, 30, 591,
        549, 562, 671,
        330, 1090, 1061,
        792, 699, 798,
        871, 726, 657,
        548, 537, 731,
        731, 537, 529,
        698, 267, 712,
        723, 442, 432,
        635, 1072, 572,
        621, 302, 503,
        659, 436, 30,
        1041, 184, 1047,
        549, 548, 746,
        770, 593, 592,
        835, 644, 527,
        625, 635, 631,
        553, 349, 525,
        625, 1071, 1082,
        361, 580, 630,
        631, 635, 144,
        144, 488, 394,
        394, 488, 607,
        564, 581, 567,
        1084, 1068, 594,
        440, 95, 386,
        857, 620, 594,
        635, 626, 144,
        626, 635, 365,
        488, 144, 626,
        581, 587, 563,
        49, 530, 217,
        217, 530, 579,
        49, 217, 639,
        687, 715, 705,
        615, 624, 835,
        664, 684, 614,
        639, 217, 337,
        44, 626, 422,
        705, 736, 687,
        396, 772, 527,
        289, 290, 188,
        549, 759, 562,
        635, 572, 365,
        446, 511, 799,
        361, 360, 67,
        217, 579, 346,
        348, 579, 618,
        603, 542, 730,
        978, 997, 977,
        624, 644, 835,
        396, 290, 289,
        426, 65, 4,
        626, 44, 488,
        360, 639, 337,
        358, 433, 290,
        644, 647, 527,
        647, 396, 527,
        433, 610, 290,
        897, 919, 903,
        572, 600, 365,
        866, 643, 849,
        846, 601, 430,
        601, 533, 430,
        515, 525, 349,
        816, 774, 793,
        358, 290, 396,
        601, 846, 568,
        397, 540, 388,
        679, 558, 557,
        665, 558, 679,
        576, 815, 583,
        557, 576, 583,
        815, 576, 808,
        624, 609, 644,
        557, 558, 576,
        615, 609, 624,
        358, 396, 647,
        658, 430, 533,
        1087, 298, 703,
        578, 626, 365,
        483, 601, 568,
        1028, 1078, 1080,
        192, 652, 408,
        629, 644, 609,
        644, 629, 647,
        433, 67, 429,
        762, 640, 732,
        605, 497, 493,
        503, 477, 599,
        568, 486, 483,
        302, 641, 503,
        552, 474, 481,
        958, 739, 941,
        538, 665, 739,
        641, 477, 503,
        559, 558, 665,
        645, 578, 763,
        541, 568, 604,
        958, 461, 538,
        558, 584, 576,
        882, 897, 903,
        348, 763, 640,
        578, 645, 545,
        598, 604, 668,
        568, 541, 486,
        467, 560, 551,
        422, 439, 425,
        584, 558, 559,
        576, 584, 808,
        808, 589, 1010,
        882, 903, 871,
        433, 429, 13,
        579, 640, 814,
        645, 763, 348,
        604, 598, 541,
        800, 807, 806,
        801, 797, 800,
        629, 580, 647,
        647, 580, 358,
        763, 578, 365,
        551, 560, 559,
        559, 585, 584,
        580, 67, 358,
        358, 67, 433,
        707, 858, 711,
        465, 552, 456,
        577, 585, 559,
        560, 577, 559,
        584, 585, 589,
        771, 790, 770,
        555, 565, 689,
        677, 682, 169,
        334, 344, 792,
        370, 511, 371,
        1081, 1058, 1063,
        658, 533, 436,
        550, 555, 689,
        395, 663, 661,
        354, 1075, 1057,
        810, 1043, 1039,
        1085, 323, 328,
        627, 758, 683,
        699, 571, 798,
        720, 21, 692,
        671, 561, 556,
        723, 687, 6,
        409, 651, 30,
        690, 571, 699,
        555, 550, 546,
        551, 559, 665,
        402, 672, 616,
        303, 1089, 352,
        699, 792, 344,
        715, 677, 705,
        381, 305, 653,
        305, 357, 653,
        1023, 1042, 1005,
        616, 709, 571,
        709, 798, 571,
        689, 730, 550,
        692, 21, 696,
        402, 333, 672,
        169, 673, 736,
        442, 723, 700,
        684, 664, 660,
        393, 341, 714,
        1013, 986, 979,
        356, 827, 669,
        702, 698, 811,
        616, 784, 709,
        662, 667, 670,
        670, 674, 676,
        634, 656, 702,
        634, 702, 686,
        306, 345, 1076,
        1084, 594, 620,
        667, 674, 670,
        594, 1067, 857,
        61, 708, 714,
        381, 653, 711,
        707, 711, 653,
        672, 333, 325,
        598, 667, 662,
        667, 598, 668,
        667, 182, 674,
        676, 694, 338,
        851, 691, 855,
        393, 714, 611,
        701, 694, 1087,
        683, 734, 735,
        627, 680, 689,
        338, 694, 701,
        683, 758, 751,
        490, 96, 502,
        700, 723, 6,
        696, 634, 686,
        212, 1081, 1079,
        834, 1067, 1086,
        566, 561, 771,
        565, 627, 689,
        690, 718, 571,
        686, 702, 811,
        356, 666, 661,
        656, 634, 688,
        712, 650, 660,
        627, 683, 680,
        698, 664, 811,
        370, 721, 511,
        682, 381, 169,
        696, 611, 634,
        676, 128, 670,
        1100, 603, 735,
        6, 611, 700,
        368, 632, 329,
        654, 395, 661,
        655, 690, 411,
        1007, 1023, 1006,
        713, 706, 717,
        713, 681, 368,
        681, 713, 719,
        681, 632, 368,
        586, 563, 587,
        730, 689, 680,
        655, 718, 690,
        770, 575, 566,
        341, 21, 59,
        718, 616, 571,
        660, 650, 675,
        1087, 703, 706,
        706, 703, 717,
        632, 802, 804,
        442, 700, 708,
        717, 719, 713,
        614, 864, 18,
        696, 393, 611,
        650, 267, 736,
        735, 730, 680,
        736, 705, 169,
        703, 321, 704,
        693, 710, 681,
        710, 802, 632,
        549, 671, 556,
        672, 325, 784,
        714, 700, 611,
        704, 717, 703,
        719, 717, 720,
        685, 868, 867,
        661, 666, 608,
        718, 419, 402,
        235, 357, 305,
        718, 402, 616,
        436, 659, 658,
        719, 693, 681,
        538, 461, 551,
        717, 704, 720,
        296, 614, 18,
        710, 693, 695,
        672, 784, 616,
        321, 298, 355,
        739, 665, 679,
        652, 395, 654,
        356, 669, 666,
        719, 720, 693,
        692, 695, 693,
        695, 582, 710,
        656, 698, 702,
        653, 848, 707,
        816, 357, 347,
        232, 238, 447,
        664, 614, 296,
        650, 673, 675,
        59, 21, 720,
        720, 692, 693,
        292, 721, 370,
        682, 268, 381,
        722, 931, 679,
        680, 683, 735,
        1073, 1060, 247,
        603, 730, 735,
        688, 634, 6,
        692, 686, 695,
        6, 634, 611,
        659, 591, 766,
        608, 651, 654,
        752, 608, 666,
        698, 712, 664,
        341, 393, 21,
        651, 652, 654,
        654, 661, 608,
        381, 711, 169,
        710, 632, 681,
        660, 691, 684,
        675, 691, 660,
        614, 684, 864,
        705, 677, 169,
        268, 682, 426,
        6, 687, 688,
        696, 686, 692,
        686, 582, 695,
        811, 582, 686,
        736, 688, 687,
        684, 856, 864,
        675, 855, 691,
        1089, 1057, 820,
        944, 948, 933,
        859, 522, 1070,
        685, 867, 1100,
        774, 320, 308,
        454, 706, 713,
        862, 732, 781,
        68, 527, 772,
        364, 1090, 573,
        960, 1097, 948,
        454, 297, 822,
        300, 767, 314,
        709, 767, 779,
        545, 422, 578,
        300, 753, 767,
        784, 767, 709,
        753, 779, 767,
        870, 726, 871,
        1034, 1042, 1041,
        821, 825, 815,
        13, 464, 610,
        726, 870, 869,
        753, 740, 773,
        912, 927, 902,
        868, 685, 869,
        1055, 1041, 457,
        942, 931, 923,
        753, 773, 779,
        779, 792, 798,
        13, 862, 464,
        862, 297, 464,
        433, 13, 610,
        728, 854, 804,
        806, 592, 800,
        779, 773, 792,
        862, 762, 732,
        188, 610, 744,
        939, 968, 964,
        822, 701, 706,
        861, 68, 531,
        839, 852, 838,
        772, 396, 289,
        930, 922, 740,
        773, 322, 792,
        43, 140, 19,
        981, 986, 978,
        314, 767, 784,
        740, 922, 313,
        824, 841, 839,
        740, 313, 773,
        789, 694, 674,
        826, 615, 835,
        1023, 1005, 1006,
        861, 852, 839,
        854, 188, 744,
        711, 673, 169,
        903, 919, 912,
        583, 813, 791,
        807, 797, 813,
        592, 806, 606,
        859, 668, 604,
        813, 825, 807,
        816, 840, 848,
        1061, 1090, 364,
        791, 813, 797,
        289, 188, 854,
        583, 765, 557,
        331, 1083, 247,
        852, 531, 866,
        1066, 1076, 345,
        291, 922, 916,
        528, 101, 107,
        774, 816, 327,
        643, 18, 636,
        583, 791, 765,
        722, 737, 649,
        1043, 810, 514,
        793, 840, 816,
        928, 912, 919,
        522, 604, 846,
        430, 658, 823,
        267, 688, 736,
        673, 697, 675,
        650, 736, 673,
        778, 498, 857,
        498, 778, 364,
        841, 831, 832,
        747, 793, 774,
        899, 529, 537,
        759, 791, 786,
        72, 64, 505,
        786, 801, 782,
        522, 846, 760,
        781, 822, 297,
        308, 747, 774,
        848, 840, 707,
        612, 728, 802,
        557, 737, 679,
        821, 815, 808,
        517, 781, 850,
        747, 780, 793,
        1028, 1038, 1085,
        317, 345, 306,
        96, 487, 502,
        573, 1062, 1080,
        739, 958, 538,
        612, 802, 582,
        731, 649, 746,
        747, 748, 780,
        299, 748, 747,
        842, 707, 840,
        182, 667, 668,
        824, 830, 807,
        467, 551, 461,
        825, 824, 807,
        737, 557, 756,
        858, 707, 842,
        299, 716, 748,
        840, 812, 842,
        430, 760, 846,
        756, 765, 759,
        737, 746, 649,
        549, 756, 759,
        1059, 1065, 789,
        793, 780, 788,
        812, 840, 793,
        744, 610, 464,
        368, 329, 297,
        1064, 522, 760,
        531, 612, 288,
        13, 762, 862,
        858, 842, 843,
        549, 746, 756,
        775, 788, 780,
        759, 786, 562,
        748, 775, 780,
        788, 812, 793,
        531, 728, 612,
        738, 775, 748,
        872, 785, 873,
        522, 859, 604,
        748, 716, 738,
        711, 858, 673,
        1041, 1047, 1034,
        746, 548, 731,
        244, 309, 77,
        832, 853, 841,
        812, 833, 842,
        791, 759, 765,
        727, 716, 874,
        716, 727, 738,
        749, 788, 775,
        842, 833, 843,
        738, 749, 775,
        833, 794, 817,
        814, 13, 429,
        182, 859, 1070,
        822, 517, 701,
        788, 768, 794,
        788, 794, 812,
        794, 833, 812,
        836, 843, 833,
        903, 912, 902,
        791, 797, 786,
        182, 1059, 789,
        742, 738, 727,
        749, 768, 788,
        817, 836, 833,
        675, 697, 855,
        674, 182, 789,
        967, 979, 975,
        650, 712, 267,
        951, 950, 293,
        756, 557, 765,
        763, 600, 732,
        727, 725, 742,
        738, 742, 749,
        802, 710, 582,
        746, 737, 756,
        853, 68, 861,
        749, 754, 768,
        794, 803, 817,
        843, 836, 697,
        853, 861, 841,
        850, 781, 600,
        724, 725, 727,
        794, 768, 803,
        817, 803, 805,
        855, 837, 851,
        806, 807, 830,
        368, 454, 713,
        768, 754, 764,
        817, 837, 836,
        562, 786, 782,
        804, 854, 744,
        694, 789, 1087,
        725, 733, 742,
        742, 754, 749,
        768, 764, 803,
        803, 764, 805,
        817, 805, 837,
        776, 743, 755,
        267, 698, 656,
        1059, 182, 1070,
        805, 764, 795,
        521, 360, 361,
        735, 734, 1100,
        743, 754, 733,
        764, 754, 776,
        836, 837, 855,
        734, 726, 685,
        709, 779, 798,
        899, 537, 536,
        742, 733, 754,
        764, 776, 795,
        805, 844, 837,
        796, 602, 819,
        295, 827, 356,
        706, 701, 1087,
        799, 721, 620,
        852, 861, 531,
        649, 731, 529,
        528, 107, 475,
        725, 785, 733,
        866, 288, 296,
        542, 603, 678,
        744, 329, 804,
        743, 776, 754,
        795, 818, 805,
        907, 914, 929,
        785, 745, 743,
        785, 743, 733,
        755, 777, 776,
        844, 805, 818,
        636, 845, 628,
        848, 653, 357,
        873, 882, 872,
        343, 457, 1042,
        745, 755, 743,
        795, 776, 777,
        804, 329, 632,
        825, 831, 824,
        752, 666, 669,
        864, 856, 636,
        669, 860, 752,
        722, 679, 737,
        745, 785, 657,
        796, 795, 777,
        851, 837, 844,
        527, 68, 847,
        182, 668, 859,
        826, 832, 821,
        855, 697, 836,
        459, 741, 1002,
        883, 882, 878,
        531, 68, 728,
        851, 856, 691,
        856, 684, 691,
        615, 826, 809,
        883, 897, 882,
        860, 669, 1076,
        568, 846, 604,
        729, 745, 657,
        785, 725, 873,
        1013, 1024, 1007,
        188, 290, 610,
        752, 766, 591,
        600, 763, 365,
        729, 750, 745,
        750, 755, 745,
        750, 777, 755,
        769, 796, 777,
        777, 757, 769,
        573, 1080, 590,
        960, 970, 1097,
        814, 640, 762,
        766, 752, 860,
        875, 678, 316,
        851, 845, 856,
        664, 296, 811,
        879, 884, 874,
        729, 751, 750,
        796, 818, 795,
        819, 818, 796,
        828, 844, 818,
        851, 844, 845,
        474, 31, 481,
        802, 728, 804,
        364, 778, 1061,
        454, 822, 706,
        772, 289, 854,
        297, 454, 368,
        757, 750, 751,
        828, 845, 844,
        845, 636, 856,
        12, 16, 458,
        872, 882, 871,
        1081, 766, 1077,
        757, 777, 750,
        602, 796, 769,
        819, 828, 818,
        1083, 1073, 247,
        751, 758, 757,
        835, 527, 847,
        945, 967, 956,
        636, 18, 864,
        464, 297, 329,
        830, 824, 839,
        766, 865, 659,
        427, 682, 677,
        871, 903, 881,
        982, 987, 1008,
        984, 998, 987,
        971, 976, 1095,
        981, 979, 986,
        184, 1041, 1055,
        615, 1029, 609,
        1037, 810, 1039,
        930, 961, 940,
        950, 961, 930,
        1078, 1028, 1071,
        940, 961, 1095,
        961, 971, 1095,
        976, 992, 984,
        992, 998, 984,
        1001, 1025, 1035,
        915, 894, 291,
        652, 409, 408,
        902, 927, 911,
        915, 914, 894,
        929, 913, 904,
        1001, 1019, 1014,
        652, 192, 395,
        921, 929, 914,
        1035, 1044, 1019,
        984, 949, 1095,
        982, 1030, 1018,
        907, 898, 914,
        1036, 1018, 1030,
        984, 987, 983,
        1008, 1030, 982,
        1070, 1064, 1075,
        968, 983, 982,
        298, 789, 1065,
        956, 975, 960,
        639, 339, 49,
        1044, 362, 1037,
        339, 100, 1016,
        930, 940, 922,
        961, 950, 971,
        988, 992, 976,
        307, 951, 300,
        1008, 998, 1001,
        1025, 1001, 998,
        940, 935, 916,
        726, 729, 657,
        1035, 1019, 1001,
        1028, 1080, 1038,
        1019, 1044, 1037,
        897, 920, 919,
        884, 898, 907,
        949, 983, 968,
        1006, 978, 986,
        1023, 1043, 1042,
        971, 993, 976,
        487, 1048, 502,
        783, 349, 339,
        1025, 992, 185,
        100, 339, 639,
        929, 939, 934,
        339, 1016, 783,
        987, 998, 1008,
        990, 964, 968,
        783, 515, 349,
        949, 984, 983,
        487, 164, 1048,
        951, 993, 971,
        890, 913, 883,
        753, 293, 740,
        783, 1016, 1031,
        990, 1018, 1013,
        463, 514, 471,
        945, 956, 934,
        630, 629, 613,
        883, 878, 890,
        979, 981, 975,
        913, 929, 934,
        1042, 1043, 343,
        523, 526, 1020,
        810, 362, 458,
        629, 609, 1049,
        630, 613, 1020,
        987, 982, 983,
        1016, 999, 1031,
        404, 493, 497,
        1015, 81, 1056,
        913, 890, 904,
        994, 993, 951,
        1036, 1024, 1018,
        956, 960, 944,
        881, 903, 902,
        873, 878, 882,
        453, 999, 1016,
        519, 1031, 1027,
        976, 993, 988,
        17, 1035, 1025,
        255, 278, 2,
        1020, 613, 957,
        1031, 999, 1027,
        609, 1029, 1049,
        468, 1048, 453,
        1037, 362, 810,
        1049, 1032, 1045,
        291, 894, 891,
        1048, 1026, 453,
        1026, 999, 453,
        538, 551, 665,
        1029, 1032, 1049,
        613, 1045, 957,
        957, 1017, 1020,
        907, 929, 904,
        206, 999, 1026,
        1045, 613, 1049,
        957, 1009, 1017,
        939, 921, 949,
        206, 1027, 999,
        913, 920, 883,
        1027, 304, 519,
        303, 354, 1057,
        362, 1044, 183,
        458, 362, 12,
        921, 935, 949,
        404, 497, 417,
        1027, 206, 304,
        939, 949, 968,
        615, 809, 1029,
        879, 874, 716,
        1026, 262, 206,
        941, 965, 958,
        958, 965, 455,
        1032, 1050, 1045,
        1009, 995, 1017,
        514, 463, 343,
        929, 921, 939,
        952, 941, 953,
        952, 965, 941,
        995, 787, 490,
        809, 1010, 1029,
        1029, 1010, 1032,
        1045, 1050, 957,
        514, 343, 1043,
        455, 965, 980,
        1050, 1009, 957,
        995, 490, 1017,
        1052, 460, 465,
        931, 953, 941,
        952, 980, 965,
        785, 872, 657,
        589, 808, 584,
        1024, 1013, 1018,
        741, 1000, 1002,
        884, 907, 904,
        637, 460, 88,
        980, 1000, 455,
        362, 183, 12,
        1010, 1021, 1032,
        920, 897, 883,
        953, 931, 942,
        465, 456, 451,
        589, 1021, 1010,
        1051, 1050, 1021,
        1050, 1051, 1009,
        1056, 787, 995,
        637, 863, 5,
        952, 962, 972,
        972, 980, 952,
        1021, 1050, 1032,
        1009, 1011, 995,
        891, 879, 716,
        598, 405, 541,
        939, 945, 934,
        1053, 88, 460,
        920, 934, 928,
        455, 1000, 462,
        935, 915, 916,
        1011, 1009, 1051,
        1011, 1056, 995,
        787, 96, 490,
        934, 956, 928,
        994, 29, 993,
        923, 722, 917,
        923, 931, 722,
        942, 962, 953,
        962, 952, 953,
        1021, 589, 586,
        915, 935, 921,
        962, 969, 972,
        989, 1000, 980,
        1035, 183, 1044,
        586, 587, 1021,
        291, 916, 915,
        946, 962, 942,
        972, 989, 980,
        787, 1056, 81,
        863, 186, 5,
        917, 924, 923,
        456, 1002, 450,
        1005, 1042, 1034,
        892, 895, 899,
        899, 895, 908,
        909, 917, 908,
        909, 924, 917,
        989, 1002, 1000,
        1002, 989, 1003,
        860, 1066, 1077,
        456, 450, 451,
        976, 984, 1095,
        499, 1015, 1011,
        1011, 1015, 1056,
        939, 964, 945,
        886, 875, 880,
        886, 892, 885,
        886, 895, 892,
        895, 909, 908,
        925, 924, 909,
        946, 942, 936,
        991, 1003, 989,
        1003, 1022, 450,
        450, 1040, 451,
        451, 1040, 1052,
        590, 1080, 1078,
        1010, 809, 808,
        875, 886, 885,
        895, 910, 909,
        985, 972, 969,
        1003, 450, 1002,
        1040, 450, 1022,
        878, 874, 884,
        893, 900, 886,
        900, 895, 886,
        910, 895, 900,
        910, 925, 909,
        972, 991, 989,
        880, 893, 886,
        936, 942, 923,
        946, 969, 962,
        985, 991, 972,
        1040, 1033, 1046,
        1046, 1052, 1040,
        1054, 1046, 1033,
        1052, 1046, 1053,
        307, 994, 951,
        878, 884, 890,
        887, 893, 880,
        905, 910, 900,
        959, 969, 946,
        1046, 88, 1053,
        960, 975, 970,
        515, 783, 1031,
        956, 967, 975,
        316, 880, 875,
        900, 901, 905,
        918, 925, 910,
        905, 918, 910,
        925, 936, 924,
        936, 923, 924,
        959, 946, 954,
        954, 946, 936,
        88, 1046, 1054,
        1011, 495, 499,
        868, 316, 867,
        877, 880, 316,
        877, 887, 880,
        932, 925, 918,
        932, 936, 925,
        959, 973, 969,
        963, 973, 959,
        2, 278, 154,
        868, 877, 316,
        901, 893, 887,
        901, 900, 893,
        996, 991, 985,
        991, 1022, 1003,
        996, 1022, 991,
        1015, 64, 81,
        887, 888, 901,
        901, 906, 905,
        905, 926, 918,
        932, 954, 936,
        996, 1012, 1022,
        1033, 1040, 1012,
        876, 877, 868,
        906, 901, 888,
        906, 926, 905,
        918, 937, 932,
        954, 932, 943,
        963, 959, 954,
        1012, 1040, 1022,
        206, 150, 304,
        928, 944, 933,
        990, 979, 967,
        585, 586, 589,
        869, 876, 868,
        876, 887, 877,
        911, 926, 906,
        1054, 637, 88,
        920, 928, 919,
        889, 876, 869,
        889, 888, 876,
        888, 887, 876,
        1052, 1053, 460,
        72, 81, 64,
        888, 896, 906,
        938, 937, 926,
        955, 963, 954,
        1047, 1054, 1033,
        863, 637, 1054,
        293, 950, 930,
        888, 889, 896,
        1047, 863, 1054,
        990, 1013, 979,
        1034, 1012, 1005,
        884, 904, 890,
        894, 879, 891,
        870, 889, 869,
        896, 911, 906,
        536, 885, 892,
        879, 898, 884,
        898, 879, 894,
        927, 926, 911,
        1012, 1034, 1033,
        1034, 1047, 1033,
        349, 49, 339,
        986, 1013, 1007,
        927, 938, 926,
        955, 974, 963,
        1007, 1006, 986,
        964, 967, 945,
        881, 889, 870,
        896, 902, 911,
        982, 1018, 990,
        871, 881, 870,
        896, 881, 902,
        948, 947, 938,
        1004, 1005, 1012,
        5, 186, 193,
        914, 915, 921,
        956, 944, 928,
        968, 982, 990,
        934, 920, 913,
        889, 881, 896,
        927, 912, 933,
        933, 938, 927,
        933, 948, 938,
        948, 1097, 947,
        966, 974, 955,
        184, 863, 1047,
        465, 451, 1052,
        1005, 1004, 997,
        935, 940, 1095,
        1095, 949, 935,
        1051, 1021, 587,
        970, 975, 981,
        981, 978, 966,
        970, 981, 966,
        955, 954, 943,
        966, 955, 1094,
        937, 918, 926,
        943, 932, 937,
        937, 938, 947,
        943, 937, 947,
        1094, 943, 947,
        970, 1094, 1097,
        1008, 1001, 1014,
        1030, 1008, 1014,
        1036, 1030, 1092,
        1019, 1037, 1091,
        1014, 1019, 1091,
        1037, 1039, 1096,
        1091, 1096, 1036,
        1096, 1024, 1036,
        1039, 1043, 1023,
        1023, 1007, 1039,
        1024, 1096, 1039,
        1004, 1012, 996,
        985, 969, 973,
        1099, 985, 1093,
        973, 963, 974,
        974, 977, 1093,
        977, 1099, 1093,
        1092, 1014, 1091,
        1091, 1036, 1092,
        985, 973, 1093,
        1030, 1014, 1092,
        1099, 1004, 996,
        955, 943, 1094,
        1094, 970, 966,
        1099, 977, 997,
        1096, 1091, 1037,
        1024, 1039, 1007,
        1094, 947, 1097,
        1093, 973, 974,
        266, 165, 1098,
        1099, 997, 1004,
        996, 985, 1099,
        212, 1088, 761,
        867, 603, 1100,
        1100, 734, 685,
        885, 535, 1101,
        678, 875, 1101,
        1101, 542, 678
    };

    LOG_IF(FATAL, (buffVertices.size() % 3 != 0)) << "Invalid vertex data";
    LOG_IF(FATAL, (buffFaces.size() % 3 != 0)) << "Invalid face data";

    std::shared_ptr<VecDataArray<double, 3>> verticesPtr = std::make_shared<VecDataArray<double, 3>>();
    VecDataArray<double, 3>&                 vertices    = *verticesPtr;
    vertices.reserve(static_cast<int>(buffVertices.size() / 3));
    for (size_t i = 0; i < buffVertices.size() / 3; ++i)
    {
        vertices.push_back(Vec3d(buffVertices[i * 3],
                                    buffVertices[i * 3 + 1],
                                    buffVertices[i * 3 + 2]));
    }

    std::shared_ptr<VecDataArray<int, 3>> facesPtr = std::make_shared<VecDataArray<int, 3>>();
    VecDataArray<int, 3>&                 faces    = *facesPtr;
    faces.reserve(static_cast<int>(buffFaces.size() / 3));
    for (size_t i = 0; i < buffFaces.size() / 3; ++i)
    {
        // Face ID of triangles is 0-based index (data from .obj file is 1-based index)
        faces.push_back(Vec3i(buffFaces[i * 3] - 1, buffFaces[i * 3 + 1] - 1, buffFaces[i * 3 + 2] - 1));
    }

    return { verticesPtr, facesPtr };
}
