/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

=========================================================================*/

#ifndef imstkVTKdbgLinesRenderDelegate_h
#define imstkVTKdbgLinesRenderDelegate_h

#include <memory>

#include "imstkVTKRenderDelegate.h"

class vtkDoubleArray;

namespace imstk
{

///
/// \class LinesRenderDelegate
///
/// \brief Renders a list of disjoint line segments
///
class VTKdbgLinesRenderDelegate : public VTKRenderDelegate
{
public:
    ///
    /// \brief Constructor
    ///
    VTKdbgLinesRenderDelegate(std::shared_ptr<DebugRenderLines> renderLines);

    ///
    /// \brief Update polydata source based on the surface mesh geometry
    ///
    void updateDataSource() override;
    
    ///
    /// \brief Return geometry to render
    ///
    std::shared_ptr<Geometry> getGeometry() const { return nullptr; };

    ///
    /// \brief Return the render material
    ///
    std::shared_ptr<RenderMaterial> getRenderMaterial() const { return m_Lines->getRenderMaterial(); };    

protected:

    std::shared_ptr<DebugRenderLines> m_Lines;                ///> Geometry to render
    vtkSmartPointer<vtkDoubleArray> m_mappedVertexArray;    ///> Mapped array of vertices
};
}

#endif // ifndef imstkVTKdbgLinesRenderDelegate_h
