/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   =========================================================================*/

#ifndef imstkVegaMeshReader_h
#define imstkVegaMeshReader_h

#include <memory>

#include "imstkMeshReader.h"
#include "imstkVolumetricMesh.h"

namespace imstk {

///
/// \class VegaMeshReader
///
/// \brief
///
class VegaMeshReader
{
public:

    VegaMeshReader() = default;
    ~VegaMeshReader() = default;

    ///
    /// \brief
    ///
    static std::shared_ptr<VolumetricMesh> read(const std::string& filePath, MeshFileType meshType);
};
}

#endif // ifndef imstkVegaMeshReader_h
