# This will copy the PhysX headers and libraries
# from its install directory to the iMSTK install directory

if(POLICY CMP0012)
  cmake_policy(SET CMP0012 NEW)
endif()

function(string_starts_with str search bool)
  string(FIND "${str}" "${search}" out)
  if("${out}" EQUAL 0)
    set(${bool} TRUE PARENT_SCOPE)
  else()
    set(${bool} FALSE PARENT_SCOPE)
  endif()
endfunction()
message(STATUS "Installing PhysX from ${PhysX_INSTALL_DIR} to ${iMSTK_INSTALL_DIR}")

set(physx_platform_folder_ "")
file(GLOB dir_list RELATIVE ${PhysX_INSTALL_DIR}/bin/ ${PhysX_INSTALL_DIR}/bin/*)
  foreach(dir ${dir_list})
    if(IS_DIRECTORY ${PhysX_INSTALL_DIR}/bin/${dir})
      string_starts_with(${dir} "win." is_win_)
      string_starts_with(${dir} "mac." is_mac_)
      string_starts_with(${dir} "linux." is_linux_)
      string_starts_with(${dir} "UNKNOWN" is_unknown_)
      if( ${is_win_} OR ${is_mac_} OR ${is_linux_} OR ${is_unknown_})
        set(physx_platform_folder_ ${PhysX_INSTALL_DIR}/bin/${dir})
        break()
      endif()
    endif()
  endforeach()
message(STATUS "physx_platform_folder : ${physx_platform_folder_}")

file(MAKE_DIRECTORY ${iMSTK_INSTALL_DIR}/include/physx)
file(COPY ${PhysX_INSTALL_DIR}/include/ DESTINATION ${iMSTK_INSTALL_DIR}/include/physx)
file(COPY ${PhysX_INSTALL_DIR}/source/foundation/include/ DESTINATION ${iMSTK_INSTALL_DIR}/include/physx)
file(COPY ${PhysX_INSTALL_DIR}/source/fastxml/include/ DESTINATION ${iMSTK_INSTALL_DIR}/include/physx)
if(EXISTS ${physx_platform_folder_}/debug)
  file(COPY ${physx_platform_folder_}/debug/ DESTINATION ${iMSTK_INSTALL_DIR}/lib)
endif()
if(EXISTS ${physx_platform_folder_}/release)
  file(COPY ${physx_platform_folder_}/release/ DESTINATION ${iMSTK_INSTALL_DIR}/lib)
endif()
if(EXISTS ${physx_platform_folder_}/checked)
  file(COPY ${physx_platform_folder_}/checked/ DESTINATION ${iMSTK_INSTALL_DIR}/lib)
endif()
if(EXISTS ${physx_platform_folder_}/profile)
  file(COPY ${physx_platform_folder_}/profile/ DESTINATION ${iMSTK_INSTALL_DIR}/lib)
endif()

