/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License",
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

=========================================================================*/

#include "imstkMath.h"
using namespace imstk;

// Hard-code a point set of particles sampled inside a Stanford bunny
// Num. particles: 8834
StdVectorOfVec3d getBunny()
{
    StdVectorOfVec3d bunny;
    bunny.resize(8834);
    double buff[] {
        -1.92681599, -2.64812398, 0.0674370006,
        -1.78630209, -2.74101901, 0.0469290018,
        -1.62241495, -2.74305606, -0.015261,
        -1.39111495, -2.74284315, 0.0509760007,
        -1.22273397, -2.74135208, 0.0490349978,
        -1.049016, -2.74033809, 0.0573600009,
        -0.879002988, -2.707932, 0.0771539956,
        0.789219022, -2.71027493, 0.0179909989,
        1.01450109, -2.71401882, 0.0569549985,
        1.18834198, -2.68853402, 0.0244349986,
        -1.86633897, -2.483742, 0.0907230005,
        -1.69854605, -2.58964801, 0.0342300013,
        -1.51111794, -2.61512113, 0.0158759989,
        -1.32553506, -2.59052086, 0.0119880009,
        -1.14128399, -2.59632587, 0.0103559997,
        -0.983051956, -2.57542801, 0.0537749976,
        -0.844064951, -2.55088806, 0.144549012,
        -0.702426016, -2.47408199, 0.0890039951,
        -0.557823002, -2.57794213, 0.085710004,
        -0.454178989, -2.44795799, 0.115817994,
        -0.351027012, -2.57717991, 0.0847859979,
        -0.175953001, -2.57748318, 0.0726689994,
        -0.00235800003, -2.55699897, 0.0282329991,
        0.161982, -2.55447912, -0.0319169983,
        0.299234986, -2.55452991, 0.0724169984,
        0.479982018, -2.55081296, 0.0703829974,
        0.648414016, -2.60209203, 0.0308579989,
        0.832199931, -2.46695995, 0.0349230021,
        0.961205959, -2.56911898, -0.0183270015,
        1.13152504, -2.52255011, 0.0154619999,
        1.31075096, -2.56676412, -0.0160050001,
        1.46903396, -2.49209094, -0.0139529994,
        -1.74516892, -2.43016195, -0.0236730017,
        -1.61661911, -2.32929587, 0.0501779988,
        -1.44405293, -2.46178794, 0.00721499976,
        -1.28478003, -2.43251705, -0.0409829989,
        -1.02281094, -2.35961986, 0.0094259996,
        -0.858440995, -2.41411495, 0.041540999,
        -0.767565012, -2.28533697, 0.128630996,
        -0.579047978, -2.33925915, 0.142289996,
        -0.40614301, -2.29786205, 0.145331994,
        -0.268449008, -2.4298048, 0.0831750035,
        -0.108080998, -2.42270398, 0.0302730016,
        0.0427949987, -2.39850307, -0.0300990008,
        0.177345008, -2.41203308, 0.0680700019,
        0.324416995, -2.40514803, -0.00928500015,
        0.475521028, -2.37894893, 0.103476003,
        0.654950976, -2.3187151, 0.118433997,
        0.779994011, -2.31060886, -0.00306600006,
        0.998948932, -2.44871712, 0.104747996,
        1.14329696, -2.34794998, 0.0621750019,
        1.3077631, -2.39466596, 0.0164940003,
        1.44950998, -2.32614899, -0.0661319941,
        1.60848892, -2.385252, -0.0503039956,
        1.78112698, -2.38457108, -0.022392001,
        1.91626501, -2.41872907, 0.0842010006,
        -1.49468696, -2.22777009, 0.119621992,
        -1.46658003, -2.29326296, -0.041313,
        -1.32683992, -2.21600699, 0.0387839973,
        -1.18153501, -2.30337906, -0.0233430006,
        -0.888498008, -2.27681708, -0.0572339967,
        -0.783552051, -2.16927004, 0.00578100001,
        -0.629601002, -2.2049551, 0.068324998,
        -0.350741982, -2.21673298, 0.00876899995,
        -0.208095014, -2.28304505, 0.0402569994,
        -0.0757170022, -2.2891798, 0.136110008,
        0.0827340037, -2.27397895, 0.0764340013,
        0.246441007, -2.26006794, 0.050108999,
        0.392279983, -2.25401402, -0.0308250003,
        0.53877902, -2.22831583, 0.0426540002,
        0.698534966, -2.16302705, 0.0607619956,
        0.868121982, -2.14634705, 0.0548909977,
        0.937520981, -2.29950905, 0.0608370006,
        1.06718397, -2.19643497, 0.0789780021,
        1.23056698, -2.19594908, 0.103244998,
        1.38392699, -2.219172, 0.0423419997,
        1.55010605, -2.21322298, 0.00695099961,
        1.70576692, -2.233881, -0.0822720006,
        1.93550706, -2.28386402, -0.0258000009,
        2.08203888, -2.30655909, 0.0681449994,
        -1.44128704, -2.08291197, 0.0413039997,
        -1.18543804, -2.13830686, -0.0163170006,
        -1.09587002, -2.0447998, 0.0959189981,
        -0.950322032, -2.124192, 0.040965002,
        -0.816704988, -2.0107739, 0.0516630001,
        -0.657827973, -2.06002188, 0.00853800029,
        -0.483621001, -2.08681798, 0.0471090004,
        -0.305615991, -2.06676292, 0.0548160002,
        -0.181647003, -2.14903498, 0.149055004,
        -0.0234960001, -2.14811993, 0.0686969981,
        0.272666991, -2.11787105, 0.128546998,
        0.42099601, -2.09690404, 0.0490470007,
        0.577161014, -2.071944, -0.0151140001,
        0.724460959, -1.99812591, -0.0459390022,
        0.853617072, -1.98008704, 0.0611280017,
        1.00953293, -2.04270911, 0.0697439983,
        1.17705894, -2.04314113, 0.0877650008,
        1.340976, -2.07323694, 0.150242999,
        1.46118605, -2.06864405, 0.0325229988,
        1.67439902, -2.1182909, 0.0564150028,
        1.83238792, -2.15599203, 0.0255210008,
        1.99028707, -2.10793805, 0.0712080002,
        2.12868905, -2.16255903, -0.0251759999,
        2.277807, -2.081568, 0.0355710015,
        -1.45784998, -1.91828406, 0.109200001,
        -1.29052794, -1.88003707, 0.0710099936,
        -1.12462795, -1.87546206, 0.0497249961,
        -0.970836043, -1.94331908, 0.0310559981,
        -0.847692013, -1.83881092, 0.0759570003,
        -0.689997017, -1.91233206, 0.0900779963,
        -0.407355011, -1.93367994, 0.068723999,
        -0.265745997, -1.91846395, -0.0151650002,
        -0.117161997, -2.00034618, 0.0830370039,
        0.0532499999, -2.00346899, 0.0814080015,
        0.121271998, -1.91461194, -0.0448049977,
        0.248946011, -1.98728991, 0.028764002,
        0.468788981, -1.94464803, -0.00293700001,
        0.618227959, -1.87796998, 0.0113429995,
        0.757017016, -1.84780502, 0.0836910009,
        0.976529956, -1.90345812, 0.148635,
        1.13891697, -1.8844831, 0.126741007,
        1.30256701, -1.94088602, 0.0382950008,
        1.44458401, -1.921134, 0.115016997,
        1.59648907, -1.97309399, 0.0769079998,
        1.76561999, -1.97323799, 0.0629639998,
        1.92554998, -1.96302009, 0.00870900042,
        2.07106209, -2.00233507, -0.0794880018,
        2.20463991, -1.89372301, -0.0391019993,
        -1.574121, -1.79276705, 0.0674400032,
        -1.41771293, -1.78497601, 0.00263400003,
        -1.32024002, -1.71778202, 0.118616998,
        -1.14136195, -1.70211887, 0.0859469995,
        -1.00130105, -1.78290904, -0.0188190006,
        -0.854357958, -1.70605195, -0.0430740006,
        -0.817770004, -1.67920196, 0.116454005,
        -0.613761008, -1.68764997, 0.118974,
        -0.458393991, -1.72933197, 0.146537989,
        -0.323480994, -1.79750705, 0.0845159963,
        -0.160566002, -1.80336607, 0.0889620036,
        -0.0334949978, -1.87203908, 0.00543899974,
        0.210033, -1.77082193, 0.0345479995,
        0.341139019, -1.85033989, -0.0134069994,
        0.501218975, -1.77061808, -0.0410760008,
        0.671855986, -1.71461105, 0.00494399993,
        0.836558998, -1.70345092, 0.0289979987,
        0.991239071, -1.75157404, 0.0663990006,
        1.13922596, -1.77690887, -0.000216000015,
        1.30176306, -1.77085197, 0.0321989991,
        1.45536304, -1.76147413, -0.0333929993,
        1.56977701, -1.80524397, 0.086420998,
        1.66145086, -1.86590695, -0.033183001,
        1.87660193, -1.76859605, -0.0213149991,
        2.03916311, -1.8357029, -0.0225300007,
        2.17252803, -1.72968292, 0.0315570012,
        2.34257388, -1.78547394, 0.030921001,
        -1.86175799, -1.65529513, 0.0270900019,
        -1.70065188, -1.71058512, -0.0200820006,
        -1.49773204, -1.63680303, 0.0503279977,
        -1.26421797, -1.56084895, 0.100559995,
        -1.129812, -1.55889893, 0.00154799991,
        -0.982748985, -1.63332295, 0.0536160022,
        -0.846050978, -1.54364991, 0.00868199952,
        -0.700788021, -1.55163002, 0.0838140026,
        -0.536556005, -1.53473997, 0.0998969972,
        -0.381444007, -1.57806301, 0.134127006,
        -0.241590008, -1.65398097, 0.0668070018,
        -0.0993869975, -1.72019398, -0.0443729982,
        0.0580679998, -1.69697106, 0.031973999,
        0.206603989, -1.61062193, 0.074244,
        0.360134989, -1.68820202, 0.0220229998,
        0.509621978, -1.60799694, 0.014769,
        0.653708994, -1.57687497, -0.0804480016,
        0.83339107, -1.539114, -0.0436979979,
        1.05873299, -1.61186707, 0.154392004,
        1.18100703, -1.61793303, 0.0392519981,
        1.34967899, -1.62570906, -0.043841999,
        1.49658597, -1.64021695, 0.0739500001,
        1.65912294, -1.61880302, 0.127124995,
        1.73625004, -1.75747204, 0.0788040012,
        1.95930004, -1.63552809, 0.0358709991,
        -2.12583613, -1.43690991, 0.0612749979,
        -1.98225904, -1.53408301, 0.0633479953,
        -1.77093601, -1.55304003, 0.131642997,
        -1.56258309, -1.50031507, 0.142457992,
        -1.40743494, -1.48575306, 0.0421530008,
        -1.25343299, -1.43708396, -0.0124260001,
        -1.09750795, -1.38520503, 0.0163649991,
        -0.970037937, -1.47652197, 0.114179999,
        -0.936911941, -1.34588408, 0.010458,
        -0.799371004, -1.40690696, 0.0918179974,
        -0.631556988, -1.39721704, 0.0979139954,
        -0.425285995, -1.41435301, 0.116937004,
        -0.260366976, -1.48802996, 0.0480029956,
        -0.0812460035, -1.60141802, 0.0699450001,
        0.0430350006, -1.50473392, 0.00302099995,
        0.195398986, -1.44815993, 0.0629519969,
        0.357492, -1.52825713, 0.0682319999,
        0.605774999, -1.4727149, 0.047127001,
        0.765227973, -1.41344404, 0.0491820015,
        0.93631196, -1.4277451, 0.0314610004,
        1.0995121, -1.46309996, 0.0706590042,
        1.26442504, -1.42639804, 0.0887340009,
        1.41078901, -1.495875, 0.0478679985,
        1.56489611, -1.52415013, -0.0189479999,
        1.69282198, -1.46518505, 0.0749519989,
        1.8429749, -1.53324294, 0.122694001,
        2.01018, -1.49028599, 0.111924,
        -2.25371695, -1.32590997, 0.0142559996,
        -2.08826995, -1.29490209, -0.020291999,
        -1.94657397, -1.36295104, 0.0430620015,
        -1.79292607, -1.38476706, 0.105422996,
        -1.65275109, -1.35092402, 0.188172013,
        -1.49324703, -1.35047996, 0.107865006,
        -1.34021401, -1.30831802, 0.0411840007,
        -1.19677198, -1.25134504, 0.125819996,
        -1.04895902, -1.22481906, 0.0485820025,
        -0.905876994, -1.17719996, -0.0252090022,
        -0.854339957, -1.25415599, 0.121560007,
        -0.690377951, -1.24725306, 0.0951419994,
        -0.514451981, -1.27402806, 0.0742980018,
        -0.348306, -1.33096504, -0.000752999971,
        -0.119355008, -1.39962602, 0.0570539981,
        0.00793199986, -1.34377193, -0.0323130004,
        0.187377006, -1.28775907, 0.118841998,
        0.333338976, -1.269243, 0.0314100012,
        0.453458995, -1.39134002, 0.0474689975,
        0.596666992, -1.30635297, 0.0302069988,
        0.759468019, -1.25098205, 0.012255,
        1.03981197, -1.29128706, 0.0374670029,
        1.18804502, -1.25197494, 0.113844007,
        1.37447095, -1.30135202, 0.052956,
        1.526793, -1.37755799, 0.0582690015,
        1.64975703, -1.31865001, 0.151547998,
        1.81510806, -1.37120104, 0.171725988,
        1.92940199, -1.35505795, 0.0395670012,
        -2.33561397, -1.18201804, 0.0731670037,
        -2.16732311, -1.1499629, 0.0229980014,
        -1.99326897, -1.20147896, 0.0810480043,
        -1.828161, -1.241871, 0.00132899999,
        -1.70291114, -1.20002997, 0.106964998,
        -1.47616196, -1.20554698, 0.0292199999,
        -1.33052099, -1.15161598, 0.0979889929,
        -1.21368003, -1.08330894, 0.00329399994,
        -1.04429698, -1.06659305, -0.0142199993,
        -0.947108984, -1.10761201, 0.122348994,
        -0.782747984, -1.11317396, 0.0733439997,
        -0.611955047, -1.11780596, 0.0267960001,
        -0.447297037, -1.11520505, 0.0398970023,
        -0.209151, -1.25460601, 0.0534689985,
        -0.0840479955, -1.18316996, -0.0492480025,
        0.0563190021, -1.20312607, 0.0522599965,
        0.206211001, -1.15150499, 0.00973800011,
        0.343142986, -1.10926199, 0.0876930058,
        0.483774006, -1.18137598, 0.0427290015,
        0.6426, -1.13242805, 0.0121769998,
        0.767867982, -1.13764501, 0.141663,
        0.928830028, -1.17102909, 0.0945900008,
        1.14171004, -1.08614993, 0.0524699986,
        1.29491699, -1.15356302, 0.0271649994,
        1.52342415, -1.21081197, 0.0763140023,
        1.68480897, -1.18075204, 0.0652259961,
        1.86491704, -1.20202196, 0.0763290003,
        1.97494805, -1.17697501, -0.054390002,
        -2.41803002, -1.023597, 0.0720269978,
        -2.25314999, -1.03601396, 0.120522,
        -2.18096995, -0.981399, -0.0133379996,
        -2.02260303, -1.05363595, 0.0086400006,
        -1.86185396, -1.09107304, 0.0719339997,
        -1.58620501, -1.08137107, 0.068829,
        -1.428864, -1.03629303, 0.0368789993,
        -1.304106, -0.932958007, 0.0101159997,
        -1.13714397, -0.947030962, 0.0678210035,
        -0.976287007, -0.919059038, 0.0149009991,
        -0.847715974, -1.01438093, -0.0342869982,
        -0.689889014, -0.976790965, 0.0887340009,
        -0.520137012, -0.962538004, 0.00231299992,
        -0.353922009, -0.978024006, 0.0422639996,
        -0.292802989, -1.13592303, -0.0292380005,
        -0.100857005, -1.002882, 0.141830996,
        0.0746280029, -1.03090203, 0.0336959995,
        0.229437009, -0.988445997, 0.0826230049,
        0.360188991, -0.990651011, -0.030311998,
        0.494783998, -1.01712, 0.0718200058,
        0.662384987, -0.999876022, 0.106364995,
        0.825797975, -0.99476707, 0.0804929957,
        0.988404036, -1.01847005, 0.0631019995,
        1.11447597, -0.915012002, 0.0290970001,
        1.26174903, -0.967440009, 0.103496999,
        1.41139197, -1.02989399, 0.0529859997,
        1.57272899, -1.05877793, 0.0119460002,
        1.853127, -1.06015193, -0.0136049995,
        2.01212406, -1.00517702, 0.0191879999,
        -0.0419519991, -1.59889805, -1.18382704,
        -2.46600914, -0.845625043, 0.0947519988,
        -2.36007595, -0.921516001, -0.0600060001,
        -2.05180192, -0.895500004, 0.0512040034,
        -1.859478, -0.91880697, 0.0367949978,
        -1.70673895, -0.963797987, 0.111867003,
        -1.544487, -0.915753007, 0.0746639967,
        -1.42668295, -0.822911978, 0.000281999994,
        -1.26202202, -0.782049, -0.0590820014,
        -1.101228, -0.798642039, 0.0072900001,
        -0.934128046, -0.763905048, -0.0217710007,
        -0.804800987, -0.861413956, 0.0157889985,
        -0.640079975, -0.848165989, 0.00401100004,
        -0.546386957, -0.808188021, 0.132825002,
        -0.408612013, -0.88497293, 0.170538008,
        -0.200204998, -0.927284956, 0.0372180007,
        -0.0537090003, -0.860081971, 0.0568829998,
        0.116733, -0.863093972, 0.0867840052,
        0.258432001, -0.853505969, -0.0179099999,
        0.406562984, -0.857906938, 0.0582119972,
        0.558498025, -0.866580009, 0.114141002,
        0.729839981, -0.853349984, 0.0642390028,
        0.922259927, -0.860478044, 0.0482369959,
        -0.269468993, -1.46348393, -1.183218,
        1.06600499, -0.755874038, 0.0639210045,
        -0.0931109935, -1.43138707, -1.21000504,
        1.22186697, -0.806447983, 0.100304991,
        0.0802409947, -1.46237099, -1.18380594,
        1.37982607, -0.858467996, 0.0494820029,
        1.53396606, -0.918627024, 0.113393992,
        1.71321309, -0.969510019, -0.0204719994,
        1.87297797, -0.893393993, 0.0123180002,
        2.03456116, -0.831248999, 0.0445169993,
        -2.41200304, -0.748170018, -0.0459209979,
        -2.24710202, -0.829055965, 0.0337590016,
        -2.10644698, -0.735603034, 0.0703499988,
        -1.94110501, -0.796059012, 0.128490001,
        -1.82966101, -0.746393979, -0.00410699984,
        -1.65684593, -0.781772971, 0.0484709963,
        -1.52204704, -0.682641029, 0.00748499949,
        -1.35303307, -0.689121008, 0.060980998,
        -0.375858009, -1.321347, -1.15799403,
        -1.18616104, -0.654846013, 0.0433709994,
        -0.196713001, -1.30993807, -1.14326704,
        -1.02687299, -0.680456996, 0.112026006,
        0.0220020004, -1.2959609, -1.21229696,
        0.190589994, -1.31727004, -1.18002295,
        -0.814152002, -0.705092967, 0.0875670016,
        -0.64408195, -0.674495995, 0.101384997,
        -0.494603992, -0.657045007, 0.0371400006,
        -0.408710986, -0.714641988, 0.164456993,
        -0.282287985, -0.804780006, 0.104933992,
        -0.157148987, -0.69837904, 0.088173002,
        0.0104550002, -0.744825006, 0.162149996,
        0.169892997, -0.692561984, 0.130724996,
        0.313304991, -0.709619999, 0.0464879982,
        0.479510963, -0.715103984, 0.0986789912,
        0.691166997, -0.685868979, 0.00593400002,
        0.902166009, -0.699687004, 0.0110309999,
        1.03059006, -0.598662019, 0.0230790004,
        1.20388198, -0.633332968, 0.0659099966,
        1.36057496, -0.699383974, 0.111234002,
        1.52701807, -0.753180027, 0.0841259956,
        1.68392694, -0.816419959, 0.0475830026,
        1.85322595, -0.725345969, 0.00490200007,
        2.00477099, -0.654797971, 0.0638879985,
        -0.456255019, -1.164855, -1.13161206,
        -0.28303802, -1.17146993, -1.20193493,
        -0.105909005, -1.1803081, -1.21062601,
        0.0630690008, -1.12261498, -1.20804894,
        0.241028994, -1.14851999, -1.18589699,
        -2.46518993, -0.637103975, 0.0866969973,
        -2.29978514, -0.671499014, 0.0813810006,
        -2.10190511, -0.573594034, 0.0258570015,
        -1.95003915, -0.638472021, 0.0698940009,
        -1.78516495, -0.595238984, 0.0694350004,
        -1.66915488, -0.630515993, -0.0463440008,
        -1.46201694, -0.532494009, -0.0313019976,
        -1.29600298, -0.576710999, 0.173054993,
        -1.17747307, -0.490028977, 0.0811080039,
        -1.00872302, -0.523221016, 0.0561570004,
        -0.856277943, -0.54913801, 0.123240009,
        -0.736124992, -0.56813705, 0.0169859994,
        -0.581351995, -0.506954968, 0.0458310023,
        -0.377175003, -0.555696011, 0.113504991,
        -0.213318005, -0.548316002, 0.128883004,
        -0.0687030032, -0.454466999, 0.125610009,
        0.0471810028, -0.577445984, 0.107868001,
        0.209517002, -0.515016019, 0.133368,
        0.360024005, -0.547397971, 0.0570180044,
        0.558266997, -0.582357049, -0.0196620002,
        0.652454972, -0.524886012, 0.104540996,
        0.804021001, -0.571287036, 0.0519630015,
        0.941568017, -0.472781986, 0.0826109946,
        1.11112201, -0.485907018, 0.111171007,
        1.27905297, -0.441897035, 0.137777999,
        1.527807, -0.591524959, 0.0462720022,
        1.69292998, -0.648225009, 0.00470699975,
        1.77578092, -0.495756, 0.036417,
        1.92451811, -0.539408982, -0.0395969972,
        -0.416004002, -0.987990022, -1.14121509,
        -0.248547018, -0.995024979, -1.20385802,
        -0.0748949945, -1.00992906, -1.23389101,
        0.0941369981, -0.948642015, -1.21122897,
        0.264750004, -0.968861997, -1.18171203,
        0.398943007, -1.07564998, -1.15098906,
        -2.42039704, -0.464489996, 0.0495389998,
        -2.25419402, -0.508226991, 0.0558330044,
        -2.13084006, -0.40466702, 0.00233400008,
        -1.98501301, -0.469461024, 0.0820049942,
        -1.81883097, -0.432125986, 0.0469799973,
        -1.64260507, -0.485627979, 0.0433019996,
        -1.49140799, -0.41237998, 0.0918510035,
        -1.33840799, -0.456450015, 0.0657179952,
        -1.22402096, -0.330453008, 0.0538560003,
        -1.07018101, -0.384882033, -0.014397,
        -0.871773005, -0.385365009, 0.137450993,
        -0.720548987, -0.401361018, 0.0546720028,
        -0.556434035, -0.351677984, 0.0815970004,
        -0.384204, -0.387021005, 0.0762659982,
        -0.212175012, -0.402674973, 0.0492359996,
        -0.047832001, -0.340458006, 0.00391199999,
        0.100899003, -0.44412902, 0.00997199956,
        0.227627993, -0.341223001, 0.0279989988,
        0.352497011, -0.386241019, 0.128808007,
        0.495006025, -0.441318035, 0.0506159998,
        0.636843026, -0.35867399, 0.0580319986,
        0.791718006, -0.405687034, 0.0767730027,
        0.999464989, -0.328812003, 0.135090008,
        1.15601695, -0.338690996, 0.0608099997,
        1.32261896, -0.306221992, 0.0452880003,
        1.48232102, -0.416547, 0.0338729993,
        1.62928796, -0.469620019, 0.107531995,
        1.68856812, -0.349425018, -0.000636000012,
        1.90842915, -0.384656966, 0.0533220023,
        -0.235670999, -0.825888038, -1.15103996,
        -0.0431279987, -0.844373941, -1.18589699,
        0.118776008, -0.787413001, -1.13616896,
        -2.38263893, -0.288482994, 0.0441869982,
        -2.1990571, -0.273416996, 0.0916620046,
        -1.95393014, -0.316913992, 0.0249329992,
        -1.83145499, -0.230208009, -0.0411150008,
        -1.69841695, -0.335436016, -0.0252210014,
        -1.56727195, -0.272297978, 0.0572999977,
        -1.44604206, -0.165500998, 0.0833130032,
        -1.27186203, -0.167735994, 0.0989309996,
        -1.0965569, -0.231534004, 0.0361170024,
        -0.974375963, -0.252402008, 0.159668997,
        -0.764564991, -0.246123016, 0.113180995,
        -0.618116975, -0.201914996, 0.0413250029,
        -0.455504984, -0.220254004, 0.0751409978,
        -0.290715009, -0.251774997, 0.0727709979,
        -0.131877005, -0.209250003, 0.0769049972,
        0.0836099982, -0.263402998, 0.0866609961,
        0.222597003, -0.174980998, 0.0643140003,
        0.366864026, -0.245882988, 0.00444900012,
        0.49516502, -0.289631993, 0.118058994,
        0.703338027, -0.20664601, 0.0456600003,
        0.890051961, -0.235161006, 0.0485699996,
        1.07659805, -0.223056018, -0.0299220011,
        1.21034694, -0.181769997, 0.0813179985,
        1.35975003, -0.132386997, 0.0157469995,
        1.47948301, -0.244485006, 0.0482520014,
        1.64456999, -0.190577984, 0.0373290032,
        1.80948901, -0.236835003, 0.0499530025,
        -2.32925701, -0.124931999, 0.0807269961,
        -2.16674089, -0.110312998, 0.0350189991,
        -1.879179, -0.128069997, 0.0847470015,
        -1.73656201, -0.0419190004, 0.0353219993,
        -1.7147851, -0.200354993, 0.0766320005,
        -1.56831908, -0.0519720018, 0.050561998,
        -1.36211395, -0.0347459987, 0.0311460011,
        -1.19099998, -0.0156060001, 0.0638490021,
        -1.02659106, -0.106809005, 0.107019,
        -0.861063004, -0.117513001, 0.148311004,
        -0.733896017, -0.0869880021, 0.0131670004,
        -0.580464005, -0.0549869984, 0.114981003,
        -0.403989017, -0.0619890019, 0.0809729993,
        -0.241970986, -0.083039999, 0.0510930046,
        -0.079791002, -0.0609630011, -0.00207599998,
        -0.00093899999, -0.131450996, 0.125853002,
        0.223439991, -0.0270959996, -0.0123420004,
        0.372593999, -0.0819900036, 0.0446969979,
        0.529725015, -0.143438995, 0.0483390018,
        0.652962029, -0.0317850001, 0.0537960008,
        0.81584698, -0.0794579983, 0.0364320017,
        0.970970988, -0.0222120006, 0.0734999999,
        1.13747394, -0.0656429976, -0.0127260005,
        1.26620102, -0.0180329997, 0.0926430002,
        1.52266812, -0.078396, 0.027555,
        1.68472505, -0.0240120012, 0.015408,
        -2.34060907, 0.0537630022, 0.0735689998,
        -2.18672395, 0.0532139987, -0.0235920008,
        -2.03254485, -0.0118890004, 0.0414839983,
        -1.87595093, 0.0420899987, 0.0734789968,
        -1.72263908, 0.121757999, 0.0839219987,
        -1.57634103, 0.106391996, -0.0161430016,
        -1.40159106, 0.109202996, 0.100253999,
        -1.14084601, 0.148268998, 0.0678929985,
        -1.02448499, 0.037374001, 0.0411360003,
        -0.859880984, 0.0157169998, 0.0487499982,
        -0.676578045, 0.0771870017, 0.0286680013,
        -0.505964994, 0.0648749992, 0.0256830007,
        -0.336542994, 0.0960239992, 0.0588960014,
        -0.209562004, 0.039398998, -0.0549930036,
        -0.105041996, 0.0971549973, 0.0596820004,
        0.0452760011, 0.0233669989, 0.0881519988,
        0.190338001, 0.113165997, 0.0659909993,
        0.34622401, 0.090797998, -0.0389430001,
        0.504467964, 0.0203639995, -0.0191430002,
        0.623187006, 0.138944998, 0.049817998,
        0.781118989, 0.0719909966, 0.0945719928,
        0.914142013, 0.118607998, -0.010884,
        1.09534502, 0.0940020084, 0.0345600024,
        1.26199806, 0.126438007, 0.00988199934,
        1.40661299, 0.0396779999, 0.00331200007,
        1.59066606, 0.120743997, 0.089373,
        -2.45535898, 0.201756001, 0.088440001,
        -2.30713797, 0.206711993, -0.00880200043,
        -2.16297603, 0.207566991, 0.0829230025,
        -2.024652, 0.152738988, 0.00396000035,
        -1.86987615, 0.21270901, 0.0545729995,
        -1.74141598, 0.302363992, 0.110715002,
        -1.59095097, 0.251780987, 0.0709680021,
        -1.43968797, 0.244668007, 0.0076919999,
        -1.27949107, 0.204467982, 0.0062549999,
        -1.00061107, 0.237069011, 0.0510900021,
        -0.83871007, 0.182303995, 0.0496829972,
        -0.718430996, 0.298209012, 0.0950490087,
        -0.578675985, 0.219884992, 0.0463469997,
        -0.433932006, 0.220367998, 0.138342008,
        -0.289596021, 0.253973991, 0.0458819978,
        -0.142073989, 0.229161009, -0.0384959988,
        0.0344489999, 0.187215, 0.0443160012,
        0.181326002, 0.280956, -0.0401760004,
        0.313143015, 0.232320011, 0.0588300005,
        0.471333027, 0.201177001, -0.00545099983,
        0.641618967, 0.282801002, -0.0470190011,
        0.833997011, 0.226940989, 0.091583997,
        0.955971003, 0.291747004, -0.00139799993,
        1.05532205, 0.229284018, 0.122280002,
        1.31135392, 0.313473016, 0.0325050019,
        1.45162201, 0.20439899, 0.00950699951,
        -2.41366816, 0.359634012, 0.00775799993,
        -2.25406194, 0.364778996, -0.0691529959,
        -2.12647796, 0.376163989, 0.0574529991,
        -1.98237896, 0.316542, -0.016404001,
        -1.89414597, 0.37976101, 0.117789,
        -1.64981997, 0.396587968, -0.00421199994,
        -1.49498093, 0.39250201, 0.0562379993,
        -1.32720602, 0.371427, 0.0404760018,
        -1.17306602, 0.345503986, -0.0405960009,
        -1.00391698, 0.392069995, -0.011349,
        -0.865469992, 0.393381, 0.0885960013,
        -0.707475007, 0.46875, 0.106224,
        -0.545252979, 0.387356997, 0.0281910002,
        -0.393285036, 0.41474998, 0.115446001,
        -0.233877003, 0.410957992, 0.0142979994,
        -0.0807210058, 0.468917996, 0.0830669999,
        0.0452039987, 0.355749011, 0.0322050005,
        0.248082012, 0.395201981, 0.077105999,
        0.344003975, 0.284844011, -0.0996569991,
        0.482748002, 0.370848, -0.00191400014,
        0.642264009, 0.435770988, 0.0418649986,
        0.794427037, 0.349332005, -0.0138839995,
        0.975354016, 0.468590975, 0.00201599998,
        1.16114402, 0.415847987, 0.040583998,
        -2.35761905, 0.589223981, -0.0193980001,
        -2.19548106, 0.536954999, -0.100049995,
        -2.09611201, 0.547742963, 0.044294998,
        -1.94960713, 0.550361991, 0.140747994,
        -1.75910997, 0.479822993, 0.101616003,
        -1.63267493, 0.567716956, 0.0176790003,
        -1.46417093, 0.530937016, -0.0376619995,
        -1.29221094, 0.515757024, -0.0453419983,
        -1.11662996, 0.516111016, -0.0463289991,
        0.138173997, 0.496917009, -0.00992999971,
        0.325194001, 0.531284988, -0.00536100008,
        0.504765034, 0.547140002, 0.0232079998,
        0.660444021, 0.598671019, 0.113366991,
        0.823557019, 0.549944997, 0.0506010018,
        -2.36299205, 0.749603987, 0.0601379983,
        -2.23234797, 0.70845598, -0.0514439978,
        -2.09553885, 0.750791967, 0.0476040021,
        -1.96510792, 0.650867999, -0.00662100036,
        -1.800699, 0.593019009, -0.022632001,
        -1.68733191, 0.72834897, -0.00166200008,
        -1.52203202, 0.704627991, 0.0612360016,
        -1.37200201, 0.681824982, -0.0288540013,
        -2.25659108, 0.877209067, -0.00828300044,
        -2.14835405, 0.944031, 0.118368,
        -1.99220395, 0.889586985, 0.0499169976,
        -1.85331011, 0.777915001, 0.0159059986,
        -1.59545696, 0.862691998, 0.070430994,
        -1.447896, 0.866729975, -0.013970999,
        -2.29873204, 1.02936292, 0.069201,
        -2.04640484, 1.07943296, 0.0557459965,
        -1.88720989, 1.01939094, 0.00883799978,
        -1.75026608, 0.914757013, 0.0233520009,
        -1.60242605, 1.00067103, -0.0378810018,
        -1.450827, 1.03074598, 0.0538019985,
        -2.23332286, 1.19723403, 0.0543779992,
        -2.07704711, 1.26303303, 0.017882999,
        -1.94616294, 1.17452693, -0.0481380001,
        -1.73181295, 1.08818102, 0.0302460007,
        -1.58499599, 1.18382096, 0.0343680009,
        -2.19553518, 1.38147902, 0.0682019964,
        -1.924878, 1.34729993, -0.00870900042,
        -1.78590298, 1.24166095, -0.0257760007,
        -1.324278, 1.29486299, 0.0304769985,
        -1.14968395, 1.26705897, 0.00121199992,
        -0.969873011, 1.27224004, -0.00660299975,
        -1.94628596, 1.260849, -1.18842006,
        -2.08312488, 1.52001309, 0.0550439954,
        -1.78795803, 1.46244299, 0.0245309994,
        -1.27409399, 1.45825803, -0.0247169994,
        -1.06730103, 1.42281294, 0.0432960019,
        -0.895452023, 1.46859598, 0.0176489986,
        -0.79893297, 1.316028, 0.0285359994,
        -0.641838014, 1.39735198, 0.0611579977,
        -1.88154292, 1.43170798, -1.1700809,
        -1.70178902, 1.44395709, -1.12988102,
        -1.31093693, 1.64727592, 0.0115080001,
        -1.87187099, 1.59233403, -1.25513995,
        -1.12415695, 1.59232807, 0.0512880012,
        -1.66133404, 1.61235595, -1.19465101,
        -0.929645956, 1.64608502, 0.0205620006,
        -0.731822968, 1.55357409, 0.0598020032,
        -0.582054019, 1.66728294, 0.0977669954,
        -0.488661021, 1.49529004, 0.0737280026,
        -0.370307982, 1.63197303, 0.101628006,
        -1.99500895, 1.71895802, -1.20186603,
        -1.79468393, 1.74197102, -1.18294799,
        -1.15617895, 1.76752496, 0.0764160007,
        -0.967431068, 1.81954801, 0.0591629967,
        -0.738885045, 1.73240995, 0.0176640004,
        -2.22979212, 1.89284396, -1.14042294,
        -2.05281305, 1.92585588, -1.17794096,
        -1.88014507, 1.89816308, -1.23123002,
        -1.72745705, 1.90304112, -1.12142396,
        -1.120911, 1.94433296, 0.0949050039,
        -0.969231009, 1.99517691, 0.00536700012,
        -0.81050694, 1.90181398, 0.0162959993,
        -2.06999683, 2.10920691, -1.15981495,
        -1.9080689, 2.05281019, -1.08843303,
        -0.837626934, 2.08830309, 0.0958770066,
        -0.653735995, 2.11589718, 0.0797130018,
        -2.00959802, -2.63064289, 0.223877996,
        -1.87122893, -2.73894906, 0.209085017,
        -1.695189, -2.74299002, 0.194880009,
        -1.53322506, -2.74249196, 0.140805006,
        -1.33933198, -2.74128294, 0.217452005,
        -1.16064596, -2.74015498, 0.210593998,
        -0.983664036, -2.74151421, 0.21717,
        -0.808784962, -2.74235702, 0.229709983,
        0.643953025, -2.70654583, 0.176405996,
        0.815114975, -2.71548891, 0.191136003,
        0.981191993, -2.70723295, 0.230246991,
        1.17509997, -2.71461916, 0.205100983,
        1.34772599, -2.68639803, 0.203451008,
        -1.93069804, -2.47292113, 0.25483501,
        -1.77815104, -2.59022093, 0.200544,
        -1.59629095, -2.58713698, 0.164019004,
        -1.42705202, -2.59756494, 0.170078993,
        -1.28998804, -2.4992249, 0.150371999,
        -1.22274899, -2.59605598, 0.274379998,
        -1.08086395, -2.59169102, 0.185982004,
        -0.933890998, -2.5887599, 0.279468,
        -0.69836098, -2.61791086, 0.185808003,
        -0.599534988, -2.48188806, 0.224496007,
        -0.457271993, -2.57818794, 0.222014993,
        -0.329481006, -2.45318103, 0.236417994,
        -0.216543004, -2.57722807, 0.245261997,
        -0.0487680025, -2.57555389, 0.193998009,
        0.135444, -2.55394793, 0.144446999,
        0.368093997, -2.52963901, 0.224981993,
        0.513716996, -2.60979891, 0.235170007,
        0.59632802, -2.46891308, 0.179874003,
        0.742610991, -2.55384588, 0.162771001,
        0.906726003, -2.58330011, 0.134096995,
        1.07459104, -2.58661199, 0.158541009,
        1.24610102, -2.565171, 0.138431996,
        1.48844695, -2.610255, 0.120726004,
        1.66630507, -2.52137709, 0.0628350005,
        1.83229804, -2.54029202, 0.189234003,
        -1.80792594, -2.34528589, 0.229196995,
        -1.69691098, -2.44914293, 0.145971,
        -1.52636397, -2.43186593, 0.153603002,
        -1.37794495, -2.35548902, 0.122985005,
        -1.15170598, -2.44264793, 0.0724560022,
        -1.00412703, -2.44146585, 0.15841499,
        -0.855545998, -2.40087914, 0.216224998,
        -0.703971028, -2.35608006, 0.258818984,
        -0.580119014, -2.26076102, 0.300291002,
        -0.473835021, -2.38606787, 0.278183997,
        -0.251810998, -2.30028009, 0.202178985,
        -0.142926008, -2.43173409, 0.194153994,
        0.0226859991, -2.42464781, 0.140498996,
        0.157626003, -2.42236185, 0.247212008,
        0.315234005, -2.38649106, 0.158433005,
        0.465698987, -2.40214801, 0.278241009,
        0.684839964, -2.35868692, 0.278102994,
        0.853464007, -2.42013597, 0.19907999,
        1.038903, -2.31904793, 0.198128998,
        1.14644706, -2.44674897, 0.195654005,
        1.30803597, -2.41111803, 0.181172997,
        1.45525801, -2.36418581, 0.104627997,
        1.62354004, -2.32719302, 0.108011998,
        1.72218299, -2.41636515, 0.202020004,
        1.88774693, -2.38277698, 0.252656996,
        2.05086613, -2.41657209, 0.2007,
        0.215736002, -2.06420708, -1.01822698,
        -1.63367391, -2.26919699, 0.223658994,
        -1.34720397, -2.20961094, 0.212789983,
        -1.21865106, -2.30686808, 0.148497,
        -1.08527398, -2.21932197, 0.0889950022,
        -0.934184968, -2.27994299, 0.122483999,
        -0.844122052, -2.14591789, 0.169062003,
        -0.685845017, -2.15750408, 0.218603998,
        -0.509270966, -2.175771, 0.181928992,
        -0.339477003, -2.15262604, 0.199044004,
        -0.119819999, -2.29529691, 0.297347993,
        0.0559769981, -2.28752708, 0.245402992,
        0.222647995, -2.2625432, 0.216518998,
        0.388248026, -2.23838997, 0.137522995,
        0.530588984, -2.26217413, 0.21703501,
        0.673959017, -2.19245696, 0.232179016,
        0.804614961, -2.26500297, 0.156351,
        0.943313956, -2.18673897, 0.201917991,
        1.19942403, -2.29598403, 0.228107989,
        1.35679805, -2.24456096, 0.201948017,
        1.51615214, -2.22056699, 0.180093005,
        1.68191409, -2.20030785, 0.203816995,
        1.796157, -2.29018497, 0.121701002,
        1.95246899, -2.24972701, 0.163127989,
        -0.100095004, -1.93025994, -1.04458797,
        2.11637998, -2.25353098, 0.229997993,
        0.0772590041, -1.95763803, -1.05175805,
        2.27405095, -2.22475815, 0.149216995,
        0.257757008, -1.86118805, -1.04738092,
        0.375419974, -1.98310494, -0.997002006,
        -1.49786997, -2.15349603, 0.275822997,
        -1.38774002, -2.03525686, 0.213734999,
        -1.27928698, -2.045928, 0.0808530003,
        -1.19220304, -2.14066505, 0.193844989,
        -1.01508904, -2.14126205, 0.221798986,
        -0.767829001, -2.00041795, 0.215709001,
        -0.599514008, -2.03228402, 0.158300996,
        -0.438578993, -2.02113605, 0.201729,
        -0.221586004, -2.15433288, 0.322416008,
        -0.0442200005, -2.15523601, 0.239232004,
        0.112404004, -2.138901, 0.174774006,
        0.249582008, -2.11813211, 0.296600997,
        0.405036002, -2.10120606, 0.22904399,
        0.555341959, -2.09961605, 0.156447008,
        0.684399009, -2.00018096, 0.114333004,
        0.797915936, -2.09633398, 0.194772005,
        0.937889993, -2.028723, 0.251742005,
        -0.199101001, -1.78631711, -1.07453108,
        1.08546603, -2.095644, 0.217218012,
        -0.0281130001, -1.78341007, -1.11046791,
        1.23557997, -2.13997793, 0.270224988,
        0.110703006, -1.68164098, -1.13236201,
        1.39721704, -2.11620617, 0.31327799,
        0.247979999, -1.68890715, -1.01743197,
        1.50900292, -2.05741215, 0.197120994,
        0.405122995, -1.76189399, -1.07383502,
        1.84964705, -2.09785795, 0.183167994,
        0.595767021, -1.76078987, -1.01857805,
        2.01132011, -2.11521912, 0.249642,
        2.14378214, -2.10668087, 0.143810987,
        2.26508403, -2.09160304, 0.262548,
        2.41712999, -2.05322099, 0.187290013,
        -1.49845803, -1.91858697, 0.279834002,
        -1.35083401, -1.84794009, 0.223956004,
        -1.22746205, -1.97399998, 0.226568997,
        -1.06872606, -1.92136192, 0.203244001,
        -0.930743933, -2.0066762, 0.177708,
        -0.726819038, -1.79398203, 0.196011007,
        -0.405879021, -1.61579394, -0.992942929,
        -0.538155019, -1.87554312, 0.150821999,
        -0.269571006, -1.62290704, -1.10481,
        -0.386457026, -1.85976005, 0.232488006,
        -0.110202, -1.64621711, -1.0330379,
        -0.258011997, -1.94198406, 0.153200999,
        -0.138035998, -2.01722383, 0.253578007,
        0.0383099988, -1.54544401, -1.039698,
        0.0339299999, -2.00672388, 0.249314994,
        0.213134989, -1.54526401, -1.10942698,
        0.187665001, -1.98618293, 0.185301006,
        0.378197998, -1.58385909, -1.07385004,
        0.36077401, -1.96383297, 0.149507999,
        0.547190964, -1.59711599, -1.04284191,
        0.528173983, -1.92837, 0.146375999,
        0.662526011, -1.86789, 0.217295989,
        0.808166981, -1.93435502, 0.222624004,
        0.932415009, -1.86291897, 0.308052003,
        1.07221508, -1.94897699, 0.302886009,
        1.22164798, -1.98283803, 0.23555401,
        1.38893104, -1.95585299, 0.270678014,
        1.56402004, -1.90639794, 0.236064017,
        1.6862371, -2.03253603, 0.207425997,
        1.96668899, -1.96873498, 0.183968991,
        2.10301208, -1.95371413, 0.0868560001,
        2.27276421, -1.9272449, 0.119661003,
        2.4416008, -1.87897205, 0.144951001,
        -1.64175904, -1.82088304, 0.226071,
        -0.443919003, -1.45095301, -1.05447602,
        -1.48340404, -1.73692513, 0.205464005,
        -0.282690018, -1.38848996, -1.01905501,
        -1.42056608, -1.77927613, 0.361730993,
        -0.148428008, -1.48246205, -1.054497,
        -0.00881399959, -1.37887192, -1.06229103,
        -1.18721402, -1.80945301, 0.204705,
        0.158015996, -1.39996493, -1.03562999,
        -0.998961031, -1.77823496, 0.148010999,
        0.320712, -1.411641, -1.10867095,
        -0.876842976, -1.85889602, 0.236213982,
        0.493355989, -1.43037295, -1.08046794,
        -0.839129984, -1.70393407, 0.287729979,
        0.660246015, -1.46468103, -1.03848302,
        -0.580724955, -1.76531386, 0.267426014,
        -0.434919, -1.73128796, 0.330266982,
        -0.19979699, -1.82484889, 0.25484699,
        -0.0545459986, -1.88231397, 0.188666999,
        0.0951600075, -1.84841108, 0.115878001,
        0.254441977, -1.837551, 0.204845995,
        0.40645498, -1.80352807, 0.140177995,
        0.562016964, -1.75331104, 0.120321006,
        0.719705999, -1.71369302, 0.170720994,
        0.870525002, -1.78325701, 0.178943992,
        1.03762197, -1.76503491, 0.22101599,
        1.18993497, -1.72630501, 0.158033997,
        1.29716098, -1.85153699, 0.180950999,
        1.42602301, -1.76262295, 0.150182992,
        1.59116697, -1.73532009, 0.231768012,
        1.72103405, -1.86655807, 0.207147002,
        1.86719406, -1.84939206, 0.12845999,
        2.03002214, -1.80604506, 0.142341003,
        2.19172788, -1.79191494, 0.196193993,
        2.34465885, -1.71372306, 0.199344009,
        2.51697588, -1.73176503, 0.221919,
        -0.557838023, -1.3500061, -0.95679307,
        -0.412965, -1.27625394, -0.992444992,
        -0.256308019, -1.21962893, -1.0050211,
        -0.0857580006, -1.23027897, -1.040079,
        0.0985049978, -1.22015095, -1.06751704,
        0.26376, -1.26650703, -1.02700806,
        0.400635004, -1.25412297, -1.13117099,
        0.432410985, -1.23039305, -0.966609001,
        0.624125957, -1.30101895, -1.08102596,
        0.792585015, -1.25588405, -1.03861201,
        -1.94805002, -1.65990007, 0.179358006,
        -1.78942204, -1.74170995, 0.164123997,
        -1.63543487, -1.656672, 0.158831999,
        -1.40537703, -1.58178902, 0.185802013,
        -1.22801995, -1.65163207, 0.239496008,
        -1.1089859, -1.55652595, 0.171119988,
        -0.970515013, -1.62796187, 0.223253995,
        -0.829923034, -1.53727198, 0.193760991,
        -0.691626012, -1.62093294, 0.253886998,
        -0.515388012, -1.60887003, 0.246411011,
        -0.354348004, -1.59029698, 0.334068,
        -0.310355991, -1.70332813, 0.221288994,
        -0.150347993, -1.67154002, 0.206229001,
        0.00163200009, -1.72537208, 0.189446986,
        0.164019004, -1.70073295, 0.209219992,
        0.325931996, -1.66215599, 0.185127005,
        0.596675992, -1.59278107, 0.167687997,
        0.741599977, -1.57302904, 0.087996006,
        0.888455987, -1.62194705, 0.161877006,
        0.975686967, -1.61394, 0.302432984,
        1.20909595, -1.54322696, 0.199815005,
        1.33107901, -1.626405, 0.124512002,
        1.45680594, -1.62792599, 0.240996003,
        1.60925412, -1.58456087, 0.304782003,
        1.74503696, -1.67655897, 0.261767983,
        1.89173698, -1.68732905, 0.181077003,
        2.096874, -1.64153099, 0.162897006,
        2.25892186, -1.57051802, 0.142071009,
        2.42999101, -1.55126095, 0.20336701,
        -0.575789988, -1.18488002, -1.00527894,
        -0.390839994, -1.10927999, -0.986063957,
        -0.182379007, -1.09953594, -1.08529496,
        -0.0199769996, -1.07536793, -1.06989598,
        0.146039993, -1.04855096, -1.0770781,
        0.292722017, -1.097682, -1.01678407,
        0.449726999, -1.05798304, -0.976821005,
        0.539867997, -1.151052, -1.0840199,
        0.701609969, -1.09902894, -1.04760599,
        -2.0863471, -1.55408406, 0.208205998,
        -1.90448689, -1.491063, 0.217857003,
        -1.68698692, -1.50559795, 0.268400997,
        -1.53827405, -1.59296703, 0.289611012,
        -1.419783, -1.47692394, 0.318713993,
        -1.25058603, -1.49285102, 0.28926301,
        -1.19370902, -1.41570902, 0.149046004,
        -1.04764497, -1.33929896, 0.177692994,
        -0.893846989, -1.3902421, 0.239409,
        -0.719067037, -1.42079401, 0.242165983,
        -0.553119004, -1.44330597, 0.237351,
        -0.378194988, -1.44033301, 0.275867999,
        -0.244217992, -1.531353, 0.21510601,
        -0.0845099986, -1.48824894, 0.191808015,
        0.0626400039, -1.57353902, 0.153248996,
        0.211923003, -1.53525603, 0.226428002,
        0.379317015, -1.51475692, 0.238743007,
        0.520401001, -1.43875802, 0.194058001,
        0.685160995, -1.44993901, 0.194822997,
        0.849584937, -1.46755195, 0.195336014,
        1.01481605, -1.46212804, 0.22311601,
        1.16263199, -1.38381004, 0.22014299,
        1.37381399, -1.47896695, 0.211845011,
        1.54280996, -1.50416398, 0.160788,
        1.67834091, -1.444839, 0.252380997,
        1.82676291, -1.50566697, 0.293021977,
        1.98903894, -1.56020999, 0.267500997,
        2.14245605, -1.482234, 0.244782001,
        -0.534015, -1.012236, -1.01333094,
        -0.28600499, -0.986886024, -1.024755,
        -0.128229007, -0.940883994, -1.07077193,
        0.0395039991, -0.915320992, -1.04596806,
        0.234302998, -0.91760397, -1.013448,
        0.396548986, -0.929237962, -1.06786203,
        0.571533024, -0.953375995, -1.07331002,
        0.766011, -0.947223008, -0.998712063,
        -2.3317349, -1.30224907, 0.203508005,
        -2.20397997, -1.42022407, 0.213734999,
        -2.03168106, -1.38410699, 0.191561997,
        -1.80140996, -1.36450207, 0.270552009,
        -1.66144204, -1.36513507, 0.35986799,
        -1.5138061, -1.355214, 0.271907985,
        -1.35514498, -1.40977502, 0.182691008,
        -1.23848701, -1.31839204, 0.283859998,
        -1.10575497, -1.20837295, 0.270474017,
        -0.946331978, -1.22663403, 0.249839991,
        -0.789128959, -1.27023602, 0.283838987,
        -0.626901031, -1.27464604, 0.245433003,
        -0.462435007, -1.30447793, 0.239937007,
        -0.264186025, -1.36701596, 0.166362002,
        -0.095769003, -1.31906104, 0.204999,
        0.0475379974, -1.3932929, 0.133515,
        0.192710996, -1.37309694, 0.264230996,
        0.322371006, -1.38568807, 0.153714001,
        0.48120001, -1.27562094, 0.178562999,
        0.693468034, -1.28668499, 0.160259992,
        0.864030004, -1.31525397, 0.134420991,
        1.02181804, -1.28718901, 0.200172007,
        1.158867, -1.22886896, 0.278259009,
        1.31674504, -1.31394005, 0.21495299,
        1.48714495, -1.30962002, 0.204225004,
        1.61546695, -1.30553699, 0.32960701,
        1.79060102, -1.32597899, 0.331071019,
        1.95480895, -1.39503598, 0.264596999,
        2.06005788, -1.32707703, 0.148317009,
        -0.473517001, -0.840615034, -1.03881299,
        -0.309275985, -0.826871991, -0.993804038,
        -0.143379003, -0.803079009, -0.973649979,
        0.0225990005, -0.77015698, -0.952695012,
        0.193235993, -0.764714956, -0.932307005,
        0.296292007, -0.803369999, -1.12451994,
        0.493467003, -0.786924005, -1.07525396,
        0.700973988, -0.787881017, -1.02077699,
        -2.41268706, -1.13894093, 0.228138,
        -2.23914909, -1.16269803, 0.224289,
        -2.14463091, -1.27182007, 0.141473994,
        -2.01677704, -1.215927, 0.250595987,
        -1.85581505, -1.23474598, 0.172481999,
        -1.70148003, -1.21360207, 0.280761003,
        -1.55195093, -1.20728707, 0.182549998,
        -1.39057493, -1.249668, 0.216324002,
        -1.25441706, -1.14430201, 0.244062006,
        -1.11650097, -1.09889996, 0.142428011,
        -0.824571013, -1.10997295, 0.236505002,
        -0.664986014, -1.10865903, 0.188660994,
        -0.510330021, -1.15473902, 0.196130991,
        -0.358074009, -1.22173202, 0.134867996,
        -0.22429499, -1.21397698, 0.239307001,
        -0.0873659998, -1.17064798, 0.123357005,
        0.0580800027, -1.2455039, 0.217077017,
        0.193493992, -1.129071, 0.174333006,
        0.321446985, -1.22891998, 0.206238002,
        0.446900994, -1.10914803, 0.21420899,
        0.60197401, -1.14610195, 0.175559998,
        0.878391027, -1.20795906, 0.254171997,
        1.05623698, -1.11950707, 0.195635989,
        1.23525906, -1.10865903, 0.192210004,
        1.39138198, -1.16714406, 0.167454004,
        1.49863505, -1.16579401, 0.303314984,
        1.66171813, -1.17623401, 0.23142001,
        1.82949591, -1.19022, 0.237213001,
        1.99726486, -1.20479095, 0.254061013,
        2.05936813, -1.16261101, 0.0953040048,
        -0.268040985, -0.668838024, -1.03918803,
        -0.111572996, -0.708606005, -1.10738993,
        0.0444540009, -0.642243028, -1.06377602,
        0.217575014, -0.661929011, -1.05909598,
        0.390461981, -0.646088958, -1.03478706,
        0.566703022, -0.642789006, -0.994542003,
        -2.49285293, -0.977699995, 0.227784008,
        -2.25114608, -1.00835705, 0.288147002,
        -2.09802914, -1.09080899, 0.165437996,
        -1.96268392, -0.99505794, 0.163953006,
        -1.79036701, -1.07322896, 0.223577991,
        -1.62023997, -1.05831003, 0.236880004,
        -1.44119406, -1.07339096, 0.207837,
        -1.26604509, -1.00526404, 0.152619004,
        -1.14288902, -0.99742502, 0.27471301,
        -1.00794601, -0.963236928, 0.176672995,
        -0.844595969, -0.964841962, 0.146543995,
        -0.707216978, -0.956264973, 0.254384995,
        -0.540669024, -0.991095006, 0.161660999,
        -0.38301301, -1.05140698, 0.193682998,
        -0.239063993, -1.093068, 0.120965995,
        -0.0996330008, -1.10719204, 0.274989009,
        0.0395010002, -1.079175, 0.189561009,
        0.164312989, -0.976871967, 0.239999995,
        0.367842019, -0.969929934, 0.177951008,
        0.565890014, -0.984239995, 0.241154999,
        0.735230982, -1.010553, 0.257766008,
        0.898055971, -1.05030298, 0.218418002,
        0.993218958, -0.919206023, 0.196733996,
        1.14387894, -0.97249496, 0.219897002,
        1.368963, -1.00698602, 0.224904001,
        1.51073098, -0.945524991, 0.281888992,
        1.53784513, -1.07238305, 0.174741,
        1.75947297, -1.05242395, 0.127004996,
        1.92609608, -1.06585205, 0.159815997,
        2.08506012, -1.05055201, 0.231141001,
        -2.54226589, -0.808034956, 0.256500006,
        -2.32387495, -0.897086978, 0.174956992,
        -2.14170599, -0.917285979, 0.191909999,
        -1.99232388, -0.873636007, 0.274829984,
        -1.83152413, -0.899634004, 0.209330991,
        -1.52137506, -0.919031978, 0.238608003,
        -1.38378906, -0.883862972, 0.155145004,
        -1.24236596, -0.810923934, 0.100850999,
        -1.09440005, -0.824808002, 0.180453002,
        -0.928514957, -0.815427065, 0.141552001,
        -0.823127985, -0.818033934, 0.271301985,
        -0.709991992, -0.820293009, 0.155193001,
        -0.530142009, -0.881880045, 0.289310992,
        -0.373061985, -0.941091061, 0.321419984,
        -0.252405018, -0.94284904, 0.198795006,
        -0.137454003, -0.819092989, 0.198542982,
        0.0114090005, -0.906777024, 0.207371995,
        0.141419992, -0.812219977, 0.249435008,
        0.270195007, -0.83516103, 0.150195003,
        0.449292004, -0.840947986, 0.247202992,
        0.670533001, -0.844995022, 0.224343002,
        0.831411004, -0.879072011, 0.202821001,
        0.951546013, -0.762138009, 0.187898993,
        1.11091197, -0.80340004, 0.219899982,
        1.27129793, -0.860567987, 0.245451003,
        1.42683601, -0.821705997, 0.206516996,
        1.67434192, -0.934715986, 0.206339985,
        1.84421086, -0.914618969, 0.177096009,
        1.92536998, -0.768956959, 0.161066994,
        2.06923509, -0.862821043, 0.218886003,
        -2.38807201, -0.734955013, 0.213783011,
        -2.21880007, -0.764889002, 0.192372009,
        -2.0596652, -0.724406958, 0.228758991,
        -1.87030506, -0.756413937, 0.303171009,
        -1.78161299, -0.744446993, 0.155844003,
        -1.66799402, -0.843986988, 0.228701994,
        -1.51079702, -0.766149044, 0.149358004,
        -1.362939, -0.722112, 0.228758991,
        -1.19241309, -0.698606968, 0.208916992,
        -1.04616606, -0.665511012, 0.280596018,
        -0.887264967, -0.668676019, 0.236898005,
        -0.718392015, -0.669155955, 0.252413988,
        -0.550701022, -0.710822999, 0.271185011,
        -0.400355995, -0.771090031, 0.321114004,
        -0.249264002, -0.68590796, 0.22755,
        -0.0825750008, -0.613436997, 0.218327999,
        0.0529500023, -0.682011008, 0.305321991,
        0.218469009, -0.616656005, 0.27264601,
        0.349292994, -0.697959006, 0.208364993,
        0.503615975, -0.685590029, 0.272768974,
        0.632319033, -0.689141989, 0.162822008,
        0.794715047, -0.720077991, 0.136371002,
        0.919850945, -0.60817802, 0.166479006,
        1.07953799, -0.63815701, 0.183108002,
        1.23178804, -0.691014051, 0.220557004,
        1.48532104, -0.664709985, 0.225555003,
        1.59228301, -0.79537499, 0.233976007,
        1.75958097, -0.760475993, 0.191706002,
        1.85297406, -0.615851998, 0.131099999,
        2.05821896, -0.673290014, 0.229445994,
        -2.52329993, -0.63101995, 0.256200016,
        -2.35081196, -0.553731024, 0.187896013,
        -2.16761708, -0.597995996, 0.178296,
        -2.00255394, -0.563333988, 0.221138984,
        -1.8351779, -0.607257009, 0.233972996,
        -1.62618291, -0.631808996, 0.133490995,
        -1.46128798, -0.581081986, 0.128733009,
        -1.39078796, -0.453302979, 0.225395992,
        -1.14618301, -0.535697997, 0.232113004,
        -0.979743004, -0.519918025, 0.230315983,
        -0.815991044, -0.502749026, 0.283293009,
        -0.689733028, -0.522917986, 0.174020991,
        -0.527177989, -0.569963992, 0.190458,
        -0.386388004, -0.595085979, 0.280173004,
        -0.247047007, -0.491724014, 0.280811995,
        -0.0807330012, -0.462020993, 0.289638013,
        0.0766049996, -0.524280012, 0.276132017,
        0.218108982, -0.431942999, 0.276549011,
        0.352271974, -0.522410989, 0.230216995,
        0.495855033, -0.563849986, 0.157940999,
        0.616338015, -0.55480504, 0.267557979,
        0.771476984, -0.568994999, 0.222126007,
        1.01506495, -0.489753008, 0.240546003,
        1.18593299, -0.528605998, 0.254157007,
        1.34717393, -0.567737997, 0.227306992,
        1.49193895, -0.499743015, 0.187433988,
        1.63967109, -0.647682011, 0.160016999,
        1.74275398, -0.52572602, 0.210191995,
        1.986498, -0.506561995, 0.160041004,
        -2.49533391, -0.460305035, 0.210726008,
        -2.30607295, -0.389958024, 0.163877994,
        -2.13385797, -0.426146984, 0.168969005,
        -1.99620605, -0.333986998, 0.193484992,
        -1.8750031, -0.444932997, 0.208820999,
        -1.71808791, -0.494916022, 0.193158001,
        -1.55935192, -0.478679985, 0.220650002,
        -1.36725593, -0.305619001, 0.140133008,
        -1.23391795, -0.393903017, 0.206147999,
        -1.06636202, -0.39219898, 0.158888996,
        -0.947916031, -0.365330994, 0.283715993,
        -0.727385998, -0.365877002, 0.222507,
        -0.565817952, -0.412205994, 0.233208001,
        -0.400932014, -0.435432017, 0.232023001,
        -0.214727998, -0.335379004, 0.209585994,
        -0.0436710007, -0.297711015, 0.186879009,
        0.0874499977, -0.404852986, 0.167298004,
        0.213687003, -0.293597996, 0.186774001,
        0.346175998, -0.326439023, 0.288803995,
        0.492582023, -0.410117984, 0.236111999,
        0.694097996, -0.40940702, 0.218897998,
        0.864147067, -0.420827985, 0.227775007,
        1.07485795, -0.337785006, 0.280716002,
        1.22649896, -0.299322009, 0.207294017,
        1.42348802, -0.343079984, 0.18898201,
        1.59221697, -0.313392013, 0.147578999,
        1.63766992, -0.414018005, 0.271095008,
        1.76504695, -0.363797992, 0.158784002,
        1.94999099, -0.327912003, 0.219224989,
        -2.44604993, -0.289943993, 0.20872499,
        -2.29390788, -0.234540001, 0.229548007,
        -2.13022804, -0.252359986, 0.25454998,
        -2.04089403, -0.196521014, 0.105462,
        -1.83656693, -0.291005999, 0.142644003,
        -1.67365503, -0.328871995, 0.180197999,
        -1.50878096, -0.306726009, 0.238739997,
        -1.39376998, -0.172908008, 0.241661996,
        -1.15489793, -0.245799005, 0.189603001,
        -1.03663802, -0.175305009, 0.297369003,
        -0.867243052, -0.218432993, 0.286428005,
        -0.719018996, -0.138327003, 0.271848023,
        -0.597962976, -0.243479997, 0.206532001,
        -0.373943985, -0.266709, 0.218814015,
        -0.241295993, -0.157457992, 0.199283987,
        -0.0874560028, -0.156134993, 0.276120007,
        0.0917069986, -0.193275005, 0.244994998,
        0.254094005, -0.140046, 0.273362994,
        0.353159994, -0.211455017, 0.160991997,
        0.476741999, -0.222719997, 0.266205013,
        0.633359969, -0.253791004, 0.216971993,
        0.795363069, -0.272666991, 0.181152001,
        1.04883003, -0.169616997, 0.122438997,
        1.21186805, -0.129314989, 0.23795101,
        1.35204303, -0.189123005, 0.172488004,
        1.51362598, -0.168960005, 0.198657006,
        1.68130493, -0.179033995, 0.200327992,
        1.85219097, -0.178791001, 0.208815008,
        -2.41285491, -0.110571004, 0.231186002,
        -2.30862308, 0.0241379999, 0.247260004,
        -2.202075, -0.104318999, 0.200153992,
        -2.04285288, -0.0612419993, 0.202895999,
        -1.93078208, -0.184749007, 0.233696997,
        -1.76322591, -0.147461995, 0.222389996,
        -1.59162605, -0.159729004, 0.186344996,
        -1.47541201, -0.0297449995, 0.19224599,
        -1.30981195, -0.0308100022, 0.193031996,
        -1.14889193, -0.0813359991, 0.214250982,
        -0.971355021, -0.032664001, 0.241181999,
        -0.731159985, -0.00466199964, 0.164742008,
        -0.597876012, -0.0137490006, 0.284093976,
        -0.470855981, -0.124593005, 0.221744984,
        -0.293552995, 0.00818699971, 0.190170005,
        -0.129588008, -0.0279660001, 0.171692997,
        0.0253560003, -0.0293790009, 0.247880995,
        0.185109004, -0.0388469994, 0.154329002,
        0.40467301, -0.0661889985, 0.220322996,
        0.570161998, -0.0981030017, 0.201867014,
        0.735897005, -0.115025997, 0.185139,
        0.90189296, -0.133938, 0.187992007,
        0.993102014, -0.0145169999, 0.273129016,
        1.11465299, -0.0216179993, 0.157632008,
        1.29391205, 0.0187229998, 0.26019901,
        1.42122006, -0.0328320004, 0.153182998,
        1.60225797, -0.0282779988, 0.174770996,
        1.76538897, -0.0271530002, 0.242418006,
        -2.46967506, 0.0577409975, 0.198605999,
        -2.27142906, 0.180914998, 0.216365993,
        -2.16766787, 0.0517679974, 0.147906005,
        -2.00260806, 0.0990149975, 0.169785008,
        -1.88143492, -0.0253830012, 0.224601001,
        -1.70820308, 0.0139290001, 0.216570005,
        -1.56525302, 0.104229003, 0.150570005,
        -1.41816592, 0.121466994, 0.264014989,
        -1.25798094, 0.130908012, 0.191355005,
        -1.09886694, 0.0726300031, 0.213863999,
        -0.936749935, 0.108501002, 0.162845999,
        -0.765182972, 0.164337009, 0.191754013,
        -0.606675029, 0.119562, 0.177264005,
        -0.454925984, 0.0560580008, 0.186534002,
        -0.218928009, 0.159155995, 0.167183995,
        -0.0596880019, 0.121347003, 0.222143993,
        0.106661998, 0.120563999, 0.217479005,
        0.26434201, 0.168264002, 0.215643018,
        0.341354996, 0.0578610003, 0.126273006,
        0.512721002, 0.0493860021, 0.149489999,
        0.669755995, 0.0376590006, 0.216353998,
        0.830688, 0.0120359994, 0.24682501,
        0.937914014, 0.113192998, 0.162104994,
        1.14802206, 0.116889, 0.23988001,
        1.35488403, 0.136976987, 0.146643013,
        1.493016, 0.0985080004, 0.234983996,
        1.66249502, 0.116804995, 0.262511998,
        -2.57416797, 0.206063986, 0.22399801,
        -2.41286993, 0.270072013, 0.248631001,
        -2.29229689, 0.314648986, 0.122391,
        -2.16089392, 0.319479018, 0.222434998,
        -2.01801014, 0.263439, 0.140552998,
        -1.84226096, 0.138626993, 0.209733009,
        -1.68439507, 0.185093999, 0.239223003,
        -1.53593111, 0.262292981, 0.228471011,
        -1.37606704, 0.264377981, 0.166362002,
        -1.20102298, 0.296985, 0.125169009,
        -1.07097006, 0.233451009, 0.207267016,
        -0.907458007, 0.266220003, 0.190523982,
        -0.783038974, 0.367254019, 0.235143006,
        -0.632261992, 0.277911007, 0.252974987,
        -0.46134001, 0.310014009, 0.281664014,
        -0.299717993, 0.304307997, 0.213027,
        -0.0917879939, 0.283185005, 0.123209998,
        0.158418, 0.262140006, 0.128100008,
        0.18095699, 0.293900996, 0.290408999,
        0.32902801, 0.316964984, 0.207821995,
        0.439914018, 0.198822007, 0.163517997,
        0.603587985, 0.194555998, 0.208773002,
        0.777507067, 0.171767995, 0.244404003,
        0.925557017, 0.274187982, 0.224574,
        1.09589398, 0.274755001, 0.282011986,
        1.22010303, 0.249816, 0.163712993,
        1.46158493, 0.274859995, 0.175844997,
        -2.54809189, 0.35274601, 0.127074003,
        -2.39759684, 0.429363012, 0.178931996,
        -2.27224207, 0.470678985, 0.0657930002,
        -2.16823196, 0.486456037, 0.194141999,
        -2.0215168, 0.412955999, 0.223047003,
        -1.74814796, 0.342177004, 0.269861996,
        -1.62027597, 0.413534999, 0.179058,
        -1.45481992, 0.412365019, 0.217538998,
        -1.29267907, 0.412164032, 0.210672006,
        -1.17206097, 0.470894992, 0.111267,
        -1.134534, 0.384477019, 0.257421017,
        -0.976292968, 0.41624999, 0.225833997,
        -0.690297008, 0.50020802, 0.281571001,
        -0.552033007, 0.435723007, 0.193022996,
        -0.377460003, 0.463914037, 0.284780979,
        -0.235736996, 0.464810997, 0.179639995,
        -0.0898080021, 0.409929037, 0.248964012,
        0.0624659993, 0.373521, 0.198719993,
        0.212601006, 0.444240034, 0.244593009,
        0.403845012, 0.443453997, 0.129546002,
        0.538559973, 0.344030976, 0.159186006,
        0.705806971, 0.315011978, 0.145853996,
        0.860492945, 0.40317297, 0.135464996,
        1.03699803, 0.393552005, 0.164196,
        1.17456305, 0.484100997, 0.230967015,
        1.32207608, 0.386574, 0.200358003,
        -2.570544, 0.516485989, 0.220716,
        -2.49186301, 0.508674026, 0.0623039976,
        -2.23926306, 0.63459897, 0.107156999,
        -2.08964705, 0.637163997, 0.19461599,
        -2.01108003, 0.551405966, 0.321758986,
        -1.87075806, 0.467243969, 0.267414004,
        -1.72140598, 0.533922017, 0.262952983,
        -1.50453007, 0.545396984, 0.127406999,
        -1.331604, 0.55893898, 0.123102009,
        -1.12988698, 0.617825985, 0.197465986,
        -1.00610995, 0.536606967, 0.095693998,
        -0.856562972, 0.535041034, 0.193773001,
        0.0606720001, 0.542366982, 0.165455997,
        0.233852997, 0.573069036, 0.140271008,
        0.404936969, 0.606855035, 0.175419003,
        0.547106981, 0.50879401, 0.214917004,
        0.718313992, 0.468948007, 0.219800994,
        0.811398029, 0.611328006, 0.217959017,
        0.96600306, 0.552308977, 0.155588999,
        -1.87089908, 1.24988103, -1.02035403,
        -2.60430598, 0.682835996, 0.284559011,
        -2.49106503, 0.665673018, 0.147759005,
        -2.35131907, 0.732179999, 0.235491008,
        -2.18613601, 0.778409958, 0.191841006,
        -1.95235205, 0.726402044, 0.151484996,
        -1.80276597, 0.642363012, 0.139527008,
        -1.63608599, 0.643880963, 0.170529008,
        -1.44878101, 0.667061985, 0.230253011,
        -1.23869693, 0.704655051, 0.0866999999,
        -1.90409994, 1.428303, -0.988458037,
        -1.71667492, 1.34105992, -0.977133036,
        -2.48378396, 0.840063035, 0.196181998,
        -2.31613803, 0.883995056, 0.159177005,
        -2.03282404, 0.860168934, 0.223931998,
        -1.86619496, 0.873137951, 0.167670012,
        -1.72368002, 0.792312026, 0.151850998,
        -1.56754196, 0.788217008, 0.221379012,
        -1.41619194, 0.808377028, 0.145617008,
        -1.25511003, 0.860319018, 0.17621699,
        -2.01128101, 1.55045092, -1.11073804,
        -1.70313597, 1.58878505, -1.01575494,
        -2.39973593, 1.02719402, 0.215930998,
        -2.20388985, 1.10178304, 0.19282499,
        -2.02321792, 1.17167997, 0.194934011,
        -1.94641507, 1.01758504, 0.177237004,
        -1.77584386, 1.02483296, 0.185144991,
        -1.62229192, 0.951239944, 0.21079199,
        -1.44320107, 0.963672042, 0.216114014,
        -1.29605699, 1.04096401, 0.148980007,
        -2.10407114, 1.77910495, -1.06502104,
        -1.92501605, 1.6894021, -1.02495897,
        -1.75744808, 1.76482809, -1.00342798,
        -2.35002613, 1.19993699, 0.192594007,
        -2.1591959, 1.26949203, 0.193530008,
        -1.87006795, 1.15878606, 0.112773001,
        -1.70288694, 1.18806303, 0.167456999,
        -1.55023789, 1.10254502, 0.186837003,
        -1.40317202, 1.17971396, 0.134712011,
        -1.22713804, 1.20517802, 0.150306001,
        -1.05322504, 1.17706501, 0.125550002,
        -2.08305001, 2.00102711, -1.01172006,
        -1.93608892, 1.869735, -1.05171895,
        -1.80814815, 1.95170712, -0.950874031,
        -2.29905605, 1.362252, 0.238011003,
        -2.01182079, 1.36641598, 0.143748,
        -1.83262503, 1.32353103, 0.138743997,
        -1.66991401, 1.33471501, 0.0711029992,
        -1.5422461, 1.27421403, 0.177884996,
        -1.36278594, 1.33139694, 0.218924999,
        -1.21177506, 1.38170099, 0.136767,
        -1.05474591, 1.342785, 0.208278,
        -0.900272965, 1.26234901, 0.167261988,
        -2.13746095, 1.46131504, 0.222452998,
        -1.92046785, 1.52060986, 0.133121997,
        -1.77905703, 1.46046901, 0.230576992,
        -1.594239, 1.43869209, 0.191271007,
        -1.45850396, 1.40312397, 0.0823200047,
        -1.32842994, 1.51238704, 0.135999009,
        -1.12084496, 1.509624, 0.223769993,
        -0.949197054, 1.51803899, 0.180225,
        -0.764028072, 1.39861798, 0.194358006,
        -1.43887496, 1.64609408, 0.182810992,
        -1.22877002, 1.64658904, 0.189350992,
        -1.02162898, 1.686795, 0.172454998,
        -0.825797975, 1.66177797, 0.168260992,
        -0.821624994, 1.540344, 0.30470401,
        -0.657405019, 1.55787599, 0.225060001,
        -1.24191904, 1.81892395, 0.229277998,
        -1.07012999, 1.84643698, 0.283364981,
        -0.895691991, 1.80823803, 0.248474985,
        -0.965364039, 1.96793413, 0.188652009,
        -0.783120036, 1.94098496, 0.190884009,
        -0.893633962, -2.69319606, -0.861194968,
        -0.728196025, -2.73245382, -0.919389009,
        -0.552860975, -2.74246502, -0.877082944,
        -0.700194001, -2.55420899, -0.914909959,
        -0.528495014, -2.50963497, -0.903104961,
        -0.405798018, -2.64036894, -0.887795985,
        -0.237813011, -2.5934999, -0.855834007,
        -0.647535026, -2.38033199, -0.865433931,
        -0.325350016, -2.43351603, -0.868110001,
        -0.232310995, -2.23780799, -0.852917969,
        -0.0643350035, -2.23442698, -0.900240004,
        0.102617994, -2.18365812, -0.942351043,
        0.244295999, -2.27803802, -0.906437993,
        0.419423997, -2.27677202, -0.882591009,
        0.595988989, -2.2239151, -0.884976029,
        0.76543504, -2.22998095, -0.824594975,
        -0.199290007, -2.08148384, -0.934481978,
        -0.0341069996, -2.08424711, -0.99298799,
        0.0471780002, -1.99320602, -0.872009993,
        0.192606002, -2.07876897, -0.834482968,
        0.341169, -2.12642097, -0.910295963,
        0.514532983, -2.06778908, -0.919772983,
        0.704841018, -2.08070707, -0.892904997,
        0.889539003, -2.11334395, -0.85975796,
        -2.00819993, -2.67641711, 0.396755993,
        -1.83891606, -2.72942686, 0.382370979,
        -1.6649611, -2.73926997, 0.364082992,
        -1.49590492, -2.74257898, 0.310865998,
        -1.250175, -2.74107909, 0.367340982,
        -1.17144895, -2.63230515, 0.472766995,
        -1.07615697, -2.72405696, 0.363182992,
        -0.902714968, -2.73816299, 0.37765497,
        -0.703154981, -2.73798299, 0.370721996,
        -0.380313009, -1.97757888, -0.854405999,
        -0.262470007, -1.91877294, -0.971451044,
        -0.121160999, -1.93575287, -0.868731022,
        0.108680993, -1.79458809, -0.995103002,
        0.202865988, -1.91966391, -0.89597404,
        0.564482987, -2.71011901, 0.366492003,
        0.324474007, -1.79584801, -0.907940984,
        0.737897992, -2.68856096, 0.343397975,
        0.476682007, -1.85685301, -0.940908015,
        0.919829965, -2.68829107, 0.394109964,
        0.631788015, -1.93106103, -0.949986041,
        0.824708998, -1.95496202, -0.917490005,
        1.26938105, -2.7128129, 0.362021983,
        1.02615607, -2.00065517, -0.860820055,
        1.44567597, -2.68925381, 0.34948498,
        -1.94758511, -2.51264691, 0.426443994,
        -1.78924799, -2.52748203, 0.362349004,
        -1.6353631, -2.57520604, 0.321927011,
        -1.48314905, -2.488518, 0.306425989,
        -1.37394893, -2.61576295, 0.337514997,
        -1.25058901, -2.49401999, 0.408486009,
        -1.07896805, -2.54696703, 0.358686,
        -0.87757802, -2.52228308, 0.420644999,
        -0.75832504, -2.51292896, 0.302756995,
        -0.589383006, -2.61355209, 0.325070977,
        -0.49545002, -2.49465299, 0.412427992,
        -0.464550018, -1.73971796, -0.87550199,
        -0.355455011, -2.58029699, 0.354867011,
        -0.310436994, -1.75358999, -0.947430015,
        -0.0832469985, -2.57800817, 0.365360975,
        -0.140145004, -1.76752496, -0.912215948,
        0.0808050036, -2.57476211, 0.311228991,
        0.0121589992, -1.82814896, -0.857502043,
        0.249260992, -2.55625486, 0.338450998,
        0.177956998, -1.72343695, -0.83901304,
        0.418452024, -2.59459209, 0.392051995,
        0.34474498, -1.67908502, -0.79359293,
        0.541787982, -2.47692585, 0.410481036,
        0.461796016, -1.68656695, -0.92057097,
        0.683097005, -2.52443695, 0.324930012,
        0.614087999, -1.79211903, -0.851511002,
        0.854084969, -2.56763697, 0.29162401,
        0.763164043, -1.77936602, -0.935001016,
        1.09191895, -2.65658689, 0.353913009,
        0.931679964, -1.81920314, -0.888867021,
        1.21844399, -2.55786586, 0.30438301,
        1.39312196, -2.53364396, 0.258732021,
        1.55790305, -2.47175694, 0.197829008,
        1.62821102, -2.63038206, 0.245643005,
        1.78223395, -2.60692501, 0.343275011,
        1.94482207, -2.52788711, 0.329043001,
        -1.80907202, -2.35754681, 0.407270998,
        -1.65517497, -2.40436792, 0.331128001,
        -1.472247, -2.32265687, 0.274356008,
        -1.31523299, -2.39206791, 0.281711996,
        -1.15560603, -2.44405794, 0.242549986,
        -0.383922011, -1.59834599, -0.824501991,
        -1.12917602, -2.374542, 0.393507004,
        -0.24180001, -1.59370494, -0.933230996,
        -0.977609992, -2.41312504, 0.332379013,
        -0.0747299939, -1.53147304, -0.911841035,
        -0.819092989, -2.36928296, 0.382571995,
        0.0136560006, -1.67509198, -0.923841,
        -0.646299005, -2.41667104, 0.400463998,
        0.154155001, -1.57808399, -0.920771956,
        -0.490893006, -2.31802797, 0.432134986,
        -0.329070002, -2.32660198, 0.354104996,
        0.327762008, -1.56607795, -0.911478043,
        -0.200268, -2.44228506, 0.351125985,
        0.493431032, -1.51934385, -0.893180966,
        -0.0142080002, -2.43238497, 0.307206005,
        0.621758997, -1.62732887, -0.866909981,
        0.162548989, -2.43661499, 0.417614996,
        0.737003982, -1.61659205, -0.995612979,
        0.300104976, -2.38548899, 0.328704,
        0.899082005, -1.64994907, -0.934848011,
        0.539108992, -2.30105996, 0.400179029,
        1.08340502, -1.64665496, -0.886502981,
        0.709661961, -2.31868219, 0.436995029,
        0.824535012, -2.41931415, 0.369575977,
        0.99860698, -2.479491, 0.270711005,
        1.126086, -2.38843513, 0.349835992,
        1.29326403, -2.42413807, 0.356283009,
        1.43966401, -2.37458992, 0.273995996,
        1.60041595, -2.3294611, 0.282777011,
        1.65930295, -2.48180985, 0.340317011,
        1.80935097, -2.43960309, 0.400425017,
        2.10703206, -2.43759298, 0.361859977,
        -1.56929088, -2.26269603, 0.411561012,
        -1.37786698, -2.23211694, 0.389999986,
        -0.521474957, -1.51644301, -0.902664006,
        -1.21665597, -2.25696611, 0.312557995,
        -0.370671004, -1.44972599, -0.894147038,
        -1.06829107, -2.30203509, 0.234242991,
        -0.211007997, -1.44988203, -0.853980064,
        -0.911576986, -2.25738001, 0.288744003,
        -0.0912330002, -1.35581398, -0.917607069,
        -0.759252012, -2.21935511, 0.352425009,
        0.0581849962, -1.43193007, -0.906419992,
        -0.622053027, -2.20309186, 0.446244001,
        0.229667991, -1.43382907, -0.88706696,
        -0.427637994, -2.18760896, 0.339441001,
        0.383846998, -1.40302193, -0.948969007,
        -0.190412998, -2.27033401, 0.446673006,
        0.545684993, -1.35156608, -0.932525992,
        0.00128700002, -2.30037904, 0.405020982,
        0.654090047, -1.45834506, -0.865487933,
        0.169272006, -2.27460003, 0.37618798,
        0.825299978, -1.46081996, -0.980664015,
        0.311976016, -2.24373913, 0.458712012,
        1.00007701, -1.498299, -0.94223094,
        0.39279601, -2.24599791, 0.311679006,
        1.19862008, -1.43502903, -0.852581978,
        0.533154011, -2.14051509, 0.336275995,
        0.687162042, -2.1616261, 0.392664015,
        0.813362956, -2.24586916, 0.319271982,
        0.962432981, -2.32598996, 0.344933987,
        1.09347296, -2.22088504, 0.330389977,
        1.30678797, -2.26256084, 0.354809999,
        1.479918, -2.25058508, 0.369251996,
        1.64309096, -2.25914407, 0.42958802,
        1.76168704, -2.29712701, 0.318819016,
        1.91693091, -2.22891307, 0.332304001,
        2.09787607, -2.26798201, 0.398537993,
        2.24546719, -2.33690405, 0.314558983,
        2.37752104, -2.21667004, 0.327300012,
        -0.609809995, -1.40695798, -0.799386024,
        -0.458109021, -1.330809, -0.81674999,
        -0.29906401, -1.29917097, -0.863682032,
        -0.149438992, -1.20822299, -0.872363985,
        -1.44088793, -2.05254889, 0.401349008,
        0.0245789997, -1.22724605, -0.915164948,
        -1.28532004, -2.09876108, 0.335592002,
        0.140349001, -1.30825496, -0.822911978,
        -1.11840296, -2.06271291, 0.328478992,
        0.302685022, -1.28781605, -0.861162007,
        -0.874922991, -2.08927798, 0.323765993,
        0.460079968, -1.27078795, -0.804614961,
        -0.711314976, -2.05968285, 0.366591007,
        0.630455971, -1.30297196, -0.790677071,
        -0.559646964, -2.08415985, 0.312321007,
        0.770978987, -1.33038902, -0.880407035,
        -0.497915983, -2.09037304, 0.465224981,
        0.941558957, -1.329252, -0.943679988,
        -0.333317995, -2.0768218, 0.428811014,
        1.09589696, -1.28294396, -0.862389028,
        -0.0697920024, -2.15029192, 0.405815989,
        0.0882869959, -2.13322806, 0.341046005,
        0.221376002, -2.0975399, 0.465030015,
        0.382050008, -2.09389496, 0.396911979,
        0.494322002, -1.98078895, 0.297632992,
        0.657500982, -2.03061604, 0.279357016,
        0.80428493, -2.0483911, 0.359531999,
        0.943271995, -2.15176797, 0.367698014,
        1.09259999, -2.07793808, 0.412554026,
        1.26872396, -2.12019587, 0.434864998,
        1.46779203, -2.12286282, 0.467078984,
        1.59041405, -2.12920499, 0.328097999,
        1.76660109, -2.12690687, 0.328181982,
        1.95223498, -2.07792902, 0.405206978,
        2.13132596, -2.0896709, 0.367727995,
        2.32270503, -2.08089304, 0.421361983,
        2.48904896, -2.08130407, 0.357114017,
        -1.49434793, -1.89838493, 0.452505022,
        -0.640079975, -1.24189496, -0.846486032,
        -1.31829906, -1.93047905, 0.365943015,
        -0.481736988, -1.17212403, -0.86037302,
        -1.14032102, -1.899405, 0.363357008,
        -0.282815993, -1.07289004, -0.870248973,
        -0.977108955, -1.95076799, 0.332430005,
        -0.126296997, -1.05633593, -0.93661499,
        -0.816356957, -1.93178391, 0.371955007,
        0.0666510016, -1.05669606, -0.92802304,
        -0.636416972, -1.92407691, 0.28153199,
        0.186446995, -1.17275703, -0.907064974,
        -0.582629979, -1.94369996, 0.435965985,
        0.353154004, -1.13370001, -0.855441034,
        -0.445253968, -1.96828794, 0.354402006,
        0.530004025, -1.12762499, -0.852077961,
        -0.282348007, -1.963413, 0.317541003,
        0.65386498, -1.21297503, -0.930447042,
        -0.162851989, -2.01543903, 0.426279008,
        0.80369103, -1.11813593, -0.91376102,
        0.0391860008, -2.01401091, 0.454443008,
        0.973559976, -1.15714192, -0.940991998,
        0.167142004, -1.978863, 0.350373,
        0.330698997, -1.94625592, 0.320367008,
        0.456090033, -1.86465907, 0.412154973,
        0.617604017, -1.90199113, 0.378987014,
        0.78263104, -1.88002503, 0.384038985,
        0.946458042, -1.98584998, 0.415674001,
        1.08065701, -1.89085793, 0.470403016,
        1.21237504, -1.96619701, 0.398886025,
        1.51312804, -1.98481798, 0.377997011,
        1.68001807, -1.98504901, 0.368378997,
        1.84409702, -1.97681403, 0.309017986,
        2.00810099, -1.92342603, 0.344529003,
        2.15363097, -1.95573902, 0.253686011,
        2.32715392, -1.92757511, 0.282084018,
        2.41460705, -1.94267702, 0.429050982,
        2.52158713, -1.91664314, 0.296196014,
        -0.631568968, -1.06604695, -0.877335012,
        -1.81312501, -1.79297698, 0.33761999,
        -0.443960965, -1.00544095, -0.865275025,
        -1.64875793, -1.84854305, 0.396567017,
        -0.219096005, -0.921725988, -0.882791996,
        -1.55017495, -1.71898806, 0.456780016,
        -0.0464910008, -0.921509981, -0.887703001,
        -1.25017202, -1.77013803, 0.358020008,
        0.116954997, -0.903737962, -0.896651983,
        -1.10293496, -1.76051402, 0.454397976,
        0.235335007, -1.01619291, -0.873947978,
        -1.00075805, -1.77518106, 0.320363998,
        0.371178001, -0.990099013, -0.779628038,
        -0.870419979, -1.78262401, 0.439404011,
        0.455771983, -0.915395975, -0.893568039,
        -0.71471405, -1.79663408, 0.364886999,
        0.618728995, -0.976601958, -0.90485698,
        -0.509792984, -1.790241, 0.466053009,
        0.799889982, -0.972536981, -0.822032928,
        -0.357963026, -1.845927, 0.420167983,
        -0.197199002, -1.84870791, 0.416637003,
        0.923067033, -0.98734796, -0.934431016,
        -0.0494430028, -1.91387701, 0.359133005,
        0.0912059993, -1.84313393, 0.279504001,
        0.229431003, -1.82139301, 0.382824004,
        0.366488993, -1.76500201, 0.31181699,
        0.52186799, -1.807971, 0.27265501,
        0.67702198, -1.74743092, 0.329199016,
        0.847193956, -1.71800399, 0.329930991,
        1.03219795, -1.74945593, 0.38183701,
        1.17599702, -1.82373297, 0.29429099,
        1.31193304, -1.71085203, 0.272900999,
        1.46050799, -1.80051899, 0.308192998,
        1.65892196, -1.82362199, 0.359798998,
        1.85485196, -1.80860102, 0.298031986,
        2.01295805, -1.73295593, 0.288056999,
        2.14014912, -1.81201208, 0.359174997,
        2.27453089, -1.7342701, 0.432731986,
        2.40986395, -1.78971899, 0.346697986,
        2.58167696, -1.77039599, 0.382209003,
        -0.576587975, -0.892064989, -0.876935959,
        -0.406434, -0.844448984, -0.85590899,
        -0.25869599, -0.759906054, -0.847955942,
        -1.97290802, -1.697559, 0.349035025,
        -0.0883139968, -0.772935033, -0.822207034,
        -1.81908894, -1.62263393, 0.287672997,
        0.0942419916, -0.782817006, -0.791393995,
        -1.66837502, -1.68774605, 0.332663983,
        0.282687008, -0.856184959, -0.825264037,
        -1.35536098, -1.62827706, 0.344889015,
        0.357725978, -0.800198972, -0.964890003,
        -1.22065806, -1.63648486, 0.461169004,
        0.568706989, -0.801162004, -0.919502974,
        -1.09525502, -1.628613, 0.339597017,
        0.720870018, -0.827468991, -0.849279046,
        -0.973773003, -1.63994694, 0.459353983,
        0.863028049, -0.80904901, -0.946335018,
        -0.888327003, -1.54768801, 0.349337995,
        1.02642596, -0.85026598, -0.892190933,
        -0.765107989, -1.64129698, 0.422856033,
        -0.590942979, -1.65771294, 0.394124985,
        -0.345254987, -1.68833709, 0.471926987,
        -0.216066003, -1.68587995, 0.365238011,
        -0.0658289939, -1.75448108, 0.342018008,
        0.0778800026, -1.66761303, 0.348560989,
        0.249006003, -1.64837098, 0.354396015,
        0.479982018, -1.64448595, 0.271211982,
        0.606326997, -1.60773897, 0.388736963,
        0.742311001, -1.58915114, 0.279008985,
        0.896229029, -1.61437201, 0.459071994,
        1.09983301, -1.60378194, 0.458781004,
        1.14154506, -1.65486312, 0.301937997,
        1.26831603, -1.60793686, 0.395099998,
        1.46596193, -1.56901503, 0.394305021,
        1.55912995, -1.70319593, 0.412223995,
        1.73877597, -1.69515586, 0.434051991,
        1.88251495, -1.65106797, 0.355235994,
        2.07919192, -1.62504292, 0.399195015,
        2.22377396, -1.62780905, 0.304217994,
        2.38848901, -1.61619294, 0.364905,
        2.56426501, -1.59492898, 0.382761002,
        -0.407603979, -0.692996979, -0.931136966,
        -0.251070023, -0.594395995, -0.878525972,
        -0.0978719965, -0.62924397, -0.955989003,
        0.0147240004, -0.647121012, -0.826938033,
        -2.16645598, -1.51147807, 0.361755013,
        -1.99261808, -1.52512193, 0.363620996,
        0.184116006, -0.638502002, -0.824166059,
        0.343163997, -0.684908986, -0.846563995,
        -1.82022607, -1.49288094, 0.394625992,
        0.509537995, -0.676230013, -0.826887012,
        -1.65631509, -1.54208994, 0.432981014,
        0.741275966, -0.64586103, -0.924825072,
        -1.48962295, -1.560498, 0.448940992,
        0.904404044, -0.664493978, -0.854004025,
        -1.32243299, -1.49873996, 0.446832001,
        -1.14899707, -1.488765, 0.422394007,
        -1.03441501, -1.46858096, 0.295067996,
        -0.798330009, -1.414572, 0.39041698,
        -0.663941979, -1.50891304, 0.379413009,
        -0.496703982, -1.510077, 0.376403987,
        -0.353358001, -1.46752501, 0.448767006,
        -0.209811002, -1.51586103, 0.379842013,
        -0.0686549991, -1.58739901, 0.322430998,
        0.0564479977, -1.47899699, 0.285284996,
        0.179157004, -1.49246395, 0.391251028,
        0.341583014, -1.50675595, 0.399578989,
        0.500952005, -1.47917402, 0.357690006,
        0.668576956, -1.45463693, 0.359939992,
        0.838025987, -1.48208094, 0.367985994,
        1.00335002, -1.48237205, 0.392499,
        1.16999698, -1.48186803, 0.35778901,
        1.34357691, -1.46238303, 0.375113994,
        1.51308012, -1.43885696, 0.308448017,
        1.71242404, -1.52218509, 0.427125037,
        1.85828698, -1.42839301, 0.444353998,
        2.02312183, -1.45864797, 0.413292021,
        2.18336105, -1.49724603, 0.458867967,
        2.2884388, -1.40169907, 0.351926982,
        -0.105774, -0.533393979, -0.814254045,
        2.4648838, -1.44629407, 0.357531011,
        0.0955320001, -0.534641981, -0.931154966,
        0.276329994, -0.547911048, -0.941595018,
        0.447663009, -0.53610003, -0.907110035,
        0.615243018, -0.547502995, -0.852048039,
        -2.3015461, -1.39230001, 0.359435976,
        -2.12835598, -1.32095993, 0.330264002,
        -1.95529795, -1.36097407, 0.337053001,
        -1.81210792, -1.33140898, 0.434490025,
        -1.68859792, -1.39851904, 0.528551996,
        -1.52145886, -1.40221798, 0.435437977,
        -1.38449097, -1.31779802, 0.374706,
        -1.24088693, -1.34772599, 0.457530022,
        -1.09053004, -1.33188295, 0.386492997,
        -0.923786998, -1.31052899, 0.38894701,
        -0.713868022, -1.27641904, 0.435045004,
        -0.57735002, -1.36167598, 0.383076012,
        -0.408249021, -1.31575799, 0.398745,
        -0.247814983, -1.35246599, 0.334176004,
        -0.0871110037, -1.41421199, 0.345449984,
        0.0609360002, -1.332057, 0.363209993,
        0.195423007, -1.21524298, 0.322182,
        0.262950003, -1.34445, 0.420947969,
        0.392982006, -1.35683393, 0.307857007,
        0.596543968, -1.31561697, 0.293888986,
        0.776036978, -1.34265602, 0.289709985,
        0.938217044, -1.34617496, 0.328460991,
        1.0946579, -1.337556, 0.39278698,
        1.25522697, -1.32690597, 0.372815996,
        1.4227891, -1.30678797, 0.354705006,
        1.57911909, -1.41453898, 0.461166024,
        1.70756698, -1.30558801, 0.479591966,
        1.95872104, -1.29499507, 0.398261994,
        2.11518002, -1.32295501, 0.313062012,
        -2.47764301, -1.11032999, 0.391860008,
        -2.33753991, -1.21962893, 0.382299006,
        -2.1762569, -1.150527, 0.374109,
        -2.00811887, -1.14603603, 0.409173012,
        -1.86974108, -1.208727, 0.336513013,
        -1.6743269, -1.22768104, 0.455208004,
        -1.53800702, -1.21101606, 0.349743009,
        -1.37934601, -1.15260005, 0.353552997,
        -1.21062899, -1.18911004, 0.398783982,
        -0.993918061, -1.07725501, 0.294692993,
        -0.864830971, -1.15158594, 0.396314979,
        -0.698217034, -1.14433801, 0.344958007,
        -0.532284021, -1.1992681, 0.364430994,
        -0.376904994, -1.176054, 0.305943012,
        -0.255825013, -1.2050581, 0.420603007,
        -0.106755003, -1.25172901, 0.363672018,
        0.0332849994, -1.16484296, 0.360242993,
        0.164385006, -1.07377207, 0.411047995,
        0.39783901, -1.19196904, 0.34857899,
        0.557397008, -1.12928998, 0.340653002,
        0.714128971, -1.18493104, 0.302439004,
        0.850049973, -1.15686595, 0.405737996,
        1.01141107, -1.19206202, 0.360879004,
        1.15918803, -1.11189902, 0.391487986,
        1.31818199, -1.17448497, 0.323058009,
        1.43105102, -1.17353702, 0.456705004,
        1.5973351, -1.17834902, 0.439733982,
        1.75201201, -1.16847301, 0.385818005,
        1.91711998, -1.12455893, 0.38211,
        2.11577415, -1.15017295, 0.373410016,
        -2.34638119, -1.00334692, 0.426171005,
        -2.18306994, -0.980015993, 0.444774002,
        -2.07873893, -1.01655304, 0.317831993,
        -1.91109002, -1.02460504, 0.334133983,
        -1.7617681, -1.09740305, 0.391506016,
        -1.6027081, -1.06953001, 0.405144006,
        -1.46193004, -1.001724, 0.365534991,
        -1.31171405, -1.00204504, 0.309606016,
        -1.20335698, -0.931676984, 0.414756,
        -1.03468204, -0.962985039, 0.413760006,
        -0.866427004, -0.972623944, 0.319983006,
        -0.719532013, -0.998373032, 0.41476202,
        -0.572264969, -1.04155493, 0.317166001,
        -0.440055013, -1.05747008, 0.416685015,
        -0.254198998, -1.06268096, 0.319748998,
        -0.116201997, -1.05422401, 0.428586006,
        0.0279299989, -1.00335598, 0.339183003,
        0.160356, -0.907766998, 0.401435971,
        0.292896003, -1.06996202, 0.298593014,
        0.434888989, -0.989481032, 0.341583014,
        0.708287954, -1.05771303, 0.416496009,
        0.86275202, -0.992949009, 0.373314023,
        1.02426004, -1.02537894, 0.333056986,
        1.22714102, -0.965843976, 0.364565998,
        1.371261, -1.03184104, 0.392666996,
        1.52305508, -1.02842999, 0.442485005,
        1.63164902, -1.04899502, 0.324144006,
        1.79204106, -1.03407598, 0.29162401,
        1.94590211, -0.97369206, 0.303543001,
        2.09302807, -0.937706947, 0.381992996,
        -2.54585385, -0.920498967, 0.390956998,
        -2.39230204, -0.867963016, 0.325437009,
        -2.22498894, -0.846444011, 0.337116003,
        -2.07827091, -0.852836967, 0.417768002,
        -1.90994704, -0.872568011, 0.423516035,
        -1.76452804, -0.93806994, 0.356081992,
        -1.60625386, -0.891725957, 0.382686019,
        -1.39509892, -0.850863039, 0.330765009,
        -1.2459209, -0.858417034, 0.257981986,
        -1.13092494, -0.786839962, 0.35037899,
        -0.982109964, -0.847829998, 0.30319199,
        -0.807402015, -0.859524012, 0.432213008,
        -0.672717035, -0.811007977, 0.338136017,
        -0.563558996, -0.941541016, 0.454041004,
        -0.402507007, -0.876855016, 0.472586989,
        -0.247368008, -0.829734027, 0.329886019,
        -0.123815998, -0.941097021, 0.308744997,
        0.012654, -0.833538055, 0.359577,
        0.216306001, -0.751088977, 0.379848003,
        0.293520004, -0.890798986, 0.305963993,
        0.573552012, -0.862682998, 0.36639899,
        0.756594062, -0.860517025, 0.358577996,
        0.930063009, -0.843593955, 0.337247998,
        1.08904505, -0.874485016, 0.363803983,
        1.237764, -0.802863002, 0.402065992,
        1.39020598, -0.867704988, 0.363674998,
        1.49631, -0.874343991, 0.490938008,
        1.625175, -0.884642959, 0.379997969,
        1.77809107, -0.866273999, 0.324698985,
        1.93329298, -0.807431996, 0.322715998,
        2.08880687, -0.756603003, 0.381173998,
        -2.57734203, -0.713721037, 0.412904978,
        -2.37970805, -0.715613961, 0.406823993,
        -2.17115402, -0.708719969, 0.42930603,
        -2.01169801, -0.699059963, 0.381969005,
        -1.8816359, -0.713321984, 0.479655027,
        -1.74106801, -0.784139991, 0.409986019,
        -1.68519294, -0.684099019, 0.281729996,
        -1.53238201, -0.75029701, 0.312476993,
        -1.38626099, -0.691608012, 0.39782998,
        -1.23242402, -0.626543999, 0.350561976,
        -0.984633029, -0.729294002, 0.422345996,
        -0.803033948, -0.698390961, 0.395739019,
        -0.638180971, -0.654263973, 0.405090004,
        -0.529304981, -0.782058001, 0.424281001,
        -0.45362401, -0.63933301, 0.425898015,
        -0.285135001, -0.66751802, 0.389360994,
        -0.120089993, -0.726059973, 0.339549005,
        -0.0167820007, -0.670151949, 0.455282986,
        0.144336, -0.603479981, 0.418335021,
        0.36314401, -0.674763024, 0.374889016,
        0.511586964, -0.711815953, 0.437390983,
        0.658865988, -0.71323204, 0.329246998,
        0.824990988, -0.719516993, 0.296483994,
        1.031214, -0.703215003, 0.328967988,
        1.18266904, -0.648576021, 0.375225008,
        1.35609007, -0.710018992, 0.321650982,
        1.52098203, -0.748059034, 0.381660014,
        1.64285398, -0.707639992, 0.508112967,
        1.69102192, -0.720264018, 0.348975003,
        1.82994604, -0.640380025, 0.297470987,
        2.03684711, -0.535529971, 0.343328983,
        -2.57318711, -0.52068603, 0.387710989,
        -2.40279603, -0.538980007, 0.345818996,
        -2.26735187, -0.647493005, 0.304248005,
        -2.08605599, -0.542469025, 0.368741989,
        -1.91711402, -0.563336968, 0.371075988,
        -1.76703608, -0.616766989, 0.407958001,
        -1.62565207, -0.545189977, 0.358254015,
        -1.465011, -0.593201995, 0.293931007,
        -1.34733903, -0.524675965, 0.409635007,
        -1.2211709, -0.435911983, 0.365321994,
        -1.08204901, -0.529980004, 0.37854901,
        -0.92477107, -0.584316015, 0.378933012,
        -0.776135981, -0.535337985, 0.450282007,
        -0.652893007, -0.497195989, 0.344063997,
        -0.479444981, -0.482318997, 0.374981999,
        -0.308721006, -0.506525993, 0.436070979,
        -0.151346996, -0.569094002, 0.400572002,
        0.00336900027, -0.507165015, 0.427466989,
        0.150281996, -0.440972984, 0.422307014,
        0.30081898, -0.521721005, 0.395208001,
        0.467243969, -0.539390981, 0.351236999,
        0.609848976, -0.578754008, 0.427320004,
        0.768939018, -0.627084017, 0.426243007,
        0.901811957, -0.575213969, 0.332514018,
        1.05472207, -0.542373002, 0.391403973,
        1.30437303, -0.535122037, 0.388716012,
        1.45932293, -0.594173968, 0.384219021,
        1.605582, -0.576384008, 0.304253995,
        1.74160194, -0.503564954, 0.377603978,
        1.88027394, -0.471986979, 0.290376008,
        -2.52088213, -0.35541901, 0.351969004,
        -2.35287905, -0.375611991, 0.326759994,
        -2.23045802, -0.482345998, 0.292311013,
        -2.12880301, -0.375432014, 0.381695986,
        -1.96564794, -0.405636013, 0.346373975,
        -1.78195202, -0.463223994, 0.346883982,
        -1.63355708, -0.38301599, 0.333213001,
        -1.47400498, -0.429242969, 0.362075984,
        -1.33924794, -0.318948001, 0.313701004,
        -1.21487999, -0.27917999, 0.437471986,
        -1.10393405, -0.33050099, 0.319425017,
        -0.939648032, -0.431766003, 0.434139013,
        -0.804714024, -0.355917007, 0.37055099,
        -0.644243956, -0.321662992, 0.359369993,
        -0.482255995, -0.31447801, 0.338885993,
        -0.324903011, -0.359237999, 0.35867399,
        -0.103242002, -0.309822023, 0.338927984,
        0.053247001, -0.358211994, 0.320325017,
        0.195654005, -0.274542004, 0.350648999,
        0.291963011, -0.363884985, 0.453428984,
        0.450231016, -0.382646978, 0.405474007,
        0.606872976, -0.418484986, 0.363245994,
        0.769965053, -0.468273014, 0.363654017,
        0.94462198, -0.414789021, 0.374357998,
        1.17392099, -0.424578011, 0.378834009,
        1.32505202, -0.369165003, 0.33107999,
        1.48403394, -0.430515021, 0.339125991,
        1.64217603, -0.376035035, 0.436394989,
        1.78136408, -0.331671, 0.327156007,
        1.98099899, -0.372065991, 0.389075994,
        -2.41875911, -0.216948003, 0.368925005,
        -2.25025201, -0.260565013, 0.388094991,
        -2.13223219, -0.139766991, 0.402260989,
        -2.00443792, -0.243230999, 0.366653979,
        -1.82182503, -0.299571007, 0.312857985,
        -1.66226399, -0.221729994, 0.333425999,
        -1.52450395, -0.281064004, 0.414914966,
        -1.38523197, -0.190611005, 0.409644008,
        -1.24298692, -0.167913005, 0.316824019,
        -1.10644794, -0.140652001, 0.448994994,
        -0.983045936, -0.26463002, 0.428457022,
        -0.782886028, -0.18824999, 0.43107003,
        -0.570369005, -0.167535007, 0.356727004,
        -0.39842999, -0.176075995, 0.364079982,
        -0.237654001, -0.22190401, 0.350349009,
        -0.121719003, -0.207267016, 0.468098998,
        0.0298289992, -0.212996989, 0.397794008,
        0.243446991, -0.154670998, 0.464156985,
        0.39756301, -0.212241009, 0.408069015,
        0.585870028, -0.247644007, 0.385751992,
        0.750743985, -0.294483006, 0.347954988,
        0.916391969, -0.267401993, 0.297324002,
        1.05691504, -0.169826999, 0.290948987,
        1.19523907, -0.243768007, 0.359622002,
        1.29572701, -0.104616001, 0.381641984,
        1.41543007, -0.222887993, 0.325892985,
        1.58904898, -0.261045009, 0.321123004,
        1.73315692, -0.162303001, 0.360230982,
        1.90269589, -0.208460987, 0.372467995,
        -2.4939661, -0.0576390028, 0.381795019,
        -2.28754807, -0.103589997, 0.349521011,
        -2.14814997, 0.00837600045, 0.314756989,
        -1.98887992, -0.0523139983, 0.362612993,
        -1.842906, -0.135642007, 0.366717011,
        -1.67939091, -0.0593039989, 0.372783005,
        -1.52254808, -0.113303997, 0.332571,
        -1.39094996, -0.0129690003, 0.370284021,
        -1.22751904, 0.0159570016, 0.328736991,
        -0.999417007, -0.0226649996, 0.51709795,
        -0.91110599, -0.0851580054, 0.387863994,
        -0.720534027, -0.0259709992, 0.409605026,
        -0.549789011, -0.0347819999, 0.456210017,
        -0.436803013, -0.00544199999, 0.33910799,
        -0.279855013, -0.0653039962, 0.333222002,
        -0.0488549992, -0.0627599955, 0.412709981,
        0.124910995, -0.0796470046, 0.371558994,
        0.229499996, 0.0290369987, 0.297231019,
        0.347375989, -0.0491459966, 0.378762007,
        0.50612402, -0.0844769999, 0.359007001,
        0.668973029, -0.0989910066, 0.340562999,
        0.832706988, -0.124439999, 0.343704015,
        0.981690049, -0.102458999, 0.423317969,
        1.14480591, -0.0218940005, 0.351422995,
        1.28665507, 0.0650940016, 0.429932982,
        1.44643795, -0.0506789982, 0.316307992,
        1.61206198, -0.0268980004, 0.347558975,
        1.76446795, -0.00174600002, 0.421097994,
        -2.6047709, 0.0754979998, 0.338021994,
        -2.4333961, 0.118371002, 0.357264012,
        -2.25813293, 0.129617989, 0.38150999,
        -2.11466408, 0.167108998, 0.275393993,
        -1.96401, 0.116856001, 0.337632,
        -1.81901693, 0.0313259996, 0.363351017,
        -1.68021905, 0.100653, 0.431730032,
        -1.56854403, 0.0586289987, 0.312342018,
        -1.31311798, 0.144719988, 0.394892991,
        -1.14379203, 0.165188998, 0.354170978,
        -1.06732798, 0.00528899999, 0.36967501,
        -0.829557002, 0.0382619984, 0.288416982,
        -0.685712993, 0.125493005, 0.334935009,
        -0.58919704, 0.129381001, 0.479193002,
        -0.518141985, 0.149540991, 0.319788009,
        -0.348432004, 0.151932001, 0.28452,
        -0.191432983, 0.0749609992, 0.317405999,
        0.0412710011, 0.0708869994, 0.373751998,
        0.173510998, 0.161106005, 0.377256006,
        0.39370501, 0.0904380009, 0.290513992,
        0.555696011, 0.0823950022, 0.326795995,
        0.719969988, 0.0560759977, 0.388871968,
        0.890537977, 0.0418020003, 0.402243018,
        0.989489973, 0.148085997, 0.316854,
        1.13520598, 0.145265996, 0.406064987,
        1.30388701, 0.183981001, 0.304917008,
        1.45597506, 0.112542003, 0.401768982,
        -2.08638906, 1.28894103, -0.864369035,
        1.65532804, 0.143295005, 0.440984964,
        -1.90190399, 1.29424202, -0.845052004,
        -1.71854997, 1.26599097, -0.801977992,
        -2.56397104, 0.234443992, 0.401567996,
        -2.39043593, 0.272255987, 0.420533985,
        -2.22318292, 0.296765983, 0.379301995,
        -2.04917693, 0.30142799, 0.352187991,
        -1.90835094, 0.285605997, 0.262977004,
        -1.80235791, 0.200268, 0.362406015,
        -1.64301586, 0.258809984, 0.386016011,
        -1.46554804, 0.237116992, 0.377912998,
        -1.26123595, 0.266687989, 0.289517999,
        -1.02536392, 0.292773008, 0.355976999,
        -0.97162199, 0.136056006, 0.321707994,
        -0.827820003, 0.227771997, 0.330953985,
        -0.738339007, 0.214370996, 0.468246013,
        -0.563961029, 0.294492006, 0.420554996,
        -0.41685003, 0.205094993, 0.444995999,
        -0.249045014, 0.20914501, 0.416355014,
        -1.84743595, 1.46825707, -0.820443034,
        -0.149582997, 0.256263018, 0.287061006,
        -1.65764701, 1.43989193, -0.832880974,
        0.0208739992, 0.245394006, 0.304427981,
        0.189938992, 0.323421001, 0.454068005,
        0.321668983, 0.226925999, 0.362438977,
        0.472034991, 0.283683002, 0.308694005,
        0.660192013, 0.217511997, 0.365226001,
        0.822134972, 0.199802995, 0.417015016,
        0.954551935, 0.302994013, 0.38717103,
        1.218279, 0.293637007, 0.404273987,
        1.39920592, 0.324464977, 0.347211003,
        1.55028605, 0.23793, 0.324809998,
        -2.61996603, 0.365465999, 0.299145013,
        -2.45740509, 0.414018005, 0.336075008,
        -2.29305315, 0.444957018, 0.313749015,
        -2.13355803, 0.441920996, 0.357111007,
        -1.992522, 0.442562997, 0.45155102,
        -1.85511303, 0.36699599, 0.400967985,
        -1.69990802, 0.429068983, 0.400647014,
        -1.54657495, 0.389258981, 0.35066101,
        -1.36884594, 0.377732992, 0.366822004,
        -1.19651401, 0.361211985, 0.410567999,
        -1.04535294, 0.452268004, 0.419261992,
        -0.886572003, 0.386057973, 0.37112999,
        -2.01530981, 1.56127203, -0.925886989,
        -0.717002988, 0.363896996, 0.391830027,
        -1.76822114, 1.64389801, -0.853421926,
        -0.539790034, 0.465705037, 0.362109005,
        -0.410279989, 0.380007029, 0.432198018,
        -0.25782299, 0.365240991, 0.367578,
        -0.0963390023, 0.388736963, 0.418128014,
        0.0708450004, 0.409970999, 0.366020977,
        0.214754999, 0.485330999, 0.421595991,
        0.350714982, 0.416945994, 0.336915016,
        0.497454017, 0.487131, 0.379220992,
        0.615101993, 0.376403987, 0.316955984,
        0.782909989, 0.33138001, 0.300480008,
        0.924893975, 0.437567979, 0.290796012,
        1.09971595, 0.414497972, 0.371546984,
        1.27646101, 0.454227, 0.385464013,
        -2.55377388, 0.549951017, 0.391281009,
        -2.41114807, 0.570858002, 0.271952987,
        -2.24273682, 0.612024009, 0.27768299,
        -2.15275788, 0.597914994, 0.415961981,
        -1.99772394, 0.615897, 0.484130979,
        -1.84857595, 0.536630988, 0.427569032,
        -1.68343496, 0.59691602, 0.417039037,
        -1.55552101, 0.546263993, 0.288864017,
        -1.36529398, 0.536222994, 0.294699013,
        -1.19183695, 0.527031004, 0.334412992,
        -2.09070015, 1.72603488, -0.889217973,
        -0.997601986, 0.576224983, 0.306635976,
        -1.91248488, 1.75452304, -0.850553989,
        -0.833778024, 0.54916203, 0.367217988,
        -1.73575211, 1.83055794, -0.833052039,
        -0.190953016, 0.520601988, 0.342168003,
        -0.018096, 0.551679015, 0.324234009,
        0.157712996, 0.597236991, 0.305813998,
        0.331286997, 0.592392027, 0.335276991,
        0.503063977, 0.649667978, 0.318750024,
        0.680109024, 0.654704988, 0.323493004,
        0.806192994, 0.53342104, 0.367641002,
        1.03578591, 0.568379998, 0.314247012,
        -2.65954781, 0.67967701, 0.456353992,
        -2.45436621, 0.700313985, 0.374715,
        -2.281986, 0.733497024, 0.399738014,
        -2.03900719, 0.718127966, 0.33732301,
        -1.87601101, 0.646347046, 0.292116016,
        -1.71730506, 0.71588999, 0.304868996,
        -1.553352, 0.699105024, 0.368144989,
        -1.38824105, 0.670140028, 0.392897964,
        -2.17476892, 1.91435409, -0.876744032,
        -1.27768803, 0.689247012, 0.259979993,
        -1.98755097, 1.91867685, -0.877979994,
        -1.12120509, 0.701514006, 0.354135007,
        -2.56269002, 0.839717984, 0.355848014,
        -2.38250709, 0.865089059, 0.344837993,
        -2.15806198, 0.84108901, 0.347378999,
        -2.01572108, 0.921090007, 0.390086979,
        -1.897995, 0.813539982, 0.329201996,
        -1.74960601, 0.881906986, 0.29786998,
        -1.59612894, 0.863958001, 0.365961015,
        -1.42575598, 0.826083004, 0.324986994,
        -1.23872101, 0.834821999, 0.350741982,
        -2.49081302, 1.00241697, 0.362924993,
        -2.24919891, 0.968873978, 0.291107982,
        -2.08366489, 1.01786995, 0.271506011,
        -1.87355995, 0.99296701, 0.333093017,
        -1.70946002, 1.03952098, 0.344067007,
        -1.54427099, 1.02495003, 0.342837006,
        -1.38339901, 1.04897702, 0.354653984,
        -1.22740507, 1.00594199, 0.308882982,
        -2.45572519, 1.21177197, 0.347831994,
        -2.305197, 1.122558, 0.338117987,
        -2.13744593, 1.16837406, 0.335855991,
        -1.97044492, 1.13266802, 0.351830989,
        -1.807374, 1.17388499, 0.305792987,
        -1.61553597, 1.181265, 0.333846003,
        -1.44513607, 1.19649601, 0.303837001,
        -1.27038896, 1.18069196, 0.316664994,
        -1.09227002, 1.15625405, 0.302030981,
        0.137912989, 2.32906795, -0.889841974,
        -2.40546894, 1.377684, 0.380328,
        -2.25913191, 1.27428293, 0.397103995,
        -2.10289812, 1.33610702, 0.339312017,
        -1.93514109, 1.29158998, 0.280023009,
        -1.68799496, 1.32057905, 0.274416,
        -1.51727092, 1.34537399, 0.331887007,
        -1.44274199, 1.48535705, 0.26642102,
        -1.20116091, 1.34911501, 0.312116981,
        -1.04592896, 1.32275701, 0.398247004,
        -2.23613405, 1.44038999, 0.382220984,
        -2.07354593, 1.49478304, 0.413793027,
        -1.93772399, 1.46932793, 0.304778993,
        -1.77900887, 1.49205899, 0.403727978,
        -1.60819495, 1.49214303, 0.354108006,
        -1.41628194, 1.63080001, 0.364253998,
        -1.27541709, 1.52423108, 0.311838001,
        -1.01762998, 1.50082207, 0.372285008,
        -0.905790031, 1.38042307, 0.302598,
        -1.24112093, 1.69095302, 0.380807996,
        -1.04211307, 1.67986202, 0.353505015,
        -1.01295304, -2.63730597, -0.740477979,
        -0.881253004, -2.73906898, -0.685314,
        -0.748263001, -2.66162086, -0.761004031,
        -0.605973005, -2.74039507, -0.679986,
        -0.431217015, -2.74097991, -0.740900993,
        -0.232374012, -2.74103093, -0.741788983,
        -0.0556860007, -2.74059296, -0.714993,
        0.107238002, -2.67634797, -0.752813995,
        0.257912993, -2.72137499, -0.667029023,
        -0.923570991, -2.48555708, -0.743252993,
        -0.751524031, -2.48607612, -0.763787985,
        -0.594114006, -2.59792209, -0.77876097,
        -0.327197999, -2.60299206, -0.700130999,
        -0.225483, -2.47021794, -0.730701029,
        -0.0668729991, -2.58658504, -0.808809042,
        0.0858329982, -2.50306201, -0.782240987,
        0.252054006, -2.56714797, -0.755568027,
        0.41415602, -2.64802504, -0.724842012,
        0.566165984, -2.55228901, -0.726072013,
        0.740565002, -2.58086109, -0.690060019,
        -0.761114955, -2.31540298, -0.741108,
        -0.593855977, -2.43158388, -0.707499027,
        -0.43107599, -2.46970797, -0.737360954,
        -0.312801003, -2.32533002, -0.722217023,
        -0.100778997, -2.39791512, -0.826461017,
        0.0775739998, -2.33355594, -0.85144496,
        0.222914994, -2.39416504, -0.777027011,
        0.40168798, -2.47524905, -0.750705004,
        0.526920021, -2.3562901, -0.774174035,
        0.676892996, -2.41542292, -0.715721965,
        0.841305017, -2.36322594, -0.730637968,
        1.05174005, -2.3496089, -0.700358987,
        -0.593594968, -2.25755095, -0.741648018,
        -0.45272398, -2.31756306, -0.828198016,
        -0.366384, -2.16747308, -0.768144011,
        -0.151407003, -2.17767906, -0.713387966,
        -0.0184199996, -2.28786612, -0.712437034,
        0.177002996, -2.23083019, -0.750999033,
        0.360800982, -2.30872798, -0.720510006,
        0.486669004, -2.18350196, -0.75624299,
        0.640604973, -2.244771, -0.713522971,
        0.882239938, -2.19822311, -0.705765009,
        1.03334701, -2.18029499, -0.771926999,
        -0.466926008, -2.04132318, -0.71410799,
        -0.241218001, -2.04092407, -0.773985028,
        -0.0709439963, -2.03492713, -0.743669987,
        0.0364740007, -2.14821887, -0.792330027,
        0.195245996, -2.11666512, -0.624144018,
        0.321272999, -2.14130998, -0.739515007,
        0.44679898, -2.03340006, -0.709827006,
        0.613278031, -2.07046795, -0.74615705,
        0.83930397, -2.00638485, -0.739656031,
        0.979725003, -2.06105995, -0.657804012,
        1.18161905, -2.18422794, -0.676073968,
        1.27945197, -2.05575609, -0.74258399,
        -0.470589012, -1.87002003, -0.753663003,
        -0.265869021, -1.85857809, -0.808488011,
        -0.0100739999, -1.88294101, -0.699692965,
        0.0939750075, -2.01401997, -0.705986977,
        0.261561006, -1.98305988, -0.701514006,
        0.365571022, -1.950804, -0.831602991,
        0.537495017, -1.93262708, -0.803508043,
        0.706470013, -1.91922891, -0.790886998,
        0.822345018, -1.84546208, -0.684321046,
        0.971340001, -1.90326595, -0.731442034,
        1.12157094, -1.98705006, -0.712283969,
        1.24971604, -1.88895893, -0.784538984,
        -0.396920979, -1.72649097, -0.717285037,
        -0.252674997, -1.69586396, -0.794898033,
        -0.0996000022, -1.74735296, -0.748659015,
        0.0548100024, -1.72411501, -0.687866986,
        0.139109999, -1.86140406, -0.751304984,
        0.291602999, -1.82395506, -0.746721029,
        0.499523997, -1.72893298, -0.752300978,
        0.685295999, -1.74025488, -0.70638597,
        0.829622984, -1.71688509, -0.789359987,
        0.98498404, -1.74138594, -0.722391009,
        1.09664404, -1.81906807, -0.834936023,
        1.32647407, -1.74345899, -0.72536701,
        -0.551643014, -1.63607097, -0.763460994,
        -0.450587988, -1.60697699, -0.623330951,
        -0.297371984, -1.56670213, -0.682038009,
        -0.141726002, -1.580652, -0.770019054,
        0.0299249999, -1.58911192, -0.78053093,
        0.222764999, -1.59047699, -0.722217023,
        0.402186036, -1.55263186, -0.70788902,
        0.567095995, -1.58067298, -0.712055981,
        0.704271019, -1.60037398, -0.612564027,
        0.780117035, -1.56204009, -0.830765963,
        0.944451034, -1.59068406, -0.778428018,
        1.10267401, -1.62017107, -0.714150012,
        1.25459099, -1.60070109, -0.808032036,
        -0.632547021, -1.46625006, -0.639762044,
        -0.469172984, -1.48532104, -0.737480998,
        -0.318735003, -1.40983796, -0.729701996,
        -0.175512001, -1.32567, -0.748263001,
        -1.90393496, -2.67604494, 0.546434999,
        -0.0476819985, -1.43807697, -0.768336058,
        -1.73540688, -2.72415614, 0.526961982,
        0.127565995, -1.45709705, -0.755553007,
        -1.56397498, -2.73857403, 0.502952993,
        0.316799998, -1.41097808, -0.741285026,
        -1.39927197, -2.742522, 0.456161976,
        0.510173976, -1.42292404, -0.754568934,
        0.675894022, -1.45640993, -0.700286984,
        0.893052042, -1.43434203, -0.817220986,
        1.05608702, -1.46700597, -0.76572901,
        -0.681854963, -2.73957896, 0.543923974,
        1.20230103, -1.49113202, -0.673898995,
        -0.541776001, -2.65627193, 0.480584979,
        1.34794796, -1.45116603, -0.753219008,
        0.486684024, -2.68934703, 0.526661992,
        0.669927001, -2.71489811, 0.506669998,
        0.836475015, -2.69917798, 0.548694015,
        1.04291701, -2.68434286, 0.517359018,
        1.403736, -2.71058393, 0.528795004,
        -0.676755011, -1.29658198, -0.679605007,
        -0.513890982, -1.35044396, -0.654069006,
        -0.379877985, -1.26353097, -0.68801105,
        -0.26167199, -1.18038297, -0.752874017,
        -0.0127980001, -1.27676702, -0.758103013,
        0.120992996, -1.31743503, -0.653615952,
        0.427655995, -1.312047, -0.647840977,
        0.631191015, -1.31400895, -0.628893018,
        0.801408052, -1.346946, -0.706157982,
        -1.82373595, -2.51514602, 0.55803597,
        0.87133801, -1.22033691, -0.799524069,
        -1.67019296, -2.56384206, 0.494108975,
        0.988487959, -1.32085502, -0.731085002,
        -1.51401901, -2.59869909, 0.430131018,
        1.17914999, -1.32262802, -0.717756033,
        -1.3743329, -2.56618214, 0.505113006,
        1.34970903, -1.27646399, -0.752390981,
        -1.23701394, -2.52795315, 0.584562004,
        -1.00485301, -2.66136885, 0.512210965,
        -0.831620932, -2.65875602, 0.512300968,
        -0.695456982, -2.57471704, 0.450017989,
        -0.573516011, -2.51661611, 0.571488023,
        -0.393081009, -2.58226514, 0.524300992,
        -0.224594995, -2.57933092, 0.46103999,
        -0.0706200004, -2.57902193, 0.540566981,
        0.0946860015, -2.57777691, 0.485955,
        0.268427998, -2.5581212, 0.510254979,
        0.40200001, -2.572716, 0.622200012,
        0.509661019, -2.44943404, 0.576848984,
        0.679641008, -2.46618605, 0.506271005,
        0.798915029, -2.56255794, 0.447212994,
        0.991434038, -2.53265715, 0.430253983,
        1.22017801, -2.65519786, 0.521441996,
        1.34848797, -2.56929302, 0.435018003,
        1.50893998, -2.53322101, 0.379106998,
        1.60561502, -2.67639899, 0.422679007,
        1.71311998, -2.55552602, 0.494582981,
        1.89431095, -2.55671692, 0.498474002,
        -0.684527993, -1.13088608, -0.721940994,
        -0.532931983, -1.19514894, -0.700565994,
        -0.400385976, -1.10085893, -0.733736992,
        -0.0305819996, -1.10934293, -0.807950974,
        0.113306999, -1.1654551, -0.744315028,
        0.269939989, -1.25224805, -0.700139999,
        0.412632018, -1.14300609, -0.698208034,
        0.575120986, -1.17179394, -0.694319963,
        0.743478, -1.19508004, -0.682716012,
        0.900521994, -1.22466302, -0.627009034,
        -1.70079613, -2.38625407, 0.547854006,
        1.02272999, -1.14756894, -0.775326014,
        -1.55457294, -2.43510914, 0.471252024,
        1.22035801, -1.16099107, -0.806277037,
        -1.39669502, -2.40274811, 0.43107599,
        1.37498999, -1.10132098, -0.722882986,
        -1.25759399, -2.34865808, 0.506352007,
        -1.08539391, -2.48294091, 0.517526984,
        -0.938484013, -2.36387992, 0.504191995,
        -0.766377032, -2.4351778, 0.526641011,
        -0.611531973, -2.34980702, 0.549116969,
        -0.440003991, -2.416677, 0.559028983,
        -0.281522989, -2.41210794, 0.498338997,
        -0.0980099961, -2.4168601, 0.482261986,
        0.0785160065, -2.35966206, 0.536247015,
        0.246219009, -2.37124801, 0.556469977,
        0.382499993, -2.432019, 0.467999995,
        0.606173992, -2.31738615, 0.563228965,
        0.77313602, -2.35159206, 0.598076999,
        0.889701009, -2.44644308, 0.532374024,
        1.03969193, -2.36906099, 0.49040103,
        1.15505695, -2.50529695, 0.46726799,
        1.29962993, -2.43280792, 0.527024984,
        1.43552995, -2.3966341, 0.441354007,
        1.59582901, -2.42309713, 0.485121012,
        1.74688196, -2.36090708, 0.536435962,
        1.96146905, -2.37248397, 0.413670003,
        2.05773592, -2.47535706, 0.527445018,
        2.21481609, -2.39105701, 0.490586996,
        -0.706844985, -0.965312958, -0.698921978,
        -0.548192978, -1.01917493, -0.733206034,
        -0.328116, -0.953622043, -0.748314023,
        -0.166512012, -1.03019404, -0.754008055,
        -0.0225419998, -0.89388001, -0.719460011,
        0.107900999, -0.997386038, -0.761034012,
        0.253484994, -1.08513904, -0.70936501,
        0.40585801, -0.990678012, -0.625593007,
        0.537714005, -0.998394012, -0.743649006,
        0.68266499, -1.08587706, -0.790629029,
        0.868353009, -1.075284, -0.696756005,
        -1.448874, -2.27406907, 0.545073032,
        0.981788993, -0.977004051, -0.771144032,
        -1.21533906, -2.19120598, 0.465413988,
        1.139853, -1.00249791, -0.838595986,
        -1.08899701, -2.28636599, 0.53074801,
        1.29599404, -0.944081962, -0.753597021,
        -1.05730796, -2.21517301, 0.378812969,
        -0.759624004, -2.26274991, 0.525258005,
        -0.51146698, -2.21360397, 0.569948971,
        -0.355374008, -2.23436689, 0.496562988,
        -0.232889995, -2.27091908, 0.608514011,
        -0.0639719963, -2.26850414, 0.566850007,
        0.0780089945, -2.18702102, 0.49604702,
        0.298026025, -2.2186799, 0.628082991,
        0.442218006, -2.28846884, 0.55597198,
        0.565491021, -2.16664195, 0.510260999,
        0.72894001, -2.19647408, 0.553934991,
        0.869268, -2.27698803, 0.477591008,
        1.01854503, -2.19936609, 0.511274993,
        1.17824101, -2.26487994, 0.469329,
        1.34548497, -2.26489496, 0.510930002,
        -0.647081971, -0.813839972, -0.727955997,
        1.51638603, -2.28111315, 0.533228993,
        -0.484625995, -0.858701944, -0.711210012,
        1.66577387, -2.22372603, 0.594348013,
        -0.330060005, -0.789765, -0.694812,
        1.80305994, -2.21402693, 0.463214993,
        -0.186785996, -0.868310988, -0.73161,
        1.96801209, -2.22584391, 0.502443016,
        -0.0325950012, -0.726368964, -0.671942949,
        2.10585904, -2.28969288, 0.575429976,
        0.112851009, -0.833817005, -0.641106009,
        2.20899916, -2.1830039, 0.493716002,
        0.250598997, -0.923895001, -0.67525202,
        2.35237789, -2.28052187, 0.490680009,
        0.386346012, -0.81793201, -0.669533968,
        0.530541003, -0.827777982, -0.756849051,
        0.672636032, -0.900032997, -0.699531019,
        0.841322958, -0.897273064, -0.680348992,
        0.98261404, -0.814550996, -0.723060012,
        1.15018499, -0.806100011, -0.777045012,
        1.29748499, -0.774726033, -0.689957976,
        -1.35638702, -2.123523, 0.534048021,
        -1.20921898, -2.0211091, 0.470586002,
        -1.09758604, -2.11677599, 0.561837018,
        -0.993927002, -2.06883597, 0.443612993,
        -0.898422003, -2.20581293, 0.449858963,
        -0.662369967, -2.06420994, 0.525618017,
        -0.380424023, -2.09626794, 0.595229983,
        -0.217878014, -2.12133908, 0.541935027,
        -0.0514350012, -2.09972692, 0.565874994,
        0.113717996, -2.05986309, 0.597087026,
        0.273674995, -2.04770398, 0.620489955,
        0.414039016, -2.11464882, 0.558954,
        -0.701252997, -0.653649032, -0.697623014,
        0.52064997, -2.013978, 0.463203013,
        -0.531446993, -0.679650009, -0.725754023,
        0.694136977, -2.0340991, 0.496986032,
        -0.369531006, -0.642476976, -0.767126977,
        0.86540097, -2.10858011, 0.511407018,
        -0.184181988, -0.670862973, -0.729341984,
        1.01602805, -2.03032494, 0.556025982,
        -0.0902759954, -0.552504003, -0.646583974,
        1.15920901, -2.12100005, 0.564992964,
        0.107300997, -0.640937984, -0.679206014,
        1.34747696, -2.11239886, 0.582441032,
        0.24030599, -0.745115995, -0.705986977,
        1.51288199, -2.14312506, 0.626492977,
        0.313760996, -0.591933012, -0.709457994,
        1.63773298, -2.09561396, 0.491370022,
        0.464702994, -0.65775001, -0.667493999,
        1.79784608, -2.03927708, 0.470798969,
        0.677724004, -0.687618017, -0.767883003,
        1.91189098, -2.0891459, 0.573498011,
        0.837494969, -0.721565962, -0.705867052,
        2.07653403, -2.07214499, 0.52511698,
        1.053141, -0.663468003, -0.745424986,
        2.24008203, -2.02898693, 0.562952995,
        1.21379709, -0.621882021, -0.670143008,
        2.36930704, -2.13420296, 0.580572009,
        2.52216601, -2.0730238, 0.532658994,
        -1.352754, -1.94753408, 0.530529022,
        -1.15400398, -1.89537001, 0.571364999,
        -1.00887299, -1.90153205, 0.487167001,
        -0.829568982, -2.0501821, 0.494427025,
        -0.721017003, -1.90361702, 0.505809009,
        -0.572214007, -1.87821007, 0.595952988,
        -0.439947009, -1.94935203, 0.523820996,
        -0.278346002, -1.94818187, 0.529247999,
        -0.122802004, -1.95183015, 0.586503029,
        0.0437400006, -1.90162802, 0.594296992,
        0.186365992, -1.93383908, 0.508674026,
        -0.425559014, -0.491916001, -0.699980974,
        0.354386985, -1.96146297, 0.500835001,
        -0.253857017, -0.521100044, -0.718644023,
        0.51830399, -1.87958694, 0.568533003,
        -0.133535996, -0.391833007, -0.697826982,
        0.682005048, -1.869138, 0.526670992,
        0.0556170009, -0.499673992, -0.757916987,
        0.834074974, -1.94685292, 0.542271018,
        0.222332999, -0.475055993, -0.795854926,
        1.00165796, -1.87757707, 0.621206999,
        0.498627007, -0.472802997, -0.749472022,
        1.215114, -1.96257901, 0.567140996,
        0.611970007, -0.57408905, -0.664583981,
        1.36756206, -1.98273897, 0.467526019,
        0.752457023, -0.524985015, -0.750351012,
        1.5220201, -1.98704386, 0.549845994,
        0.918972015, -0.552215993, -0.719573975,
        1.68745494, -1.94331908, 0.567413986,
        1.800951, -1.87226391, 0.447506994,
        1.95550513, -1.93918204, 0.509196043,
        2.11893606, -1.91010296, 0.561155975,
        2.24663401, -1.91543102, 0.438345015,
        2.392869, -1.95833695, 0.596837997,
        2.57568908, -1.91490006, 0.478193998,
        -1.77782702, -1.822788, 0.511112988,
        -1.61778593, -1.87736702, 0.570297003,
        -1.46236503, -1.79240406, 0.586053014,
        -1.27661395, -1.79091287, 0.524654984,
        -1.12691402, -1.73000097, 0.615408003,
        -0.967667937, -1.76063097, 0.577077031,
        -0.865218043, -1.89392102, 0.574293017,
        -0.665055037, -1.748667, 0.514487982,
        -0.540140986, -1.71220803, 0.616914034,
        -0.304071009, -0.359094024, -0.698159993,
        -0.39189899, -1.8062191, 0.589847982,
        0.0308279991, -0.346415997, -0.692646027,
        -0.211638004, -1.74021602, 0.558333039,
        0.201242983, -0.335795999, -0.680544019,
        -0.0726509988, -1.81455302, 0.508929014,
        0.0729719996, -1.81986594, 0.440952003,
        0.195885003, -1.765347, 0.540090024,
        0.360350996, -1.78998005, 0.521342993,
        0.575999975, -1.755162, 0.468392998,
        0.762609005, -1.73270702, 0.473865032,
        0.918359995, -1.82639694, 0.470004022,
        1.04381096, -1.73317802, 0.54202199,
        1.18846202, -1.75816488, 0.44590801,
        1.31861401, -1.84728289, 0.375443995,
        1.48146892, -1.84501505, 0.471855015,
        1.63252211, -1.78961396, 0.53313601,
        1.79500198, -1.77328205, 0.583734035,
        1.95796502, -1.78706098, 0.438735008,
        2.10996294, -1.74801302, 0.517760992,
        2.26592684, -1.81181097, 0.585842967,
        2.43575406, -1.80542707, 0.522246003,
        2.6084671, -1.75760102, 0.560465991,
        -1.93521309, -1.74831891, 0.510051012,
        -1.78616095, -1.66109705, 0.452336967,
        -1.67302799, -1.70785499, 0.578664005,
        -1.38436794, -1.66587603, 0.509477973,
        -1.26669896, -1.64120698, 0.624831021,
        -1.09551299, -1.56719708, 0.565376997,
        -0.942039013, -1.60174489, 0.624441028,
        -0.800082028, -1.68220186, 0.587162971,
        -0.662267983, -1.58268607, 0.542798996,
        -0.478895992, -1.60340405, 0.509003997,
        -0.341504991, -1.66017008, 0.641144991,
        -0.23467201, -1.57240498, 0.533223033,
        -0.0863789991, -1.64843094, 0.476990998,
        0.0425430015, -1.72495794, 0.58536005,
        0.298788011, -1.629498, 0.518139005,
        0.439476013, -1.66228795, 0.432503998,
        0.58979398, -1.61098504, 0.558012009,
        0.763517976, -1.60619998, 0.58029002,
        0.88825196, -1.72318196, 0.591302991,
        0.986745, -1.58075094, 0.601350009,
        1.14363301, -1.63679385, 0.638291955,
        1.28069699, -1.67010891, 0.547230005,
        1.38972902, -1.7105701, 0.42723,
        1.59114313, -1.67838907, 0.655281007,
        1.73362505, -1.61232901, 0.580277979,
        1.89472198, -1.65371394, 0.517082989,
        2.0524919, -1.59106207, 0.563133001,
        2.22758412, -1.63255799, 0.561702013,
        2.34846592, -1.52141094, 0.50584197,
        2.47422886, -1.64061606, 0.525846004,
        -2.22093582, -1.48751104, 0.527502,
        -2.08733416, -1.60637403, 0.492330015,
        -1.91737199, -1.57480812, 0.512426972,
        -1.74722099, -1.5515039, 0.578258991,
        -1.57089901, -1.57461596, 0.601163983,
        -1.40713203, -1.51637697, 0.594354033,
        -1.24091101, -1.48322701, 0.58504498,
        -1.11197996, -1.39212894, 0.553173006,
        -0.981932998, -1.45809901, 0.460931987,
        -0.830004036, -1.517856, 0.524778008,
        -0.681711018, -1.41705596, 0.523142993,
        -0.513480008, -1.43494201, 0.523782015,
        -0.374514014, -1.50527692, 0.608358026,
        -0.21391499, -1.38039899, 0.495509982,
        0.00510900002, -1.50636005, 0.451359004,
        0.132090002, -1.61263514, 0.497141987,
        0.268866003, -1.46543694, 0.547446012,
        0.434568018, -1.52696991, 0.533900976,
        0.571205974, -1.43786097, 0.50612402,
        0.740630984, -1.45725894, 0.509546995,
        0.905898035, -1.45173597, 0.52899003,
        1.0721159, -1.44737399, 0.533078969,
        1.22319007, -1.51320314, 0.528591037,
        1.38567305, -1.534266, 0.531777024,
        1.57075787, -1.57399201, 0.524088025,
        1.62890697, -1.51375794, 0.669708014,
        1.75455594, -1.4436481, 0.576282024,
        1.91017199, -1.50433803, 0.58504796,
        2.128263, -1.44778502, 0.620616019,
        2.2661159, -1.34577894, 0.564327002,
        2.43914413, -1.37398207, 0.524084985,
        -1.74127793, 1.84951508, -1.94337595,
        2.57442307, -1.49284792, 0.533348978,
        -2.322402, -1.3420949, 0.529448986,
        -2.15655589, -1.27872598, 0.491762996,
        -1.97661602, -1.292817, 0.485903978,
        -1.86356091, -1.41847205, 0.568476021,
        -1.69762194, -1.25578797, 0.622101009,
        -1.53857398, -1.40539503, 0.603774011,
        -1.38648593, -1.36663198, 0.535353005,
        -1.24672198, -1.32477295, 0.634829998,
        -0.991548061, -1.290084, 0.536057949,
        -0.831458926, -1.34296501, 0.542132974,
        -0.687251985, -1.25210702, 0.595523953,
        -0.539888978, -1.26872694, 0.520269036,
        -0.381047964, -1.34404194, 0.561645031,
        -0.253322989, -1.24583101, 0.58949703,
        -0.0420629978, -1.34281504, 0.497628003,
        0.118601993, -1.39775097, 0.513264,
        0.241724998, -1.29186893, 0.585708022,
        0.396710992, -1.36113906, 0.534569979,
        0.501851976, -1.29050398, 0.431151032,
        0.665361047, -1.31103599, 0.450498015,
        0.824754, -1.32598209, 0.447731972,
        0.974169016, -1.296942, 0.493851006,
        1.20880198, -1.34923804, 0.541161001,
        1.37662804, -1.35899103, 0.500889003,
        -1.76433015, 2.08517408, -1.95682502,
        1.49557209, -1.43281794, 0.605601013,
        -1.61066985, 1.98039603, -1.97192395,
        1.63900495, -1.34447396, 0.634164035,
        1.83527708, -1.28893793, 0.587382019,
        1.990659, -1.36132801, 0.563871026,
        2.11854601, -1.28987396, 0.480722964,
        -2.430897, -1.20068395, 0.537621021,
        -2.2684741, -1.180686, 0.58711499,
        -2.12922287, -1.11410105, 0.525965989,
        -1.9777019, -1.14946496, 0.581694007,
        -1.83621597, -1.188519, 0.509132981,
        -1.60161602, -1.12202704, 0.563732982,
        -1.5113821, -1.25611806, 0.509289026,
        -1.32749093, -1.21500301, 0.52304697,
        -1.14895797, -1.224015, 0.548544049,
        -1.03422594, -1.17249298, 0.425565004,
        -0.941711962, -1.13666999, 0.574764013,
        -0.767612994, -1.11595798, 0.533289015,
        -0.603468001, -1.10524797, 0.485396981,
        -0.396840036, -1.18403101, 0.511322975,
        -0.257363975, -1.08642006, 0.541857004,
        -1.77127194, 2.27176499, -1.96751404,
        -0.112899005, -1.19150102, 0.524133027,
        0.0289740004, -1.10398495, 0.518454015,
        0.125579998, -1.23305106, 0.481025994,
        0.282122999, -1.17959404, 0.465503991,
        0.439446032, -1.13423097, 0.501900017,
        0.60197401, -1.16750097, 0.497604012,
        0.761948943, -1.19821799, 0.536069989,
        0.967010975, -1.12930501, 0.521964014,
        1.11324, -1.21088994, 0.516084015,
        1.27544701, -1.20836103, 0.485312998,
        1.51867795, -1.27736402, 0.546645045,
        1.66743898, -1.174389, 0.59454602,
        1.82253909, -1.12020004, 0.532323003,
        1.96662605, -1.19840693, 0.531572998,
        2.11376405, -1.12468505, 0.550098002,
        -2.42349601, -1.0312469, 0.575667024,
        -2.24394608, -1.01230502, 0.602424026,
        -2.01955509, -0.995049, 0.484932005,
        -1.857126, -1.01490307, 0.502494037,
        -1.69425011, -0.979470015, 0.511418998,
        -1.52674198, -0.960294008, 0.512597978,
        -1.45109105, -1.10414696, 0.494831979,
        -1.29488993, -1.06140602, 0.466721982,
        -1.13600397, -1.06365299, 0.503766,
        -1.03517401, -0.968726993, 0.592395008,
        -0.885393023, -1.005759, 0.483632982,
        -0.745884001, -0.942861021, 0.569213986,
        -0.587216973, -0.982779026, 0.618386984,
        -0.410333991, -1.010571, 0.576377988,
        -0.25513199, -0.951866984, 0.447645009,
        -0.107094005, -1.02618909, 0.587502003,
        0.0252630003, -0.943980038, 0.489785969,
        0.175577998, -0.989441991, 0.555660009,
        0.31508702, -0.992058039, 0.459318012,
        0.550292969, -1.00885499, 0.462969005,
        0.675470948, -1.04820001, 0.581579983,
        0.833889008, -1.02704096, 0.536822975,
        0.994046926, -0.961373985, 0.488099992,
        1.10293198, -1.05124807, 0.578613043,
        1.25317204, -1.04896796, 0.512685001,
        1.40678692, -1.05404401, 0.568413019,
        1.56727195, -1.00178099, 0.599307001,
        1.68641102, -1.03752303, 0.481043994,
        1.83803701, -0.971990943, 0.443040013,
        1.99198508, -1.01894093, 0.495779991,
        -2.57456994, -0.879624009, 0.561995983,
        -2.41845608, -0.863165975, 0.49336201,
        -2.25431395, -0.838937998, 0.505712986,
        -2.12283587, -0.890864968, 0.592598975,
        -1.95927608, -0.883704007, 0.593891978,
        -1.80413997, -0.854025006, 0.551900983,
        -1.64160597, -0.825743973, 0.542199016,
        -1.36499095, -0.917109013, 0.481578022,
        -1.26052201, -0.781584024, 0.452609986,
        -1.10662496, -0.83633399, 0.509420991,
        -0.944694042, -0.854622006, 0.517256975,
        -0.814007998, -0.789537013, 0.594089985,
        -0.666797996, -0.810108066, 0.506154001,
        -0.51767695, -0.837128997, 0.584102988,
        -0.372105002, -0.867449999, 0.659793019,
        -0.265704006, -0.785849929, 0.496902019,
        -0.117548995, -0.857240975, 0.458517015,
        -0.0355979986, -0.862218022, 0.608924985,
        0.0973529965, -0.779823065, 0.50287199,
        0.260822982, -0.834918022, 0.521403015,
        0.399294019, -0.837939024, 0.419910014,
        0.681335986, -0.906900048, 0.496941,
        0.857082009, -0.864402056, 0.487391979,
        1.041309, -0.797567964, 0.501569986,
        1.16308498, -0.908471942, 0.511826992,
        1.32862496, -0.90072602, 0.514692008,
        1.43165398, -0.909218967, 0.641811013,
        1.54978502, -0.784328938, 0.614178002,
        1.66836905, -0.879473984, 0.537999034,
        1.81526399, -0.803795993, 0.478799999,
        1.98308408, -0.843477011, 0.484005034,
        -2.6049931, -0.712670982, 0.609041989,
        -2.44362593, -0.711024046, 0.562563002,
        -2.27783704, -0.680727005, 0.556670964,
        -2.0411849, -0.746217012, 0.539982021,
        -1.90329885, -0.728409052, 0.642560959,
        -1.73691308, -0.679812014, 0.555611968,
        -1.60994387, -0.687165022, 0.449865013,
        -1.487571, -0.802968025, 0.465008974,
        -1.30013704, -0.638067007, 0.53344202,
        -1.13350201, -0.666905999, 0.47616601,
        -1.02042007, -0.717011988, 0.587858975,
        -0.883962035, -0.64258498, 0.533481002,
        -0.720654011, -0.66070503, 0.552468002,
        -0.559377015, -0.678945005, 0.557703018,
        -0.398148, -0.713178039, 0.57198298,
        -0.254355013, -0.619235992, 0.551001012,
        -0.122856006, -0.726657033, 0.567273021,
        0.0890190005, -0.60816896, 0.570477009,
        0.263265014, -0.665408969, 0.517289996,
        0.40852803, -0.737451017, 0.56753701,
        0.521232009, -0.857223034, 0.530369997,
        0.662028015, -0.742200017, 0.493347019,
        0.807987034, -0.723623991, 0.563324988,
        0.914606988, -0.707723975, 0.441857994,
        1.2056911, -0.701157033, 0.532082975,
        1.37567103, -0.740222991, 0.482732981,
        1.48991096, -0.638079047, 0.552515984,
        1.627092, -0.58297801, 0.634860039,
        1.78902304, -0.636299968, 0.475808978,
        1.944888, -0.667122006, 0.412659019,
        2.06259298, -0.595842004, 0.514976978,
        -2.55389404, -0.557967007, 0.555021048,
        -2.38977003, -0.568098009, 0.508239031,
        -2.23612213, -0.551949024, 0.445233017,
        -2.13049197, -0.621903002, 0.610244989,
        -1.99643707, -0.583167017, 0.51564002,
        -1.85472608, -0.570155978, 0.601202965,
        -1.71880794, -0.50315702, 0.524282992,
        -1.49593198, -0.569967031, 0.458058,
        -1.391994, -0.493121982, 0.56813705,
        -1.19661593, -0.514701009, 0.513126016,
        -1.02136803, -0.548940003, 0.526271999,
        -0.871475995, -0.47675702, 0.57702601,
        -0.715790987, -0.514712989, 0.620223045,
        -0.590948999, -0.525192022, 0.504905999,
        -0.420081019, -0.538820982, 0.55447799,
        -0.231579006, -0.460355997, 0.598815024,
        -0.0898379982, -0.553547978, 0.556599021,
        0.0735030025, -0.443096995, 0.578783989,
        0.233022004, -0.502833009, 0.548918962,
        0.418121994, -0.574458003, 0.51296097,
        0.574506044, -0.626834989, 0.580469966,
        0.716265023, -0.503004014, 0.527594984,
        0.899259031, -0.548717976, 0.504770994,
        1.04570997, -0.635447979, 0.526262999,
        1.17692995, -0.530315995, 0.509609997,
        1.33032, -0.588320971, 0.554928005,
        1.450773, -0.47646898, 0.502011001,
        1.60331106, -0.545606971, 0.467331022,
        1.74334502, -0.48446998, 0.544770002,
        1.89652801, -0.506232023, 0.461597979,
        -2.11235094, 1.34654093, -0.690357029,
        -1.95265496, 1.17709506, -0.711257994,
        -1.83689713, 1.31944799, -0.676329017,
        -2.57923198, -0.385586977, 0.547149003,
        -2.4243331, -0.412053019, 0.477087021,
        -2.26183796, -0.38716802, 0.49870199,
        -2.11585808, -0.466425002, 0.532671034,
        -2.018502, -0.333692998, 0.506910026,
        -1.87834203, -0.44234699, 0.486735016,
        -1.73461795, -0.347070009, 0.457749009,
        -1.57491302, -0.425042987, 0.493745983,
        -1.36913705, -0.352874994, 0.478433967,
        -1.22540998, -0.365738988, 0.585155964,
        -1.09335303, -0.392444998, 0.47439301,
        -0.852678001, -0.316196978, 0.523481965,
        -0.701910019, -0.391110003, 0.504719973,
        -0.533630967, -0.370505989, 0.489255011,
        -0.365781009, -0.373640984, 0.527616024,
        -0.194949001, -0.37380299, 0.462110996,
        -0.0266549997, -0.35363701, 0.479772002,
        0.13408199, -0.299811006, 0.498134971,
        0.230340004, -0.350652009, 0.618968964,
        0.385464013, -0.418673992, 0.58713603,
        0.547059, -0.460536003, 0.533097029,
        0.670773029, -0.34443599, 0.495111018,
        0.837678015, -0.389585972, 0.497178018,
        1.02824402, -0.430337995, 0.518738985,
        1.16278803, -0.320975989, 0.499643981,
        1.30045807, -0.411183, 0.500256002,
        1.48134303, -0.311747998, 0.455769002,
        1.59021902, -0.25604701, 0.571074009,
        1.76760602, -0.273858011, 0.488261998,
        -1.96305907, 1.44842696, -0.661688983,
        2.00395799, -0.436592996, 0.577598989,
        -1.75494599, 1.48250401, -0.666102052,
        -2.51571608, -0.223757982, 0.517611027,
        -2.33146214, -0.161685005, 0.505887032,
        -2.17029905, -0.249920994, 0.534354031,
        -1.99937403, -0.146940008, 0.508404016,
        -1.87580705, -0.259667993, 0.475545019,
        -1.7324729, -0.178038001, 0.483408004,
        -1.62523806, -0.282597005, 0.562734008,
        -1.466277, -0.245274007, 0.57525599,
        -1.30557299, -0.214944005, 0.561219037,
        -1.094733, -0.258536994, 0.56962198,
        -0.944949031, -0.181035012, 0.573819041,
        -0.774377942, -0.196722001, 0.606791973,
        -0.636878967, -0.230745018, 0.499170005,
        -0.466266006, -0.222522005, 0.51057601,
        -0.280310988, -0.227513999, 0.513273001,
        -0.128408998, -0.305213988, 0.605736017,
        0.0137250004, -0.214458019, 0.565743029,
        -2.13976192, 1.59052491, -0.694832981,
        0.169881001, -0.186486006, 0.61323601,
        -1.95464408, 1.60161304, -0.757631958,
        0.348039001, -0.251253009, 0.55803597,
        -1.63384485, 1.59705591, -0.738882005,
        0.507057011, -0.294548988, 0.530802011,
        0.712818027, -0.183299989, 0.479910016,
        0.871257067, -0.231822014, 0.465354025,
        1.02451205, -0.273869991, 0.429966033,
        1.12839603, -0.152373001, 0.487398028,
        1.323789, -0.249422997, 0.466683,
        1.53297901, -0.148718998, 0.43345201,
        1.678092, -0.120251998, 0.518949032,
        1.84890914, -0.1215, 0.536475003,
        1.93761897, -0.278961003, 0.527465999,
        -2.46483302, -0.0617310032, 0.561567008,
        -2.34803104, 0.00783899985, 0.458804995,
        -2.16623116, 0.0106889997, 0.479447991,
        -1.99625695, 0.0437760018, 0.503261983,
        -1.85013306, -0.0603749976, 0.517745972,
        -1.68494403, -0.0238320008, 0.550274968,
        -2.20683599, 1.75505996, -0.749094009,
        -1.57373106, -0.139649987, 0.48476699,
        -1.99215603, 1.76213098, -0.685317039,
        -1.42034698, -0.0909930021, 0.534428954,
        -1.71539402, 1.75072503, -0.669723034,
        -1.26501, -0.0837839991, 0.464462996,
        -1.10081995, -0.0992130041, 0.629006982,
        -0.834428966, -0.0538859963, 0.537795007,
        -0.667172968, -0.0763529986, 0.566420972,
        -0.504707992, -0.0874409974, 0.611573994,
        -0.375831008, -0.0805229992, 0.497963995,
        -0.205802992, -0.0591570027, 0.476988018,
        -0.089373, -0.094122, 0.587154031,
        0.0844589993, -0.0596969984, 0.535539031,
        0.222396016, 0.0209489986, 0.471512973,
        0.394436985, -0.0881280005, 0.530120969,
        0.555788994, -0.136100993, 0.513597012,
        0.680450976, -0.0278249979, 0.542492986,
        0.837051034, -0.0728549957, 0.511281013,
        0.983711958, 0.0147510003, 0.544896007,
        1.14978302, 0.0138599994, 0.517262995,
        1.2768929, -0.107825994, 0.551762998,
        1.4151001, -0.0329819992, 0.480773985,
        1.57087207, 0.014568001, 0.532016993,
        1.73371804, 0.0312899984, 0.592221022,
        -2.09700298, 1.90885806, -0.709514976,
        -1.91261411, 1.92636001, -0.708213031,
        -2.60982895, 0.00987899955, 0.502503037,
        -2.49487185, 0.136092007, 0.525066018,
        -2.32537508, 0.151283994, 0.548220038,
        -2.10361505, 0.167093992, 0.448973984,
        -2.01319218, 0.195686996, 0.598364949,
        -1.83999896, 0.108168006, 0.506715,
        -1.69779003, 0.150636002, 0.589707017,
        -1.52724886, 0.0221790001, 0.472359002,
        -1.34498394, 0.0573719963, 0.538137019,
        -1.17986393, 0.0560999997, 0.489479989,
        -1.08380401, 0.0784559995, 0.623939991,
        -0.856005013, 0.0870959982, 0.441524982,
        -0.739488006, 0.0827040002, 0.572964013,
        -0.627710998, 0.26583299, 0.578105986,
        -0.444353998, 0.0671730042, 0.546945035,
        -0.320892006, 0.0633450001, 0.433359027,
        -0.0415109992, 0.0539700016, 0.539148033,
        0.0902189985, 0.143870994, 0.518046021,
        0.252972007, 0.185742006, 0.521996975,
        0.378392994, 0.0935789943, 0.465249002,
        0.531230986, 0.0281520002, 0.480570018,
        0.65239799, 0.135708004, 0.527678967,
        0.823143005, 0.0923639983, 0.556590021,
        0.982985973, 0.166536003, 0.482864976,
        1.14719999, 0.174747005, 0.573737979,
        1.34893203, 0.218891993, 0.484826982,
        1.45552206, 0.131931007, 0.58592999,
        1.62401998, 0.169218004, 0.615836978,
        -2.70897913, 0.157554001, 0.50020498,
        -2.60525703, 0.271112978, 0.579972029,
        -2.43488407, 0.289326012, 0.584598005,
        -2.27130604, 0.315315008, 0.542208016,
        -2.10098696, 0.322988987, 0.515565038,
        0.176817, 1.98291898, -0.734027982,
        -1.94187307, 0.234791994, 0.456353992,
        -1.78819489, 0.268113017, 0.51353699,
        -1.63852501, 0.32128799, 0.543147027,
        -1.54959607, 0.182525992, 0.513746977,
        -1.38661802, 0.222285002, 0.525014997,
        -1.21444798, 0.220173001, 0.515372992,
        -1.03325999, 0.143853009, 0.478890002,
        -0.904167056, 0.248111993, 0.478302002,
        -0.800397038, 0.240465, 0.624002993,
        -0.741513014, 0.395061016, 0.568985999,
        -0.465011984, 0.308669984, 0.571166992,
        -0.196716011, 0.101909995, 0.535323024,
        -0.0859889984, 0.163116008, 0.414780021,
        0.0242069997, 0.282509983, 0.469455004,
        0.125541002, 0.283757985, 0.612393022,
        0.39961499, 0.322808981, 0.468869984,
        0.513804018, 0.198044986, 0.450891018,
        0.703260005, 0.290885985, 0.511968017,
        0.912479997, 0.298718989, 0.560409009,
        1.0768559, 0.308108985, 0.503196001,
        1.23719096, 0.317184001, 0.576393008,
        1.39596295, 0.385556996, 0.512372971,
        1.52798402, 0.264423013, 0.495899975,
        -2.71170592, 0.326466024, 0.44531098,
        -2.55120611, 0.392360985, 0.471936017,
        -0.0486539975, 2.18718004, -0.743676007,
        -2.38465786, 0.430589974, 0.494145036,
        0.135389999, 2.16299701, -0.762834013,
        -2.21298599, 0.470654994, 0.507503986,
        -2.06513691, 0.462714016, 0.599640012,
        -1.93065, 0.350255996, 0.588434994,
        -1.78272891, 0.429563999, 0.548220038,
        -1.62650406, 0.489192009, 0.535929024,
        -1.48076999, 0.364569008, 0.502130985,
        -1.310835, 0.366486013, 0.533237994,
        -1.16596198, 0.456326991, 0.544661999,
        -1.07123101, 0.309071988, 0.515159965,
        -0.918171048, 0.402998984, 0.536882997,
        -0.675707996, 0.517911017, 0.460382998,
        -0.52184701, 0.466733992, 0.534761965,
        -0.326786995, 0.49368, 0.540650964,
        -0.293139011, 0.320264995, 0.542055011,
        -0.134154007, 0.268262982, 0.533496022,
        0.0160140004, 0.430913985, 0.544770002,
        0.173595011, 0.472940981, 0.586941004,
        0.365541011, 0.489771008, 0.491132975,
        0.522354007, 0.51771003, 0.546461999,
        0.558875978, 0.363335997, 0.481404006,
        0.816425979, 0.390474021, 0.452892005,
        0.970367968, 0.446691036, 0.476357996,
        1.08439195, 0.441621006, 0.603441,
        1.24650598, 0.484830022, 0.559467018,
        -0.0951779932, 2.39160013, -0.742251039,
        -2.70843291, 0.506532013, 0.468663007,
        0.0683699995, 2.32157707, -0.689091027,
        -2.59796095, 0.487356007, 0.601428032,
        -2.46835518, 0.577418983, 0.538343966,
        -2.33130598, 0.575019002, 0.426674992,
        -2.13933015, 0.608955026, 0.593963981,
        -1.90872598, 0.528941989, 0.598029017,
        -1.75524008, 0.598757982, 0.571496964,
        -1.56184208, 0.642003, 0.530559003,
        -1.48345804, 0.524717987, 0.438189,
        -1.31831396, 0.51415205, 0.456221998,
        -1.18867195, 0.610292971, 0.485462964,
        -0.999086976, 0.60314703, 0.498230994,
        -0.827198982, 0.548300982, 0.53906405,
        -0.0938009918, 0.547698021, 0.487937987,
        0.0810360014, 0.59185499, 0.466899008,
        0.246405005, 0.628391981, 0.523478985,
        0.416399986, 0.654635966, 0.474792004,
        0.591437995, 0.658841968, 0.474896997,
        0.659264982, 0.497514009, 0.440447986,
        0.766155005, 0.658428013, 0.485403001,
        0.933128953, 0.618417025, 0.448428035,
        1.10490298, 0.54885304, 0.475679994,
        -0.0556949973, 2.57351398, -0.664590001,
        -2.59948206, 0.65713501, 0.625838995,
        -2.43889213, 0.747204006, 0.538158,
        -2.23480797, 0.745172977, 0.615378022,
        -2.12801409, 0.74406302, 0.484076977,
        -1.96841407, 0.782091022, 0.484143019,
        -1.82422507, 0.70432198, 0.446843982,
        -1.67052603, 0.760784984, 0.483327001,
        -1.4643929, 0.782076001, 0.50820601,
        -1.29152703, 0.758750975, 0.498461992,
        -1.12417507, 0.755000949, 0.542580009,
        -2.60113192, 0.832460999, 0.528024018,
        -2.45006084, 0.913257003, 0.503349006,
        -2.23916698, 0.866264999, 0.498336017,
        -2.07458997, 0.901497006, 0.545459986,
        -1.88507986, 0.923129976, 0.499262989,
        -1.71200109, 0.926723957, 0.477569997,
        -1.51938891, 0.939765036, 0.491993964,
        -1.35290098, 0.914712071, 0.458514035,
        -1.18153799, 0.914205015, 0.499656022,
        -2.57190609, 1.02562201, 0.551472008,
        -2.43581104, 1.11059403, 0.486221999,
        -2.31852603, 0.99770999, 0.445052981,
        -2.14907694, 1.02449703, 0.430239022,
        -1.99448097, 1.06091404, 0.504752994,
        -1.80830407, 1.06839299, 0.479903996,
        -1.61470807, 1.07784295, 0.486024022,
        -1.43924403, 1.08849299, 0.514811993,
        -1.26647997, 1.06728601, 0.476073027,
        -2.59278584, 1.19031596, 0.488516986,
        -2.38380313, 1.26757503, 0.520097971,
        -2.26038599, 1.145064, 0.508179009,
        -2.14496708, 1.16456103, 0.630245984,
        -1.89664197, 1.20954299, 0.486470997,
        -1.71875703, 1.20797706, 0.474599987,
        -1.52304304, 1.23387897, 0.47113502,
        -1.34826303, 1.22851503, 0.464166015,
        -1.16571295, 1.20718801, 0.45864898,
        -2.54061317, 1.35354304, 0.535853982,
        -2.3842082, 1.43809199, 0.544019997,
        -2.22129011, 1.31384397, 0.570449948,
        -2.08564806, 1.23613191, 0.486635983,
        -1.96875, 1.353459, 0.438140988,
        -1.80929399, 1.32383704, 0.39280799,
        -1.64502001, 1.35176706, 0.442119002,
        -1.354689, 1.38548708, 0.388410032,
        -1.20366597, 1.37153697, 0.514904976,
        -2.21468401, 1.48958099, 0.552371979,
        -2.06017494, 1.41658199, 0.56963098,
        -1.92066002, 1.50137711, 0.508269012,
        -1.652421, 1.50064492, 0.526938021,
        -1.495911, 1.44624603, 0.474431992,
        -1.34352303, 1.52834094, 0.494337022,
        -1.16977799, 1.53965092, 0.457388997,
        -1.7885251, -2.68163109, 1.15826106,
        -1.62001204, -2.71671915, 1.10334301,
        -1.47889507, -2.686167, 1.20773995,
        -1.34187603, -2.71358681, 1.10112894,
        -1.19159698, -2.71317601, 1.20153606,
        -1.04141104, -2.71891809, 1.11192,
        -0.884012997, -2.71499109, 1.17609,
        -0.714879036, -2.70087004, 1.20787501,
        0.917943001, -2.68540502, 1.14847207,
        1.11325502, -2.6897912, 1.14974701,
        -1.739259, -2.52696896, 1.08196497,
        -1.56249905, -2.54928613, 1.12437296,
        -1.38533401, -2.55359697, 1.14016199,
        -1.22031903, -2.54582095, 1.19758499,
        -1.04522705, -2.55776095, 1.20728099,
        -0.872568011, -2.54716492, 1.21301997,
        -0.703958988, -2.52319813, 1.23632407,
        -0.580940962, -2.60393095, 1.15403402,
        -0.41207698, -2.57903099, 1.18430996,
        -0.250077009, -2.57695198, 1.11303294,
        -0.0991889983, -2.55388188, 1.19741094,
        0.0639839992, -2.55609894, 1.144665,
        0.208344012, -2.55289507, 1.23576903,
        0.396990001, -2.4387269, 1.19226897,
        0.501206994, -2.551404, 1.127496,
        0.666552007, -2.52768302, 1.19571304,
        0.813650966, -2.5425148, 1.11349201,
        0.99299401, -2.52669287, 1.12476599,
        1.15630496, -2.54215503, 1.0651741,
        1.28426695, -2.63743496, 1.13853896,
        1.45992303, -2.55171013, 1.12047899,
        -1.62637496, -2.39391899, 1.07058299,
        -1.48872304, -2.36486387, 1.17659998,
        -1.32137394, -2.40646505, 1.20709801,
        -1.17938697, -2.42040586, 1.08972597,
        -1.00848603, -2.41767907, 1.11882603,
        -0.813758969, -2.39319897, 1.2394979,
        -0.688407004, -2.3839798, 1.129794,
        -0.519371986, -2.35021806, 1.16993403,
        -0.327018023, -2.41177487, 1.15894496,
        -0.145389006, -2.42894697, 1.09917307,
        -0.0135390004, -2.40963006, 1.21636796,
        0.146403, -2.40296698, 1.17974997,
        0.289757997, -2.32151699, 1.134408,
        0.454061985, -2.30717397, 1.11494398,
        0.561269999, -2.39770198, 1.20178795,
        0.70669198, -2.38835692, 1.10527503,
        0.872442007, -2.44035006, 1.23564899,
        0.995597959, -2.34924293, 1.16834104,
        1.15207195, -2.39499903, 1.14001501,
        1.31868005, -2.42557192, 1.19947505,
        1.44533992, -2.375247, 1.09720802,
        1.60162807, -2.43474889, 1.13019896,
        1.77024901, -2.39515781, 1.14724803,
        -1.40339994, -2.26027489, 1.06034696,
        -1.24089897, -2.261976, 1.19491804,
        -1.04235899, -2.27125216, 1.20658195,
        -0.894938946, -2.2872901, 1.12075806,
        -0.742443025, -2.24120092, 1.20447898,
        -0.585051, -2.19269109, 1.15140903,
        -0.41624701, -2.22184515, 1.19349599,
        -0.246306002, -2.188344, 1.20626104,
        -0.111642003, -2.27467799, 1.22834706,
        0.0257400014, -2.25213599, 1.13633406,
        0.173357993, -2.24961901, 1.23890996,
        0.331955999, -2.15842795, 1.15616393,
        0.609629989, -2.25314689, 1.13589895,
        0.706961989, -2.19072604, 1.25835896,
        0.835956037, -2.27797508, 1.19346309,
        0.962024927, -2.18763304, 1.11194992,
        1.11207294, -2.25282001, 1.0639019,
        1.28294694, -2.30874896, 1.08546305,
        1.394853, -2.27258992, 1.23172796,
        1.64643002, -2.27421904, 1.21013999,
        1.77920401, -2.22474313, 1.11232507,
        1.91115296, -2.30226302, 1.20552003,
        2.08670998, -2.24400282, 1.15825796,
        -1.30887604, -2.11331105, 1.116678,
        -1.13422799, -2.130615, 1.18304706,
        -0.950312972, -2.13275099, 1.15247107,
        -0.785681963, -2.10702896, 1.11991501,
        -0.632780969, -2.03099394, 1.12460995,
        -0.440798998, -2.09639096, 1.08670497,
        -0.255465001, -2.05811095, 1.10394597,
        -0.0953460038, -2.12289286, 1.15735507,
        0.0632250011, -2.11138821, 1.227054,
        0.246333003, -2.02328086, 1.20391798,
        0.452040017, -2.01332712, 1.146891,
        0.540656984, -2.12526298, 1.243536,
        0.651084006, -2.09345698, 1.12585199,
        0.819164991, -2.10099888, 1.14071107,
        0.966816008, -2.0537672, 1.209324,
        1.12364399, -2.09444094, 1.147632,
        1.28045702, -2.16482115, 1.17481494,
        1.52146196, -2.1551609, 1.20564604,
        1.65669608, -2.05446601, 1.16227508,
        1.79910898, -2.11246204, 1.2371881,
        1.97310901, -2.14758301, 1.26563692,
        2.1336689, -2.08233595, 1.21638,
        2.28470397, -2.03224206, 1.13160896,
        -1.22851503, -1.96103704, 1.16954708,
        -1.04143798, -1.98401392, 1.17289805,
        -0.869486928, -1.96734905, 1.19735408,
        -0.702162027, -1.91255093, 1.22525704,
        -0.500217021, -1.93646097, 1.11429,
        -0.370599002, -1.99109101, 1.20479095,
        -0.259779006, -1.89116693, 1.11538196,
        -0.163275003, -1.97983813, 1.23262501,
        0.001116, -1.95923996, 1.19362497,
        0.151524007, -1.89247489, 1.16810393,
        0.321078002, -1.90690207, 1.10973001,
        0.588564038, -1.95950699, 1.21071005,
        0.73546195, -1.95253801, 1.10959506,
        0.865718961, -1.91467786, 1.202847,
        1.08089697, -1.95460796, 1.28235304,
        1.18074, -1.86049497, 1.18912506,
        1.26360893, -2.00029206, 1.17923701,
        1.42810202, -2.02169394, 1.15415704,
        1.5675211, -1.9152, 1.17553198,
        1.80267, -1.96365595, 1.14966607,
        1.94410491, -1.97449803, 1.24619997,
        2.10099888, -1.91010594, 1.20349503,
        2.27065182, -1.86111903, 1.18241692,
        -1.30545306, -1.79530191, 1.175946,
        -1.13455796, -1.8036871, 1.17253494,
        -0.969197989, -1.83018899, 1.16401196,
        -0.804212987, -1.80283809, 1.13149798,
        -0.668954968, -1.75129795, 1.21137905,
        -0.530189991, -1.71554399, 1.13064003,
        -0.400025994, -1.82330394, 1.19835603,
        -0.241152003, -1.76470506, 1.22284508,
        -0.105227999, -1.83543599, 1.15120196,
        0.0268290006, -1.78879499, 1.23667192,
        0.161168993, -1.72764897, 1.15459204,
        0.328758001, -1.74174607, 1.12081802,
        0.471579015, -1.83355808, 1.148067,
        0.698993981, -1.84070992, 1.22656202,
        0.83011204, -1.73466003, 1.24933493,
        0.978893995, -1.81262708, 1.26692104,
        1.09186196, -1.71813905, 1.19657695,
        1.31343007, -1.7646091, 1.18156505,
        1.4560771, -1.81469703, 1.10330999,
        1.58253598, -1.74392104, 1.19461203,
        1.71972299, -1.83383393, 1.20352805,
        1.90016103, -1.81265998, 1.18514395,
        2.09282398, -1.73832893, 1.17449701,
        2.26617002, -1.68698692, 1.14355493,
        -1.79512787, -1.60633802, 1.17348301,
        -1.62642312, -1.68026996, 1.17501593,
        -1.50920105, -1.56591606, 1.13601601,
        -1.359936, -1.55679893, 1.20096302,
        -1.20004201, -1.56072307, 1.25005198,
        -1.06295991, -1.60957503, 1.16629195,
        -0.909521937, -1.67214012, 1.136922,
        -0.753836989, -1.62755108, 1.13283598,
        -0.614178002, -1.56357002, 1.19570696,
        -0.451286972, -1.57256389, 1.16106904,
        -0.235557005, -1.60277402, 1.18419003,
        -0.0720660016, -1.67117393, 1.12796402,
        0.0482280031, -1.60932302, 1.23979199,
        0.179361001, -1.56504297, 1.134987,
        0.327558011, -1.59821105, 1.19656503,
        0.482823014, -1.66950595, 1.16255403,
        0.646247983, -1.70076609, 1.16360104,
        0.778827071, -1.597224, 1.14857101,
        0.940886974, -1.64459705, 1.16485798,
        1.22615993, -1.64112902, 1.27702796,
        1.34613001, -1.55879092, 1.18634403,
        1.47179103, -1.65637207, 1.08559501,
        1.61666107, -1.58447707, 1.14584994,
        1.74503112, -1.660923, 1.22026801,
        1.89883804, -1.587798, 1.22842503,
        -1.95413995, -1.52296793, 1.16382599,
        -1.81218004, -1.426947, 1.18269002,
        -1.65345001, -1.50677705, 1.20266998,
        -1.41238797, -1.39451396, 1.14242697,
        -1.25423098, -1.34158492, 1.12593007,
        -1.09817994, -1.44492006, 1.17559493,
        -0.931905031, -1.50741315, 1.21115398,
        -0.766491055, -1.51856995, 1.26380098,
        -0.660660028, -1.38935101, 1.25727296,
        -0.566895008, -1.41809702, 1.11865199,
        -0.398952007, -1.42073095, 1.13128507,
        -0.232226998, -1.43368495, 1.15508401,
        -0.0809579939, -1.45014906, 1.075755,
        0.0563880019, -1.45159805, 1.172001,
        0.205998003, -1.40143204, 1.11971998,
        0.359225988, -1.43106306, 1.17095995,
        0.517259955, -1.45280099, 1.11834002,
        0.697247982, -1.471398, 1.07273698,
        0.938322008, -1.4791379, 1.15274394,
        1.08347404, -1.55610895, 1.19483101,
        1.20905101, -1.485111, 1.11182404,
        1.34915709, -1.40863204, 1.08719707,
        1.483338, -1.49678695, 1.10237694,
        1.604442, -1.42015505, 1.1873641,
        1.75998008, -1.49352896, 1.180722,
        1.95502186, -1.43391907, 1.15402806,
        -2.1365459, -1.37929201, 1.15895402,
        -1.96529698, -1.34490001, 1.18202102,
        -1.81507802, -1.25450099, 1.18104899,
        -1.66628695, -1.34082901, 1.1943121,
        -1.51231205, -1.25879693, 1.17822599,
        -1.35501599, -1.2371819, 1.04402101,
        -1.16214597, -1.31301594, 1.25831997,
        -1.01576996, -1.25070596, 1.20808804,
        -0.805776, -1.31984997, 1.18954206,
        -0.643934965, -1.26573896, 1.14474297,
        -0.479766011, -1.28145897, 1.18358099,
        -0.325518012, -1.27511692, 1.09360194,
        -0.161228999, -1.29249597, 1.07786405,
        0.0113549996, -1.30132198, 1.09444809,
        0.147599995, -1.20634496, 1.04890203,
        0.298386008, -1.26455104, 1.09982991,
        0.459608972, -1.30107605, 1.14205194,
        0.616539001, -1.32401395, 1.07133901,
        0.788411975, -1.33363199, 1.099998,
        0.954473972, -1.33266294, 1.07832599,
        1.08845699, -1.38588905, 1.15836906,
        1.26969898, -1.323102, 1.21676099,
        1.36897206, -1.24509907, 1.09918809,
        1.45163703, -1.35992694, 1.20752394,
        1.67370892, -1.254246, 1.19589591,
        1.81666493, -1.33694696, 1.17418194,
        1.9677, -1.24930191, 1.14148498,
        -2.26648808, -1.2022109, 1.17922497,
        -2.08848906, -1.21207798, 1.17525005,
        -1.940889, -1.13640594, 1.21152604,
        -1.79630399, -1.08891904, 1.13461804,
        -1.66143894, -1.172997, 1.20304203,
        -1.632465, -1.09712696, 1.06080306,
        -1.45766401, -1.11104095, 1.09437895,
        -1.21775699, -1.15598392, 1.22751904,
        -1.070346, -1.09349394, 1.17451191,
        -0.879473984, -1.15724099, 1.19682598,
        -0.71883899, -1.12762499, 1.20398998,
        -0.579840004, -1.18566298, 1.27923,
        -0.376230001, -1.151811, 1.19327092,
        -0.221145004, -1.13864696, 1.13129997,
        -0.0720150024, -1.18049097, 1.186674,
        0.0538979992, -1.08796203, 1.13487303,
        0.233808011, -1.12583101, 1.16524196,
        0.403160989, -1.1464889, 1.17228901,
        0.545040011, -1.17048907, 1.077999,
        0.712688982, -1.17258596, 1.10778904,
        0.877590001, -1.19741094, 1.13998199,
        1.06372201, -1.21976101, 1.15487099,
        1.227723, -1.16573405, 1.14585304,
        1.38015902, -1.13369405, 1.227759,
        1.52059197, -1.21277702, 1.16017199,
        1.65234613, -1.09034395, 1.16999996,
        1.80852008, -1.167027, 1.13710201,
        1.92972302, -1.08037198, 1.22739899,
        -2.34787512, -1.04143798, 1.20127201,
        -2.16977096, -1.05813897, 1.19512498,
        -2.1027, -0.941895008, 1.09659302,
        -1.94256592, -0.995063961, 1.11778796,
        -1.79377508, -0.921141028, 1.10696101,
        -1.67873406, -0.989798963, 1.20532501,
        -1.54655409, -0.959414959, 1.10122204,
        -1.35790491, -1.06634998, 1.22402692,
        -1.20553803, -0.993620992, 1.182513,
        -1.07502604, -0.951972008, 1.28171706,
        -0.921693027, -0.991446018, 1.20825601,
        -0.751703978, -0.972774029, 1.27164602,
        -0.592328966, -1.02451801, 1.25094306,
        -0.438474, -1.00014305, 1.19398499,
        -0.271010995, -0.982697964, 1.18100703,
        -0.102456003, -1.01066101, 1.13796902,
        0.145704001, -1.02800107, 1.26894903,
        0.318561018, -0.999903023, 1.23152697,
        0.470613003, -1.02331197, 1.08976197,
        0.624566972, -1.03738201, 1.171965,
        0.810488999, -1.05585301, 1.1961,
        0.980355024, -1.07379293, 1.19121003,
        1.1053021, -1.06424999, 1.07805598,
        1.24584901, -0.97815603, 1.08103204,
        1.37187302, -0.963845968, 1.19966698,
        1.55253303, -0.952430964, 1.21306205,
        1.69209301, -0.925989032, 1.13060403,
        1.83943796, -0.997988999, 1.10202599,
        2.00999403, -1.02522898, 1.08317101,
        -2.40252304, -0.876989961, 1.15860605,
        -2.23180485, -0.842517018, 1.16453397,
        -2.06760597, -0.813084006, 1.19852996,
        -1.90411496, -0.827522993, 1.19650793,
        -1.7415421, -0.790077031, 1.20513904,
        -1.63751698, -0.818184018, 1.07482207,
        -1.4627099, -0.816053987, 1.08710694,
        -1.30665302, -0.864342034, 1.14187801,
        -1.14827108, -0.83573699, 1.18537498,
        -0.983819962, -0.807482958, 1.15487397,
        -0.851979017, -0.843450069, 1.24988699,
        -0.703341007, -0.829820991, 1.15939498,
        -0.551712036, -0.869507968, 1.21781397,
        -0.37976101, -0.846675038, 1.20868802,
        -0.153753012, -0.870402038, 1.23547804,
        0.0181530006, -0.905520022, 1.22867107,
        0.184503004, -0.915021062, 1.15803301,
        0.311340004, -0.801779985, 1.15696204,
        0.466325998, -0.867740989, 1.14065099,
        0.628104031, -0.871080041, 1.10343599,
        0.811802983, -0.84641701, 1.04484606,
        0.905831933, -0.973733962, 1.08377397,
        1.11763501, -0.892904997, 1.015782,
        1.20116997, -0.862200022, 1.19229293,
        1.31070304, -0.746349037, 1.17195296,
        1.45604706, -0.81972301, 1.15837204,
        1.616436, -0.773100019, 1.157529,
        1.79312086, -0.801702023, 1.16027403,
        1.94917202, -0.885315061, 1.17360604,
        -2.34391212, -0.73218298, 1.24921203,
        -2.16967487, -0.689159989, 1.24268997,
        -2.06781602, -0.664691985, 1.10773206,
        -1.88087988, -0.691574991, 1.09028399,
        -1.72219205, -0.63577497, 1.13278198,
        -1.55677807, -0.677426994, 1.11632407,
        -1.38531899, -0.676299036, 1.13194799,
        -1.22533798, -0.707607031, 1.099383,
        -1.11497402, -0.678218961, 1.22253609,
        -0.94817698, -0.635933995, 1.21410608,
        -0.829877973, -0.720831037, 1.13036108,
        -0.656340003, -0.676280975, 1.21733403,
        -0.482726991, -0.710561991, 1.20524096,
        -0.295940995, -0.700040996, 1.204041,
        -0.130817994, -0.722945988, 1.15800595,
        0.0361770019, -0.755469024, 1.1007781,
        0.158169001, -0.766209006, 1.21889997,
        0.30051899, -0.632319033, 1.17149401,
        0.440891981, -0.706506014, 1.09601998,
        0.576839983, -0.743258953, 1.19133306,
        0.729725957, -0.731567979, 1.12517405,
        0.943583965, -0.801174045, 1.13930106,
        1.04641795, -0.709203005, 1.04754603,
        1.15789795, -0.684590995, 1.17148495,
        1.270509, -0.599610031, 1.06397402,
        1.42102802, -0.634238958, 1.13505304,
        1.56359696, -0.624330044, 1.20944703,
        1.78272891, -0.650243998, 1.08479702,
        1.94419491, -0.706485033, 1.12937403,
        -2.36882401, -0.556442976, 1.22235596,
        -2.19866395, -0.528126001, 1.18431306,
        -2.02930498, -0.521076024, 1.18258202,
        -1.86353993, -0.538500011, 1.16251802,
        -1.70994592, -0.467180997, 1.14308405,
        -1.57658708, -0.53490603, 1.20353401,
        -1.41218996, -0.536118031, 1.21702206,
        -1.262187, -0.592517972, 1.22171998,
        -1.14314699, -0.552843034, 1.10942996,
        -1.00608599, -0.480416983, 1.18533599,
        -0.910820961, -0.553218007, 1.06514406,
        -0.79450196, -0.549594045, 1.1978941,
        -0.625874996, -0.521628022, 1.15081501,
        -0.464424014, -0.540093005, 1.19121003,
        -0.195923984, -0.565400958, 1.20763803,
        -0.0322889984, -0.590543985, 1.16735101,
        0.137271002, -0.602339983, 1.206375,
        0.241335005, -0.525833964, 1.05114901,
        0.411374986, -0.53906405, 1.07411098,
        0.548262, -0.584414959, 1.15612197,
        0.708344996, -0.566163003, 1.08497691,
        0.838485003, -0.618206978, 1.17995405,
        0.950040042, -0.556926012, 1.07598901,
        1.11163497, -0.553223968, 1.08280802,
        1.20060003, -0.454959035, 1.18602896,
        1.362921, -0.478733987, 1.13926494,
        1.52761197, -0.484539002, 1.11641097,
        1.69053006, -0.520625949, 1.151631,
        1.87405193, -0.552357018, 1.19541001,
        -2.4185431, -0.411305964, 1.12800896,
        -2.16408587, -0.337877989, 1.17183304,
        -2.0210042, -0.377967, 1.10044503,
        -1.86606002, -0.386099994, 1.05661201,
        -1.79069686, -0.335705996, 1.19365799,
        -1.59548402, -0.341625005, 1.13457298,
        -1.43628907, -0.386730015, 1.13825393,
        -1.29371107, -0.299394011, 1.10976899,
        -1.18446302, -0.358011007, 1.21812606,
        -1.02628207, -0.316731006, 1.16772306,
        -0.861683965, -0.40526399, 1.13239503,
        -0.737559021, -0.358799994, 1.23872697,
        -0.472209036, -0.379664987, 1.11589503,
        -0.326510996, -0.450486004, 1.18221593,
        -0.186035991, -0.359921992, 1.1951611,
        -0.0767579973, -0.460283995, 1.26416397,
        0.0723960027, -0.452241004, 1.18165803,
        0.246414006, -0.465681016, 1.20447898,
        0.385632008, -0.383103013, 1.14495003,
        0.544616997, -0.421707004, 1.13018107,
        0.689954996, -0.349745989, 1.05913806,
        0.822924018, -0.444324017, 1.08095407,
        0.973457932, -0.397100985, 1.03796101,
        1.12469399, -0.347631007, 1.08325803,
        1.28883302, -0.353699982, 1.07299197,
        1.44359398, -0.326081991, 1.15043402,
        1.6346159, -0.360639006, 1.17176104,
        1.81583405, -0.375819027, 1.17299998,
        -2.32414818, -0.269267976, 1.17657304,
        -2.08526111, -0.211907983, 1.09447193,
        -1.93361092, -0.249506995, 1.16649604,
        -1.79724908, -0.217149004, 1.066113,
        -1.08570004, -2.70622206, -0.586665034,
        -1.68539107, -0.206898004, 1.19437504,
        -0.920828998, -2.65457392, -0.541749001,
        -1.52656496, -0.186540008, 1.16407204,
        -0.747672021, -2.71959591, -0.570569992,
        -1.36427999, -0.150263995, 1.13140798,
        -1.14891291, -0.204836994, 1.136778,
        -1.00557601, -0.152954996, 1.22244906,
        -0.87518996, -0.261779994, 1.22190309,
        -0.165365994, -2.71556091, -0.568364978,
        -0.63369, -0.221184015, 1.22329807,
        0.0593699962, -2.72289896, -0.580277979,
        -0.447488964, -0.195624009, 1.08037198,
        0.247622997, -2.70573902, -0.489566982,
        -0.319620013, -0.287403017, 1.12970102,
        0.409335017, -2.71738791, -0.568658948,
        -0.233507991, -0.139527008, 1.17885602,
        0.57526201, -2.71003795, -0.644895017,
        -0.0144119989, -0.310649991, 1.23724198,
        0.741518974, -2.71592093, -0.574775994,
        0.114699006, -0.296912998, 1.13425493,
        0.897284985, -2.65517998, -0.634145975,
        0.276138008, -0.272753984, 1.19588995,
        0.448740005, -0.227310002, 1.18604398,
        0.616890013, -0.288554996, 1.19275796,
        0.697652996, -0.182525992, 1.076262,
        0.847314, -0.271836013, 1.04704499,
        0.958887041, -0.309009016, 1.18678498,
        1.15865695, -0.173781008, 1.08106804,
        1.30962896, -0.204888001, 1.161906,
        1.44514203, -0.186726004, 1.04190302,
        1.566504, -0.201819003, 1.14904797,
        1.73358297, -0.218418002, 1.17400801,
        -1.04324102, -2.51728797, -0.610521019,
        -0.866580009, -2.49613786, -0.58001101,
        -2.27700591, -0.110624999, 1.10891998,
        -0.684267044, -2.56934094, -0.634884,
        -2.11640406, -0.0461729988, 1.08020997,
        -0.588495016, -2.65722895, -0.524438977,
        -1.95269704, -0.0911040008, 1.1244719,
        -0.489392996, -2.60598302, -0.649142981,
        -1.80209708, -0.0531179979, 1.20612299,
        -0.378294021, -2.51087999, -0.564101994,
        -1.64266801, -0.0589139983, 1.28385305,
        -0.203340009, -2.54547, -0.581117988,
        -1.49691904, -0.0193440001, 1.200261,
        -0.0289319996, -2.58372021, -0.636312008,
        -1.37416196, 0.0157650001, 1.09267497,
        0.144867003, -2.57069111, -0.616065025,
        -1.22388005, -0.054432001, 1.10585403,
        0.313511997, -2.57203197, -0.578837991,
        -0.961058974, 0.00732900016, 1.19077504,
        0.481877983, -2.56552196, -0.575523019,
        -0.835500002, -0.101117998, 1.21991706,
        0.64377296, -2.57797813, -0.542093992,
        -0.673862994, -0.0543420017, 1.21703398,
        0.903752983, -2.48069096, -0.620499015,
        1.0509541, -2.569695, -0.590586007,
        -0.526974022, -0.0527549982, 1.12544394,
        -0.362906992, -0.0275459997, 1.17109799,
        -0.230517, 0.00228299992, 1.07472301,
        -0.0852839947, -0.0706169978, 1.15315497,
        0.0880109966, -0.133485004, 1.161816,
        0.237114012, -0.0372809991, 1.13684094,
        0.427488029, -0.0247980002, 1.13556898,
        0.569972992, -0.108245999, 1.16264093,
        0.706155002, -0.016299, 1.13819695,
        0.848177969, -0.114542998, 1.12773895,
        1.02013195, -0.145128012, 1.17683101,
        1.15761006, -0.031983003, 1.16379297,
        1.302387, -0.059514001, 1.07810998,
        1.45244098, -0.0542579964, 1.15466702,
        1.62191701, -0.043494001, 1.18876493,
        -0.891692996, -2.31795883, -0.616023004,
        -0.723756015, -2.40351009, -0.596091032,
        -0.564689994, -2.48749804, -0.55181098,
        -0.451494008, -2.35678816, -0.611796021,
        -2.57136297, 0.0452640019, 1.17304492,
        -0.286181986, -2.37263107, -0.560841024,
        -2.41880703, -0.0398430005, 1.195521,
        -0.0884729996, -2.42627692, -0.640452027,
        0.0806310028, -2.41046405, -0.639279008,
        0.248070002, -2.42522097, -0.618371964,
        0.407175004, -2.41340113, -0.589295983,
        0.574934959, -2.42393112, -0.572877049,
        -2.23855805, 0.0344519988, 1.20046198,
        0.745059013, -2.4313798, -0.559383035,
        -1.76445007, 1.67163301, -1.86344695,
        -2.10457206, 0.114321001, 1.12787104,
        0.91970706, -2.31344414, -0.58565402,
        -1.96865702, 0.0496980026, 1.21726501,
        1.05150604, -2.40393901, -0.534033,
        -1.72808695, 0.0836069956, 1.11798298,
        1.20160794, -2.34976196, -0.601307988,
        -1.60254908, 0.109767005, 1.24032903,
        -1.42800295, 0.170540988, 1.10289598,
        -1.25893497, 0.136002004, 1.115592,
        -1.11759603, 0.0733769983, 1.17657304,
        -0.989196002, 0.172124997, 1.23061502,
        -0.804383993, 0.0540900007, 1.15383303,
        -0.626172006, 0.0807240009, 1.11331499,
        -0.47199899, 0.097608, 1.192101,
        -0.344076008, 0.215346009, 1.22367299,
        -0.215190008, 0.177549005, 1.09103703,
        -0.0698579997, 0.0762870014, 1.08496499,
        0.0795750022, 0.0404789969, 1.168221,
        0.220643997, 0.133130997, 1.15324199,
        0.516744018, 0.0906749964, 1.23103499,
        0.560552955, 0.0571050011, 1.07131803,
        0.664101005, 0.154320002, 1.17439508,
        0.822962999, 0.0963089913, 1.15536296,
        0.971714973, 0.0127859991, 1.14740705,
        1.08728409, 0.0889350027, 1.25286293,
        1.28185499, 0.0978540033, 1.15135193,
        1.47173107, 0.113136001, 1.22118592,
        -0.602738976, -2.28173113, -0.568187952,
        -0.473679006, -2.18708706, -0.626244009,
        -0.300651014, -2.2013731, -0.602475047,
        -1.84626913, 1.82502604, -1.79165387,
        -0.148355991, -2.28061485, -0.583940983,
        0.0116099995, -2.28799486, -0.539714992,
        0.172769994, -2.27879095, -0.589370966,
        0.333993018, -2.21179795, -0.585476995,
        0.500526011, -2.27751613, -0.621441007,
        0.622779012, -2.17423487, -0.565530002,
        0.760215044, -2.26933503, -0.592503011,
        -2.68245292, 0.183207005, 1.18173301,
        1.03970098, -2.20399213, -0.58711797,
        -2.38748407, 0.128208011, 1.17232502,
        1.18573201, -2.20308304, -0.499500006,
        -2.23743916, 0.20113501, 1.23079193,
        1.33342206, -2.21170187, -0.592032015,
        -2.11233282, 0.281100005, 1.15669799,
        -1.87231207, 0.165887997, 1.14977098,
        -1.72951198, 0.252201021, 1.16015697,
        -1.56218398, 0.256188005, 1.14972901,
        -1.436625, 0.334488004, 1.06438196,
        -1.27009201, 0.302715003, 1.10208297,
        -1.11341405, 0.243800998, 1.13656497,
        -0.947088003, 0.293079019, 1.10765696,
        -0.821090937, 0.220014006, 1.20914698,
        -0.657597005, 0.24905701, 1.15502095,
        -0.484718978, 0.25365001, 1.12790704,
        -0.323453993, 0.331416011, 1.0922339,
        -0.193782002, 0.304964989, 1.20580196,
        -0.054446999, 0.234150007, 1.14201295,
        0.0833039954, 0.202313989, 1.23701096,
        0.270774007, 0.290342987, 1.19598901,
        0.419715017, 0.160830006, 1.12456799,
        0.555647969, 0.231197983, 1.05654597,
        0.667893052, 0.326058, 1.13761806,
        0.811949968, 0.256502986, 1.21075797,
        0.975113988, 0.192617983, 1.16667604,
        1.13116801, 0.256232977, 1.16587496,
        1.30076098, 0.270393014, 1.20759296,
        -1.70480394, 1.97577286, -1.81082702,
        -0.382080019, -2.0554409, -0.558255017,
        -0.212520003, -2.05642509, -0.609233975,
        -0.0940409973, -2.13961792, -0.506489992,
        0.023711998, -2.14240503, -0.62452203,
        0.220482007, -2.005023, -0.50138098,
        0.363927007, -2.038131, -0.570263982,
        -2.7110641, 0.355374008, 1.153548,
        0.469053, -2.15432096, -0.508764029,
        -2.54156709, 0.330123007, 1.18586993,
        0.559679985, -2.02432799, -0.58653599,
        -2.37822008, 0.293079019, 1.21312201,
        0.746099949, -2.118855, -0.66130197,
        -2.24797797, 0.378192008, 1.12607098,
        0.874382973, -2.14621806, -0.54974401,
        -2.07816887, 0.445533037, 1.14582002,
        1.07765698, -2.05500007, -0.511130989,
        -1.9544251, 0.315456003, 1.19076896,
        1.24382997, -2.061831, -0.569276989,
        -1.8137939, 0.399663001, 1.15118396,
        -1.64601302, 0.400716007, 1.12102795,
        1.45414197, -2.07856512, -0.563831985,
        -1.49175906, 0.498959988, 1.06494904,
        -1.77559197, 2.14439702, -1.77851093,
        -1.34454894, 0.43909201, 1.17040801,
        -1.168383, 0.436953008, 1.16674197,
        -0.0372000001, 0.399125993, 1.18004704,
        0.120624006, 0.334529996, 1.13352001,
        0.220152006, 0.459075004, 1.21314597,
        0.435096025, 0.33168, 1.15200901,
        0.552974999, 0.453653991, 1.18514705,
        0.694253981, 0.537524998, 1.10624099,
        0.875694036, 0.523064971, 1.11986995,
        1.03128004, 0.432030022, 1.15102792,
        1.21353304, 0.386552989, 1.09033203,
        -0.582455993, -1.82640004, -0.47259298,
        -0.527804971, -1.94084692, -0.589316964,
        -0.336492002, -1.94017804, -0.672927022,
        -0.168083996, -1.91364908, -0.684072018,
        -0.0597510003, -1.98813593, -0.580482006,
        0.124550998, -1.89520788, -0.585824966,
        0.299228996, -1.87123799, -0.578276992,
        0.431865036, -1.87016094, -0.689208031,
        0.587895036, -1.86185396, -0.640779018,
        0.713454008, -1.96256113, -0.625121951,
        -1.95357609, 2.19949794, -1.77413702,
        0.867686987, -1.97558689, -0.567597032,
        -1.78594208, 2.33012986, -1.79052591,
        1.05118799, -1.89240599, -0.585021019,
        1.22251201, -1.90130103, -0.599660993,
        1.38365996, -1.93871105, -0.65595001,
        -2.68408489, 0.567494988, 1.20606899,
        -2.52370787, 0.504363, 1.19743204,
        -2.36396694, 0.461345971, 1.21671307,
        -2.22267294, 0.541334987, 1.17855895,
        -2.07412195, 0.608067036, 1.19049299,
        -1.92641997, 0.530870974, 1.17111003,
        -1.76196289, 0.55893302, 1.16660404,
        -1.59935999, 0.54648304, 1.18680906,
        -1.34101796, 0.587060988, 1.08023691,
        -1.17587101, 0.61263299, 1.11946797,
        0.385464013, 0.513350964, 1.16262293,
        0.523593009, 0.573800981, 1.06171501,
        -0.544905007, -1.76546395, -0.634823978,
        -0.400257021, -1.82064009, -0.562569022,
        -1.96382999, 2.38542891, -1.77314091,
        -0.26285401, -1.79021394, -0.649491012,
        -0.0828059986, -1.79357708, -0.58147198,
        0.0767579973, -1.74447906, -0.52452302,
        0.210837007, -1.73576093, -0.630984008,
        0.380253017, -1.71914399, -0.631139994,
        0.562703967, -1.70424592, -0.593474984,
        0.733743012, -1.81064391, -0.547119021,
        0.908612967, -1.81302285, -0.541521013,
        1.05161703, -1.71909606, -0.57050705,
        1.16066706, -1.77378893, -0.683766007,
        -2.54935503, 0.669708014, 1.17988205,
        1.31151307, -1.771101, -0.538022995,
        -2.376369, 0.63074702, 1.19530499,
        1.46106899, -1.78510499, -0.618713975,
        -2.22001505, 0.721053004, 1.19990993,
        -2.053689, 0.770540953, 1.1712389,
        -1.91928291, 0.696534038, 1.08915007,
        -1.79865599, 0.716747999, 1.21088398,
        -1.65589499, 0.689846992, 1.12318802,
        -1.45059609, 0.704346001, 1.12672496,
        -1.27906799, 0.755346, 1.14879608,
        -0.604575038, -1.62040508, -0.570765018,
        -0.477017999, -1.69548607, -0.480366021,
        -0.326826006, -1.62472808, -0.514394999,
        -0.17682299, -1.65731692, -0.622869015,
        -0.0329549983, -1.61646295, -0.565149009,
        0.127635002, -1.59549308, -0.576341987,
        0.289650023, -1.59881091, -0.551774979,
        0.455385, -1.59066296, -0.545982003,
        -2.58601809, 0.822051048, 1.11303604,
        0.608457029, -1.57378793, -0.479766011,
        0.854000926, -1.67744994, -0.624185979,
        -2.43362403, 0.799814939, 1.186854,
        0.980556011, -1.56097198, -0.606543005,
        -2.2902751, 0.873839974, 1.14771307,
        1.21171796, -1.63885498, -0.583638012,
        -2.12947202, 0.918489039, 1.18990803,
        1.36818302, -1.59341705, -0.653334022,
        -1.90424705, 0.852807045, 1.18140602,
        1.51319396, -1.63090205, -0.560519993,
        -1.75063801, 0.835925996, 1.09870803,
        -1.582026, 0.835260034, 1.15342498,
        -1.41226196, 0.848868012, 1.22126102,
        -0.55480504, -1.39912796, -0.500663996,
        -0.389009982, -1.46199298, -0.57999301,
        -0.236954987, -1.39910698, -0.539633989,
        -0.134243995, -1.49307299, -0.630777001,
        0.0352559984, -1.45986295, -0.617913008,
        0.210212991, -1.45624506, -0.612123013,
        0.370056003, -1.45284593, -0.579168022,
        0.539027989, -1.453197, -0.590142012,
        0.694970965, -1.43852401, -0.528729022,
        0.834038973, -1.51146305, -0.673538983,
        1.07382298, -1.41999304, -0.593150973,
        -2.60938215, 1.0115521, 1.15726197,
        1.20689702, -1.48676097, -0.502628982,
        1.34191501, -1.43437505, -0.582566977,
        -2.30849099, 1.03385103, 1.08492005,
        1.49564707, -1.474002, -0.635897994,
        -2.16302395, 0.973049998, 1.03390503,
        -1.98152995, 1.01235902, 1.20405304,
        -1.81202996, 0.991853952, 1.13787007,
        -1.65119398, 0.973752022, 1.06567502,
        -1.55078697, 0.991253972, 1.21295404,
        -1.38812399, 0.998124003, 1.13025904,
        -0.719852984, -1.34298301, -0.522042036,
        -0.576258004, -1.24036801, -0.52807498,
        -0.408614993, -1.30878901, -0.531636,
        -0.252384007, -1.23506701, -0.581261992,
        -0.0849930048, -1.33586693, -0.610812008,
        -2.60087681, 1.18550396, 1.11788702,
        -2.4392972, 1.13031602, 1.12685096,
        0.0131250005, -1.20015299, -0.604539037,
        0.229346991, -1.31954694, -0.519389987,
        -2.28122711, 1.20312905, 1.15625405,
        0.396671981, -1.32758403, -0.481971025,
        -2.13284707, 1.09998, 1.17264903,
        0.567009032, -1.32316196, -0.482246995,
        -1.86603308, 1.1399641, 1.21003497,
        0.77433604, -1.29054606, -0.542190015,
        -1.70379901, 1.15243196, 1.09146607,
        -1.53876901, 1.10414696, 1.07959509,
        -1.88776195, 1.39099193, -1.52626514,
        0.909972072, -1.38981891, -0.581430018,
        -1.45044005, 1.131495, 1.23212099,
        1.06557608, -1.249071, -0.602472007,
        1.21265399, -1.33024502, -0.552789032,
        1.36811709, -1.27426505, -0.528065979,
        1.49503207, -1.29618597, -0.647006989,
        1.62868786, -1.27123201, -0.529653013,
        -1.78207803, -2.64400196, 0.676766992,
        -1.62172794, -2.71991396, 0.663326979,
        -1.45143604, -2.74097395, 0.633065999,
        -1.287714, -2.705127, 0.579288006,
        -1.13267994, -2.68228197, 0.636431992,
        -0.70845902, -2.71278, 0.711849034,
        -0.541206002, -2.71883392, 0.651365995,
        0.522521973, -2.69082594, 0.71349895,
        -2.47614288, 1.29410994, 1.18573797,
        -1.48703694, -1.23734403, -0.535925984,
        0.702663004, -2.71705508, 0.676794052,
        -2.32569003, 1.38886201, 1.16554499,
        -1.32688797, -1.15709102, -0.566120982,
        0.87610507, -2.71071005, 0.716894984,
        -2.09831691, 1.27202702, 1.21631408,
        1.09922397, -2.65771198, 0.681419969,
        -1.92243004, 1.57770586, -1.58920789,
        -1.85432696, 1.29765892, 1.08850205,
        -0.738005996, -1.17093599, -0.564725995,
        -1.68364799, 1.32554102, 1.06637704,
        -1.75172102, 1.51756203, -1.54029608,
        -0.578505039, -1.08742499, -0.578771949,
        -1.57229114, 1.24219799, 1.16452193,
        1.447299, -2.68958092, 0.715220988,
        -0.419772029, -1.15072501, -0.572372973,
        -1.42348206, 1.34643006, 1.15442097,
        -0.27145499, -1.07031608, -0.623678982,
        -0.123416997, -1.17858601, -0.681869984,
        -0.0197160002, -1.04945993, -0.657941997,
        0.170193002, -1.16400301, -0.585198045,
        0.331110001, -1.18664396, -0.557424009,
        0.492644995, -1.19442606, -0.550035,
        0.657981038, -1.17431402, -0.536337018,
        0.823460937, -1.12896597, -0.503105998,
        0.985512018, -1.09851897, -0.556743026,
        1.1262629, -1.10261405, -0.655970991,
        1.26176393, -1.19561696, -0.632036984,
        1.46294403, -1.13859296, -0.57673502,
        1.62431693, -1.09328699, -0.535269022,
        -1.67226899, -2.50400686, 0.690747023,
        -1.53051901, -2.56138492, 0.600842953,
        -1.377864, -2.58594298, 0.676002026,
        -1.21958399, -2.56116891, 0.747830987,
        -1.05960894, -2.52783012, 0.687668979,
        -1.9165051, 1.75526094, -1.53361201,
        -2.1580472, 1.44058204, 1.17954302,
        -1.68299413, 1.729527, -1.49732399,
        -0.929322004, -2.51791501, 0.576258004,
        -1.89000297, 1.46391296, 1.19287801,
        -1.51098299, -1.06537795, -0.588432014,
        -0.728435993, -2.57354093, 0.613536,
        -1.74887109, 1.48606503, 1.09316099,
        -1.35975301, -0.985610962, -0.617688,
        -0.604218006, -2.57013297, 0.730284035,
        -1.5765779, 1.44256496, 1.171314,
        -1.1873579, -1.013412, -0.612318039,
        -0.426788986, -2.59512901, 0.696350992,
        -1.01316297, -1.02150905, -0.591573,
        -0.257133007, -2.58034492, 0.626955032,
        -0.840654016, -1.02663898, -0.611577034,
        -0.705986977, -1.00253999, -0.508643985,
        -0.104088008, -2.57967615, 0.708657026,
        -0.583748996, -0.926450968, -0.592830002,
        0.0644010007, -2.57832003, 0.659489989,
        -0.430716008, -0.990965962, -0.612078011,
        0.239198998, -2.57510996, 0.681599975,
        -0.290715009, -0.908598065, -0.585699022,
        0.379929006, -2.575845, 0.79540801,
        -0.139958993, -0.96093595, -0.594492018,
        0.521390975, -2.51621103, 0.734162986,
        0.121893004, -1.001019, -0.594257951,
        0.606353998, -2.58643198, 0.602156997,
        0.270177007, -1.02637506, -0.53313601,
        0.772350073, -2.54993701, 0.625761032,
        0.419550002, -1.06120503, -0.479322016,
        0.944384933, -2.58259201, 0.620418012,
        0.560693979, -1.04449499, -0.582011998,
        1.20065999, -2.52746701, 0.632694006,
        0.723201036, -1.03878295, -0.619104028,
        1.36317301, -2.56798196, 0.62065196,
        0.834360003, -0.956813931, -0.521988034,
        1.52110195, -2.57768393, 0.543420017,
        0.987627029, -0.93690598, -0.601332009,
        1.61715293, -2.661057, 0.661550999,
        1.13935196, -0.939213037, -0.674448013,
        1.78419006, -2.60796595, 0.64585799,
        1.27026606, -1.03258801, -0.603263974,
        1.94180393, -2.52917099, 0.665504992,
        1.467237, -0.971861959, -0.638388038,
        -1.94200194, 1.97440803, -1.45132494,
        -1.75925112, 1.90258205, -1.48479605,
        -1.54815292, -2.38342786, 0.64379698,
        -1.37629807, -2.42142296, 0.613986015,
        -1.16694903, -2.39181304, 0.639365971,
        -1.00770903, -2.35498786, 0.665076017,
        -1.53874207, -0.885164976, -0.589236021,
        -0.847674012, -2.40541196, 0.669818997,
        -1.37672997, -0.809219956, -0.644147992,
        -0.678674996, -2.42523003, 0.686670005,
        -1.24952996, -0.870687008, -0.54618597,
        -0.505385995, -2.43672585, 0.720009029,
        -1.09407604, -0.864197969, -0.620835006,
        -0.340146005, -2.44939804, 0.697386026,
        -0.92205894, -0.870491982, -0.616665006,
        -0.186219007, -2.42668796, 0.637233019,
        -0.756453037, -0.833115041, -0.599270999,
        -0.0249899998, -2.436759, 0.635985017,
        -0.58919102, -0.768929958, -0.581505001,
        0.140969992, -2.42255998, 0.685518026,
        -0.441126019, -0.835839033, -0.550161004,
        0.269165993, -2.45091009, 0.795543015,
        -0.177522004, -0.778223991, -0.601637959,
        0.368631005, -2.39965796, 0.669812977,
        -2.16399288, 2.10480309, -1.51385999,
        -0.0297689997, -0.846789002, -0.550607979,
        0.520262957, -2.34846306, 0.716067016,
        0.121955998, -0.874686003, -0.486090004,
        0.653787017, -2.43564606, 0.670953035,
        -1.90560603, 2.16137695, -1.49418306,
        0.260901004, -0.815373063, -0.54973799,
        0.879108071, -2.44070101, 0.706664979,
        0.390542984, -0.899165988, -0.490626007,
        -1.78567791, 2.06445599, -1.39637399,
        1.04385602, -2.4637351, 0.628188014,
        0.525801003, -0.879482985, -0.595562994,
        1.17106497, -2.36184001, 0.606249034,
        0.674219966, -0.88914001, -0.521642983,
        1.30720198, -2.4138, 0.692306995,
        0.803772032, -0.790127993, -0.555065989,
        1.46233797, -2.43136787, 0.607676983,
        0.975794971, -0.775671005, -0.552971959,
        1.64640892, -2.48817611, 0.633455992,
        1.14940202, -0.786852002, -0.600602984,
        1.79687095, -2.43542695, 0.679884017,
        1.31782806, -0.882171035, -0.565250993,
        1.91947496, -2.37580514, 0.577742994,
        1.45915198, -0.794090986, -0.61768502,
        2.05324507, -2.40470386, 0.686883032,
        2.22142792, -2.384547, 0.669498026,
        -2.06207108, 2.25429606, -1.46676898,
        -1.30695903, -2.25872397, 0.65357101,
        -1.49186397, -0.678300023, -0.614351988,
        -1.13238299, -2.23499703, 0.688817978,
        -1.32963002, -0.616521001, -0.620927989,
        -0.957776964, -2.20151401, 0.608960986,
        -1.19795096, -0.725585997, -0.618413985,
        -0.74881798, -2.26992011, 0.694676995,
        -1.02359402, -0.705222011, -0.595839024,
        -0.580793977, -2.28915596, 0.701676011,
        -0.865841985, -0.713057995, -0.67377001,
        -0.393783033, -2.29207492, 0.659814,
        -0.719048977, -0.683453977, -0.523436964,
        -0.258363008, -2.32038307, 0.762278974,
        -0.55536902, -0.61679101, -0.547935009,
        -0.0916170031, -2.30656195, 0.730769992,
        -0.405630022, -0.673328996, -0.599931002,
        0.125111997, -2.24165392, 0.643482029,
        -0.243135005, -0.620429993, -0.571560025,
        0.229892999, -2.29396486, 0.76156801,
        -0.0910409987, -0.665205002, -0.520056009,
        0.507524967, -2.18186092, 0.68087399,
        0.0674970001, -0.711942017, -0.532109976,
        0.663432002, -2.25726891, 0.706403971,
        0.226136997, -0.649872005, -0.564015031,
        0.825546026, -2.24529314, 0.713841021,
        0.38834399, -0.709442973, -0.530595005,
        0.94758296, -2.31333613, 0.622707009,
        0.549432039, -0.640056014, -0.519279003,
        1.08324599, -2.23309207, 0.66750598,
        1.25341797, -2.22409821, 0.657948017,
        0.632799029, -0.751403928, -0.618026972,
        1.41062999, -2.27862597, 0.658640981,
        0.75237596, -0.632559001, -0.58889401,
        1.58029795, -2.33976293, 0.685122013,
        0.917478025, -0.618963003, -0.565073967,
        1.72833002, -2.28545094, 0.742370963,
        1.08455992, -0.640769958, -0.548483968,
        1.83352804, -2.23154116, 0.622802973,
        1.25299799, -0.670877993, -0.514271975,
        1.94371796, -2.28552294, 0.728426993,
        1.53808808, -0.657878995, -0.525156021,
        2.03704214, -2.16048002, 0.660600007,
        2.2127161, -2.17888188, 0.665835023,
        2.35949707, -2.27546096, 0.679700971,
        -1.23350406, -2.09769297, 0.653124034,
        -1.04319596, -2.09850907, 0.72776401,
        -1.456074, -0.507647991, -0.58564198,
        -0.962004066, -2.02463388, 0.603273034,
        -1.23974395, -0.584936976, -0.486318022,
        -0.818168998, -2.11487699, 0.653982043,
        -0.649782002, -2.13901806, 0.674489975,
        -1.13022006, -0.562896013, -0.622802973,
        -0.479498982, -2.16114593, 0.723321021,
        -0.944565058, -0.554775, -0.642660022,
        -0.312905997, -2.16598201, 0.738395989,
        -0.880824029, -0.641052008, -0.514077008,
        -0.145419002, -2.15211296, 0.696726024,
        -0.764901042, -0.533183992, -0.597860992,
        0.02073, -2.12497211, 0.714774013,
        -0.59751302, -0.517145991, -0.671289027,
        0.190311, -2.12574911, 0.746528983,
        0.362295002, -2.11119294, 0.751034975,
        -0.371646017, -0.516129017, -0.53965801,
        0.582252026, -2.03591704, 0.625151992,
        -0.222599983, -0.447314978, -0.566262007,
        0.733916998, -2.097615, 0.685559988,
        -0.0903809965, -0.504626989, -0.481359005,
        0.942282021, -2.13906002, 0.659726977,
        0.052466996, -0.53937304, -0.555209994,
        1.06431901, -2.02799392, 0.715686023,
        0.195035994, -0.497184008, -0.630272985,
        1.23469794, -2.06065798, 0.704981983,
        0.350642979, -0.536412001, -0.554558992,
        1.39524305, -2.09907293, 0.745682955,
        0.510803998, -0.483521998, -0.567171037,
        1.5036931, -2.22366905, 0.780875981,
        0.673979998, -0.515084982, -0.506559014,
        1.64025593, -2.13655806, 0.735396028,
        0.819378018, -0.465312004, -0.600338995,
        1.75781107, -2.08096194, 0.633773983,
        1.08033609, -0.511022985, -0.666723013,
        1.18975806, -0.507165015, -0.530883014,
        1.89607811, -2.09956789, 0.741173983,
        1.37701201, -0.583649993, -0.590621948,
        2.00934315, -1.99392307, 0.664080024,
        2.16779089, -2.01483893, 0.709374011,
        2.32820106, -2.06638193, 0.729008973,
        2.49643493, -2.11145115, 0.706928968,
        -1.32342303, -1.95564902, 0.696218967,
        -1.149207, -1.96160102, 0.724862993,
        -1.00694394, -1.87901092, 0.692987978,
        -0.864102006, -1.96576202, 0.729086995,
        -0.703794003, -1.973436, 0.658955991,
        -0.533388019, -2.03449798, 0.63012898,
        -1.28797507, -0.443408966, -0.622964978,
        -0.418175995, -1.932621, 0.697224021,
        -1.20437706, -0.292701006, -0.571874976,
        -0.251649022, -2.02274108, 0.677958012,
        -1.04503798, -0.408369005, -0.616667986,
        -0.0867899954, -1.98572397, 0.74733001,
        -0.871173024, -0.398111999, -0.612429023,
        0.0917069986, -1.97241306, 0.739818037,
        -0.691905022, -0.378209978, -0.629397035,
        0.26138401, -1.97018695, 0.771981001,
        -0.52037096, -0.347543985, -0.668465972,
        0.422846973, -1.98115802, 0.664004982,
        -0.392783999, -0.353601009, -0.554036975,
        0.563243985, -1.9034369, 0.73250103,
        -0.222104996, -0.279938996, -0.559370995,
        0.723621011, -1.93231511, 0.670518041,
        -0.0591330007, -0.356168985, -0.544673979,
        0.890805006, -1.98077393, 0.698109031,
        0.109949991, -0.372783005, -0.538583994,
        1.03547096, -1.87695003, 0.79123503,
        0.278411984, -0.377247036, -0.533514023,
        1.22922301, -1.89826798, 0.742835999,
        0.349862993, -0.423584998, -0.681939006,
        1.37498403, -1.96164894, 0.638355017,
        0.505301952, -0.330807, -0.647556007,
        1.53055501, -2.00338507, 0.715937972,
        0.658746004, -0.408975005, -0.638391018,
        1.69200301, -1.96948206, 0.744047999,
        0.898829937, -0.352647007, -0.488700002,
        1.84569001, -1.92992699, 0.640793979,
        0.967088938, -0.379839003, -0.643359005,
        1.97902799, -1.87093496, 0.761373043,
        1.14369297, -0.354764998, -0.612159014,
        2.132442, -1.82771409, 0.711645007,
        1.332744, -0.413345993, -0.555611968,
        2.2862401, -1.89107108, 0.73517102,
        2.44128895, -1.94671202, 0.756210029,
        2.5762229, -1.94700599, 0.651932955,
        -1.86151791, -1.79128504, 0.664620042,
        -1.68865192, -1.83189905, 0.721086025,
        -1.49066401, -1.894014, 0.720677972,
        -1.32475793, -1.78817701, 0.689267993,
        -1.16795707, -1.7902081, 0.763988972,
        -1.00663197, -1.71357608, 0.745365024,
        -1.15031099, -0.129320994, -0.513144016,
        -0.856229961, -1.79176497, 0.704375982,
        -1.034181, -0.241607994, -0.570594013,
        -0.693468034, -1.79713202, 0.671057999,
        -0.868901968, -0.196824014, -0.564440966,
        -0.538815022, -1.81023598, 0.751860023,
        -0.698414981, -0.180618003, -0.566226006,
        -0.363687009, -1.77674699, 0.774197996,
        -0.525756001, -0.188894987, -0.592296004,
        -0.248183995, -1.85883307, 0.670758009,
        -0.359501988, -0.211833, -0.634508967,
        -0.0780270025, -1.81193113, 0.679311037,
        -0.352131009, -0.214109987, -0.462321013,
        0.137823001, -1.80461097, 0.70755899,
        -0.0820830017, -0.220340997, -0.641942978,
        0.276672006, -1.87953007, 0.637274981,
        0.0963240042, -0.192936003, -0.645336032,
        0.422178, -1.81684506, 0.689741969,
        0.220616996, -0.217226982, -0.53314501,
        0.578250051, -1.74539399, 0.671181023,
        0.349104017, -0.250245005, -0.647589028,
        0.740720987, -1.7635529, 0.646242023,
        0.868808985, -1.81743598, 0.751376987,
        0.480843008, -0.199643999, -0.544595957,
        1.00895703, -1.73468089, 0.706553996,
        0.646812022, -0.234059989, -0.594335973,
        1.17045605, -1.80777597, 0.611645997,
        0.82179296, -0.216432005, -0.56813097,
        1.32570601, -1.83235192, 0.542048991,
        1.51296294, -1.84775996, 0.647118032,
        1.67324102, -1.81319714, 0.699939013,
        1.832286, -1.79042101, 0.745481968,
        1.96824312, -1.78118706, 0.614234984,
        2.12693691, -1.65867305, 0.699221969,
        2.29172707, -1.69036496, 0.714033008,
        2.432796, -1.78376102, 0.692855954,
        2.60083795, -1.78487706, 0.742211998,
        -2.00859904, -1.678473, 0.653639972,
        -1.75665903, -1.67095208, 0.731159985,
        -1.57060814, -1.71138597, 0.714024007,
        -1.42166698, -1.64513397, 0.689414978,
        -1.28651404, -1.66532099, 0.793451965,
        -1.14282894, -1.60768199, 0.733500004,
        -0.996008992, -1.54112697, 0.769892931,
        -0.832409978, -1.62509704, 0.753401995,
        -0.662429988, -1.63389611, 0.713084996,
        -0.469680011, -1.64437509, 0.750351012,
        -0.322416008, -1.59916496, 0.800499022,
        -0.354798019, -0.0613709986, -0.536586046,
        -0.212202013, -1.70998192, 0.729072034,
        -0.186995998, -0.0945540071, -0.582131982,
        -0.0862109959, -1.63887298, 0.642467976,
        -0.00649499986, -0.0812669992, -0.561215997,
        0.0698039979, -1.64412296, 0.730343997,
        0.196820989, -0.0558030009, -0.588734984,
        0.289685994, -1.71360898, 0.665951967,
        0.371550024, -0.0783089995, -0.616712987,
        0.44174701, -1.67317808, 0.608117998,
        0.538680017, -0.0407880023, -0.564491987,
        0.533408999, -1.58708096, 0.726363003,
        0.716933966, -0.0707940012, -0.566181004,
        0.698171973, -1.62180901, 0.736856997,
        0.873975039, -1.6312499, 0.727079988,
        1.03547692, -1.58590794, 0.762503982,
        1.19424903, -1.59120905, 0.80104506,
        1.31212199, -1.74702001, 0.687914968,
        1.44442797, -1.71127486, 0.580572009,
        1.72689593, -1.65593398, 0.74911201,
        1.87121701, -1.63839006, 0.678231001,
        1.999614, -1.53942013, 0.727841973,
        2.15646601, -1.51592398, 0.783654034,
        2.28662395, -1.51360512, 0.669809997,
        2.43445206, -1.59615302, 0.686753988,
        2.60484886, -1.61908507, 0.674858987,
        -2.27653503, -1.44202507, 0.715991974,
        -2.13679504, -1.55102706, 0.669039011,
        -2.03128195, -1.44894302, 0.537656963,
        -1.88355899, -1.56025207, 0.678402007,
        -1.68017101, -1.52359807, 0.733353019,
        -1.51085401, -1.50025201, 0.744791985,
        -1.29626703, -1.51077604, 0.73784101,
        -1.12761307, -1.43965197, 0.712553978,
        -0.968382001, -1.43501401, 0.629652023,
        -0.878039956, -1.425192, 0.770544052,
        -0.746625006, -1.48897803, 0.674538016,
        -0.541794002, -1.53916204, 0.647570968,
        -0.448550999, -1.43382001, 0.735630035,
        -0.212181002, -1.54553413, 0.696927011,
        -0.108162001, -1.47050095, 0.589359045,
        0.0469859987, -1.52165985, 0.61443603,
        0.199854016, -1.57821, 0.648815989,
        0.359991014, -1.54595113, 0.688055992,
        0.491540998, -1.43779802, 0.660422981,
        0.652440012, -1.48689604, 0.64795202,
        0.819344997, -1.47792602, 0.671603978,
        0.97784096, -1.43796301, 0.713979006,
        1.147596, -1.47067797, 0.678086996,
        1.29569697, -1.57022405, 0.675363004,
        1.45973396, -1.57711792, 0.674753964,
        1.555197, -1.57715392, 0.806684971,
        1.78423798, -1.49843097, 0.736098051,
        1.90878904, -1.395504, 0.710465968,
        2.05901408, -1.37594998, 0.775256991,
        2.22833395, -1.37044799, 0.740679026,
        2.39432096, -1.361745, 0.697833002,
        2.54249716, -1.45613396, 0.70817697,
        -2.35452604, -1.28170204, 0.694712996,
        -2.14559388, -1.37045097, 0.63282299,
        -1.984074, -1.31652594, 0.649155021,
        -1.80980992, -1.39966202, 0.728498995,
        -1.63627195, -1.36418998, 0.737553,
        -1.52707493, -1.25033402, 0.672621012,
        -1.399629, -1.3794961, 0.699734986,
        -1.25611198, -1.35619199, 0.797565043,
        -1.07490599, -1.28021097, 0.690644979,
        -0.906578958, -1.28193903, 0.67762804,
        -0.753087044, -1.32343197, 0.730490983,
        -0.605589032, -1.38472807, 0.67020905,
        -0.476801991, -1.28050804, 0.68087101,
        -0.257858992, -1.39351499, 0.664707005,
        -0.106632002, -1.308285, 0.653504968,
        0.062138997, -1.28792703, 0.628862977,
        0.165933013, -1.41681004, 0.673316956,
        0.334665, -1.37897706, 0.694023013,
        0.55834198, -1.29287696, 0.601152003,
        0.721392035, -1.33601403, 0.63340497,
        0.888422966, -1.31516695, 0.636627018,
        1.06155598, -1.31820607, 0.632766008,
        1.20996904, -1.31140506, 0.706247985,
        1.33343101, -1.41099, 0.647786975,
        1.49687696, -1.30751705, 0.713862002,
        1.61718297, -1.41191101, 0.799823999,
        1.76577592, -1.32175207, 0.736727953,
        1.95859194, -1.23756599, 0.700824022,
        2.11641288, -1.26889491, 0.651293993,
        -2.4701581, -1.14910197, 0.706736982,
        -2.24488211, -1.16751003, 0.763583958,
        -2.11611605, -1.20856798, 0.664739966,
        -1.98697209, -1.15034699, 0.753386974,
        -1.85295606, -1.21749902, 0.678341985,
        -1.63224602, -1.13443506, 0.728096962,
        -1.46460605, -1.093701, 0.657480001,
        -1.36218905, -1.21953905, 0.693989992,
        -1.20900595, -1.19580603, 0.763764024,
        -1.09176898, -1.11218095, 0.665657997,
        -0.945758939, -1.13571906, 0.748008013,
        -0.791646004, -1.16004896, 0.695201993,
        -0.630155981, -1.18857598, 0.739652991,
        -0.519437969, -1.13191497, 0.627290964,
        -0.35868901, -1.14591897, 0.668256044,
        -0.19210799, -1.1724, 0.728106022,
        -0.0337920003, -1.15350902, 0.671922028,
        0.147711009, -1.14120901, 0.629999995,
        0.402114004, -1.23019207, 0.640842021,
        0.534767985, -1.12514102, 0.65237999,
        0.694613993, -1.17767692, 0.68384099,
        0.865571976, -1.14932704, 0.656585991,
        1.03503609, -1.16189396, 0.685464025,
        1.21670997, -1.15809, 0.640881002,
        1.36652708, -1.24412107, 0.622079968,
        1.51015806, -1.15017605, 0.658845007,
        1.63127697, -1.23045897, 0.759059966,
        1.8031621, -1.15469408, 0.697107017,
        1.95023394, -1.07854795, 0.650888979,
        2.09510088, -1.12235999, 0.751394987,
        -2.34725404, -1.03115702, 0.738959968,
        -2.210253, -0.933975041, 0.759474039,
        -2.07926083, -1.03842592, 0.662312984,
        -1.90097094, -1.02438593, 0.66513598,
        -1.75485599, -1.09335601, 0.616838992,
        -1.58775902, -0.983097017, 0.661103964,
        -1.37455499, -0.956541002, 0.650178015,
        -1.25741696, -1.09895098, 0.626154006,
        -1.19036698, -0.996798038, 0.748292983,
        -1.01671505, -0.986297965, 0.756507039,
        -0.878937006, -0.99981606, 0.654518962,
        -0.719573975, -1.012308, 0.716270983,
        -0.576077998, -1.03919995, 0.796560049,
        -0.417681009, -1.00836897, 0.74733299,
        -0.257853001, -1.01810098, 0.697062016,
        -0.108987004, -0.949730992, 0.729449987,
        0.0432810001, -1.000476, 0.659636974,
        0.151443005, -1.04481602, 0.777719975,
        0.306213021, -1.09120798, 0.603168011,
        0.44383201, -0.993090034, 0.598067999,
        0.611541033, -0.967686057, 0.70667702,
        0.771192074, -1.03148997, 0.721076965,
        0.954912007, -1.00598693, 0.657101989,
        1.13978994, -1.04691601, 0.747014999,
        1.27412403, -0.980646014, 0.666152954,
        1.48184097, -1.00456202, 0.767673016,
        1.63617897, -1.06926608, 0.734445035,
        1.75209904, -1.00353909, 0.634551048,
        1.8926971, -0.924890995, 0.597674966,
        2.09207392, -0.975558043, 0.643746018,
        -2.50968885, -0.961920023, 0.707381964,
        -2.34900618, -0.887639999, 0.643548012,
        -2.2227869, -0.782600999, 0.678972006,
        -2.03968191, -0.908303976, 0.753555,
        -1.88022602, -0.865772963, 0.738123,
        -1.74375594, -0.942618012, 0.687357008,
        -1.50086713, -0.842154026, 0.622550964,
        -1.34634602, -0.799001992, 0.593271017,
        -1.21972501, -0.932520032, 0.587981999,
        -1.11140108, -0.853085995, 0.703346968,
        -0.949268997, -0.841356039, 0.683799028,
        -0.799673975, -0.86631, 0.743699968,
        -0.659321964, -0.81348896, 0.67403698,
        -0.525884986, -0.884855986, 0.74702698,
        -0.25365299, -0.871178985, 0.781055927,
        -0.205487996, -0.890679002, 0.605612993,
        -0.119711995, -0.789498031, 0.728277028,
        0.0231870003, -0.865512013, 0.777351022,
        0.135201007, -0.853961945, 0.646677017,
        0.297098994, -0.923430026, 0.656360984,
        0.471944988, -0.861878991, 0.696632981,
        0.628389001, -0.810858011, 0.64410001,
        0.775749028, -0.892983019, 0.631161034,
        0.938885987, -0.835826993, 0.627539992,
        1.08917403, -0.90515399, 0.659156978,
        1.23879302, -0.821444988, 0.642072022,
        1.50826192, -0.825920999, 0.760074019,
        1.64405394, -0.900741041, 0.709415972,
        1.77301204, -0.811550975, 0.645462036,
        1.92631793, -0.802043974, 0.706355989,
        2.078583, -0.798228025, 0.622539043,
        -2.48214602, -0.797666967, 0.695168972,
        -2.49310207, -0.614382029, 0.708144009,
        -2.33147407, -0.658385992, 0.719244003,
        -2.06222391, -0.750947952, 0.703814983,
        -1.81944299, -0.633662999, 0.755535007,
        -1.74475193, -0.774647951, 0.684590995,
        -1.598526, -0.702998996, 0.649775982,
        -1.45561802, -0.678149998, 0.57583499,
        -1.33800602, -0.665123999, 0.696681023,
        -1.19513404, -0.742982984, 0.613278031,
        -1.02774, -0.703559995, 0.74790597,
        -0.823415995, -0.64854598, 0.690198004,
        -0.659103036, -0.654738009, 0.730278015,
        -0.503840983, -0.723533988, 0.711179972,
        -0.362625003, -0.628578007, 0.727217972,
        -0.261431992, -0.742659032, 0.664074004,
        -0.126287997, -0.625406981, 0.700551033,
        0.0211440008, -0.723767996, 0.671421051,
        0.188519999, -0.693816006, 0.671934009,
        0.334631979, -0.760805964, 0.713174999,
        0.503948987, -0.699029982, 0.712656021,
        0.671306968, -0.670515001, 0.715779006,
        0.82060504, -0.757692039, 0.718778968,
        -1.89336598, 1.119699, -0.546471,
        0.940599024, -0.662589014, 0.657881975,
        1.092219, -0.739449024, 0.653310001,
        1.38770103, -0.74731195, 0.648330033,
        1.50671101, -0.656883001, 0.723254979,
        1.65405297, -0.731531978, 0.73547399,
        1.78182006, -0.643271983, 0.652296007,
        1.92507899, -0.696015, 0.575954974,
        2.04409814, -0.630668998, 0.686177969,
        -2.60481906, -0.480207026, 0.705963016,
        -2.42915988, -0.468698978, 0.644064009,
        -2.26386595, -0.515579998, 0.60790801,
        -2.12220001, -0.477800965, 0.703940988,
        -1.99206901, -0.593138993, 0.710147977,
        -1.69800603, -0.568305016, 0.677487016,
        -1.54958987, -0.544914007, 0.614375949,
        -1.42071295, -0.512624979, 0.731624961,
        -1.26301503, -0.506210983, 0.674498975,
        -1.12715101, -0.595866024, 0.648290992,
        -0.967628956, -0.563214004, 0.681326985,
        -0.831717014, -0.480729014, 0.741029978,
        -0.664290011, -0.490613997, 0.773018956,
        -0.535037994, -0.556007981, 0.672417045,
        -2.1230669, 1.292889, -0.516057014,
        -0.383222997, -0.461786985, 0.69747299,
        -1.94285095, 1.29323101, -0.535526991,
        -0.237540007, -0.51740402, 0.755303979,
        -1.68773103, 1.26230097, -0.587154031,
        -0.0675719976, -0.443973005, 0.679368019,
        0.0373860002, -0.569594979, 0.724599004,
        0.179021999, -0.481814981, 0.709022999,
        0.320562005, -0.591897011, 0.656340003,
        0.474815995, -0.532092035, 0.679157972,
        0.641313016, -0.500105977, 0.682493985,
        0.792831063, -0.582450032, 0.649976969,
        1.03989601, -0.532602012, 0.655194044,
        1.19216096, -0.594609022, 0.66662395,
        1.30773306, -0.457569003, 0.659696996,
        1.46793604, -0.504486024, 0.670734048,
        1.58703303, -0.425076008, 0.585774004,
        1.74408603, -0.483137995, 0.713981986,
        1.90288186, -0.527808011, 0.679214954,
        -2.10262799, 1.47507, -0.543558002,
        -2.56221008, -0.308930993, 0.70609802,
        -1.85149789, 1.44947398, -0.518337011,
        -2.3858881, -0.305316001, 0.602972984,
        -1.63691103, 1.43170798, -0.537227988,
        -2.24254513, -0.353742003, 0.685212016,
        -2.0761261, -0.31211102, 0.661625981,
        -1.96910095, -0.445086002, 0.628742993,
        -1.82087111, -0.461645991, 0.727052987,
        -1.67145002, -0.401087999, 0.674126983,
        -1.50517797, -0.389060974, 0.64704299,
        -1.35383403, -0.325806022, 0.687093019,
        -1.17688799, -0.383270979, 0.750797987,
        -1.05992699, -0.424818009, 0.636231005,
        -0.909170985, -0.344648987, 0.674861968,
        -0.74318701, -0.349317014, 0.666020989,
        -0.590292037, -0.403656006, 0.642111003,
        -0.45390898, -0.315420002, 0.661563039,
        -0.278199017, -0.324714005, 0.688601971,
        -0.119376004, -0.318777025, 0.775448978,
        0.0580950007, -0.315824986, 0.687852025,
        0.200111985, -0.326907009, 0.778341055,
        0.358335018, -0.293531984, 0.718311012,
        0.524604023, -0.368589014, 0.679307997,
        0.749508023, -0.376098007, 0.636543036,
        0.89390707, -0.456681013, 0.646472991,
        0.944468975, -0.308144987, 0.602267981,
        1.15074003, -0.417849004, 0.633203983,
        1.26652205, -0.289655983, 0.619442999,
        1.42999494, -0.347057998, 0.612986982,
        1.62999892, -0.341975987, 0.719379008,
        1.73707795, -0.234734997, 0.648698986,
        1.83859801, -0.373800009, 0.629343033,
        -2.04667497, 1.65166187, -0.551310003,
        -1.85982907, 1.62867594, -0.597561002,
        -1.65984607, 1.61690688, -0.559152007,
        -2.449965, -0.172719002, 0.693755984,
        -2.27760911, -0.187146008, 0.661424994,
        -2.11974597, -0.120591, 0.625646949,
        -1.93082392, -0.221399993, 0.649886966,
        -1.81484389, -0.340556979, 0.60906899,
        -1.72250998, -0.178793997, 0.649002016,
        -1.58400893, -0.259647012, 0.724698007,
        -1.42998004, -0.177633002, 0.731418014,
        -1.20867002, -0.22281301, 0.692649007,
        -1.04800797, -0.278735995, 0.730325997,
        -0.890339971, -0.192123011, 0.739503026,
        -0.724140048, -0.196925998, 0.767145038,
        -0.598901987, -0.22339499, 0.657236993,
        -0.370346993, -0.176514, 0.640574992,
        -0.207188994, -0.173942998, 0.674061,
        -0.0409860015, -0.179585993, 0.721352994,
        0.126135007, -0.170111999, 0.770678997,
        0.221283004, -0.0337140001, 0.747060001,
        0.314258993, -0.139329001, 0.670665026,
        0.473939985, -0.180776998, 0.652770042,
        0.637244999, -0.247764006, 0.628188014,
        0.802649975, -0.212235004, 0.621209979,
        0.964617014, -0.146450996, 0.591312051,
        1.09944904, -0.250055999, 0.628602028,
        1.33961701, -0.164804995, 0.696521997,
        1.43993998, -0.177717, 0.568289995,
        1.61359215, -0.113049001, 0.678546011,
        1.797966, -0.0839670002, 0.707006991,
        1.90137005, -0.221042991, 0.685518026,
        -2.15723085, 1.79646301, -0.576632977,
        -1.97732115, 1.87294793, -0.540708005,
        -1.80901504, 1.78970098, -0.514692008,
        -2.39613914, -0.00910800043, 0.708606005,
        -2.26584911, -0.0280109979, 0.605342984,
        -2.107692, 0.047460001, 0.636575997,
        -1.96233892, -0.0496440008, 0.644064009,
        -1.84021807, -0.111687005, 0.747116983,
        -1.68070507, -0.033168003, 0.721770048,
        -1.55922294, -0.113027997, 0.643911004,
        -1.42337406, -0.0180930011, 0.679251015,
        -1.2674129, -0.065609999, 0.636813045,
        -1.03677905, -0.125909999, 0.791898012,
        -0.941159964, -0.0455820002, 0.674142003,
        -0.76840198, -0.0510869995, 0.698351979,
        -0.588657022, 0.0551849976, 0.640725017,
        -0.416571021, 0.0221309997, 0.709287047,
        -0.275705993, -0.0260609984, 0.624879003,
        -0.111023992, 0.0246569999, 0.696557999,
        0.049812004, -0.0313050002, 0.701238036,
        0.176789999, 0.0658020005, 0.628208995,
        0.341753989, 0.0295589995, 0.638006985,
        0.504960001, -0.0140249999, 0.635843992,
        0.633374989, -0.095250003, 0.69333601,
        0.79094398, -0.0492689982, 0.672639012,
        0.954174042, -0.0140819997, 0.702987015,
        1.110165, -0.0857160017, 0.648903012,
        1.24776304, 0.0220379997, 0.655607998,
        1.41094196, -0.021156, 0.645614982,
        1.55198693, 0.0439649969, 0.710207999,
        1.71284699, 0.0543389991, 0.76748395,
        -0.0792330056, 1.84522498, -0.526635051,
        0.12520501, 1.86272097, -0.584363997,
        -2.68972206, 0.0623969994, 0.653771996,
        -2.56733108, -0.0421049967, 0.727772951,
        -2.43625212, 0.151602, 0.686841011,
        -2.27231407, 0.105489001, 0.713456988,
        -2.1765151, 0.198569983, 0.612369001,
        -1.97044492, 0.101886004, 0.727074027,
        -1.8169589, 0.0357839987, 0.660221994,
        -1.66878605, 0.128511012, 0.749271035,
        -1.56211495, 0.0620879978, 0.636911988,
        -1.247805, 0.100869, 0.67969799,
        -1.13284504, 0.00442200014, 0.764247,
        -0.978011966, 0.0963480026, 0.750455976,
        -0.911264956, 0.101870999, 0.594479978,
        -0.812262058, 0.105008997, 0.729435027,
        -0.663504004, 0.183063, 0.718527019,
        -0.478725016, 0.175299004, 0.67198199,
        -0.318468004, 0.144530997, 0.640143037,
        -0.157178998, 0.183246002, 0.676872015,
        0.0149370003, 0.142551005, 0.676991999,
        0.160427988, 0.167058006, 0.761079073,
        0.309518993, 0.192069009, 0.673910975,
        0.462786019, 0.15248999, 0.607755005,
        0.658484995, 0.0722910017, 0.682904959,
        0.830282986, 0.0978600085, 0.737619042,
        0.956915975, 0.157235995, 0.648747027,
        1.09303796, 0.0733620003, 0.689679027,
        1.30224299, 0.181083009, 0.650631011,
        1.43213701, 0.156009004, 0.757175982,
        1.60236001, 0.192798018, 0.794028044,
        -0.231539994, 2.01968098, -0.577769995,
        -0.0375299975, 1.99963796, -0.621320963,
        0.133623004, 2.048949, -0.565322995,
        -2.75930119, 0.227522999, 0.66190201,
        -2.6001358, 0.190490991, 0.733067989,
        -2.46902704, 0.301818013, 0.753587961,
        -2.30317807, 0.27323699, 0.709607959,
        -2.12334895, 0.336759001, 0.696282029,
        -1.95135307, 0.278796017, 0.745496988,
        -1.852386, 0.197382003, 0.646389008,
        -1.72231197, 0.285194993, 0.696474016,
        -1.55988002, 0.23823899, 0.67554599,
        -1.41565502, 0.147248998, 0.666401982,
        -1.29079199, 0.264420003, 0.665286005,
        -1.12698901, 0.236925006, 0.667172968,
        -0.967539072, 0.253295988, 0.634343982,
        -0.721352994, 0.342266977, 0.735374987,
        -0.549719989, 0.314103007, 0.717033029,
        -0.355646998, 0.300764978, 0.698588967,
        -0.196355999, 0.337565988, 0.735626996,
        -0.0365580022, 0.30942601, 0.664011002,
        0.0831059963, 0.315254986, 0.819243014,
        0.229481995, 0.319110006, 0.742385983,
        0.289178997, 0.342123002, 0.589583993,
        0.458871007, 0.333810002, 0.630101979,
        0.749520004, 0.214338005, 0.651881993,
        0.876057029, 0.28243798, 0.73842299,
        1.03375506, 0.305220008, 0.682322979,
        1.15316403, 0.215658009, 0.753012061,
        -0.25128001, 2.24154615, -0.619530022,
        1.30592096, 0.280712992, 0.792369008,
        -0.0870239958, 2.16873002, -0.563811004,
        1.49843693, 0.296586007, 0.666924,
        -2.74220085, 0.392921984, 0.605159998,
        -2.61654902, 0.367350012, 0.723504007,
        -2.44244409, 0.443175018, 0.656432986,
        -2.26602602, 0.436392009, 0.665973008,
        -2.13393903, 0.504603028, 0.749067008,
        -1.96968889, 0.44561398, 0.737544,
        -1.79828703, 0.436436981, 0.715529978,
        -1.60737598, 0.405764997, 0.681113958,
        -1.48131299, 0.503691018, 0.61175698,
        -1.43154001, 0.350741982, 0.661068022,
        -1.19306099, 0.398159981, 0.702197969,
        -1.04283595, 0.40792501, 0.64585501,
        -0.887238026, 0.384254992, 0.705902994,
        -0.777417004, 0.511728048, 0.701520026,
        -0.611850023, 0.468998998, 0.684939027,
        -0.439937979, 0.444665998, 0.688458025,
        -0.271946996, 0.49217099, 0.713199019,
        -0.155220002, 0.428885996, 0.597186029,
        0.0582450032, 0.440751016, 0.708912015,
        -0.224936992, 2.42640591, -0.613083005,
        0.208578005, 0.476100028, 0.77492106,
        -0.0619979985, 2.35296011, -0.559800029,
        0.325800002, 0.492956996, 0.651677966,
        0.489014983, 0.509451032, 0.709329009,
        0.618800998, 0.403115988, 0.637299001,
        0.784779072, 0.379758, 0.631229997,
        0.935805023, 0.448467016, 0.68918699,
        1.18452597, 0.382602006, 0.728819966,
        1.35602701, 0.409982979, 0.683529019,
        -2.74048185, 0.549843013, 0.687771022,
        -2.56416893, 0.533946037, 0.760103941,
        -2.39276695, 0.564782977, 0.759582043,
        -2.31066895, 0.589245021, 0.601494014,
        -2.23475409, 0.64051497, 0.751626015,
        -2.0090909, 0.610614002, 0.713618994,
        -1.83772802, 0.602007031, 0.736433983,
        -1.66497898, 0.564126015, 0.72060895,
        -1.39470899, 0.633212984, 0.556629002,
        -1.30963206, 0.501495004, 0.629547,
        -1.10825706, 0.59186101, 0.640043974,
        -0.945717037, 0.544857025, 0.662028015,
        -0.115247995, 2.51998806, -0.496667981,
        -0.102239996, 0.547205985, 0.73130703,
        0.0511860028, 0.59841001, 0.639419973,
        0.21700801, 0.625532985, 0.698925018,
        0.380892009, 0.65326798, 0.64618504,
        0.553388953, 0.66040802, 0.645105004,
        0.684267044, 0.558098972, 0.602373004,
        0.844604969, 0.519171, 0.559643984,
        0.998468995, 0.597074986, 0.613400996,
        1.1154151, 0.542445004, 0.738983989,
        -2.52891898, 0.704355001, 0.786998987,
        -2.3864069, 0.718110025, 0.696927011,
        -2.26322412, 0.808313966, 0.769793987,
        -2.05684805, 0.753636003, 0.636170983,
        -1.883955, 0.712865949, 0.613800049,
        -1.72064996, 0.725456953, 0.676527023,
        -1.552719, 0.694922984, 0.686942995,
        -1.39730692, 0.758783937, 0.677084982,
        -1.25776494, 0.668372989, 0.642398953,
        -1.12652397, 0.751532972, 0.717236996,
        -2.63392186, 0.811230004, 0.698810995,
        -2.34968996, 0.870752931, 0.630641997,
        -2.19886494, 1.00300503, 0.590786994,
        -2.12828112, 0.89210397, 0.712643981,
        -1.95641088, 0.886730969, 0.665937006,
        -1.78999794, 0.874494016, 0.631356001,
        -1.61697292, 0.860241055, 0.610793948,
        -1.40705097, 0.917307019, 0.622220993,
        -1.25285399, 0.843518972, 0.646224022,
        -2.65916395, 0.982956052, 0.696801007,
        -2.49176407, 1.01465702, 0.711005986,
        -2.35668588, 1.04329503, 0.616712987,
        -2.04661202, 1.03079998, 0.663605988,
        -1.8784709, 1.03399205, 0.635217011,
        -1.70981097, 1.02895498, 0.620418012,
        -1.54395294, 1.017102, 0.642257988,
        -1.38513005, 1.07701504, 0.67759198,
        -1.23197401, 1.01420093, 0.638589025,
        -2.64923382, 1.154055, 0.656901002,
        -2.4759841, 1.1813581, 0.640847981,
        -2.3076148, 1.19765401, 0.673554003,
        -2.06453085, 1.16379297, 0.781967998,
        -1.96998286, 1.18141496, 0.635850012,
        -1.79399407, 1.18515599, 0.627030015,
        -1.61959195, 1.18555498, 0.617604017,
        -1.44233704, 1.22545803, 0.628746033,
        -1.259745, 1.18622696, 0.609713972,
        -2.63080812, 1.32710397, 0.691500008,
        -2.45384097, 1.35363901, 0.692636967,
        -2.22975302, 1.32982194, 0.746945977,
        -2.07166791, 1.306023, 0.692790031,
        -1.90508103, 1.34383798, 0.601550996,
        -1.733706, 1.34636104, 0.589892983,
        -1.55968785, 1.34643602, 0.602165997,
        -1.373577, 1.37097001, 0.566864967,
        -1.30981505, 1.31493902, 0.718188047,
        -1.80269098, -2.66886592, 1.33682394,
        -1.64257193, -2.71471214, 1.27366495,
        -1.49897993, -2.71320009, 1.38127208,
        -1.33418107, -2.71380281, 1.31090999,
        -1.16933107, -2.69270992, 1.37653494,
        -1.02374101, -2.7097888, 1.28180397,
        -0.832569003, -2.7133739, 1.34319293,
        -0.662418008, -2.67467093, 1.37408698,
        -2.32123804, 1.47039294, 0.703956008,
        -2.13800406, 1.51078498, 0.709545016,
        -1.96565986, 1.52080202, 0.677451015,
        -1.79678106, 1.51834202, 0.62807703,
        -1.64981699, 1.46021998, 0.697070956,
        -1.47384596, 1.48558199, 0.667320013,
        0.97844696, -2.69076896, 1.32321298,
        1.16207409, -2.68629289, 1.31250596,
        -1.76666403, -2.51571894, 1.25799906,
        -1.60360193, -2.54748011, 1.29534292,
        -1.44691491, -2.49550486, 1.28567696,
        -1.29282594, -2.50614905, 1.34451008,
        -1.12565398, -2.52378011, 1.3534739,
        -0.961877942, -2.56576204, 1.35694194,
        -0.797403038, -2.54699397, 1.37381399,
        -0.644805014, -2.48928905, 1.39927197,
        -0.539168954, -2.4872191, 1.267869,
        -0.391184986, -2.45100307, 1.33044302,
        -0.27325201, -2.55293107, 1.28603697,
        -0.123473994, -2.55267286, 1.362198,
        0.0442919992, -2.55227995, 1.31436896,
        0.189653993, -2.52955198, 1.40580893,
        0.356411994, -2.54862881, 1.32288301,
        0.832089007, -2.60254788, 1.27802396,
        1.01555705, -2.52828598, 1.28926802,
        1.175583, -2.53463984, 1.23046494,
        1.33350897, -2.56760406, 1.29092693,
        -1.69612205, -2.35655999, 1.22900999,
        -1.56380403, -2.26363802, 1.30288196,
        -1.40784597, -2.33647799, 1.34573698,
        -1.14647698, -2.39400005, 1.25226593,
        -0.977450967, -2.41420794, 1.28355896,
        -0.845463037, -2.38058996, 1.40476203,
        -0.653409004, -2.36093998, 1.28646004,
        -0.487523973, -2.32277393, 1.33324194,
        -0.311603993, -2.30799294, 1.29809403,
        -0.182328001, -2.41602302, 1.26212704,
        -0.0549599975, -2.3934629, 1.38161993,
        0.110349, -2.39037585, 1.34189701,
        0.272552997, -2.39744687, 1.28947198,
        0.446105987, -2.39031291, 1.33658099,
        0.527646005, -2.52848387, 1.29810894,
        0.713663995, -2.38351488, 1.281093,
        0.85384202, -2.3242619, 1.36151099,
        1.01941502, -2.37059116, 1.34409308,
        1.19007003, -2.3828249, 1.30191004,
        1.35372901, -2.39333987, 1.36691701,
        1.49102402, -2.40496802, 1.26167703,
        -1.41146696, -2.20814705, 1.22808003,
        -1.24468803, -2.34650993, 1.38149691,
        -1.14219904, -2.22306013, 1.335531,
        -0.899559021, -2.26360798, 1.29246604,
        -0.753309011, -2.23652411, 1.37267101,
        -0.595380008, -2.20452905, 1.32151198,
        -0.415068001, -2.17083907, 1.35220504,
        -0.169196993, -2.26725602, 1.38675904,
        0.0213329997, -2.24852109, 1.31509805,
        0.139062002, -2.24324989, 1.43168998,
        0.294339001, -2.24340606, 1.35696006,
        0.425535023, -2.24636698, 1.260252,
        0.578610003, -2.28396893, 1.32317102,
        0.710678995, -2.25913191, 1.42181396,
        0.852326989, -2.12977195, 1.31994903,
        0.979083002, -2.22259188, 1.27246809,
        1.13963699, -2.24109292, 1.23230398,
        1.27463698, -2.23878288, 1.34273696,
        1.53245401, -2.25313807, 1.34889305,
        -1.26905096, -2.12177706, 1.28504395,
        -1.00527, -2.1342392, 1.30867505,
        -0.836898029, -2.11317611, 1.27787995,
        -0.676686049, -2.06837106, 1.28387702,
        -0.54528898, -2.09136581, 1.43845797,
        -0.509916008, -2.07491088, 1.24713004,
        -0.276713997, -2.07395697, 1.31733298,
        -0.110544004, -2.12002802, 1.32945001,
        0.0428880006, -2.10262489, 1.40346897,
        0.200534999, -2.11470604, 1.33670104,
        0.373928994, -2.08612514, 1.29581702,
        0.482859015, -2.16758108, 1.39509606,
        0.640827, -2.10417604, 1.38806403,
        0.740238011, -2.01811194, 1.26578403,
        0.921921015, -1.97719502, 1.35309601,
        1.039029, -2.09750986, 1.36175406,
        1.19614494, -2.09127903, 1.30442393,
        1.39556098, -2.12453699, 1.31826901,
        1.64047503, -2.11085701, 1.32379794,
        -1.13545799, -2.01836109, 1.31168997,
        -0.961881042, -1.97977185, 1.33991694,
        -0.794169009, -1.97088897, 1.35448503,
        -0.62716198, -1.94920802, 1.40121901,
        -0.526059031, -1.90735495, 1.27588499,
        -0.417383999, -2.00051999, 1.37634301,
        -0.285483003, -1.90270507, 1.321383,
        -0.0417749994, -1.96518302, 1.35604799,
        0.119453996, -1.975425, 1.31050491,
        0.276053995, -1.96675801, 1.37142301,
        0.393069029, -1.920753, 1.26406503,
        0.502668023, -2.00136614, 1.361292,
        0.646589994, -1.92662692, 1.36505103,
        0.802538991, -1.86367798, 1.35131705,
        1.02997494, -1.86089993, 1.41690898,
        1.16351998, -1.97246397, 1.42177498,
        1.31866801, -1.9621079, 1.33583999,
        1.43474102, -1.85940289, 1.26349497,
        1.51054811, -2.00530481, 1.30734599,
        1.73675394, -1.96216798, 1.31851506,
        -1.22096109, -1.86346793, 1.31736898,
        -1.04984701, -1.84606814, 1.31028891,
        -0.878603935, -1.83441305, 1.30741501,
        -0.723968983, -1.80762005, 1.36930501,
        -0.519281983, -1.74119997, 1.29758394,
        -0.419414997, -1.83310795, 1.400316,
        -0.274551004, -1.75190091, 1.39448094,
        -0.131925002, -1.83054006, 1.3297739,
        0.138921008, -1.8205471, 1.36238396,
        0.268070996, -1.81458592, 1.26244807,
        0.397119015, -1.71641994, 1.299312,
        0.530043006, -1.82429099, 1.30408502,
        0.671348989, -1.76304603, 1.37684393,
        0.907433987, -1.73838592, 1.4044559,
        1.05597305, -1.70376599, 1.47545099,
        1.15339196, -1.78692889, 1.339311,
        1.32087898, -1.77482092, 1.34991598,
        1.44238806, -1.68564296, 1.24822807,
        1.59399605, -1.8570869, 1.32887697,
        1.80033302, -1.77204609, 1.34120703,
        -1.48484099, -1.65577197, 1.28597999,
        -1.30927801, -1.67903101, 1.30764604,
        -1.14173102, -1.704705, 1.32412803,
        -0.978704989, -1.70014191, 1.28151894,
        -0.812835038, -1.68084288, 1.28514004,
        -0.655479014, -1.65266097, 1.33890605,
        -0.504164994, -1.57556105, 1.32414305,
        -0.368373007, -1.67111397, 1.27205396,
        -0.231251985, -1.59661794, 1.35232806,
        -0.106299005, -1.67351413, 1.284132,
        0.024722999, -1.70404494, 1.38145804,
        0.203438997, -1.65458107, 1.29721498,
        0.337725013, -1.57806897, 1.37172604,
        0.46191299, -1.53366899, 1.25820005,
        0.555732012, -1.65623713, 1.31951404,
        0.722159982, -1.62492609, 1.30724096,
        0.938858986, -1.59360301, 1.32482409,
        1.09987497, -1.57668006, 1.37016594,
        1.36760998, -1.60338593, 1.36655402,
        1.49533796, -1.52437198, 1.27281296,
        1.63998592, -1.69424391, 1.35104108,
        1.80213594, -1.60062003, 1.38189602,
        -1.77382803, -1.51480198, 1.32694793,
        -1.60793102, -1.55173492, 1.3641181,
        -1.486902, -1.46732402, 1.2756269,
        -1.30059004, -1.41828597, 1.27381206,
        -1.16056502, -1.44365406, 1.3624289,
        -1.04549396, -1.55393708, 1.32821703,
        -0.88883996, -1.48742998, 1.37574601,
        -0.648263991, -1.49480104, 1.38976204,
        -0.489993006, -1.42031097, 1.27463698,
        -0.347294986, -1.50453007, 1.26675296,
        -0.216749996, -1.43220603, 1.32949197,
        -0.0950310007, -1.50743699, 1.235466,
        0.0776429996, -1.45653594, 1.33892703,
        0.231299996, -1.48411202, 1.27009499,
        0.376596004, -1.41396594, 1.34486401,
        0.539606988, -1.39120197, 1.27980304,
        0.625514984, -1.53333592, 1.21195197,
        0.818724036, -1.48689604, 1.27244103,
        1.02104092, -1.44160497, 1.29932094,
        1.19023502, -1.46172297, 1.27965903,
        1.352718, -1.44221401, 1.31226003,
        1.56103802, -1.41971707, 1.40107799,
        1.65899396, -1.53185391, 1.31277001,
        1.85213089, -1.43891096, 1.3183949,
        -2.07114291, -1.31524801, 1.31505895,
        -1.92560101, -1.42140007, 1.33780503,
        -1.75949407, -1.33764303, 1.33811402,
        -1.58108997, -1.3255651, 1.33767009,
        -1.41748798, -1.35241199, 1.37631607,
        -1.3533659, -1.25815797, 1.23361492,
        -1.25122201, -1.30948198, 1.40207398,
        -1.00993502, -1.38531601, 1.31264699,
        -0.893558979, -1.264557, 1.32327604,
        -0.752588987, -1.37337303, 1.43213701,
        -0.566403031, -1.32215106, 1.38032699,
        -0.334091991, -1.32959998, 1.25802302,
        -0.171447009, -1.30025399, 1.24359298,
        -0.0062730005, -1.32500398, 1.26223493,
        0.146579996, -1.27306497, 1.20179105,
        0.206294999, -1.33861494, 1.34435093,
        0.337541997, -1.27811706, 1.25787294,
        0.597365975, -1.24561191, 1.21698594,
        0.705867052, -1.37037599, 1.24296904,
        0.89655304, -1.33433402, 1.24421406,
        1.11917698, -1.30292392, 1.29678893,
        1.24043393, -1.34985006, 1.39879799,
        1.38496494, -1.27356303, 1.33405197,
        1.55327106, -1.27459192, 1.31546402,
        1.69781399, -1.36678493, 1.31130898,
        1.87718105, -1.23656702, 1.29277205,
        -2.07901502, -1.162323, 1.40573096,
        -1.91037297, -1.24979401, 1.33157396,
        -1.79443192, -1.13202906, 1.30067098,
        -1.64341199, -1.158216, 1.36795497,
        -1.47871208, -1.18783796, 1.32959998,
        -1.31535292, -1.16081691, 1.36592698,
        -1.12818003, -1.19133306, 1.36514997,
        -0.998820066, -1.09958398, 1.31854498,
        -0.840674996, -1.09139109, 1.34572196,
        -0.72655797, -1.24614, 1.32401693,
        -0.519795001, -1.09944594, 1.41814208,
        -0.430949986, -1.21484709, 1.33379102,
        -0.239675999, -1.154001, 1.29641402,
        -0.0885419995, -1.20454192, 1.35611999,
        0.057705, -1.16669703, 1.29107404,
        0.221514016, -1.17656696, 1.32213295,
        0.375240028, -1.12118399, 1.33247101,
        0.59483695, -1.12037396, 1.3218751,
        0.747693002, -1.19719195, 1.26610804,
        0.909986973, -1.17192304, 1.30462193,
        1.07735097, -1.14364505, 1.30629301,
        1.24335301, -1.18111801, 1.316553,
        1.41591299, -1.12110901, 1.40493906,
        1.53644109, -1.10498095, 1.29017997,
        1.69000506, -1.16642404, 1.33256996,
        1.83843589, -1.08675909, 1.37320197,
        -2.21403599, -1.04776502, 1.35985804,
        -2.02491283, -0.999789, 1.26584399,
        -1.84977007, -0.971439004, 1.26441002,
        -1.92515695, -1.06481099, 1.38763499,
        -1.71834004, -0.99951303, 1.36833596,
        -1.53234291, -1.06372499, 1.23628795,
        -1.75921798, 1.54812002, -1.72349405,
        -1.39884901, -1.02003598, 1.385571,
        -1.20174301, -1.03706694, 1.35897303,
        -0.937736988, -0.948828042, 1.38152993,
        -0.777978063, -0.957450032, 1.44563103,
        -0.682722032, -1.08851397, 1.38106203,
        -0.60997802, -0.939858019, 1.40462697,
        -0.369938999, -1.05669904, 1.33742404,
        -0.212828994, -0.99120301, 1.34315109,
        -0.058637999, -1.04342699, 1.30086005,
        0.0637619942, -0.994551063, 1.40768707,
        0.243138, -1.03836596, 1.41038394,
        0.482454002, -1.01003098, 1.26073802,
        0.577995002, -0.985305011, 1.41748798,
        0.714486003, -0.99890703, 1.31780994,
        0.876044989, -1.02832198, 1.37936997,
        1.03980899, -0.982089043, 1.32372904,
        1.17412496, -1.02728093, 1.23027599,
        1.30185604, -1.02290702, 1.33495796,
        1.45748103, -0.966165066, 1.34979892,
        1.71048594, -0.999807, 1.29274201,
        1.85941207, -0.911594987, 1.321347,
        -2.30461502, -0.904113054, 1.30848598,
        -2.13444591, -0.89389205, 1.33457696,
        -1.96675801, -0.896729946, 1.39469695,
        -1.83648014, -0.799118996, 1.34494805,
        -1.58513093, -0.847445965, 1.23155701,
        -1.78002, 1.71913505, -1.65478492,
        -1.43915093, -0.91937995, 1.22909999,
        -1.2905879, -0.91079396, 1.30280101,
        -1.15811098, -0.810858011, 1.35583496,
        -0.997626007, -0.805461049, 1.31984401,
        -0.859649956, -0.796748996, 1.41761398,
        -0.706412971, -0.820502996, 1.32760799,
        -0.548958004, -0.777032971, 1.35370207,
        -0.451902032, -0.915207028, 1.34723401,
        -0.241571993, -0.835673928, 1.40314496,
        -0.0707219988, -0.882194996, 1.37912405,
        0.0886529982, -0.83249402, 1.36465192,
        0.235478997, -0.89209795, 1.32292509,
        0.403098017, -0.858645022, 1.29127502,
        0.594321012, -0.885773957, 1.27360797,
        0.757082999, -0.894752979, 1.19538307,
        0.907073975, -0.918980956, 1.25272501,
        1.05071998, -0.926634014, 1.16283298,
        1.18213201, -0.893429995, 1.35712802,
        1.34890807, -0.838952959, 1.31360996,
        1.53134704, -0.815622032, 1.30748093,
        1.69633806, -0.834123015, 1.29021001,
        1.86877799, -0.734351993, 1.28989804,
        -2.23473597, -0.760998011, 1.38132298,
        -2.04763794, -0.749261975, 1.35781801,
        -1.95492005, -0.66841805, 1.23958504,
        -1.92868805, 1.91468406, -1.62805796,
        -1.79357409, -0.641324997, 1.28665805,
        -1.68401408, 1.87893605, -1.65334201,
        -1.62643194, -0.687023997, 1.27558506,
        -1.45955706, -0.736761034, 1.26879907,
        -1.283319, -0.74998498, 1.25651097,
        -1.19864106, -0.646112978, 1.37043905,
        -1.02894306, -0.651180029, 1.35841799,
        -0.812502027, -0.68739897, 1.29856503,
        -0.674474955, -0.665772021, 1.3897171,
        -0.533235013, -0.610589981, 1.32892501,
        -0.377711982, -0.742394984, 1.34161794,
        -0.167699993, -0.703217983, 1.324875,
        -0.00257100002, -0.733317018, 1.26282299,
        0.143501997, -0.671918988, 1.35806406,
        0.293460011, -0.736541986, 1.31619596,
        0.43995899, -0.675570011, 1.26020706,
        0.580806017, -0.705251992, 1.34981704,
        0.734633982, -0.763011038, 1.29043496,
        0.899267972, -0.745643973, 1.28922892,
        1.0651679, -0.790377021, 1.26405597,
        1.21845007, -0.729314983, 1.32026398,
        1.28653502, -0.592728019, 1.23629403,
        1.42923307, -0.687726021, 1.29283798,
        1.59239697, -0.666279018, 1.37126708,
        1.72041297, -0.664182007, 1.24274707,
        -2.01299691, 2.09766889, -1.63029599,
        -1.71746397, 2.07800698, -1.58539796,
        -2.24237704, -0.572916031, 1.34790897,
        -2.06875205, -0.583305001, 1.33097696,
        -1.93311, -0.490548015, 1.38746107,
        -1.79661608, -0.471777022, 1.29538798,
        -1.66174197, -0.538944006, 1.34924102,
        -1.50275695, -0.587529004, 1.34891701,
        -1.34271002, -0.546935976, 1.37157893,
        -1.1358, -0.511341035, 1.28427005,
        -1.00349402, -0.496316969, 1.38782406,
        -0.834152937, -0.539739013, 1.37583303,
        -0.674223006, -0.508379996, 1.31579995,
        -0.456294, -0.469713002, 1.35250807,
        -0.336942017, -0.575417995, 1.30492806,
        -0.170021996, -0.540086985, 1.37969708,
        0.00265499996, -0.580899, 1.33968592,
        0.150752991, -0.499736965, 1.34247899,
        0.29636699, -0.576240003, 1.33590901,
        0.412503004, -0.510713995, 1.24021804,
        0.564455986, -0.512241006, 1.30386591,
        0.686478019, -0.612686992, 1.24985993,
        0.845471978, -0.594362974, 1.34199905,
        1.00281596, -0.639135003, 1.20732903,
        1.12972808, -0.563414991, 1.29380703,
        1.25014496, -0.463476002, 1.355178,
        1.40762401, -0.484355986, 1.29363298,
        1.58014798, -0.479088008, 1.28547001,
        1.75889087, -0.477528036, 1.30482006,
        -2.15359187, 2.29770303, -1.62130201,
        -1.95290995, 2.29553986, -1.61138999,
        -2.27989817, -0.408729017, 1.28274596,
        -2.10325193, -0.413798988, 1.31358302,
        -1.93929899, -0.396102011, 1.249071,
        -1.819857, -0.338277012, 1.39138508,
        -1.65561914, -0.379499972, 1.28536499,
        -1.49443507, -0.420798004, 1.30325997,
        -1.32597303, -0.405936003, 1.282251,
        -1.209903, -0.329174995, 1.38802195,
        -1.0615859, -0.362487018, 1.32231593,
        -0.898323059, -0.404931009, 1.29795909,
        -0.766254008, -0.37856099, 1.39850104,
        -0.571815014, -0.384266973, 1.25463307,
        -0.411450028, -0.33199501, 1.27487099,
        -0.281322002, -0.418958992, 1.34345102,
        -0.130524009, -0.332256019, 1.36137891,
        0.15218699, -0.348068982, 1.28318107,
        0.321956992, -0.385952979, 1.33125591,
        0.492720008, -0.357276022, 1.292799,
        0.693153024, -0.33495, 1.33604395,
        0.692367017, -0.449061036, 1.20707107,
        0.86066401, -0.456026971, 1.24145699,
        1.02602398, -0.46341902, 1.19231391,
        1.10746205, -0.381587982, 1.31394303,
        1.31164193, -0.347912997, 1.25048101,
        1.49172604, -0.33524999, 1.316082,
        1.66011894, -0.335628003, 1.33947301,
        -1.01435101, -2.74131012, -0.422969997,
        -2.18778014, -0.253398001, 1.31783402,
        -0.811610937, -2.70732307, -0.406850994,
        -2.01701999, -0.261317998, 1.31684399,
        -1.82132101, -0.205092013, 1.28747702,
        -1.667274, -0.230832011, 1.361709,
        -1.505445, -0.284327984, 1.39762807,
        -1.41737401, -0.268025994, 1.25429094,
        -1.26129293, -0.20647499, 1.25446796,
        -1.11932099, -0.202724993, 1.34531403,
        0.722048998, -2.71098614, -0.39368999,
        -0.960231006, -0.241304994, 1.36172104,
        0.895583987, -2.71375203, -0.461682022,
        -0.762365937, -0.203585982, 1.33898699,
        1.06846201, -2.67714882, -0.449993968,
        -0.553664982, -0.246816009, 1.366974,
        -0.389156997, -0.176982, 1.23511493,
        -0.257091016, -0.25486201, 1.29527998,
        -0.104157001, -0.177015007, 1.28597999,
        0.0828360021, -0.202587008, 1.31985593,
        0.247181982, -0.230255991, 1.35439205,
        0.414053977, -0.213945001, 1.358181,
        0.568332016, -0.185034007, 1.30471206,
        0.787190974, -0.309536994, 1.19695807,
        0.873843074, -0.188472003, 1.27728903,
        1.025208, -0.226914018, 1.32422996,
        1.16311502, -0.252260983, 1.22772896,
        1.29202497, -0.204015017, 1.33578897,
        1.43843699, -0.186168, 1.26016498,
        1.59960008, -0.168870002, 1.31499898,
        -1.10750699, -2.58318901, -0.454937994,
        -0.889554024, -2.55155993, -0.413358003,
        -0.73072803, -2.55762005, -0.475551009,
        -0.580781996, -2.55635405, -0.38717103,
        -2.28088212, -0.107741997, 1.28025007,
        -0.407225966, -2.55456305, -0.401585996,
        -2.113029, -0.118349999, 1.23682797,
        -1.95063901, -0.103407003, 1.29369903,
        -0.232529998, -2.55516291, -0.411705017,
        -1.77279902, -0.0830610022, 1.39478993,
        -0.0731249973, -2.60131192, -0.467805028,
        -1.59920704, -0.0995849967, 1.44735301,
        0.100682996, -2.61516595, -0.452078998,
        0.189330012, -2.47091699, -0.474444032,
        -1.46449494, -0.120344996, 1.33612204,
        0.406077027, -2.65341616, -0.41059202,
        -1.32840896, -0.0461760014, 1.25631905,
        0.560154021, -2.71598101, -0.468338996,
        -1.15365601, -0.0711359978, 1.25520301,
        0.704712033, -2.49877787, -0.404870987,
        -0.917351961, -0.0757170022, 1.37638497,
        0.81023401, -2.57456112, -0.506321967,
        -0.749346018, -0.0277590007, 1.37685001,
        0.95706296, -2.52123308, -0.451340973,
        -0.597660005, -0.0842040032, 1.43501091,
        1.17580795, -2.53071308, -0.467028022,
        -0.524268031, -0.104987994, 1.28301299,
        -0.290288985, -0.0722550005, 1.32147896,
        -0.136014, -0.0193109997, 1.35973501,
        0.00966600049, -0.0520469993, 1.28864396,
        0.180767998, -0.0677819997, 1.29463196,
        0.33050701, -0.120591, 1.24533296,
        0.470481008, -0.0519930013, 1.29881406,
        0.638496041, -0.019932, 1.29044104,
        0.716187, -0.160076991, 1.23741293,
        0.81350702, -0.0317460001, 1.280532,
        0.984341979, -0.0549660027, 1.31807399,
        1.151649, -0.101867996, 1.31876695,
        1.30749595, -0.054390002, 1.24818599,
        1.484514, -0.0319680013, 1.32581699,
        -0.991127968, -2.3973, -0.489446998,
        -0.813615024, -2.4044342, -0.446456999,
        -0.648285031, -2.38843203, -0.442905009,
        -0.568632007, -2.41890287, -0.301449001,
        -2.53964996, -0.016632, 1.33235705,
        -0.474767983, -2.40087605, -0.44710502,
        -2.36804986, 0.0420330018, 1.33374906,
        -0.311340004, -2.40430188, -0.393432021,
        -2.20881605, 0.0912600011, 1.36360192,
        -0.145586997, -2.4195869, -0.473793,
        -2.06705093, 0.00483600004, 1.34816396,
        0.0207329988, -2.45563197, -0.48566103,
        -1.89967799, 0.0356729999, 1.37903404,
        0.12936601, -2.323035, -0.427047014,
        -1.76949906, 0.0986250043, 1.28402996,
        0.419883013, -2.48538899, -0.435479999,
        -1.64883006, 0.0665609986, 1.41033602,
        0.564693034, -2.41593313, -0.368294984,
        -1.47459006, 0.0556079969, 1.38088202,
        0.724599004, -2.34874201, -0.33405599,
        -1.37307596, 0.118170008, 1.253106,
        0.854879975, -2.36738396, -0.445644021,
        -1.21904397, 0.0710790008, 1.32206404,
        -1.95097494, 1.31978703, -1.365435,
        1.01219106, -2.376477, -0.371972978,
        -1.04443192, 0.0391109996, 1.33465493,
        -1.78676105, 1.41882598, -1.36438203,
        -0.866994023, 0.0846059993, 1.31649899,
        1.17801595, -2.35839891, -0.427797019,
        -0.691662014, 0.106536001, 1.26669896,
        -0.539870977, 0.0545310006, 1.34187293,
        -0.354369015, 0.0863099992, 1.34072709,
        -0.222581998, 0.0606210008, 1.2293849,
        -0.0584639981, 0.105848998, 1.25882101,
        0.103775993, 0.0757260025, 1.34473491,
        0.33939898, 0.0600090027, 1.24759507,
        0.432336032, 0.0934050009, 1.38778806,
        0.595170021, 0.120179996, 1.37037003,
        0.754137039, 0.124298997, 1.31472301,
        0.916334987, 0.0987599939, 1.28958297,
        1.02694798, 0.159860998, 1.39897501,
        1.17684901, 0.0603059977, 1.40525997,
        1.32395399, 0.104540996, 1.32016802,
        -1.94434214, 1.526703, -1.41179407,
        -1.69739699, 1.58277297, -1.37585104,
        -0.763293028, -2.24626493, -0.509682,
        -0.564879, -2.24250603, -0.400755018,
        -0.408764988, -2.24744987, -0.474575996,
        -2.67902088, 0.0971190035, 1.33770299,
        -0.241713017, -2.25494409, -0.445644021,
        -2.50282812, 0.15485999, 1.30377007,
        -0.0835050046, -2.27977204, -0.401124001,
        -2.34526491, 0.207186013, 1.3664341,
        0.052956, -2.18175292, -0.395687997,
        -2.181108, 0.255849004, 1.38846302,
        0.217161, -2.17347908, -0.466683,
        -2.07303619, 0.170364007, 1.28340006,
        0.29429701, -2.33470201, -0.47736302,
        -1.90642798, 0.201273009, 1.31502008,
        0.47022298, -2.31870294, -0.464034021,
        -1.74374092, 0.269097, 1.32098103,
        0.644805014, -2.30926204, -0.472902,
        -1.53448796, 0.246860996, 1.31958294,
        0.780005932, -2.21350193, -0.41892302,
        -1.35273004, 0.240779996, 1.3788569,
        0.966638982, -2.22347403, -0.431706011,
        -1.23118806, 0.235053003, 1.25773191,
        1.11695707, -2.21767497, -0.350316018,
        1.36057496, -2.3029952, -0.444449991,
        1.49685001, -2.18938804, -0.422600985,
        -0.213690013, 0.193883985, 1.34089196,
        -0.0589139983, 0.282768011, 1.31507099,
        0.066542998, 0.229406983, 1.42258191,
        0.235082984, 0.184760988, 1.31792402,
        0.399846017, 0.22296001, 1.28178,
        0.561219037, 0.263516992, 1.25317204,
        0.705681026, 0.287589014, 1.35369897,
        0.879896998, 0.263733, 1.37639999,
        1.029585, 0.317526013, 1.29312301,
        1.17502499, 0.21908699, 1.32659698,
        -1.82452202, 1.71797705, -1.37856007,
        -1.65580511, 1.75157094, -1.31461799,
        -2.71114206, 0.428310037, 1.31330097,
        -0.539822996, -2.08937693, -0.486171007,
        -2.63188505, 0.270603001, 1.32245696,
        -0.399183035, -2.09793901, -0.390090019,
        -2.37233996, 0.374958009, 1.36321795,
        -0.246044993, -2.0885129, -0.451413006,
        -2.1685648, 0.388110012, 1.28032804,
        -0.0925109982, -2.11557603, -0.341457009,
        -2.02686286, 0.322163999, 1.35150599,
        0.0620249994, -2.044626, -0.486189008,
        -1.86692715, 0.383444965, 1.31766009,
        0.173997, -2.07994795, -0.336429,
        -1.701249, 0.437243998, 1.28143501,
        0.340709984, -2.060601, -0.403367996,
        -1.517241, 0.405972004, 1.24250102,
        0.50702399, -2.02221608, -0.420836985,
        -2.10797095, 1.94356489, -1.35083103,
        -1.39686298, 0.286716014, 1.22080505,
        0.612113953, -2.15652895, -0.398180991,
        -1.27076101, 0.396111012, 1.32475197,
        -1.98376203, 1.80877495, -1.36818898,
        0.729573011, -2.06778908, -0.493713021,
        0.110849999, 0.355508983, 1.30736697,
        -1.71329689, 1.92453599, -1.30407906,
        0.880934954, -2.07824707, -0.400373995,
        0.285777003, 0.359358013, 1.35288,
        1.03401899, -2.067348, -0.335978985,
        0.458736002, 0.390927017, 1.32175493,
        1.19636405, -2.05803895, -0.379835963,
        0.709445953, 0.438567013, 1.26105297,
        0.883584023, 0.409992009, 1.2573061,
        1.33601403, -2.12574601, -0.440927982,
        -2.53835702, 0.415167034, 1.34003103,
        -2.42912388, 0.544214964, 1.35076499,
        -2.26441789, 0.512331009, 1.33831191,
        -2.12715292, 0.610095024, 1.35390306,
        -2.23528194, 2.03859591, -1.25540996,
        -2.09630394, 2.1265378, -1.34054101,
        -2.01396012, 0.487896025, 1.31184304,
        -1.92852294, 2.07322216, -1.27585506,
        -1.84388399, 0.55062902, 1.32514501,
        -1.55567098, 0.543485999, 1.34615099,
        -1.43751001, 0.563306987, 1.22379601,
        -1.26214504, 0.569954991, 1.26661801,
        -0.581955016, -1.96319699, -0.368865013,
        -0.431939989, -1.93749905, -0.444203973,
        -0.265293002, -1.91884494, -0.517715991,
        -0.130190998, -1.96946406, -0.425690979,
        0.00498299999, -1.88144696, -0.464235008,
        0.166092008, -1.88133895, -0.41355598,
        0.342797995, -1.88278806, -0.414618015,
        0.462494999, -1.90085399, -0.53075099,
        0.632414997, -1.92087603, -0.471198022,
        0.793071032, -1.93318498, -0.418082982,
        0.969447017, -1.93967092, -0.438462019,
        1.142874, -1.90839601, -0.44561702,
        1.31220603, -1.94906998, -0.459867001,
        1.45919406, -2.01990294, -0.394322991,
        1.60881901, -1.94743502, -0.356895,
        -2.62421703, 0.624789, 1.36095905,
        -2.46823788, 0.701901019, 1.32390594,
        -2.29705501, 0.677625, 1.34780693,
        -2.12449193, 0.781724989, 1.33403099,
        -1.9497869, 0.678686976, 1.27747202,
        -1.69677591, 0.637871981, 1.32407093,
        -1.55243707, 0.693566978, 1.25825691,
        -1.387905, 0.697314024, 1.31652296,
        -0.654524982, -1.81418705, -0.312491983,
        -0.499662012, -1.75653601, -0.326748013,
        -0.350883007, -1.79625893, -0.394953012,
        -0.220910996, -1.75536895, -0.492057025,
        -0.0679320022, -1.72101903, -0.427236021,
        0.109196998, -1.73578215, -0.367313981,
        0.257319003, -1.74493504, -0.468087018,
        0.43521601, -1.74317408, -0.474195004,
        0.614081979, -1.74668992, -0.44056499,
        0.860936999, -1.7876699, -0.382806003,
        1.02632093, -1.78227901, -0.416510999,
        1.18153203, -1.73385894, -0.441078007,
        1.45112705, -1.73855102, -0.445038021,
        1.51352692, -1.90172696, -0.502658963,
        1.62479401, -1.76819408, -0.473906994,
        -2.60580015, 0.795369029, 1.282956,
        -2.46164703, 0.866019011, 1.3479929,
        -2.28709507, 0.849210024, 1.32656097,
        -1.99361992, 0.896142006, 1.32677698,
        -1.830477, 0.822230995, 1.338081,
        -1.70497203, 0.905312955, 1.25505602,
        -1.55333114, 0.849195004, 1.32416701,
        -0.65862, -1.67719197, -0.418473005,
        -0.548958004, -1.60538399, -0.315315008,
        -0.382254004, -1.63461292, -0.347846985,
        -0.178557009, -1.55966997, -0.481368005,
        0.0410399996, -1.59259808, -0.417035997,
        0.207246006, -1.59931803, -0.398979008,
        0.373871982, -1.60619402, -0.399159014,
        0.539865017, -1.632411, -0.341726989,
        0.761775017, -1.66910696, -0.464367002,
        0.92888701, -1.65618896, -0.467960984,
        1.08377707, -1.58900106, -0.473882973,
        1.21497893, -1.58403301, -0.367610991,
        1.346946, -1.5984869, -0.480897009,
        1.49682307, -1.52900696, -0.429834008,
        1.68659115, -1.61006999, -0.431897998,
        -2.60151291, 0.968001008, 1.32986701,
        -2.45132399, 0.994506001, 1.23805797,
        -2.27568889, 1.00552201, 1.25127006,
        -2.12773204, 1.01277304, 1.32849002,
        -1.84661102, 0.99743396, 1.31757307,
        -1.70481598, 1.0781281, 1.249089,
        -1.60588503, 1.00724101, 1.37963402,
        -1.51616406, -1.46017504, -0.402552009,
        -1.16072106, -1.45283997, -0.403106987,
        -1.00801194, -1.54496706, -0.425175011,
        -0.806001067, -1.58558393, -0.392912984,
        -0.685845017, -1.5034771, -0.476103008,
        -0.587948978, -1.45129204, -0.342978001,
        -0.475560009, -1.53290105, -0.450120002,
        -0.319032013, -1.48572004, -0.410631001,
        -0.173610002, -1.40959203, -0.379536033,
        -0.048432, -1.460253, -0.477689981,
        0.130215004, -1.45995593, -0.462359995,
        0.297308981, -1.45485294, -0.424068034,
        0.477171004, -1.47065103, -0.422586024,
        0.724332035, -1.54704309, -0.358121991,
        0.838289976, -1.52070904, -0.498374999,
        0.984930038, -1.45148396, -0.436352968,
        1.17498899, -1.418805, -0.349265993,
        1.33344603, -1.40417397, -0.421428025,
        1.49101198, -1.37571001, -0.493713021,
        1.645926, -1.44533396, -0.483269989,
        -2.54886007, 1.13746202, 1.28461504,
        -2.37222314, 1.13704193, 1.28920794,
        -2.20292711, 1.1766181, 1.31641793,
        -2.02167606, 1.14890099, 1.31056499,
        -1.86329699, 1.17473102, 1.37384093,
        -1.72833002, 1.25089502, 1.24266005,
        -1.58976293, 1.17524099, 1.34080207,
        -1.77880204, -1.35980105, -0.378462017,
        -1.61971498, -1.32766199, -0.455817014,
        -1.43898606, -1.40097904, -0.249536991,
        -1.37266803, -1.35641408, -0.457560003,
        -1.20362997, -1.29922509, -0.483222008,
        -1.03116596, -1.36369801, -0.487401009,
        -0.870896995, -1.43555093, -0.454713017,
        -0.737414956, -1.38306594, -0.35690099,
        -0.591552019, -1.2810061, -0.360188991,
        -0.441839993, -1.36846495, -0.380276978,
        -0.290775001, -1.29196799, -0.418065012,
        -0.13098, -1.27308607, -0.465366006,
        0.0422130004, -1.32267296, -0.499197006,
        0.147771001, -1.31853604, -0.369744003,
        0.310196996, -1.31211293, -0.330320984,
        0.485358, -1.31973898, -0.339825004,
        0.628970981, -1.41351295, -0.362634003,
        0.799463987, -1.38140106, -0.407799006,
        0.925121963, -1.26884103, -0.459806979,
        1.08582902, -1.31635499, -0.450398982,
        1.24591494, -1.2649889, -0.399089992,
        1.51633501, -1.23673201, -0.395750999,
        1.67409003, -1.311993, -0.362960994,
        -2.34921288, 1.304865, 1.31096101,
        -2.18218803, 1.35099602, 1.35170698,
        -2.025177, 1.41128099, 1.29078603,
        -1.89623404, 1.30125594, 1.25746202,
        -1.72976995, 1.42748106, 1.26489902,
        -1.52755499, 1.33246505, 1.30111504,
        -1.91066098, -1.18304396, -0.409389019,
        -1.75374591, -1.21744204, -0.483632982,
        -1.60266602, -1.15873802, -0.409116,
        -1.483302, -1.26649499, -0.356804997,
        -1.38329399, -1.13717997, -0.403353006,
        -1.17315292, -1.12569606, -0.484736979,
        -1.02478206, -1.19014204, -0.539304018,
        -0.875898004, -1.27157402, -0.508304954,
        -0.747954011, -1.21906209, -0.400682986,
        -0.612578988, -1.11079192, -0.406676978,
        -0.445125014, -1.20174599, -0.410798997,
        -0.29548499, -1.11197102, -0.45986402,
        -0.133040994, -1.120206, -0.528132021,
        0.0570480004, -1.15932608, -0.452060997,
        0.223493993, -1.17591894, -0.429983974,
        0.397350013, -1.19195998, -0.396924019,
        0.557271004, -1.13333702, -0.408174008,
        0.691574991, -1.25308204, -0.386958003,
        0.873519063, -1.16073895, -0.341942996,
        1.03161597, -1.13523006, -0.397794008,
        1.16210997, -1.16106904, -0.497030973,
        1.325652, -1.12524295, -0.475340992,
        1.47188997, -1.06907701, -0.410504997,
        1.62584996, -1.10942996, -0.353586018,
        -1.99410903, -1.02687001, -0.430505991,
        -1.80956101, -1.04410195, -0.419291973,
        -1.679124, -1.06508696, -0.534258008,
        -1.50387907, -1.01311207, -0.425835013,
        -1.28290796, -1.00136399, -0.437931001,
        -1.11808503, -0.941576958, -0.468977988,
        -1.02083099, -1.063851, -0.421442986,
        -0.862928987, -1.10582101, -0.462927014,
        -0.759321034, -1.0276649, -0.354054004,
        -0.543096006, -0.899168968, -0.43286103,
        -0.457677007, -1.03982997, -0.450258017,
        -0.332964003, -0.926688015, -0.424272001,
        -0.174483001, -0.993363023, -0.424862981,
        -0.0119880009, -1.01200497, -0.494801998,
        0.145749003, -1.02377391, -0.420143992,
        0.300177008, -0.979017019, -0.367892981,
        0.539676011, -0.963495016, -0.440735996,
        0.690698981, -1.0354619, -0.446721017,
        0.829707026, -1.00194001, -0.360711008,
        0.978441, -0.970058978, -0.435059965,
        1.12809002, -0.997874975, -0.516294003,
        1.29076505, -0.97103703, -0.418653011,
        1.451478, -0.910530031, -0.470457017,
        1.60883999, -0.953601003, -0.431228995,
        1.76361001, -1.03389299, -0.445553988,
        -1.662696, -2.68130708, 0.82625103,
        -1.487499, -2.73839092, 0.810711026,
        -1.32529497, -2.73980403, 0.747492015,
        -1.17756295, -2.7026372, 0.839403033,
        -1.02063894, -2.68768191, 0.765347958,
        -0.864951015, -2.68618488, 0.846143961,
        -0.704291999, -2.71539307, 0.881949067,
        -0.542300999, -2.68122888, 0.834908962,
        -2.03453994, -0.825836957, -0.40436402,
        -1.88133597, -0.894858003, -0.471108019,
        -1.71602702, -0.894162059, -0.534170985,
        -1.58857203, -0.865005016, -0.414005995,
        -1.40596795, -0.885123014, -0.479945987,
        0.739641011, -2.71405506, 0.849611998,
        -1.22465706, -0.845741987, -0.381152987,
        0.91078198, -2.69131207, 0.882777035,
        -0.992619038, -0.820644021, -0.46162498,
        1.09641004, -2.68981814, 0.849536955,
        -0.859251022, -0.929259002, -0.459318012,
        1.269225, -2.6931448, 0.794045985,
        -0.705558002, -0.844815016, -0.441273004,
        -0.58209002, -0.731096983, -0.420336008,
        -0.426266968, -0.786566973, -0.386366963,
        -0.302376002, -0.769616961, -0.498548985,
        -0.160154998, -0.83427304, -0.446583033,
        -0.00455400022, -0.892964959, -0.386106014,
        0.170646012, -0.873692989, -0.33138299,
        0.345411003, -0.784781992, -0.386457026,
        0.517346978, -0.79479003, -0.449579984,
        0.634712994, -0.870497942, -0.352532983,
        0.790455043, -0.844425023, -0.395510972,
        0.951206982, -0.802020013, -0.382808983,
        1.09358406, -0.84582901, -0.450437963,
        1.25104797, -0.812057972, -0.433905005,
        1.40201998, -0.745649993, -0.465395987,
        1.61800814, -0.816987038, -0.536007047,
        1.75910401, -0.858342052, -0.429894,
        -1.53467393, -2.57034302, 0.785883069,
        -1.36309803, -2.58725691, 0.844200015,
        -1.14785099, -2.55080986, 0.894318044,
        -0.983031034, -2.55203414, 0.892479062,
        -0.876857996, -2.65088105, 0.678059995,
        -0.767774999, -2.54734802, 0.776085019,
        -0.649778962, -2.54755807, 0.898263037,
        -0.40465498, -2.5846591, 0.870333016,
        -1.94380796, -0.669051051, -0.428771973,
        -0.254913002, -2.57906389, 0.795338988,
        -1.79443192, -0.741266966, -0.484485,
        -0.031826999, -2.57856297, 0.863588929,
        -1.62747312, -0.742700994, -0.530189991,
        0.134270996, -2.55239987, 0.815742016,
        -1.48565102, -0.733847976, -0.442589998,
        0.276890993, -2.55630016, 0.930444002,
        -1.32364798, -0.733256996, -0.491246998,
        0.453842998, -2.55749083, 0.958379984,
        -1.13357699, -0.721163988, -0.462051004,
        0.577353001, -2.65243196, 0.878522992,
        -0.985085964, -0.664599001, -0.384290993,
        0.67700398, -2.57205892, 0.763386011,
        -0.832328975, -0.744921029, -0.396719992,
        0.829016984, -2.55362988, 0.823037982,
        -0.68622601, -0.606750011, -0.378974974,
        0.994199991, -2.55411601, 0.777837038,
        -0.518276989, -0.576183021, -0.397085965,
        1.15425599, -2.48412299, 0.781949997,
        -0.366930008, -0.636873007, -0.434150994,
        1.37123406, -2.54967594, 0.794487,
        -0.21212101, -0.687614977, -0.386219978,
        1.53180289, -2.53182292, 0.743286014,
        -0.0427739993, -0.736392021, -0.382640988,
        1.67364299, -2.60984993, 0.82595706,
        0.0879390016, -0.737654984, -0.288497984,
        1.83938706, -2.55281997, 0.807416975,
        0.186179996, -0.734808028, -0.422987998,
        0.298794001, -0.617118001, -0.417530984,
        0.45389998, -0.656823039, -0.383574009,
        0.674414992, -0.727863014, -0.448668003,
        0.833393991, -0.682932019, -0.429966033,
        0.986700058, -0.626838028, -0.404183984,
        1.14087903, -0.687842965, -0.391481996,
        1.30667996, -0.680894971, -0.345551997,
        1.46542799, -0.619436979, -0.369273007,
        1.68882298, -0.693354011, -0.426698983,
        -1.44326997, -2.42605805, 0.782573998,
        -1.27838707, -2.39400291, 0.763179064,
        -1.11214495, -2.40330887, 0.797417998,
        -0.944003999, -2.41298103, 0.809423983,
        -0.777840018, -2.38363504, 0.821951985,
        -0.50939399, -2.44848585, 0.895098031,
        -0.340101004, -2.42657113, 0.865929008,
        -1.94268, -0.49337098, -0.399381012,
        -0.158922002, -2.44402504, 0.80431807,
        -1.76381707, -0.566498995, -0.476100028,
        0.00909600034, -2.42772293, 0.797010005,
        -1.58939695, -0.574413002, -0.498609006,
        0.132551998, -2.39066696, 0.898256958,
        -1.40694606, -0.59008801, -0.450336009,
        0.292890012, -2.34138298, 0.914463043,
        -1.30720806, -0.516044974, -0.344763011,
        0.434394002, -2.42307901, 0.850614071,
        -1.125525, -0.573203981, -0.370706975,
        0.598590016, -2.47571397, 0.88055402,
        -1.00754404, -0.524783969, -0.483657002,
        0.743360996, -2.401299, 0.804270029,
        -0.844863057, -0.587031007, -0.328395009,
        0.904760957, -2.40888596, 0.882918,
        -0.678134978, -0.461553007, -0.459093034,
        1.02554107, -2.37711287, 0.768278956,
        -0.524639964, -0.453372002, -0.523185015,
        1.18718994, -2.319906, 0.774006009,
        -0.387198031, -0.48715201, -0.351987004,
        1.30134892, -2.409168, 0.858042002,
        -0.238878012, -0.527121007, -0.418265998,
        1.44695997, -2.39155507, 0.779165983,
        -0.0858540013, -0.585801005, -0.337740004,
        1.66811407, -2.43535805, 0.806312978,
        0.0733859986, -0.607419014, -0.398489982,
        1.83677101, -2.38344598, 0.830954969,
        0.188940018, -0.502110004, -0.461897969,
        1.9664371, -2.47110891, 0.904320002,
        0.418464005, -0.493470013, -0.409040987,
        2.11679411, -2.40662408, 0.843312025,
        0.590996981, -0.567050993, -0.369587988,
        0.730026007, -0.471246004, -0.354254991,
        0.858197987, -0.517229974, -0.44411999,
        1.01452494, -0.486452997, -0.510792017,
        1.17963302, -0.517316997, -0.356969982,
        1.32815099, -0.53937602, -0.432393014,
        1.48406696, -0.489654005, -0.485247016,
        1.61677802, -0.538329005, -0.381776989,
        -1.20420909, -2.25390911, 0.841551065,
        -1.03094697, -2.26721406, 0.867998958,
        -0.90099895, -2.25474882, 0.761730015,
        -0.761714995, -2.221524, 0.861585021,
        -0.622277975, -2.32344294, 0.857210994,
        -0.456501007, -2.30438995, 0.818132997,
        -1.79815507, -0.395904005, -0.430464029,
        -0.322266012, -2.24556899, 0.894122958,
        -1.63627195, -0.401808023, -0.51119101,
        -0.158169001, -2.27996397, 0.891918004,
        -1.45906496, -0.344027996, -0.525602996,
        0.058743, -2.26759791, 0.797535002,
        -1.307778, -0.386099994, -0.457866013,
        0.178524002, -2.21993995, 0.901689053,
        -1.15487397, -0.443327963, -0.495249033,
        0.39338398, -2.26749897, 0.795531034,
        -0.957467973, -0.355470002, -0.461561978,
        0.55834198, -2.23733687, 0.833495975,
        -0.845187068, -0.481890023, -0.459605992,
        -0.777492046, -0.323601007, -0.493013978,
        0.699624002, -2.15405083, 0.842705965,
        -0.606330037, -0.310268998, -0.494010031,
        0.811502934, -2.26616096, 0.878996968,
        -0.45508799, -0.342929989, -0.400655985,
        0.96745193, -2.2264142, 0.803732991,
        -0.291794986, -0.371463001, -0.427623034,
        1.13291407, -2.15946007, 0.804836988,
        -0.131192997, -0.360644996, -0.39606598,
        1.33921206, -2.25233698, 0.803303957,
        0.0374040008, -0.435359985, -0.395981967,
        1.55073285, -2.33623791, 0.893772006,
        0.280427992, -0.396717012, -0.366584986,
        1.69084501, -2.2456708, 0.904808998,
        0.435756028, -0.353285998, -0.494516999,
        1.84468794, -2.21690416, 0.845523,
        0.574685991, -0.407130003, -0.422832012,
        1.98125696, -2.30031586, 0.889775991,
        0.725067019, -0.347723991, -0.482672989,
        2.10682201, -2.24855995, 0.781937957,
        0.82653898, -0.332916021, -0.335361004,
        2.26479912, -2.31204891, 0.829850972,
        0.974109054, -0.431033969, -0.359243989,
        2.39739895, -2.19690299, 0.834078074,
        1.12168205, -0.375083983, -0.435648024,
        1.32516897, -0.382323027, -0.369767994,
        1.48323607, -0.325094998, -0.427311003,
        -1.25601304, -2.05266595, 0.819612026,
        -1.11093605, -2.11646986, 0.88140595,
        -0.908313036, -2.09921098, 0.831516027,
        -0.740622044, -2.06453395, 0.799010992,
        -0.60076803, -2.15212488, 0.836256027,
        -0.414897025, -2.05218911, 0.822492003,
        -1.59112191, -0.229169995, -0.483705014,
        -0.208709985, -2.07566118, 0.833901048,
        -1.43206501, -0.212724, -0.412289977,
        -0.0621870011, -2.15401793, 0.851204991,
        -1.26386404, -0.224106014, -0.413249999,
        0.0871710032, -2.08641005, 0.875165999,
        -1.11210907, -0.292442977, -0.426836997,
        0.264863998, -2.08120489, 0.893363953,
        -1.00268102, -0.169994995, -0.406976998,
        0.443735987, -2.13021588, 0.902121067,
        -0.855270028, -0.250514984, -0.367968023,
        0.567404985, -2.06325006, 0.796616971,
        -0.690863967, -0.166109994, -0.400743008,
        0.727971017, -1.98957586, 0.824058056,
        -0.518417954, -0.194531992, -0.416513979,
        0.853401065, -2.10542703, 0.806028008,
        -0.401472032, -0.200778008, -0.303333014,
        1.00482297, -2.07825899, 0.874202967,
        -0.239669994, -0.242645994, -0.340053022,
        1.14585304, -1.99139392, 0.860675991,
        -0.117155999, -0.201138005, -0.454649985,
        1.2752099, -2.10502505, 0.861866951,
        0.00169800001, -0.278340012, -0.319245011,
        1.42098308, -2.15427899, 0.920157015,
        0.165582001, -0.267246008, -0.381408036,
        1.58031297, -2.12788486, 0.88853097,
        0.342525005, -0.237722993, -0.426176995,
        1.75069499, -2.08469105, 0.850035071,
        0.581310034, -0.238944009, -0.390275985,
        1.93608308, -2.10942292, 0.933765054,
        0.745157957, -0.191138998, -0.407441974,
        2.05515909, -2.08000183, 0.815186977,
        0.910688996, -0.192638993, -0.42305702,
        2.22661209, -2.14112401, 0.840546012,
        1.04528093, -0.239822984, -0.518544018,
        2.4939599, -2.05819201, 0.879752994,
        1.25651097, -0.27353999, -0.483987004,
        1.38455701, -0.187965006, -0.392715007,
        -1.36274695, -1.89963305, 0.857199073,
        -1.18952096, -1.906443, 0.882341981,
        -1.02433193, -1.97030997, 0.84669596,
        -0.860546947, -1.94404507, 0.89507997,
        -0.726953983, -1.89746094, 0.803828955,
        -1.64708996, -0.0852329955, -0.405176997,
        -0.57644999, -1.98302698, 0.789027035,
        -1.48302603, -0.0510540009, -0.453306019,
        -0.44888401, -1.89308703, 0.866822958,
        -1.31997895, -0.0848039985, -0.507987022,
        -0.29757601, -1.93403399, 0.813609004,
        -1.16280603, -0.101418003, -0.346749008,
        -0.0493950024, -1.99217415, 0.91170907,
        -1.00951207, -0.00894899946, -0.342830986,
        0.140844002, -1.93294191, 0.893648982,
        -0.923424006, -0.045984, -0.495315015,
        0.302550018, -1.91889, 0.927776992,
        -0.752420962, -0.0248069987, -0.487923026,
        -0.63131398, -2.65621495, 1.84376693,
        0.428451002, -1.97582102, 0.834930003,
        -0.583515048, -0.0618479997, -0.486419976,
        -0.458352029, -2.69024086, 1.86295485,
        0.592535973, -1.90853095, 0.896472037,
        -0.432177007, -0.0454409979, -0.382205963,
        -0.305124015, -2.6915822, 1.7710259,
        0.704753995, -1.82447696, 0.799067974,
        -0.122280002, -2.68992305, 1.78762794,
        -0.229142994, -0.0832619965, -0.414756,
        0.0452039987, -2.68524599, 1.84899294,
        0.214673996, -2.687433, 1.79114699,
        -0.0438959971, -0.0530340001, -0.404468983,
        0.891414046, -1.95329714, 0.866666973,
        0.0424229987, -0.227723986, -0.483480036,
        1.03140903, -1.89310491, 0.957857966,
        0.125577003, -0.082092002, -0.435764998,
        1.18636501, -1.83689094, 0.90605396,
        0.30171901, -0.0807210058, -0.454083025,
        1.30610096, -1.94951701, 0.895577967,
        0.461883008, -0.115769997, -0.403835982,
        1.4637599, -2.00079584, 0.869358063,
        1.63338614, -1.97864389, 0.911154032,
        0.628499985, -0.0695519969, -0.415844977,
        1.84779, -1.95359111, 0.811847985,
        0.885140955, -0.0471509993, -0.516674995,
        1.98877192, -1.95059705, 0.911777973,
        1.05883193, -0.121506006, -0.377418011,
        2.16062689, -1.93775702, 0.856734037,
        1.22902501, -0.114078, -0.406091988,
        2.32642508, -1.97881508, 0.877842069,
        2.39127302, -1.81552792, 0.861185968,
        2.54892015, -1.890957, 0.876015007,
        -1.56718206, -2.579952, 1.72760403,
        -1.41573596, -2.48445606, 1.75299597,
        -0.705752969, -2.49952507, 1.80613196,
        -1.75369501, -1.77285898, 0.874563038,
        -0.544076979, -2.45937586, 1.868469,
        -1.58585393, -1.82450986, 0.863451004,
        -0.405282021, -2.55297613, 1.72497606,
        -1.34599805, 0.107484005, -0.403613985,
        -0.212682009, -2.54547882, 1.76105404,
        -1.192644, 0.0313620009, -0.452010036,
        -1.43853295, -1.75412393, 0.815963984,
        -0.047484003, -2.51131487, 1.80671096,
        -1.06225204, 0.144962996, -0.402839988,
        0.115065001, -2.54402685, 1.77317095,
        -1.31463301, -1.74872994, 0.931748986,
        0.270506978, -2.53661108, 1.71273303,
        -0.888534069, 0.106215, -0.404561996,
        -1.15323305, -1.67712307, 0.892551005,
        0.382397979, -2.63055301, 1.80316508,
        -0.712409973, 0.117069006, -0.39129898,
        0.551873982, -2.59915209, 1.75207508,
        -0.541383028, 0.0898530036, -0.417645037,
        -1.047333, -1.80738008, 0.889266014,
        -0.409865975, 0.16703999, -0.335232019,
        -0.886394978, -1.76857495, 0.861227989,
        -0.302222997, 0.0710639954, -0.430649996,
        -0.723819017, -1.73897386, 0.825633049,
        -0.135053992, 0.0657749996, -0.48327601,
        -0.601677001, -1.83659399, 0.907431006,
        0.0458789989, 0.0947369933, -0.446138978,
        -0.310658991, -1.82060099, 0.941394031,
        0.223512009, 0.0701609999, -0.467028022,
        -0.163286999, -1.84075499, 0.826581001,
        0.403398037, 0.0565559976, -0.504513025,
        0.647801995, 0.088944003, -0.525990009,
        0.00595199969, -1.85035801, 0.825783014,
        0.765437961, 0.0363029987, -0.41118899,
        0.147321001, -1.77134109, 0.87609005,
        0.890196025, 0.160962, -0.408822,
        0.293738991, -1.80699015, 0.801998973,
        1.01692796, 0.0400109999, -0.434436023,
        0.462191999, -1.81452298, 0.851523042,
        0.592929006, -1.71150899, 0.841233015,
        0.786750019, -1.68940508, 0.859535933,
        0.892622948, -1.79775286, 0.922322989,
        1.0412581, -1.72627509, 0.889889956,
        1.16064894, -1.74789906, 0.769593,
        1.31396401, -1.74197102, 0.850947022,
        1.39362907, -1.87298989, 0.771687031,
        1.55596197, -1.87013388, 0.813158989,
        1.72827911, -1.85132694, 0.870015025,
        1.90124094, -1.79261708, 0.894633055,
        -0.593304038, -2.31333303, 1.7716651,
        2.06879997, -1.8036871, 0.885015011,
        -0.435483009, -2.37929106, 1.74292195,
        2.22726297, -1.773507, 0.849617958,
        -0.292944014, -2.41296601, 1.83068097,
        2.32499099, -1.70199895, 0.972357035,
        -0.14091301, -2.37586188, 1.77596998,
        2.52840281, -1.724298, 0.930477023,
        0.0804660022, -2.41731906, 1.88456988,
        0.248006999, -2.40692091, 1.82368505,
        0.416598022, -2.46105599, 1.78110003,
        0.533048987, 0.186638996, -0.433562994,
        0.71143198, 0.208913997, -0.410768986,
        -2.0470171, -1.60597193, 0.810585022,
        -1.91143799, -1.71682799, 0.820706964,
        -1.63446903, -1.64378107, 0.857454062,
        -1.42343092, -1.59412193, 0.856253982,
        -1.27940404, -1.58712292, 0.953130007,
        -1.11149096, -1.56075597, 1.00886703,
        -0.991380036, -1.64227796, 0.905703068,
        -0.866189957, -1.53699303, 0.894752979,
        -0.709725022, -1.59090292, 0.885726035,
        -0.568046987, -1.678473, 0.872696996,
        -0.402024031, -1.68137991, 0.921222031,
        -0.222819, -1.69245291, 0.895349979,
        -0.0672120005, -1.69462204, 0.804249048,
        0.0764070004, -1.62752986, 0.899736047,
        0.221564993, -1.64038801, 0.803054988,
        0.40672797, -1.67648399, 0.782060981,
        0.50288403, -1.58814597, 0.902745008,
        0.671877027, -1.57180786, 0.904532969,
        0.823332071, -1.52040887, 0.841491044,
        0.96983403, -1.56962991, 0.912966013,
        1.19255996, -1.66824913, 0.943973958,
        -0.398604035, -2.18017793, 1.77360892,
        1.35958195, -1.58156705, 0.833135962,
        -0.185028002, -2.21038818, 1.821702,
        1.464939, -1.72235692, 0.759027004,
        -0.0191639997, -2.28129292, 1.8422401,
        1.61467803, -1.72428894, 0.841719031,
        0.110891998, -2.15680194, 1.88508296,
        1.76067901, -1.70044506, 0.92593503,
        0.279525012, -2.22399902, 1.85892296,
        1.98623407, -1.70728505, 0.771569967,
        0.423041999, -2.29264188, 1.76974487,
        2.03635502, -1.64330399, 0.91760397,
        0.462027013, -2.19910192, 1.90437305,
        2.20143008, -1.61097598, 0.909965992,
        0.618900001, -2.27196598, 1.86113405,
        2.36059809, -1.59171605, 0.84168303,
        0.86748898, -2.24355316, 1.80168593,
        2.55248094, -1.56827712, 0.846756041,
        -2.16946197, -1.48714209, 0.852486014,
        -2.00367904, -1.45442998, 0.743934035,
        -1.86158109, -1.53767395, 0.842619002,
        -1.70964003, -1.49568009, 0.900386989,
        -1.54469395, -1.47638106, 0.911339998,
        -1.39044309, -1.43581498, 0.854741931,
        -1.17433798, -1.49110806, 0.865463972,
        -1.01332498, -1.45489502, 0.912101984,
        -0.870074987, -1.38297296, 0.962892056,
        -0.740076005, -1.43086505, 0.867407978,
        -0.597351015, -1.498119, 0.800285935,
        -0.446451008, -1.52230203, 0.877229929,
        -0.309798002, -1.4300549, 0.831071973,
        -0.181649998, -1.53645611, 0.863408983,
        -0.0523680001, -1.51477194, 0.75148201,
        -0.0580260009, -2.06318402, 1.86094809,
        0.104007006, -1.48913693, 0.814350009,
        0.0985739976, -2.00784612, 1.79909098,
        0.269154012, -1.47481501, 0.81793803,
        0.263997018, -2.06214595, 1.79903388,
        0.435015023, -1.45957494, 0.822327018,
        0.428852975, -2.03623796, 1.85481596,
        0.603209972, -1.45101905, 0.799760938,
        0.576276004, -2.10580492, 1.82811606,
        0.817475975, -1.35865498, 0.787647009,
        0.951555014, -1.40270996, 0.880007982,
        0.715542018, -2.01109791, 1.83682501,
        1.10075104, -1.45436096, 0.839187026,
        0.857904017, -2.08017898, 1.73573399,
        1.26774001, -1.44693601, 0.791025043,
        1.02381301, -2.10806394, 1.78103399,
        1.19238007, -2.06065798, 1.74278104,
        1.44188094, -1.44813597, 0.777237058,
        1.70488811, -1.54730093, 0.874008,
        1.872051, -1.60694396, 0.848127007,
        1.94008207, -1.45713592, 0.870995998,
        2.09428787, -1.47748494, 0.940421999,
        2.25968695, -1.42438197, 0.906620979,
        2.43437696, -1.42986894, 0.862536013,
        -2.28270602, -1.32285893, 0.850085974,
        -2.11697698, -1.32861304, 0.796095014,
        -1.94729996, -1.305843, 0.812433004,
        -1.81282187, -1.36491907, 0.894344926,
        -1.64330399, -1.33249497, 0.905915976,
        -1.50042009, -1.31432402, 0.823535979,
        -1.35621905, -1.24354804, 0.867947996,
        -1.20626998, -1.23846602, 0.947327971,
        -0.170003995, -1.92570901, 1.82067895,
        -1.10240102, -1.32752407, 0.851319015,
        -0.00211200002, -1.87484097, 1.77978611,
        0.192294002, -1.86981905, 1.85223007,
        -0.941588998, -1.28559303, 0.840702057,
        0.342498004, -1.91510987, 1.78942204,
        -0.776306987, -1.26253796, 0.89030695,
        0.559778988, -1.94222403, 1.79057407,
        -0.622677028, -1.32622802, 0.831764996,
        0.700818002, -1.86430502, 1.74735904,
        -0.463809013, -1.31581497, 0.850973964,
        0.850412965, -1.91961002, 1.789518,
        -0.32633698, -1.27589703, 0.762923956,
        0.973217964, -1.97548807, 1.88598597,
        -0.152472004, -1.38261306, 0.797349036,
        1.13393104, -1.92107999, 1.83191407,
        0.0108449999, -1.35281706, 0.776814044,
        0.179103002, -1.33266294, 0.810990036,
        0.345068991, -1.31877303, 0.849761963,
        0.502590001, -1.31108701, 0.765774012,
        0.667194009, -1.29381001, 0.797729969,
        0.921863973, -1.23114598, 0.788748026,
        1.07066107, -1.29811502, 0.795132041,
        1.20895195, -1.32715201, 0.886229992,
        1.35187197, -1.29843903, 0.783905983,
        1.49142003, -1.32887399, 0.885354042,
        1.650738, -1.29667497, 0.915228009,
        1.77958512, -1.398543, 0.880874991,
        1.91511905, -1.29065406, 0.855404973,
        2.08259106, -1.24514401, 0.883679986,
        -0.114983998, -1.75443006, 1.76663113,
        -2.39160895, -1.18563902, 0.865695,
        0.0326579995, -1.71647692, 1.85267401,
        -2.22703791, -1.12164903, 0.925568998,
        0.125588998, -1.77200103, 1.72050905,
        -2.06693101, -1.1991601, 0.898259997,
        0.286421984, -1.75905299, 1.76163888,
        -1.88031006, -1.17169201, 0.884555936,
        0.463196993, -1.80516911, 1.747491,
        -1.74278104, -1.24702799, 0.797861934,
        0.614078999, -1.72309506, 1.76651108,
        0.786549032, -1.78094411, 1.86200702,
        -1.65496492, -1.14218092, 0.897861004,
        0.946823955, -1.79952002, 1.90294504,
        -1.48871708, -1.14498901, 0.81142199,
        1.10767496, -1.74919796, 1.85099697,
        -1.33779907, -1.07542503, 0.772830009,
        1.26786602, -1.75932002, 1.77924609,
        -1.22444105, -1.08262801, 0.894261003,
        -1.07197201, -1.15273798, 0.855281949,
        -0.901244998, -1.13982904, 0.910932004,
        -0.735183001, -1.10907006, 0.850724995,
        -0.591992974, -1.18143296, 0.907868981,
        -0.467790008, -1.16243398, 0.79539001,
        -0.313863009, -1.115376, 0.829829931,
        -0.0750270039, -1.21236897, 0.842850029,
        0.0874229968, -1.19719195, 0.778739929,
        -1.88998199, 1.07816994, -0.356079012,
        0.262470007, -1.21191299, 0.733520985,
        -1.74123895, 1.15222204, -0.451085985,
        0.418560028, -1.17537904, 0.804731965,
        0.595628977, -1.1328001, 0.809682012,
        0.771152973, -1.15788603, 0.835277975,
        0.915579021, -1.06584001, 0.815055013,
        1.060812, -1.14475501, 0.863532007,
        1.229298, -1.17443395, 0.814200044,
        -0.219492003, -1.63843203, 1.83399296,
        1.35721803, -1.112625, 0.722328007,
        -0.139799997, -1.49794197, 1.76133609,
        -0.00760199968, -1.63775706, 1.70490003,
        1.47239995, -1.17321002, 0.824909985,
        0.141389996, -1.60595107, 1.79365802,
        1.62317705, -1.1291101, 0.890291929,
        0.305469006, -1.59580207, 1.79267406,
        1.77280807, -1.19952905, 0.851531982,
        0.467694014, -1.64113498, 1.791834,
        1.92695093, -1.12150502, 0.822989941,
        0.616358995, -1.55861092, 1.803105,
        2.06450081, -1.07266796, 0.921006024,
        0.819689989, -1.62257099, 1.88438702,
        -2.0352211, 1.155231, -0.436002016,
        0.944133043, -1.52886307, 1.82789707,
        -1.89328802, 1.25918102, -0.362711996,
        1.15269303, -1.57875586, 1.86259496,
        -1.73342991, 1.33200598, -0.418076992,
        -2.46830106, -1.02990603, 0.862107038,
        -2.31503391, -0.981230974, 0.904410005,
        -2.10353398, -1.04931295, 0.829005003,
        -1.92679203, -1.012797, 0.826862991,
        -1.7811389, -1.08314097, 0.781910956,
        -1.63422298, -0.992177963, 0.821604013,
        -1.47167099, -0.977874041, 0.790941,
        -1.32057297, -0.939123034, 0.874712944,
        -1.10514295, -0.972447038, 0.894608974,
        -0.953732967, -0.960848987, 0.95470798,
        -0.860222936, -1.002231, 0.82089901,
        -0.63639605, -1.02382803, 0.953261971,
        -0.473688006, -1.0640161, 0.934419036,
        -0.347072989, -0.958152056, 0.89240694,
        -0.186300009, -1.01344204, 0.854372978,
        -0.0185550004, -1.0561111, 0.810402036,
        -0.307793975, -1.48735499, 1.79065204,
        0.0871049985, -0.95767796, 0.904806018,
        -0.0844559968, -1.39348507, 1.88056803,
        0.261179984, -0.995975971, 0.908097029,
        -0.0098369997, -1.54786491, 1.84469414,
        0.313848019, -1.05452991, 0.76335901,
        0.219021007, -1.449579, 1.77546,
        0.472992003, -1.01744401, 0.782081962,
        0.35335499, -1.37092507, 1.8411839,
        0.469944, -1.47531307, 1.78132486,
        0.691245019, -0.994715989, 0.859799981,
        0.618452966, -1.42119908, 1.70980501,
        0.869547009, -0.907449007, 0.769608021,
        0.77908206, -1.51508713, 1.75991702,
        -2.01928496, 1.382622, -0.401250005,
        1.02808809, -0.934865952, 0.812496006,
        -1.85613608, 1.43961596, -0.339509994,
        0.90753305, -1.394292, 1.74614096,
        1.17132902, -1.01777399, 0.914784014,
        1.08200097, -1.43531394, 1.79663992,
        -1.72389901, 1.5332849, -0.414561033,
        1.33101904, -1.01625299, 0.856551051,
        1.27814102, -1.46981394, 1.80014992,
        1.48052096, -1.03924799, 0.933683991,
        1.61495996, -0.960420012, 0.864618063,
        1.76940608, -1.03113294, 0.825299978,
        1.90594196, -0.962043047, 0.762494981,
        2.06937885, -0.934076965, 0.815481067,
        -2.54886293, -0.869874001, 0.854777992,
        -2.38156199, -0.869885981, 0.807422996,
        -2.24021411, -0.78858304, 0.850292981,
        -2.07648587, -0.796938062, 0.871209025,
        -1.91973901, -0.859313965, 0.902108967,
        -1.78080904, -0.934763968, 0.856827021,
        -0.302957982, -1.32573307, 1.72719288,
        -1.60612202, -0.840363026, 0.749508023,
        -0.15309, -1.26744604, 1.79331303,
        -1.43468094, -0.818897963, 0.76602298,
        -0.0233789999, -1.37084103, 1.73235905,
        -1.27429497, -0.846482992, 0.734318972,
        0.173451006, -1.28439593, 1.84084201,
        -2.19644094, 1.57274401, -0.410730004,
        -1.18627501, -0.830354929, 0.872954965,
        0.336795002, -1.20780897, 1.82173514,
        -1.011096, -0.843840003, 0.843489051,
        -1.92813301, 1.58905196, -0.431990981,
        0.490070999, -1.30143309, 1.75635004,
        -0.816747069, -0.866523027, 0.914963961,
        -1.79883599, 1.68191707, -0.344538003,
        0.698325038, -1.23853803, 1.70754004,
        -0.667001963, -0.904254019, 0.835680008,
        0.879977942, -1.25690997, 1.65722704,
        -0.512822986, -0.90160203, 0.91644001,
        1.03358102, -1.28115296, 1.73109007,
        -0.400287032, -0.801272988, 0.823967993,
        1.19826305, -1.32432902, 1.73248792,
        -0.275202006, -0.808680058, 0.942876041,
        1.36291802, -1.31580603, 1.77914691,
        -0.119447999, -0.858047962, 0.885288,
        0.0305010006, -0.807278991, 0.940512061,
        0.189803988, -0.880145967, 0.800360978,
        0.352335006, -0.897729039, 0.809769034,
        0.555108011, -0.887015998, 0.842664003,
        0.706187963, -0.847056031, 0.786368966,
        0.83396101, -0.784341037, 0.884615958,
        0.977988005, -0.778998017, 0.778214931,
        1.18803, -0.893736005, 0.793520987,
        1.34480703, -0.855798006, 0.774780035,
        1.45274401, -0.87994802, 0.899460018,
        1.60604405, -0.796992064, 0.888461947,
        1.76084697, -0.839172006, 0.81853199,
        1.92106199, -0.833754063, 0.869207978,
        2.06032515, -0.75917697, 0.804710984,
        -2.11707306, 1.74085808, -0.407141984,
        -1.94184303, 1.78954804, -0.381146997,
        -0.464163005, -1.19433904, 1.71697187,
        -0.277595997, -1.15821004, 1.74858308,
        -0.112101004, -1.10030103, 1.79514909,
        0.0236820001, -1.21919394, 1.77470708,
        -2.60246992, -0.722330987, 0.785153985,
        0.200397, -1.11554694, 1.85654688,
        -2.44148397, -0.714671969, 0.839544058,
        0.355800003, -1.03682399, 1.84694099,
        -0.375762016, 1.75319386, -0.406400979,
        -2.32044005, -0.675494969, 0.943452001,
        0.484182, -1.12872303, 1.79745603,
        -0.189338982, 1.72606802, -0.403892994,
        0.695499003, -1.075647, 1.74582303,
        0.000828000018, 1.73899508, -0.394692004,
        0.848823071, -1.09001398, 1.812639,
        -2.17185307, -0.639026999, 0.77521193,
        0.999891043, -1.1521771, 1.84593594,
        -1.94043612, -0.721724987, 0.809894979,
        -1.43287504, -2.70368099, -0.266291976,
        1.14942908, -1.15896297, 1.77053094,
        -1.78028405, -0.775143027, 0.839075983,
        -1.267506, -2.73438001, -0.322712988,
        -1.65349495, -0.673601985, 0.807428956,
        1.30187106, -1.17191398, 1.85671806,
        -1.49063706, -0.659789979, 0.775820971,
        -1.09812593, -2.74165487, -0.267756015,
        -1.35188699, -0.717285037, 0.861038983,
        -0.923081994, -2.71728611, -0.268094987,
        -1.19113803, -0.69749403, 0.773105979,
        -1.04725504, -0.695078969, 0.909152985,
        -0.878064036, -0.740777969, 0.820268989,
        -0.702450037, -0.743957996, 0.873147011,
        -0.534048021, -0.735579014, 0.915330052,
        -0.36373198, -0.662211001, 0.914261937,
        -0.225303009, -0.701063991, 0.822192013,
        -0.0491699986, -0.68798703, 0.835379958,
        0.112250999, -0.726815999, 0.817170024,
        0.270234019, -0.751752019, 0.867519021,
        0.999363005, -2.71105194, -0.288330019,
        0.386222988, -0.621522009, 0.802551031,
        0.438329995, -0.769440055, 0.85146904,
        0.59779501, -0.722184002, 0.859853983,
        0.806235015, -0.630614996, 0.81140399,
        1.07690704, -0.641903996, 0.78322804,
        1.22796905, -0.725244045, 0.785354972,
        1.34165096, -0.611307025, 0.728841007,
        1.42267799, -0.720453024, 0.851639986,
        1.58139002, -0.636291027, 0.875378966,
        1.738554, -0.616140008, 0.818783998,
        1.90476298, -0.657950997, 0.790872037,
        -0.329210997, -0.997419, 1.75884914,
        -0.602319002, 1.92416096, -0.431720972,
        -0.423627019, 1.91522706, -0.487257004,
        -0.178965002, -0.948698997, 1.81700706,
        -0.0140070003, -0.958692074, 1.79298306,
        -0.224160016, 1.90713894, -0.428646028,
        0.154946998, -0.958760977, 1.82940292,
        0.013146, 1.92537296, -0.38597101,
        0.307572007, -0.892452002, 1.78074896,
        0.413217008, -0.991122007, 1.69389606,
        0.589419007, -1.01687098, 1.85917807,
        0.70551002, -0.905898035, 1.78915501,
        0.872612953, -0.904971004, 1.86795902,
        1.05353999, -0.993420005, 1.79876697,
        1.20270002, -1.00422001, 1.72067106,
        -1.34666395, -2.55306292, -0.254657984,
        1.35822892, -1.01261699, 1.80590093,
        -2.58069611, -0.568794012, 0.861696005,
        -1.17736197, -2.58572698, -0.289596021,
        -2.41069508, -0.546851993, 0.866373003,
        -1.01624405, -2.53795815, -0.306270003,
        -2.28284097, -0.49811703, 0.768626928,
        -0.863577008, -2.57578802, -0.189078003,
        -2.0844121, -0.52186197, 0.864426017,
        -0.733736992, -2.580024, -0.302877009,
        -1.91546094, -0.53133601, 0.849599957,
        -0.586362004, -2.56014585, -0.207819015,
        -1.72936201, -0.528560996, 0.852452993,
        -0.411462009, -2.55980992, -0.229686007,
        -1.58168697, -0.502490997, 0.778698027,
        -0.232928991, -2.55400491, -0.239661008,
        -1.46722198, -0.537009001, 0.893918991,
        -0.0680970028, -2.55489588, -0.295119017,
        -1.28760898, -0.572328031, 0.827943027,
        0.107900999, -2.54065514, -0.299243987,
        -1.11747599, -0.543260992, 0.811214983,
        0.273420006, -2.55420303, -0.358503014,
        -0.942452967, -0.587637007, 0.843282044,
        0.411680996, -2.55118799, -0.254220009,
        -0.774504066, -0.595236003, 0.843255043,
        0.555801034, -2.58649206, -0.348966002,
        -0.628811955, -0.59068501, 0.921203971,
        0.700868964, -2.57465696, -0.256401002,
        -0.494976014, -0.60135901, 0.827067018,
        0.852815986, -2.62523699, -0.316935003,
        -0.369138002, -0.499086022, 0.870090008,
        0.999017954, -2.53773904, -0.292688996,
        -0.220347002, -0.564992964, 0.916685939,
        1.15839601, -2.61818099, -0.310178995,
        -0.0859410018, -0.519356966, 0.829829931,
        0.0669209957, -0.577257037, 0.890115023,
        0.222570002, -0.598196983, 0.818951964,
        0.341037005, -0.455496013, 0.761106014,
        -0.552603006, 2.10279608, -0.442886978,
        0.497730017, -0.500364006, 0.843977988,
        -0.445041001, -0.839679003, 1.78689885,
        -0.370343983, 2.09334898, -0.478026032,
        0.649782002, -0.563142002, 0.841362,
        -0.273662984, -0.808989048, 1.79066098,
        -0.26553899, 2.05776, -0.328487992,
        -0.106766999, -0.798909009, 1.82867396,
        0.784766972, -0.469053, 0.781314015,
        0.0730350018, -0.815462947, 1.80450606,
        0.941720963, -0.540084004, 0.788471997,
        0.227708995, -0.754242003, 1.79842794,
        1.13197494, -0.487076998, 0.798222005,
        0.393045008, -0.743103027, 1.77045298,
        1.29303598, -0.470364034, 0.82298702,
        0.472562969, -0.897819042, 1.82634008,
        1.44328499, -0.543197989, 0.833210945,
        0.761489987, -0.772071004, 1.87291813,
        1.5996449, -0.499395013, 0.785928011,
        0.833835006, -0.822327018, 1.70847011,
        1.84369206, -0.494081974, 0.869088054,
        0.998786926, -0.833142042, 1.77371097,
        2.00656796, -0.521780968, 0.821171999,
        1.20903897, -0.862970948, 1.83666301,
        1.377267, -0.839309931, 1.77814507,
        -1.23048604, -2.42411089, -0.237861007,
        -1.03329301, -2.36355305, -0.322739989,
        -0.87992996, -2.43916798, -0.288882017,
        -0.729467988, -2.37048292, -0.293457001,
        -0.65300101, -2.41482592, -0.150341988,
        -0.433830023, -2.327595, -0.305858999,
        -0.323471993, -2.41531801, -0.216462001,
        -0.166301996, -2.40273905, -0.300683975,
        0.00701400032, -2.40151787, -0.322973996,
        0.214013994, -2.40384603, -0.30943799,
        0.372215986, -2.36256313, -0.333306015,
        0.485156983, -2.40100813, -0.22338599,
        -0.522305965, 2.2772789, -0.384087026,
        0.642996013, -2.42367005, -0.210515991,
        -0.363216013, 2.27845192, -0.476796001,
        0.849339008, -2.45631599, -0.308025002,
        -0.183113992, 2.19867301, -0.410115004,
        1.00461292, -2.37182093, -0.207593992,
        -2.55337191, -0.396221995, 0.869769037,
        1.13907301, -2.4469409, -0.278079003,
        -2.40132904, -0.36581099, 0.775985956,
        1.29735899, -2.39586306, -0.311576992,
        -2.25450301, -0.356952012, 0.865298986,
        -2.09679604, -0.355560005, 0.821142018,
        -1.94085896, -0.353543997, 0.768203974,
        -1.82237101, -0.390164971, 0.889289975,
        -1.65689099, -0.360585004, 0.843854964,
        -1.47932398, -0.365561992, 0.814499974,
        -1.31942999, -0.41563502, 0.826644063,
        -1.09929895, -0.388269007, 0.898779035,
        -0.37409699, -0.674435973, 1.75076401,
        -0.984737992, -0.433476001, 0.792818964,
        -0.232490987, -0.588873029, 1.80647707,
        -0.799098015, -0.338514, 0.824288964,
        -0.0142289996, -0.668781042, 1.75559402,
        -0.67106998, -0.421896011, 0.922023058,
        -0.511139989, -0.438843012, 0.803318977,
        0.145190999, -0.610790968, 1.77858603,
        -0.382304996, -0.334529996, 0.819234014,
        0.305415004, -0.602111995, 1.82761502,
        0.473715007, -0.612147033, 1.84730411,
        -0.231642008, -0.400910974, 0.873260975,
        0.606281996, -0.716414988, 1.82537389,
        -0.0717060044, -0.381401986, 0.927690029,
        0.744437993, -0.629880011, 1.77057004,
        0.0526650026, -0.425586015, 0.813947976,
        0.893133044, -0.697322965, 1.79190612,
        0.168327004, -0.280224025, 0.931326032,
        1.03307998, -0.680664003, 1.701015,
        0.317514002, -0.342693001, 0.898070991,
        1.18117797, -0.698799014, 1.78470004,
        1.34953499, -0.665477991, 1.75199699,
        0.465041995, -0.341583014, 0.831537008,
        0.665508032, -0.353064001, 0.773750961,
        0.854295015, -0.316808999, 0.751914024,
        -0.396015018, 2.41786194, -0.356559008,
        1.010952, -0.38866201, 0.741171002,
        -1.0121789, -2.19914103, -0.241295993,
        -0.213153005, 2.37666297, -0.435285032,
        -0.900606036, -2.26921797, -0.397046983,
        1.17443693, -0.323810995, 0.762086987,
        1.34165704, -0.322584003, 0.760902047,
        -0.745422006, -2.20617294, -0.33969301,
        1.48472404, -0.382980019, 0.801987052,
        -0.595317006, -2.27349591, -0.233271003,
        1.628649, -0.348363012, 0.884738982,
        -0.460823983, -2.17729187, -0.256926,
        1.77525592, -0.348681003, 0.809201956,
        -0.277161002, -2.26925707, -0.283151984,
        1.93926001, -0.370490998, 0.771983981,
        -0.0772320032, -2.26266003, -0.235055983,
        0.101129994, -2.27975106, -0.261593997,
        0.256383002, -2.23885202, -0.319350004,
        0.418874979, -2.20207191, -0.355443001,
        0.573338985, -2.26792502, -0.275288999,
        0.733916998, -2.21698189, -0.239250004,
        0.884723961, -2.28253198, -0.292407006,
        1.02321303, -2.19535494, -0.216260999,
        1.17628801, -2.29285789, -0.211251006,
        1.28906405, -2.21918392, -0.311870992,
        1.44178498, -2.30241299, -0.283013999,
        -0.0765330046, -0.508250952, 1.80397797,
        0.0820650011, -0.454860002, 1.76611197,
        0.251058012, -0.423008978, 1.78604698,
        0.388562977, -0.52897799, 1.70697308,
        0.510177016, -0.407360971, 1.7273221,
        0.732423007, -0.455619037, 1.79171395,
        0.87964797, -0.530946016, 1.83963895,
        -2.49108315, -0.236535013, 0.850368023,
        0.991145968, -0.513947964, 1.70498693,
        -2.32223415, -0.210147008, 0.822153032,
        1.15322709, -0.525674999, 1.76952004,
        -2.15305805, -0.206193, 0.770298004,
        -1.98446095, -0.19833, 0.823436975,
        -0.243746996, 2.54374194, -0.364100993,
        -1.78998005, -0.279434979, 0.766476035,
        -1.68284702, -0.164994001, 0.826737046,
        -1.53047705, -0.214008003, 0.879411042,
        -1.33582795, -0.252395988, 0.845211029,
        -1.16153693, -0.236663997, 0.849096,
        -0.960783005, -0.286110014, 0.876821995,
        -0.83009994, -0.185042992, 0.89686203,
        -0.68353498, -0.250917017, 0.928961992,
        -0.624179959, -0.323502004, 0.789647937,
        -1.022367, -2.03019905, -0.242325008,
        -0.49157998, -0.205619991, 0.786873043,
        -0.860430002, -2.11486483, -0.242570996,
        -0.246704996, -0.23615399, 0.842154026,
        -0.110084996, -0.210711002, 0.933176994,
        -0.608550012, -2.11369801, -0.293520004,
        0.0235980004, -0.267654002, 0.851624966,
        -0.386658013, -2.03601313, -0.235094994,
        -0.247197002, -2.107095, -0.282000005,
        0.149372995, -0.116366997, 0.931445956,
        -0.119435996, -2.1142292, -0.172862992,
        0.281643003, -0.181299001, 0.837624013,
        0.0348780006, -2.12941194, -0.23171401,
        0.440759987, -0.1866, 0.890466034,
        0.192185998, -2.16019797, -0.186233997,
        0.564770997, -0.222620994, 0.779309988,
        0.333407998, -2.09920192, -0.241482005,
        0.735266984, -0.191033989, 0.784127951,
        0.517287016, -2.10402584, -0.267306,
        0.89566803, -0.157605007, 0.750573039,
        0.86334604, -0.341861993, 1.75093496,
        1.03921199, -0.23259601, 0.778544962,
        1.04386497, -0.356646001, 1.753299,
        0.735237002, -2.06852698, -0.321318001,
        1.35891902, -0.190505996, 0.855542958,
        0.874571979, -2.12040901, -0.232317001,
        1.49673605, -0.235953003, 0.719669998,
        1.03373098, -2.01578093, -0.172935009,
        1.69006801, -0.202259988, 0.808479071,
        1.18575597, -2.12263489, -0.218990982,
        1.876122, -0.220014006, 0.857262015,
        1.32925797, -2.00243402, -0.279299974,
        1.43665802, -2.13172197, -0.273294002,
        1.60138202, -2.08533907, -0.256125003,
        -2.43228292, -0.0777089968, 0.855627,
        -2.24012709, -0.0581699982, 0.774116993,
        -2.06668496, -0.056361001, 0.773381948,
        -1.92298794, -0.0025859999, 0.846384048,
        -1.76009095, -0.011136, 0.867291033,
        -1.62411296, -0.0621780008, 0.94729805,
        -1.53474605, -0.0501689985, 0.803853035,
        -1.40299201, -0.108312003, 0.89300406,
        -1.25842202, -0.102747001, 0.804839969,
        -0.971795976, -0.121541999, 0.945107996,
        -1.17444599, -1.930035, -0.241218001,
        -0.874109983, -0.0376259983, 0.830664039,
        -1.01707196, -1.86253202, -0.294189006,
        -0.702032983, -0.0800219998, 0.886743069,
        -0.868157983, -1.94028306, -0.247617006,
        -0.60491401, -0.074496001, 0.748767018,
        -0.697584033, -1.96303487, -0.239901006,
        -0.470543981, -0.0501869991, 0.847293019,
        -0.568979979, -1.86577201, -0.168237001,
        -0.33198899, -0.109911002, 0.779628038,
        -0.159290999, -0.0929759964, 0.810404956,
        -0.435066015, -1.89112794, -0.274029016,
        -0.000321, -0.0984719992, 0.862169981,
        -0.292163998, -1.95816898, -0.351765007,
        0.109869003, 0.0268799998, 0.850998044,
        -0.142365009, -1.96972513, -0.258668989,
        0.412521005, -0.0611940026, 0.773927987,
        0.0287909992, -1.99034393, -0.328590006,
        0.564399004, -0.0673260018, 0.844470024,
        0.259440005, -1.94825399, -0.288102001,
        0.714474022, 0.00381899998, 0.824064016,
        0.42544198, -1.96688414, -0.28658101,
        0.872985005, -0.026145, 0.853332043,
        0.606948018, -1.96352696, -0.300020993,
        1.02627897, -0.0853739977, 0.845541,
        1.19391298, -0.153390005, 0.775766969,
        0.744621038, -1.94880903, -0.204287991,
        1.32215106, -0.0318330005, 0.794153988,
        0.898133993, -1.95780897, -0.279947996,
        1.47524095, -0.0856409967, 0.786306024,
        1.05549002, -1.89750886, -0.297935992,
        1.61756694, -0.060804002, 0.860909939,
        1.18622994, -1.95559812, -0.206652001,
        1.78689599, -0.0722519979, 0.882861018,
        1.23913205, -1.84873796, -0.322349995,
        1.40282404, -1.86416411, -0.34740299,
        1.4964211, -1.93551898, -0.225698993,
        -2.67276907, 0.0675450042, 0.836775005,
        -2.49652505, 0.077166006, 0.832376957,
        -2.31847501, 0.0584009998, 0.870078027,
        -2.12618113, 0.103650004, 0.795578957,
        -1.96143293, 0.152972996, 0.894884944,
        -1.82264709, 0.139752001, 0.803448021,
        -1.63601112, 0.0990569964, 0.91109401,
        -1.50861001, 0.129801005, 0.801653981,
        -1.22448003, -1.75991392, -0.259863019,
        -1.35469496, 0.0384600013, 0.813165069,
        -1.07975399, -1.70409608, -0.329640001,
        -1.21085095, 0.111896999, 0.860087991,
        -0.818961024, -1.77707696, -0.294270009,
        -1.02325499, 0.0297689997, 0.895098031,
        -0.722315967, -1.78000498, -0.155168995,
        -0.869892001, 0.117405005, 0.892220974,
        -0.570912004, -1.70162094, -0.177563995,
        -0.700343966, 0.088259995, 0.852261007,
        -2.4292469, 0.0680489987, 1.769835,
        -0.421896011, -1.78868699, -0.133634999,
        -2.26170301, 0.0235529989, 1.75472403,
        -0.539192975, 0.0976379961, 0.809348941,
        -0.299576998, -1.73510706, -0.234741002,
        -2.09531689, -0.00534899998, 1.810269,
        -0.382281005, 0.0873630047, 0.881571054,
        -0.19225201, -1.82641196, -0.340551019,
        -1.93470287, 0.0458189994, 1.87646699,
        -0.0316470005, -1.83620095, -0.30855301,
        -0.25633502, 0.0421620011, 0.774794936,
        0.120494999, -1.85863805, -0.252719998,
        -0.0601259992, 0.0631109998, 0.85471797,
        0.260015994, -1.78048205, -0.300683975,
        0.0643169954, 0.174101993, 0.903198004,
        0.507257998, -1.85605812, -0.376754999,
        0.230724007, 0.146249995, 0.911651969,
        0.703953028, -1.82481909, -0.319904983,
        0.345771015, 0.0944520012, 0.801753044,
        0.840992928, -1.81062889, -0.217965007,
        0.986021996, -1.7403841, -0.259025991,
        0.510279, 0.0865380019, 0.765902996,
        1.15301704, -1.71121812, -0.270506978,
        0.701447964, 0.181776002, 0.817463994,
        1.32601202, -1.70338488, -0.328902006,
        0.843657017, 0.133998007, 0.897831023,
        1.48571098, -1.64324403, -0.303920984,
        0.997928977, 0.0871319994, 0.828755975,
        1.15546203, 0.0110849999, 0.827930927,
        1.27628696, 0.121149004, 0.815019011,
        1.50503707, 0.0665609986, 0.88321799,
        1.55089796, -1.79685009, -0.318893999,
        1.675776, 0.0834150016, 0.936735034,
        1.73092198, -1.817343, -0.308463007,
        -1.66630805, -2.71072817, 1.44422996,
        -1.59137702, -2.56000519, 1.46657705,
        -1.33450508, -2.71230602, 1.50857401,
        -1.13360107, -2.69794798, 1.55188799,
        -0.971588969, -2.70995712, 1.45137596,
        -0.778652966, -2.69698215, 1.51390493,
        -0.57672298, -2.71246505, 1.52696109,
        0.646269023, -2.69268298, 1.48446596,
        0.819597006, -2.690166, 1.43375397,
        0.984452963, -2.69039106, 1.50733805,
        -2.53490114, 0.209403008, 1.78476,
        -2.35318208, 0.211926013, 1.833987,
        -2.19844198, 0.128037006, 1.87995601,
        -2.06328607, 0.173771992, 1.78000498,
        -1.89453292, 0.183542997, 1.77313793,
        -1.72093201, 0.212382004, 1.77712488,
        -2.75661612, 0.22457099, 0.839172006,
        -1.34927702, -1.63840508, -0.221229002,
        -2.576859, 0.212154001, 0.901704073,
        -1.21284604, -1.59637189, -0.321141005,
        -2.40386987, 0.208817989, 0.877182007,
        -1.05978298, -1.54407299, -0.255369008,
        -0.927444041, -1.64494193, -0.296750993,
        -2.24074221, 0.216129005, 0.86597997,
        -0.711341977, -1.64514899, -0.257514,
        -2.08405495, 0.258852005, 0.840783,
        -0.584537983, -1.52865291, -0.174414009,
        -1.94929814, 0.319110006, 0.911046028,
        -0.420776993, -1.62153006, -0.169637993,
        -1.79642391, 0.304481983, 0.850371003,
        -0.277913988, -1.5446701, -0.249026984,
        -1.63459206, 0.259526998, 0.845475018,
        -1.76726413, -2.56406093, 1.47528303,
        -0.213395983, -1.66046715, -0.353852987,
        -1.47890103, 0.30350399, 0.815142035,
        -1.55236495, -2.41188908, 1.39375198,
        -0.0110609997, -1.67643607, -0.27086401,
        -1.41917706, -2.57360411, 1.44106197,
        0.143370003, -1.69249201, -0.21361199,
        -1.34994602, 0.202599004, 0.809064031,
        -1.23184204, -2.57403898, 1.48279798,
        0.290528983, -1.62058187, -0.247902006,
        -1.19892907, 0.272585988, 0.81408602,
        -1.05685806, -2.56348491, 1.49903393,
        0.417542994, -1.73651695, -0.299621999,
        -1.05786896, 0.190611005, 0.85917896,
        -0.888018012, -2.55650997, 1.514907,
        0.674619019, -1.67302799, -0.245564997,
        -0.663311958, -2.567904, 1.56691194,
        -0.89714402, 0.240819007, 0.784808993,
        0.841019988, -1.65081286, -0.291476995,
        -0.512570977, -2.59028387, 1.41011405,
        -0.772740006, 0.282344997, 0.89267695,
        -0.347666979, -2.55165005, 1.45710003,
        1.00302291, -1.59023404, -0.329622,
        -0.604871988, 0.249563992, 0.862478971,
        1.12880099, -1.54679394, -0.229871988,
        -0.187908009, -2.55102015, 1.51645195,
        -0.440550029, 0.238608003, 0.827870965,
        1.36733401, -1.53049493, -0.320475012,
        -0.00573300011, -2.532969, 1.47886193,
        -2.55374694, 0.384626985, 1.76981401,
        1.60996807, -1.51316392, -0.309974998,
        -0.272979021, 0.201072007, 0.801900029,
        -2.39545202, 0.384539992, 1.8553021,
        0.318984002, -2.63720417, 1.47280502,
        1.64548492, -1.67247891, -0.263954997,
        0.490190983, -2.62783194, 1.43649292,
        -0.0674609989, 0.226341009, 0.810180008,
        1.80911398, -1.62833095, -0.294279009,
        0.684248984, -2.56846213, 1.36613703,
        -2.24132109, 0.359040022, 1.77755105,
        0.165557995, 0.297645003, 0.970361948,
        0.886419058, -2.49226499, 1.40085006,
        -2.08545017, 0.406062007, 1.83997798,
        0.312557995, 0.286179006, 0.882063031,
        1.04714394, -2.52812696, 1.456002,
        -1.92346811, 0.352955997, 1.79460907,
        0.435378015, 0.236846983, 0.775346994,
        -1.74695396, 0.397293001, 1.82785797,
        1.15936494, -2.65469408, 1.48138499,
        0.587754011, 0.231312007, 0.692685008,
        1.29915893, -2.53806591, 1.45727098,
        0.718895972, 0.352521002, 0.79421401,
        0.850973964, 0.302343011, 0.902619004,
        1.00717199, 0.252726018, 0.848864973,
        1.13562298, 0.156224996, 0.913313985,
        1.37910295, 0.188409001, 0.931959033,
        1.46648097, 0.303215981, 0.840137959,
        -1.86058211, -1.448439, -0.228588,
        -1.70105386, -1.504668, -0.281426996,
        -1.503438, -1.56194091, -0.254127026,
        -1.36040998, -1.51356888, -0.349776,
        -1.24790096, -1.43024099, -0.255953997,
        -1.04207993, -1.37840104, -0.302109003,
        -0.900341988, -1.47582603, -0.288185984,
        -0.739197016, -1.48416901, -0.223463997,
        -0.577826977, -1.36504793, -0.201525003,
        -0.438113987, -1.49116492, -0.271421999,
        -0.146547005, -1.43964005, -0.217671007,
        -0.0944790021, -1.54786801, -0.33079499,
        -1.7320621, -2.4036901, 1.40029204,
        0.0158639997, -1.42004991, -0.327398986,
        -1.495821, -2.24285698, 1.47147,
        0.116444997, -1.53952193, -0.269451022,
        -1.35602093, -2.42475319, 1.49010301,
        0.262893021, -1.45473599, -0.25308001,
        -1.16733003, -2.42325592, 1.51041305,
        0.434369981, -1.53171909, -0.260415018,
        -1.00258493, -2.42245197, 1.44937801,
        -2.77451086, 0.395615995, 0.783735037,
        0.603033006, -1.51836896, -0.233525991,
        -0.885393023, -2.39047194, 1.57727695,
        0.875634074, -1.48602593, -0.308445007,
        -2.62656593, 0.427320004, 0.884190023,
        -0.731189966, -2.42060399, 1.52345085,
        1.02317703, -1.42561197, -0.262535989,
        -0.625916958, -2.32394099, 1.442451,
        1.17312002, -1.39486194, -0.184785008,
        -2.47491312, 0.352622986, 0.918692946,
        -0.49428302, -2.43106198, 1.46790898,
        1.32235503, -1.38254094, -0.252896994,
        -2.35358405, 0.407646, 0.808281004,
        -0.228545994, -2.4220829, 1.42152309,
        1.47558296, -1.39760709, -0.326703012,
        -2.48737812, 0.536579967, 1.83060598,
        -2.19049811, 0.386736006, 0.852282047,
        -0.0774990022, -2.39058304, 1.55072093,
        1.76869798, -1.46778607, -0.360666007,
        0.089387998, -2.39358902, 1.51031709,
        -2.34399605, 0.607149005, 1.74558902,
        1.88118887, -1.48404002, -0.220970988,
        0.248622, -2.37570286, 1.45087802,
        -2.21399093, 0.524514019, 1.80945587,
        -2.03804708, 0.459186018, 0.894396007,
        -2.05012202, 0.571830034, 1.79681396,
        0.401004016, -2.4785161, 1.47176409,
        -1.86788702, 0.462782979, 0.871320009,
        -1.92204905, 0.503352046, 1.70630407,
        0.569427013, -2.44173598, 1.44116998,
        -1.67483997, 0.426674992, 0.833664,
        -1.75254893, 0.554933965, 1.73439002,
        -1.48877394, 0.46667102, 0.777270019,
        0.736755013, -2.42648411, 1.448331,
        -1.33029294, 0.405599982, 0.791492939,
        0.861434937, -2.35801196, 1.53922498,
        -1.17780304, 0.425004005, 0.87697494,
        1.027776, -2.36822104, 1.51819205,
        -1.03845596, 0.343901992, 0.800067008,
        1.17526507, -2.41817403, 1.460145,
        -0.908568025, 0.457844973, 0.864315033,
        1.32302094, -2.3788228, 1.53749108,
        -0.731808007, 0.454670995, 0.867110968,
        -0.562421978, 0.413969994, 0.84879303,
        -0.37409699, 0.409919977, 0.848675966,
        -0.208730996, 0.469253987, 0.877968013,
        -0.0632340014, 0.395513982, 0.815798998,
        0.123024002, 0.452223003, 0.920657992,
        0.302864999, 0.453494966, 0.915237069,
        0.37737599, 0.397314012, 0.774888039,
        -1.93621492, -1.31845796, -0.30557701,
        0.541508973, 0.368142009, 0.78113097,
        -1.74768615, -1.3231349, -0.211266011,
        0.629481018, 0.501459002, 0.817479014,
        -1.60258508, -1.36217701, -0.287741989,
        -1.63356292, -1.42716002, -0.135926992,
        0.776628017, 0.50909698, 0.736577988,
        -1.32062399, -1.28544593, -0.306699008,
        1.04617202, 0.415655971, 0.832253933,
        -1.16475904, -1.28031898, -0.22190401,
        1.17452407, 0.327639014, 0.914714992,
        -1.07440197, -1.22760892, -0.375113994,
        1.29532504, 0.442580998, 0.850601971,
        -0.888141036, -1.31187296, -0.337026,
        -0.736938, -1.31476796, -0.197810993,
        -0.604953051, -1.2028501, -0.208245009,
        -0.447696, -1.25799, -0.251172006,
        -0.309992999, -1.37991595, -0.273393005,
        -0.175659001, -1.279773, -0.270636022,
        -0.0181290004, -1.26024008, -0.348834008,
        0.132666007, -1.35191393, -0.206484005,
        -1.32972896, -2.20099187, 1.43399096,
        0.406533003, -1.38149095, -0.204587996,
        0.573732018, -1.35746098, -0.208433986,
        -1.1748209, -2.24155498, 1.50507295,
        0.742385983, -1.36431301, -0.246614993,
        -1.00067699, -2.25944996, 1.42930794,
        0.900128961, -1.31498706, -0.287145019,
        -0.849866986, -2.23785591, 1.51363802,
        1.0632751, -1.26673198, -0.296319008,
        -0.687204003, -2.24264097, 1.57908607,
        1.21704602, -1.24537206, -0.236609995,
        -0.494930983, -2.24155807, 1.48339796,
        1.37771702, -1.22985601, -0.295212001,
        -0.359504998, -2.32943702, 1.45550704,
        1.55657709, -1.29575992, -0.228671998,
        -0.221190006, -2.29461002, 1.54728889,
        1.69431603, -1.40464199, -0.215184003,
        -0.0221790001, -2.25022221, 1.47909606,
        -2.36889601, 0.700416028, 1.88275194,
        0.103085995, -2.25472188, 1.60676694,
        1.82935786, -1.32664204, -0.276102006,
        -2.18814898, 0.696078002, 1.79883599,
        0.263472021, -2.23511386, 1.53726888,
        0.402249008, -2.30544305, 1.46329498,
        -2.02663493, 0.733383, 1.74477303,
        0.562337995, -2.26788902, 1.50108898,
        -1.85244906, 0.701897979, 1.75601101,
        -2.75958586, 0.540917993, 0.883424997,
        0.694056034, -2.33139896, 1.58566797,
        -2.59331083, 0.607848048, 0.911345959,
        0.827502012, -2.15818501, 1.483338,
        -2.44408798, 0.514962018, 0.916691959,
        -2.06471682, -1.17517495, -0.283131003,
        0.968397021, -2.2305212, 1.43989193,
        -1.90032005, -1.16722798, -0.23645699,
        -2.27574587, 0.54082799, 0.883626044,
        1.129668, -2.261868, 1.41630304,
        -1.75323308, -1.18538404, -0.316410005,
        -2.1183691, 0.603294015, 0.887415051,
        1.25122797, -2.2208252, 1.55487299,
        -1.61736012, -1.20753896, -0.220692009,
        1.40034294, -2.236866, 1.46204698,
        -1.94006085, 0.620751023, 0.880481958,
        -1.46025002, -1.25010598, -0.185385004,
        -1.74667788, 0.578585982, 0.877563,
        -1.35626101, -1.13288701, -0.235845,
        -1.57922995, 0.559919953, 0.87725997,
        -1.40162706, 0.598572016, 0.730650008,
        -1.22496605, 0.553701043, 0.766781926,
        -1.21998596, -1.15148401, -0.327683985,
        -1.05758691, 0.511752009, 0.789101958,
        -1.07558107, -1.08471906, -0.263828993,
        -0.928436995, -1.154652, -0.315137982,
        -0.771785975, -1.15782905, -0.248400003,
        -0.639129043, -1.04807401, -0.236141995,
        -0.487008035, -1.0929811, -0.288911998,
        -0.307475984, -1.17466199, -0.305211008,
        0.0543479994, 0.575703025, 0.818739057,
        -0.144383997, -1.13829601, -0.353228986,
        0.213426009, 0.599951982, 0.892001987,
        0.114978001, -1.17719102, -0.284027994,
        0.355257004, 0.573668957, 0.799319983,
        0.28422001, -1.14294302, -0.287162989,
        0.512990952, 0.643119037, 0.814725041,
        0.423783004, -1.21014595, -0.227138996,
        0.684126019, 0.656220019, 0.760883927,
        0.586097956, -1.19760895, -0.259766996,
        0.835163951, 0.652148962, 0.664677024,
        0.721736968, -1.11296105, -0.301376998,
        0.957437992, 0.602625012, 0.787145972,
        -1.05577803, -2.10414004, 1.47514796,
        0.797531962, -1.216488, -0.185288996,
        -0.885977983, -2.09298611, 1.43765092,
        0.959192991, -1.17630291, -0.198341995,
        -0.715443015, -2.09103608, 1.45737302,
        1.11324298, -1.1148839, -0.240260988,
        1.25428796, -1.10830498, -0.327125996,
        -0.410540998, -2.10298204, 1.55094886,
        1.498191, -1.13360405, -0.232484996,
        -0.286514997, -2.16812396, 1.45734596,
        1.68505204, -1.19602203, -0.214686006,
        -0.139041007, -2.14036512, 1.53098392,
        1.78373098, -1.172328, -0.342135012,
        0.024296999, -2.11271715, 1.57130408,
        -2.41350293, 0.832841992, 1.76976609,
        0.182645991, -2.08277702, 1.50222611,
        -2.26103401, 0.843659997, 1.8590939,
        0.340674013, -2.11115694, 1.45669794,
        -2.08407307, 0.86869204, 1.84647298,
        0.496851027, -2.11515307, 1.55020201,
        -1.91737199, 0.868218005, 1.77729297,
        0.674960971, -2.15045691, 1.55947208,
        0.773777962, -2.00934887, 1.43561697,
        1.00978494, -2.00124598, 1.497558,
        1.12568104, -2.1198988, 1.50351,
        1.28922296, -2.09442282, 1.44598794,
        1.46030092, -2.07015896, 1.49387693,
        -2.13237, -1.00601697, -0.321365982,
        -1.968279, -1.01331902, -0.254628003,
        -1.79490602, -1.03641605, -0.246629983,
        -2.70391202, 0.683915973, 0.797129989,
        -1.657323, -1.00747204, -0.344364017,
        -2.62873197, 0.782600999, 0.926499009,
        -1.51313996, -1.09025693, -0.277037978,
        -2.39223003, 0.674409032, 0.891281962,
        -1.38822007, -0.975321054, -0.301604986,
        -2.23455286, 0.724470019, 0.914991021,
        -1.22431493, -0.990786016, -0.269306988,
        -1.08215094, -0.909767985, -0.305904001,
        -2.10743999, 0.74731195, 0.80190599,
        -0.928209007, -0.983313024, -0.300396025,
        -1.94541001, 0.755309939, 0.770367026,
        -1.79616904, 0.738950968, 0.832104027,
        -0.788694024, -0.999849021, -0.190727994,
        -1.63734007, 0.709145963, 0.832695007,
        -0.638513982, -0.901695013, -0.301068008,
        -1.47025204, 0.715317011, 0.834936023,
        -1.29943204, 0.702857971, 0.809585989,
        -0.439478993, -0.928919971, -0.28865701,
        -1.10079598, 0.661563039, 0.861636043,
        -0.272964001, -1.00489807, -0.279666007,
        -1.08805203, -1.93174505, 1.44985795,
        -0.102024004, -1.01138401, -0.202719003,
        -0.928511977, -1.943712, 1.51540804,
        0.00565499999, -1.04975998, -0.328635007,
        -0.757430971, -1.91468096, 1.50704408,
        0.161612988, -1.015257, -0.253803015,
        0.432596982, -1.05913198, -0.307274997,
        -0.366746992, -1.93606186, 1.53111601,
        -0.224303991, -2.00141692, 1.45883393,
        0.587229013, -1.01897395, -0.283178985,
        -0.0688079968, -1.98818398, 1.51876211,
        0.0934619978, -1.94233513, 1.47510898,
        0.722231984, -0.945131958, -0.230457008,
        0.259400994, -1.91618407, 1.52781594,
        0.842028022, -1.05327296, -0.196272016,
        0.422802031, -1.97440803, 1.50568199,
        -2.20072508, 0.989549994, 1.77145493,
        0.977123976, -1.02970493, -0.27977401,
        0.600108027, -1.99247396, 1.50996304,
        1.12782001, -0.982742965, -0.349658996,
        -2.0251112, 1.01454902, 1.75320005,
        0.716501951, -1.86553192, 1.50275111,
        1.22979307, -0.976164043, -0.218169004,
        1.38346803, -1.00576496, -0.276681006,
        0.882233977, -1.88218796, 1.49186707,
        1.54439402, -0.97251904, -0.276086986,
        1.01370895, -1.83704102, 1.58175302,
        1.70820904, -0.968438983, -0.291863978,
        1.17265499, -1.82504404, 1.50982499,
        1.87454987, -0.998955011, -0.309540004,
        1.30293894, -1.93320894, 1.50372601,
        1.4578681, -1.90438509, 1.43432105,
        1.61604905, -1.98530698, 1.45072496,
        -2.56905317, 0.912090003, 0.827615976,
        -2.41911602, 0.830343008, 0.829325974,
        -2.17252207, 0.883665025, 0.888644993,
        -2.18382287, -0.835619926, -0.300114006,
        -2.01011705, 0.887475014, 0.85828805,
        -2.01620698, -0.847142994, -0.236385003,
        -1.85039997, 0.896489978, 0.800495982,
        -1.86045599, -0.887154043, -0.298568994,
        -1.68614101, 0.865344048, 0.770397067,
        -1.69458604, -0.845805049, -0.279341996,
        -1.51636791, 0.858111024, 0.747575998,
        -1.54007101, -0.917873979, -0.250800014,
        -1.38234305, 0.855609059, 0.859658957,
        -1.03667402, -1.77227998, 1.50306308,
        -1.38107991, -0.807821989, -0.332123995,
        -1.20913804, 0.838458002, 0.849960029,
        -1.10682595, -0.739373982, -0.297713995,
        -0.864374995, -1.78286397, 1.47502494,
        -0.712095022, -1.72403705, 1.53798902,
        -0.574683011, -1.79279101, 1.45290601,
        -0.95114696, -0.805539012, -0.290567994,
        -0.359727025, -1.76574004, 1.55812502,
        -0.802178979, -0.874971032, -0.297906011,
        -0.699440956, -0.74496001, -0.289952993,
        -0.203823, -1.840029, 1.52468705,
        -0.539963961, -0.770594954, -0.264819026,
        -0.0387060009, -1.83295798, 1.46938193,
        -0.414039016, -0.804980993, -0.168795004,
        0.111278996, -1.77443397, 1.51998305,
        -0.294090003, -0.824145019, -0.288473994,
        0.271883994, -1.73605192, 1.43046308,
        -0.137076005, -0.878448009, -0.286433995,
        0.394151986, -1.84432507, 1.41001499,
        0.0273599997, -0.902613044, -0.22724399,
        0.549284995, -1.82395506, 1.47627902,
        0.311003983, -0.860714972, -0.241968006,
        0.773411989, -1.70076299, 1.49580002,
        0.460941017, -0.889154971, -0.313253999,
        0.573074996, -0.84969604, -0.194807991,
        0.916872025, -1.69117498, 1.58631599,
        0.731508017, -0.783252001, -0.246947989,
        1.07554805, -1.69170308, 1.64816403,
        1.22454, -1.67527807, 1.44741297,
        0.879564047, -0.886860013, -0.251810998,
        1.36138797, -1.77737999, 1.51205099,
        1.04471707, -0.893130004, -0.22281301,
        1.48483801, -1.74144912, 1.40159404,
        1.17989099, -0.82564497, -0.288551986,
        1.6873889, -1.81976986, 1.46905196,
        1.37553596, -0.843066037, -0.325655997,
        1.49105406, -0.831537008, -0.204555005,
        1.54342198, -0.80012393, -0.372287989,
        1.69591188, -0.803372979, -0.282090008,
        1.87290895, -0.816935956, -0.289400995,
        -2.66175604, 1.06338596, 0.857571006,
        -2.333601, 0.962067008, 0.768915057,
        -2.19095087, 1.04820609, 0.752205014,
        -2.09170485, 1.03854597, 0.892190933,
        -1.94578493, 1.03779602, 0.797504961,
        -1.12140298, -1.61870408, 1.47369003,
        -0.947207987, -1.63971615, 1.434129,
        -2.26283693, -0.638429999, -0.211266011,
        -1.77725101, 1.04846394, 0.776502013,
        -2.12879395, -0.670001984, -0.346670985,
        -0.863613009, -1.63129807, 1.58735394,
        -1.62203407, 1.00595701, 0.842046022,
        -0.78026104, -1.59991193, 1.43580902,
        -1.97038198, -0.679955959, -0.260933995,
        -0.573852003, -1.62366593, 1.483845,
        -1.81375802, -0.721677005, -0.313473016,
        -1.45238709, 1.002087, 0.810497999,
        -0.41534698, -1.66066504, 1.43571901,
        -1.665627, -0.676275015, -0.379556984,
        -0.270702004, -1.62690902, 1.51621509,
        -1.54422307, -0.749486983, -0.282869995,
        -0.130572006, -1.69403708, 1.45055401,
        -1.28217006, 0.99090004, 0.805364966,
        -1.39746296, -0.655916989, -0.266537994,
        0.149625003, -1.62242997, 1.45169997,
        0.296478003, -1.59800398, 1.53332698,
        -1.25577295, -0.681333005, -0.346643984,
        0.437336981, -1.6880281, 1.46904898,
        -1.10556602, -0.597090006, -0.209336996,
        0.494316012, -1.53044391, 1.42001402,
        -0.95380801, -0.644796014, -0.213555008,
        0.611847043, -1.64055598, 1.48251295,
        -0.731243968, -0.617802024, -0.187886998,
        0.80487895, -1.55395496, 1.42936194,
        -0.574694991, -0.600579023, -0.244677007,
        0.966092944, -1.555269, 1.491804,
        -0.416295022, -0.652928948, -0.280013978,
        1.12801206, -1.56367493, 1.53853488,
        1.35842395, -1.608603, 1.53217506,
        -0.291873008, -0.694316983, -0.174734995,
        1.52434802, -1.58208895, 1.43925297,
        -0.138311997, -0.71943301, -0.241214991,
        1.6755929, -1.63460398, 1.51163399,
        0.00186900003, -0.745088995, -0.149189994,
        0.255429, -0.704219997, -0.277328998,
        0.425646007, -0.735249043, -0.233897984,
        0.58178103, -0.720965981, -0.303744018,
        0.73189801, -0.63252598, -0.307421982,
        0.878327966, -0.710723996, -0.262740016,
        1.04455197, -0.727401018, -0.256367981,
        1.18713903, -0.638522983, -0.236396998,
        1.29954004, -0.754296005, -0.198293984,
        1.44321001, -0.672806978, -0.212007016,
        1.60085702, -0.671057999, -0.273612022,
        1.79037905, -0.660293996, -0.272753984,
        -1.45622098, -1.52027392, 1.45065606,
        -1.280532, -1.55182207, 1.42061996,
        -1.16340005, -1.46063697, 1.532022,
        -2.54846406, 1.19506502, 0.799986005,
        -0.996690035, -1.49821496, 1.51691985,
        -2.390481, 1.11585593, 0.801248968,
        -0.847650051, -1.45109701, 1.58921409,
        -2.23347902, 1.18177795, 0.842357993,
        -1.95806694, 1.15849495, 0.915663004,
        -0.690312028, -1.52514005, 1.56570303,
        -2.15888405, -0.496491015, -0.266256005,
        -1.87334704, 1.20678604, 0.777254999,
        -1.99281299, -0.516312003, -0.236927986,
        -0.499083012, -1.472592, 1.45922101,
        -1.69782293, 1.19817603, 0.775736928,
        -1.82372999, -0.551253021, -0.287303984,
        -0.339327008, -1.50240004, 1.43155801,
        -1.54179907, 1.13504398, 0.761741996,
        -1.66456497, -0.494652003, -0.359349012,
        -0.177719995, -1.49202299, 1.47956705,
        -1.52901006, -0.585425973, -0.333195001,
        -1.320696, 1.16614497, 0.810411036,
        -0.0481199995, -1.55395496, 1.39386296,
        -1.39744496, -0.508463979, -0.187151998,
        0.0669630021, -1.48905301, 1.50653994,
        -1.23305702, -0.495122999, -0.205040991,
        0.220200002, -1.47336602, 1.43582404,
        -1.00241399, -0.487529993, -0.290670007,
        0.362948984, -1.438326, 1.51076996,
        -0.849815965, -0.505403996, -0.18393001,
        0.507584989, -1.36821604, 1.45161307,
        -0.714251995, -0.479315996, -0.277658999,
        0.653814018, -1.48093796, 1.37088001,
        -0.561818957, -0.437133014, -0.321047992,
        0.753087044, -1.403355, 1.48306799,
        -0.379604995, -0.511608005, -0.190673992,
        0.903432012, -1.42273796, 1.40793896,
        -0.23199299, -0.564536989, -0.255645007,
        1.24558806, -1.51016402, 1.43298304,
        -0.0913739949, -0.579065979, -0.165008992,
        1.40483701, -1.46052599, 1.47183001,
        0.151253998, -0.650270998, -0.165789008,
        1.59369302, -1.47602093, 1.564152,
        1.73218513, -1.45427704, 1.45644295,
        0.206450999, -0.538788021, -0.298115999,
        0.364706993, -0.578346014, -0.272400022,
        0.506160021, -0.459878981, -0.27411899,
        0.649031997, -0.526109993, -0.209141999,
        0.873075008, -0.543726027, -0.272996992,
        1.04211903, -0.554085016, -0.263588995,
        1.21896291, -0.484457999, -0.185306996,
        1.35082197, -0.541115999, -0.261260986,
        1.46556592, -0.547950029, -0.103658997,
        1.5937531, -0.516945004, -0.212588996,
        1.75343108, -0.488550007, -0.270173997,
        -1.77602696, -1.29858303, 1.50905991,
        -1.64669704, -1.41533995, 1.47047698,
        -1.49191797, -1.37082303, 1.55022597,
        -1.32810593, -1.41328204, 1.51258802,
        -1.08545101, -1.32578397, 1.459185,
        -2.55329084, 1.37318707, 0.848015964,
        -0.915911973, -1.35044396, 1.46486402,
        -2.39592004, 1.27802098, 0.840546012,
        -0.756500959, -1.30051494, 1.59071696,
        -2.24666405, 1.33111501, 0.914523005,
        -0.607232988, -1.37287199, 1.54013109,
        -2.09465694, 1.25299799, 0.927168012,
        -0.488991022, -1.24346697, 1.51330197,
        -2.05288506, -0.354501009, -0.300164998,
        -1.93511105, 1.37186098, 0.770559072,
        -1.88571906, -0.393662989, -0.272643,
        -0.398954988, -1.34992194, 1.41303003,
        -1.76754308, 1.35137391, 0.764096975,
        -0.243089989, -1.28248191, 1.40551209,
        -1.723248, -0.377117991, -0.260883003,
        -0.0769679993, -1.38500702, 1.40488195,
        -1.62089086, 1.333395, 0.861084044,
        -1.58131492, -0.324378014, -0.34176898,
        -1.46606994, 1.27829695, 0.796346962,
        -1.45518601, -0.435036004, -0.376128018,
        0.0618060008, -1.30030799, 1.41695404,
        -1.31871009, -0.347072989, -0.292371005,
        0.197448, -1.31792402, 1.520262,
        -1.16397309, -0.415143013, -0.330630004,
        0.33317101, -1.26560104, 1.42892098,
        -1.00416601, -0.307206005, -0.296355009,
        0.48180601, -1.24630499, 1.34078395,
        0.647141993, -1.29477, 1.38566101,
        -0.860691011, -0.403805971, -0.314172,
        0.81645298, -1.28283298, 1.38916802,
        -0.700008035, -0.329469025, -0.348297,
        0.989367008, -1.27997696, 1.40223598,
        -0.591530979, -0.298377007, -0.229413003,
        1.08761406, -1.41503704, 1.45551002,
        -0.428354979, -0.355662018, -0.232002005,
        -0.261711001, -0.399543017, -0.26078099,
        1.30718398, -1.22474694, 1.475793,
        -0.0794999972, -0.440091014, -0.264999002,
        1.46273994, -1.30637097, 1.48413002,
        0.050733, -0.543920994, -0.244716018,
        1.64992213, -1.30917597, 1.54012799,
        0.130905002, -0.387044996, -0.26404801,
        0.35185498, -0.42453903, -0.217380017,
        1.78263903, -1.28068209, 1.43110204,
        0.440510988, -0.319518, -0.324606001,
        0.639728963, -0.361613989, -0.273315012,
        -2.39631891, 1.43738103, 0.908645988,
        0.781269014, -0.42453903, -0.198113993,
        -2.23538685, 1.49130905, 0.85501796,
        -1.92214799, -1.19931304, 1.49609995,
        0.952803016, -0.411875993, -0.196415991,
        -2.09190011, 1.39707899, 0.839064002,
        -1.76995504, -1.11708307, 1.48254001,
        1.10804701, -0.392282993, -0.261713982,
        -1.96918797, 1.52170193, 0.854322016,
        -1.60277104, -1.24988699, 1.50149095,
        1.29395401, -0.336153001, -0.210137993,
        -1.52928591, -1.08920097, 1.47726607,
        1.47643793, -0.447216034, -0.309347987,
        -1.79476798, 1.52090693, 0.80724299,
        -1.42590606, -1.22472, 1.481076,
        1.63155305, -0.370922983, -0.340703994,
        -1.55142593, 1.4951551, 0.833706021,
        -1.22099996, -1.17828608, 1.50324905,
        -1.39070702, 1.42853701, 0.823886991,
        -0.981563926, -1.19802296, 1.45098901,
        -0.817469954, -1.208565, 1.46209192,
        -0.650133014, -1.21837497, 1.47910798,
        -0.56455195, -1.11009598, 1.5931201,
        -0.354761988, -1.158885, 1.46909106,
        -0.196794003, -1.11952496, 1.45871091,
        -0.113114998, -1.25701201, 1.50811791,
        0.117228001, -1.15032899, 1.44525898,
        0.247239009, -1.15759504, 1.54601991,
        0.398690999, -1.12225199, 1.49373603,
        0.561182976, -1.18053901, 1.47840905,
        0.73159498, -1.13487601, 1.42126203,
        0.88229996, -1.17110407, 1.49795401,
        1.018242, -1.100703, 1.45947599,
        1.14026701, -1.21451998, 1.44311094,
        1.29929101, -1.07138395, 1.52322292,
        1.43419194, -1.16023505, 1.57264209,
        -1.90221906, -0.234761998, -0.317234993,
        1.56413102, -1.18064702, 1.45471799,
        -1.73283601, -0.242211014, -0.378933012,
        1.71776414, -1.12758303, 1.495875,
        -1.63946092, -0.150804013, -0.247229993,
        -1.481583, -0.215961009, -0.250634998,
        -1.31777096, -0.200306982, -0.201159,
        -1.16838598, -0.254880011, -0.268298984,
        -1.04146791, -0.139268994, -0.239594996,
        -0.892910957, -0.208748996, -0.205202997,
        -0.736014009, -0.19374299, -0.249522001,
        -0.573933005, -0.130932003, -0.272900999,
        -0.475665003, -0.205910996, -0.155600995,
        -0.301820993, -0.251645982, -0.181479007,
        -0.135770991, -0.294260979, -0.214271992,
        0.132137999, -0.222653985, -0.216957003,
        0.237116992, -0.336609006, -0.137312993,
        0.287288994, -0.257559001, -0.272112012,
        0.537822008, -0.242894992, -0.213366002,
        0.697218001, -0.210987002, -0.242493004,
        0.85828495, -0.185489997, -0.262425005,
        1.00317895, -0.272163004, -0.311091006,
        1.19541895, -0.263028026, -0.327324003,
        1.31372702, -0.170061007, -0.229286999,
        1.45828795, -0.278138995, -0.260523021,
        1.62851107, -0.217716008, -0.259319991,
        -2.08851004, -0.99771899, 1.472754,
        -1.94286597, -1.03785896, 1.55874896,
        -1.82151604, -0.937785029, 1.487661,
        -1.66019404, -0.989481032, 1.52748609,
        -1.55654705, -0.959109068, 1.36486506,
        -1.39682102, -0.945948005, 1.53892493,
        -1.22951102, -1.00971305, 1.53593397,
        -1.07496595, -1.05920994, 1.46558094,
        -0.903141022, -1.05994499, 1.5010469,
        -0.733572006, -1.092978, 1.55260801,
        -0.482334018, -0.97548306, 1.52322602,
        -0.311331004, -0.988319993, 1.48650002,
        -0.14136, -0.969309032, 1.50183892,
        -0.0341220014, -1.10385299, 1.49584198,
        0.124229997, -1.03712702, 1.56454802,
        -1.95469499, -0.0851669982, -0.232593,
        0.305673003, -0.993590951, 1.55785513,
        -1.7962079, -0.0946440026, -0.313553989,
        0.40555799, -0.976641059, 1.41206694,
        -1.65232491, 0.0163439997, -0.267374992,
        0.517832994, -1.03956008, 1.56346202,
        -1.49475598, -0.0524279997, -0.276311994,
        0.744408011, -0.97607398, 1.4785111,
        -1.33364105, -0.0789989978, -0.329676002,
        0.903344989, -0.995519996, 1.54285204,
        -1.17538202, -0.0355979986, -0.193308011,
        1.05296707, -0.941711962, 1.48022401,
        1.16847599, -1.050102, 1.42175996,
        -0.969015002, -0.0179999992, -0.143739,
        1.315992, -0.919173002, 1.46215498,
        -0.856109977, -0.0912089944, -0.344987988,
        1.46133304, -0.997736931, 1.52039695,
        -0.709610999, -0.030774001, -0.293963999,
        -0.650646031, -0.00858599972, -0.119079009,
        1.59907508, -1.02019799, 1.42411804,
        -0.431124032, -0.0557100028, -0.212619007,
        1.75443006, -0.959418058, 1.45468199,
        -0.273882002, -0.100400999, -0.255125999,
        -0.112400994, -0.14835, -0.287075996,
        0.0530520007, -0.0965370089, -0.283176005,
        0.227538005, -0.100887001, -0.296738982,
        0.397949994, -0.133494005, -0.254229009,
        0.57792604, -0.0842129961, -0.252629995,
        0.748970985, -0.053594999, -0.262410015,
        0.897491992, -0.0425100029, -0.342453003,
        0.994827032, -0.0999389961, -0.217137009,
        1.15841103, 0.0207749996, -0.332937002,
        1.33963501, -0.0199289992, -0.304863006,
        1.49464798, -0.105819002, -0.282489002,
        -2.11750507, -0.825903058, 1.49531102,
        -1.96899295, -0.868557036, 1.56986713,
        -1.84822798, -0.771123052, 1.50660586,
        -1.67379606, -0.836076021, 1.37328005,
        -1.541538, -0.872994065, 1.51270795,
        -1.42892098, -0.853883982, 1.38830996,
        -1.27557003, -0.862760961, 1.46153104,
        -1.10427594, -0.897192001, 1.49670303,
        -0.923579931, -0.883551002, 1.547562,
        -1.81409097, 0.0524489991, -0.229458004,
        -0.711248994, -0.810894012, 1.49461794,
        -0.553853989, -0.826709986, 1.51623011,
        -0.392291963, -0.836228967, 1.47925496,
        -1.67222393, 0.176726997, -0.219354004,
        -0.129507005, -0.808583975, 1.52925587,
        -1.51745701, 0.0963779986, -0.359762996,
        0.0191700011, -0.88941896, 1.52837396,
        -1.35487199, 0.0724230036, -0.229854003,
        0.183890998, -0.899693966, 1.48863292,
        0.331281006, -0.830280066, 1.45020294,
        -1.19354999, 0.107006997, -0.291500986,
        0.502743006, -0.834491968, 1.42069197,
        -1.01738703, 0.125111997, -0.234254986,
        0.613796949, -0.896619022, 1.56100512,
        -0.856830001, 0.0424439982, -0.249132007,
        0.668451011, -0.837489009, 1.418607,
        -0.707610011, 0.124118999, -0.218588993,
        0.83515501, -0.861656964, 1.39618194,
        -0.563486993, 0.0380460024, -0.255263984,
        0.996392965, -0.811650038, 1.41198599,
        -0.439704001, 0.112626001, -0.176699996,
        1.14981604, -0.801315069, 1.49662495,
        -0.301824003, 0.0621629991, -0.250925988,
        1.30878901, -0.753293991, 1.46376896,
        -0.148983002, 0.0259649977, -0.304242015,
        1.45614004, -0.838665009, 1.45692301,
        1.62077093, -0.852144003, 1.44636893,
        0.0243900008, 0.0814620033, -0.262422025,
        1.78139114, -0.78947401, 1.43151903,
        0.193176001, 0.0707850009, -0.27711302,
        0.34739399, 0.0191430002, -0.323778003,
        0.507474005, 0.0356820002, -0.363774002,
        0.644064009, 0.0789240003, -0.279978007,
        0.814839005, 0.106713004, -0.258282006,
        0.978639007, 0.0696120039, -0.246648014,
        1.07895601, 0.171552002, -0.334419012,
        1.26940203, 0.133026004, -0.261950999,
        -2.13740683, -0.651861012, 1.47449708,
        -1.99516487, -0.690917969, 1.56868207,
        -1.91635799, -0.653501987, 1.41050398,
        -1.71986997, -0.685479045, 1.43311501,
        -1.54562402, -0.731643021, 1.42050302,
        -1.348032, -0.710924983, 1.40254498,
        -1.17962396, -0.741605997, 1.52309096,
        -1.01591694, -0.754311025, 1.48638606,
        -0.789828062, -0.666005969, 1.50670505,
        -0.620906949, -0.665897965, 1.54840493,
        -0.472616971, -0.687548995, 1.46832299,
        -0.310194016, -0.635928035, 1.45907402,
        -0.153311998, -0.646911025, 1.50601208,
        -1.46289003, 0.237107992, -0.263249993,
        -0.0266669989, -0.722021997, 1.42499399,
        -1.29573894, 0.253118992, -0.309042007,
        0.120113999, -0.746870995, 1.50570297,
        -1.12299299, 0.278306991, -0.308465987,
        0.267210007, -0.675377965, 1.47840905,
        -0.948902965, 0.258953989, -0.321258008,
        0.430059016, -0.682731032, 1.42593908,
        -0.861978054, 0.19596, -0.191880003,
        0.578481019, -0.735323966, 1.53875399,
        -0.72656095, 0.294330001, -0.204411,
        0.719850004, -0.674130023, 1.43525994,
        -0.568071008, 0.210743994, -0.269309998,
        -0.40082401, 0.277773023, -0.202493995,
        0.879087031, -0.706295967, 1.46040297,
        -0.247925997, 0.224205002, -0.286728024,
        1.01663697, -0.651627004, 1.374354,
        -0.0865620002, 0.182000995, -0.356069982,
        1.17443097, -0.635447979, 1.45210803,
        0.0543569997, 0.274320006, -0.288138002,
        1.33257902, -0.607437015, 1.39447498,
        0.191505015, 0.214841992, -0.37411201,
        1.469607, -0.679515004, 1.48823404,
        0.362309992, 0.181269005, -0.388467014,
        1.63170898, -0.626121044, 1.54092908,
        0.488213986, 0.172454998, -0.266463012,
        1.75603485, -0.619830012, 1.40421605,
        0.591036022, 0.30082801, -0.312587976,
        0.83160603, 0.301100999, -0.318269998,
        0.995588958, 0.306095988, -0.256283998,
        1.16040301, 0.254759997, -0.201389998,
        -2.08328104, -0.487082988, 1.47128403,
        -1.93708801, -0.509738982, 1.56709206,
        -1.78544104, -0.532413006, 1.47425103,
        -1.60336196, -0.581411958, 1.495224,
        -1.438959, -0.611778021, 1.50333595,
        -1.27488601, -0.601781964, 1.52039409,
        -1.20415497, -0.479849994, 1.43536794,
        -1.10348403, -0.589236021, 1.49537992,
        -0.938414991, -0.601683021, 1.49492407,
        -0.703890026, -0.521355033, 1.48463702,
        -0.531383991, -0.532640994, 1.49065197,
        -0.357299984, -0.473892033, 1.49877,
        -0.194232017, -0.473051995, 1.54046094,
        -0.0351179987, -0.522608995, 1.49489403,
        0.133506, -0.569519997, 1.49165106,
        0.282777011, -0.483968973, 1.473768,
        0.436581016, -0.511728048, 1.41000307,
        0.58118701, -0.585474014, 1.46539795,
        0.711771011, 0.383697033, -0.221541017,
        0.710421026, -0.503298044, 1.37809801,
        0.814580977, -0.54676497, 1.50102305,
        0.978953958, -0.490946978, 1.35368109,
        1.11210299, -0.482055008, 1.44924903,
        1.32741606, -0.490082979, 1.50312901,
        1.48566294, -0.525783002, 1.42955399,
        1.65066314, -0.48091498, 1.444188,
        -1.97058892, -0.350262016, 1.47868502,
        -1.80862808, -0.382196993, 1.56432903,
        -1.67123699, -0.395061016, 1.45355105,
        -1.50875998, -0.445098013, 1.47646499,
        -1.35261607, -0.394178987, 1.45273793,
        -1.22794497, -0.362327993, 1.56907201,
        -1.07424593, -0.382362008, 1.49328601,
        -0.90310204, -0.417221993, 1.49703908,
        -0.746810973, -0.372731984, 1.56631494,
        -0.602603972, -0.394668013, 1.42840803,
        -0.442361981, -0.340551019, 1.45228791,
        -0.263855994, -0.320769012, 1.47834599,
        -0.0827340037, -0.342693001, 1.51883698,
        0.0239039995, -0.395682037, 1.39159799,
        0.183683991, -0.362112015, 1.44271207,
        0.429609001, -0.350955009, 1.45594203,
        0.582147002, -0.420866966, 1.44487798,
        0.723875999, -0.331187993, 1.50090301,
        0.843351007, -0.403530002, 1.40296793,
        1.002864, -0.345654011, 1.44290709,
        1.21258497, -0.367247999, 1.51371312,
        1.35773098, -0.34562999, 1.41710401,
        1.51557899, -0.367004991, 1.49811006,
        -1.90864205, -0.195279002, 1.43245804,
        -1.75675201, -0.220182002, 1.50727808,
        -1.59295499, -0.253482014, 1.54134297,
        -1.44597292, -0.161058009, 1.50916493,
        -1.33761895, -0.228540003, 1.39934695,
        -1.19890797, -0.197988003, 1.50784492,
        -1.01570094, -0.226101011, 1.54569888,
        -0.850883961, -0.253109992, 1.48276496,
        -0.679454982, -0.226341009, 1.49024403,
        -0.487542003, -0.189672008, 1.51481402,
        -0.362334013, -0.20264101, 1.40414095,
        -0.193937987, -0.166536003, 1.43080807,
        -0.030125998, -0.20306401, 1.44233406,
        0.126764998, -0.224252999, 1.50974703,
        0.299138993, -0.263534993, 1.51997995,
        0.456686974, -0.193461001, 1.52073598,
        0.582947969, -0.259427994, 1.44277501,
        0.72004199, -0.173081994, 1.407372,
        0.871607959, -0.240053996, 1.43742299,
        1.02014101, -0.172547996, 1.48836005,
        1.15638304, -0.249437988, 1.41861594,
        1.304196, -0.210239992, 1.50917411,
        1.467453, -0.202095002, 1.43421304,
        -2.24796915, -0.119915999, 1.44672596,
        -2.07524681, -0.150215998, 1.44189,
        -1.92815685, -0.0734219998, 1.550421,
        -1.28805304, -0.0599220023, 1.42723501,
        -1.07511294, -0.0827670023, 1.45712399,
        -0.424694985, -0.0484139994, 1.42833602,
        -0.260567993, -0.00804900005, 1.48143303,
        -0.0863160044, -0.0203760006, 1.53130794,
        0.0822149962, -0.0749669969, 1.43668199,
        0.244854003, -0.114107996, 1.46901894,
        0.398348987, -0.055580996, 1.45056605,
        0.567443967, -0.0839190036, 1.43580306,
        0.731979012, -0.00649499986, 1.43119204,
        0.870657027, -0.0782160014, 1.51083302,
        1.02641392, 0.000296999991, 1.47757506,
        1.1754601, -0.0926489979, 1.4892571,
        1.332057, -0.057147, 1.41898799,
        -1.74081612, -2.67628193, 0.982989013,
        -1.49102998, -2.71663499, 0.988188028,
        -1.33178091, -2.74195504, 0.921948016,
        -1.18521297, -2.73908401, 1.01848793,
        -1.02619195, -2.69638205, 0.938717961,
        -0.820347011, -2.68839908, 1.01518798,
        -0.649299026, -2.71080303, 1.03998899,
        -2.57903695, 0.00295200013, 1.50399005,
        -2.42303085, -0.0726659968, 1.45276201,
        -2.29802704, 0.0403829999, 1.49930704,
        -2.13303614, 0.00329999998, 1.50236392,
        -1.92048001, 0.0925740004, 1.53779387,
        0.789276004, -2.68612194, 1.01779795,
        -1.762995, 0.0147300009, 1.53669298,
        1.02150297, -2.69482803, 1.00781405,
        1.19876099, -2.68701005, 0.993494987,
        -2.04028511, 1.10769606, -0.260517001,
        -1.72662902, 1.09394693, -0.280692011,
        -0.0801899955, 0.126776993, 1.42919099,
        0.0645720065, 0.0774179995, 1.51330495,
        0.266517013, 0.0357539989, 1.39805102,
        0.365655005, 0.0935460031, 1.55414093,
        0.539949, 0.131694004, 1.53783894,
        0.714339018, 0.157175988, 1.48125291,
        0.875355005, 0.0928379968, 1.45826399,
        -1.63123488, -2.51844311, 0.934742928,
        -1.45815897, -2.55061817, 0.98260498,
        -1.28297698, -2.58365107, 0.997958958,
        -1.12279797, -2.57750082, 1.05880499,
        -0.948065996, -2.57768703, 1.05988503,
        -0.819696069, -2.52701688, 0.938897967,
        -0.714875996, -2.553159, 1.06841993,
        -0.523386002, -2.60811305, 0.989349008,
        -2.7364502, 0.284780979, 1.46193302,
        -0.38330698, -2.50630212, 1.02336001,
        -2.59734607, 0.175740004, 1.46469307,
        -2.12584496, 1.26227093, -0.306428999,
        -0.217433989, -2.5266211, 0.952358961,
        -1.82834995, 1.32691801, -0.206987992,
        -2.44372511, 0.115050003, 1.47559798,
        -0.0669929981, -2.56927204, 1.02826798,
        -1.65985203, 1.26054597, -0.266415,
        -2.20489216, 0.177090004, 1.54013991,
        0.106590003, -2.57834411, 0.981723011,
        0.320982009, -2.55351591, 1.10250902,
        -2.05864811, 0.149189994, 1.4514389,
        0.381849021, -2.42081094, 1.02231896,
        -1.93071592, 0.25749898, 1.476282,
        0.642294049, -2.57909107, 1.02730501,
        -1.79655004, 0.158634007, 1.444695,
        0.758982003, -2.47461605, 0.958974004,
        -1.64983201, 0.236333996, 1.45280695,
        0.913217962, -2.54937601, 0.978071988,
        -1.48672509, 0.207999006, 1.48049104,
        1.07235301, -2.53314018, 0.923909962,
        1.241418, -2.55480289, 0.904206038,
        1.37010598, -2.64068103, 0.98557502,
        1.50609899, -2.63784289, 0.877053022,
        1.60470307, -2.55820489, 1.00306201,
        0.216513008, 0.169415995, 1.48432803,
        0.373580992, 0.241715997, 1.45150805,
        0.545790017, 0.274206012, 1.42641902,
        -2.17254591, 1.43851197, -0.28331399,
        -2.00705385, 1.51612794, -0.288729012,
        -1.68181801, 1.43927705, -0.268698007,
        -1.50045013, -2.38945198, 0.950210989,
        -2.7033689, 0.459513009, 1.48647606,
        -1.34890807, -2.423985, 1.03709996,
        -2.57146215, 0.342182994, 1.48887599,
        -1.21886396, -2.40836406, 0.925949931,
        -2.37783289, 0.291279018, 1.515975,
        -1.04974496, -2.41065001, 0.957540035,
        -2.22788095, 0.401654989, 1.456833,
        -0.843630016, -2.44069195, 1.081635,
        -0.709617019, -2.40562797, 0.97164607,
        -2.08433414, 0.325892985, 1.51875591,
        -0.560571015, -2.46196795, 1.05576599,
        -1.93969798, 0.427854002, 1.46396399,
        -0.4278, -2.34087586, 1.01912403,
        -1.78202701, 0.343194008, 1.47101104,
        -0.26048699, -2.36781001, 0.999248981,
        -1.585482, 0.388868988, 1.40649295,
        -0.0802560002, -2.4177959, 0.943706989,
        -1.42137599, 0.374472022, 1.47704101,
        0.0402869992, -2.41687202, 1.05029404,
        0.210689992, -2.44716287, 1.03587294,
        0.46342501, -2.29051805, 0.953963995,
        0.553233027, -2.41934705, 1.032462,
        0.666027009, -2.33129096, 0.940286994,
        0.866481006, -2.38676095, 1.05956697,
        1.02568793, -2.403198, 1.01352298,
        1.18510497, -2.40403509, 0.972590983,
        -2.1076231, 1.65444613, -0.246729016,
        1.31928301, -2.48082304, 1.03949094,
        -1.93195486, 1.70016599, -0.220509008,
        1.45905304, -2.47813797, 0.937088966,
        1.67653191, -2.4000001, 0.979716003,
        1.80211794, -2.51523018, 0.977216959,
        1.9248271, -2.41187716, 1.06453204,
        2.08800602, -2.35305309, 1.01478601,
        -0.848841012, 1.61770797, -0.272220016,
        -0.670938015, 1.57553709, -0.276669025,
        -0.499469995, 1.62444901, -0.319245011,
        -0.315494984, 1.58315396, -0.231366009,
        -2.54001594, 0.521649003, 1.48251295,
        -2.37541509, 0.475100994, 1.49899197,
        -2.24374509, 0.580860019, 1.48841405,
        -2.09340596, 0.499395013, 1.49246097,
        -1.96295393, 0.594621003, 1.44500709,
        -1.71347702, 0.505068004, 1.43982303,
        -1.510077, 0.528216004, 1.50846899,
        -1.38039899, 0.525380969, 1.38915002,
        -1.35169792, -2.31702614, 0.90247196,
        -1.22705102, -2.27289605, 1.02825296,
        -1.05915308, -2.26758909, 1.04070902,
        -0.885221958, -2.33884501, 0.951218963,
        -0.757050037, -2.25272703, 1.030527,
        -0.590022027, -2.297544, 1.019454,
        -0.474915028, -2.18914509, 0.946460962,
        -0.311429977, -2.22003007, 1.05950701,
        -0.135486007, -2.26564789, 1.06257594,
        0.00666899979, -2.26505995, 0.96241504,
        0.154940993, -2.29526687, 1.04221797,
        0.318692982, -2.20640707, 1.00032604,
        0.476552993, -2.15648103, 1.07162702,
        0.611783981, -2.18126702, 0.982668042,
        0.766425014, -2.23395014, 1.04339993,
        0.943502963, -2.26424098, 0.971780956,
        1.08680403, -2.29014611, 0.900969028,
        1.24229705, -2.24905205, 0.937139988,
        -0.844967961, 1.79370296, -0.317622006,
        1.396137, -2.31570601, 0.952214956,
        -0.677258968, 1.74285901, -0.372002989,
        1.58043301, -2.27100301, 1.05042899,
        -0.522500992, 1.81234813, -0.310685992,
        1.82093704, -2.31493497, 0.979797006,
        -0.378294021, 1.75352407, -0.223149002,
        1.9555831, -2.23900199, 1.04530501,
        -0.195944995, 1.73649895, -0.219482988,
        2.09259605, -2.18717694, 0.944999993,
        -0.010977, 1.72817111, -0.207884997,
        2.24791193, -2.24474692, 0.995580018,
        -2.62597513, 0.668316007, 1.53374696,
        -2.41513801, 0.670956016, 1.47867906,
        -2.26215005, 0.749076009, 1.50136507,
        -2.103441, 0.694160998, 1.49985301,
        -1.968642, 0.759225011, 1.42246199,
        -1.81427693, 0.680460036, 1.44162607,
        -1.52863503, 0.693588018, 1.43095505,
        -1.30471802, -2.15152812, 0.945737958,
        -1.06612206, -2.09589005, 1.03820992,
        -0.928416014, -2.17917013, 0.98288393,
        -0.794255972, -2.08801508, 0.957210064,
        -0.636864007, -2.13764095, 0.997394979,
        -0.515757024, -2.02174211, 0.955367982,
        -0.323583007, -2.09249997, 0.953991055,
        -0.152525991, -2.11920905, 0.986901045,
        0.0218160003, -2.09928012, 1.03447807,
        -0.837363005, 1.97391891, -0.293390989,
        0.173072994, -2.14619994, 1.10353494,
        -0.669645011, 1.90670407, -0.261509985,
        0.35868001, -2.04538798, 1.02177596,
        -0.489263982, 1.90668905, -0.154451996,
        0.552321017, -2.02584291, 1.00454998,
        -0.369207025, 1.90998912, -0.312375009,
        0.718532979, -2.04953098, 0.977342963,
        0.870900035, -2.11285782, 0.975317955,
        1.00984204, -2.04374695, 1.03733706,
        1.14659691, -2.11655092, 0.973928928,
        1.30971301, -2.07291603, 1.02761996,
        1.41513002, -2.20412993, 1.07975399,
        1.54239893, -2.10446405, 1.04673004,
        1.70810699, -2.10982513, 1.01031899,
        1.89124799, -2.09406614, 1.09783792,
        2.05311608, -2.07111001, 1.06195498,
        2.19773388, -2.04841185, 0.979530036,
        -2.6031599, 0.830043018, 1.454283,
        2.35977292, -2.1070559, 0.986814022,
        -2.40898514, 0.846207023, 1.50797987,
        -2.24832892, 0.913917065, 1.48800302,
        -2.08424711, 0.868731022, 1.48036802,
        -1.87396502, 0.878715038, 1.49088597,
        -1.67977202, 0.789413989, 1.43099403,
        -0.780431986, 2.13795614, -0.237180009,
        -1.21288502, -2.02005601, 1.00461292,
        -0.60047698, 2.07612896, -0.265524,
        -1.06805396, -1.92561603, 1.01275802,
        -0.922905028, -2.00956488, 1.03863907,
        -0.420590997, 2.06213999, -0.226754993,
        -0.769791007, -1.95196795, 1.06544101,
        -0.672614992, -1.98185992, 0.935772061,
        -0.374181002, -1.95227408, 1.01428199,
        -0.213918, -1.95643795, 0.954572976,
        -0.105606005, -1.98118794, 1.07117391,
        0.0480809994, -1.91995502, 1.03478098,
        0.196392, -1.99954498, 1.036443,
        -2.53268409, 0.989885926, 1.491207,
        0.450293988, -1.89732289, 0.996800959,
        -2.370996, 0.997457981, 1.40084398,
        0.609821975, -1.85856891, 1.06072199,
        -2.22684598, 1.07520902, 1.45447803,
        0.747138023, -1.87810206, 0.95472604,
        -2.01248693, 1.02002704, 1.44780302,
        0.884738982, -1.93360496, 1.03591204,
        -1.85286307, 1.04939997, 1.48551297,
        1.02821398, -1.91012406, 1.13233805,
        -1.71791697, 0.946727991, 1.49877596,
        1.16613901, -1.9599061, 1.03852201,
        1.32401097, -1.90209913, 1.05685806,
        1.50694489, -1.94864702, 1.02205801,
        1.67818499, -1.91312706, 1.05305099,
        1.82153106, -1.988451, 0.975713968,
        1.95409489, -1.934232, 1.07700896,
        2.11354494, -1.90672493, 1.025913,
        2.28193498, -1.87153792, 1.00395,
        2.44163394, -1.94734204, 1.014588,
        -0.640700996, 2.25503397, -0.24489601,
        -0.466890037, 2.23504496, -0.193767011,
        -0.31389299, 2.25920105, -0.292001992,
        -1.46958303, -1.79245198, 0.993276,
        -1.31838, -1.88558102, 1.03156209,
        -2.45723414, 1.1417551, 1.44023705,
        -1.177086, -1.79847598, 1.01003397,
        -2.30212498, 1.23101103, 1.45899296,
        -1.03856695, -1.72088408, 1.04436004,
        -2.08562994, 1.17081308, 1.47584701,
        -0.920855999, -1.83710694, 1.00848293,
        -1.92033315, 1.23261607, 1.54827905,
        -0.759368956, -1.82478595, 0.962520003,
        -1.71844804, 1.16004598, 1.471632,
        -0.635241032, -1.85051107, 1.07646298,
        -0.469098032, -1.80841506, 1.00957501,
        -0.205962002, -1.742697, 1.05394495,
        -0.0875220001, -1.83643806, 0.976812005,
        0.0535799973, -1.74939609, 1.02808809,
        0.201035991, -1.83011103, 1.02277505,
        0.344532013, -1.75919402, 0.957219005,
        0.507440984, -1.73367, 1.00016093,
        0.682523966, -1.71923697, 0.992127061,
        0.797843993, -1.79121304, 1.09363496,
        0.965126991, -1.7741971, 1.06809306,
        1.13178301, -1.78672206, 1.04952598,
        1.32847798, -1.73706603, 1.01754594,
        1.426512, -1.84064102, 0.92951107,
        1.57733703, -1.79924703, 0.983556032,
        1.69706106, -1.72950304, 1.07536793,
        1.82238603, -1.83218694, 1.03335309,
        1.99431896, -1.77297306, 1.03523707,
        -0.394917011, 2.40254402, -0.170960993,
        2.1640439, -1.745049, 1.0121789,
        2.41083908, -1.785429, 1.09451401,
        0.33168599, -1.76175892, 2.07059717,
        0.500010014, -1.810251, 2.07714009,
        0.677157044, -1.7888279, 2.07299089,
        -2.02752304, 1.329849, 1.44495595,
        -1.85124898, 1.341048, 1.42432499,
        -1.67545485, 1.31999099, 1.40120101,
        -1.96315491, -1.6098721, 0.963575959,
        -1.81118393, -1.68352497, 1.01447403,
        -1.64408708, -1.74168599, 1.01062799,
        -1.52121592, -1.62920702, 0.98348105,
        -1.38052499, -1.67060685, 1.07553601,
        -1.21254599, -1.66428602, 1.10769606,
        -0.94849503, -1.53982508, 1.04346001,
        -0.830307007, -1.67208004, 0.987594008,
        -0.658002019, -1.69642186, 1.01326799,
        -0.519545972, -1.59195292, 1.010934,
        -0.361307979, -1.69805098, 1.09137607,
        -0.18751201, -1.57565713, 1.03021193,
        -0.0729780048, -1.66717792, 0.962448001,
        0.0380759984, -1.57586396, 1.05467999,
        0.208452016, -1.66531205, 1.00070095,
        0.33880201, -1.59808803, 0.909372032,
        0.411171019, -1.56743693, 1.05325508,
        0.584195971, -1.59089398, 1.05027306,
        0.856791019, -1.64986503, 1.00947297,
        1.05867898, -1.63092899, 1.04261994,
        1.21738791, -1.64816701, 1.10808599,
        1.34473205, -1.56899393, 1.01481295,
        1.45894802, -1.67954099, 0.920228958,
        1.60211098, -1.63136709, 0.979866028,
        1.749681, -1.57084799, 1.033746,
        1.8638339, -1.67784905, 1.086429,
        2.11201191, -1.59331799, 1.07379603,
        2.28048301, -1.53627896, 1.046718,
        2.4463439, -1.58039713, 0.995646,
        0.199386001, -1.65096903, 2.07480001,
        0.378731966, -1.59822893, 2.10019207,
        0.549392998, -1.64633095, 2.10222602,
        0.716444969, -1.60876203, 2.06311202,
        -2.07890415, -1.49918699, 1.03889406,
        -1.96981192, -1.431108, 0.925113022,
        -1.84007406, -1.50845098, 1.02683997,
        -1.67353201, -1.57105207, 1.04618096,
        -1.40716505, -1.50610209, 1.01559901,
        -1.24373698, -1.50001502, 1.09290302,
        -1.1215291, -1.38145506, 1.01900101,
        -0.960821986, -1.37239206, 1.10348105,
        -0.808605015, -1.46391296, 1.10218799,
        -0.670220971, -1.5224309, 1.03235698,
        -0.55893302, -1.42640102, 0.950631022,
        -0.35186699, -1.54333496, 1.01914191,
        -0.225944996, -1.42265701, 0.983904004,
        -0.0329940021, -1.50275111, 0.918644965,
        0.083664, -1.42245901, 1.00319099,
        0.230097011, -1.49993694, 0.984413981,
        0.378701985, -1.412076, 0.995481014,
        0.547209024, -1.43090391, 0.955925941,
        0.718137026, -1.41197395, 0.916712999,
        0.855957031, -1.47019506, 1.00548303,
        1.05598199, -1.46113491, 1.01187897,
        1.21211696, -1.49838305, 0.947259068,
        1.35121799, -1.40662503, 0.924419999,
        1.47764099, -1.50917709, 0.933207035,
        1.61994302, -1.46995199, 0.996869981,
        1.83482695, -1.42888498, 1.03290296,
        1.95073807, -1.54658413, 1.0216651,
        0.263904005, -1.46084702, 2.11117792,
        0.447726011, -1.44163501, 2.12892008,
        0.599718034, -1.48315501, 2.06384993,
        0.76335597, -1.43480992, 2.07581115,
        -2.20697689, -1.38714302, 0.994737029,
        -2.05081511, -1.30805993, 1.02681303,
        -1.88244295, -1.32567596, 1.03870499,
        -1.72631693, -1.39110899, 1.04057395,
        -1.56846607, -1.42321801, 1.07727003,
        -1.45525503, -1.35033, 0.981794953,
        -1.28306401, -1.38900304, 0.967611015,
        -1.14040804, -1.22831404, 1.09980297,
        -1.01561999, -1.24703097, 0.98943305,
        -0.855507016, -1.237275, 1.04774404,
        -0.704072952, -1.35259807, 1.0158689,
        -0.519578993, -1.27912498, 1.02195907,
        -0.38746798, -1.3825531, 0.974258959,
        -0.23318401, -1.27781701, 0.902013063,
        -0.0790230036, -1.34492993, 0.944658041,
        0.0679350048, -1.27959299, 0.92264396,
        0.226403981, -1.33208704, 0.967491031,
        0.414237022, -1.2479341, 0.984998941,
        0.0866760015, -1.39565694, 2.06821799,
        0.562131047, -1.26089406, 0.920798957,
        0.207543015, -1.28621399, 2.12945414,
        0.723758996, -1.25775003, 0.962267995,
        0.380015999, -1.28903699, 2.1657362,
        0.882623971, -1.26864302, 0.944121003,
        1.06563604, -1.29658508, 0.961935043,
        0.57257998, -1.31707799, 2.10497403,
        1.20851707, -1.32041407, 1.05696893,
        0.682874978, -1.33231199, 1.96688414,
        1.34330702, -1.23758101, 0.933465004,
        0.86479497, -1.29859209, 2.05167603,
        1.51923895, -1.34365499, 1.05100799,
        1.69206595, -1.35019207, 1.06712103,
        1.81464601, -1.26843607, 0.996302962,
        1.99176908, -1.34889603, 1.00022101,
        -2.30932498, -1.24439394, 1.01193905,
        -2.10724807, -1.10733604, 1.04239202,
        -1.94404507, -1.16171396, 1.04240704,
        -1.7717669, -1.1992681, 1.00977302,
        -1.62405002, -1.26194406, 1.05551696,
        -0.277532995, -1.19037604, 2.02301407,
        -0.139211997, -1.12424707, 2.11481404,
        -1.5083189, -1.19770503, 0.962388039,
        0.00043200003, -1.23848701, 2.10210896,
        -1.37939692, -1.095348, 0.938324928,
        0.160313994, -1.11756301, 2.15338802,
        -1.26694798, -1.10016596, 1.06907105,
        0.329400003, -1.12912798, 2.13269114,
        -1.103688, -1.09190702, 1.0104959,
        0.501756012, -1.16125202, 2.13637805,
        -0.942731977, -1.08522296, 1.06373096,
        0.714614987, -1.21117806, 2.07942605,
        -0.706716001, -1.15855503, 1.03045201,
        -0.536520004, -1.13032496, 1.11378896,
        -0.382193983, -1.20586801, 0.951978028,
        -0.219399005, -1.12798202, 0.96835494,
        -0.0619200021, -1.17132306, 1.01444697,
        0.0725729987, -1.11606598, 0.933018029,
        0.229965001, -1.17305398, 0.895506024,
        0.330623984, -1.10931301, 1.01899803,
        0.487365007, -1.104195, 0.936848998,
        0.654924035, -1.11464703, 0.964299023,
        0.82832706, -1.11465597, 0.99089402,
        0.986499071, -1.16149199, 1.01758194,
        1.18815899, -1.17380702, 0.978567004,
        1.34193003, -1.09556699, 1.01647806,
        1.49379599, -1.19116199, 0.992652059,
        1.65308094, -1.19292307, 1.04276097,
        1.77669907, -1.09869301, 0.982362032,
        1.93820393, -1.158939, 0.996342063,
        -0.29965201, -1.00501204, 2.05047297,
        -2.41092587, -1.09312797, 1.028808,
        -0.141948, -0.945416987, 2.1195991,
        -2.25868511, -0.999987006, 1.05962098,
        0.0122610005, -1.02936292, 2.11884308,
        -2.16168308, -0.928362012, 0.932268023,
        0.223374009, -0.955533028, 2.12878799,
        -2.00896502, -0.99238801, 0.965016007,
        0.402027011, -0.976004958, 2.13074088,
        -1.83985806, -1.03373706, 0.979704022,
        0.573651016, -1.00212598, 2.12942696,
        -1.68113101, -0.958485007, 0.987152934,
        0.735210001, -1.03489196, 2.07974696,
        -1.52820587, -1.02583802, 0.946356058,
        -1.38672304, -0.965204954, 1.03912807,
        -1.215927, -0.947003961, 1.01720703,
        -1.05375898, -0.948807001, 1.09341598,
        -0.801875949, -1.02454495, 0.983384967,
        -0.700332046, -0.992151022, 1.11157501,
        -0.541047037, -0.965124011, 1.07199299,
        -0.357087016, -1.06476593, 1.0521059,
        -0.224862009, -0.963714004, 1.01385307,
        -0.0641010031, -1.00731003, 0.968981981,
        0.176021993, -1.035357, 1.03842306,
        0.320363998, -0.952719033, 1.07256007,
        0.425384998, -0.954650998, 0.940935016,
        0.583638012, -0.971331, 0.983523011,
        0.734921992, -0.993672013, 1.05381298,
        0.842051983, -0.957165003, 0.924576044,
        1.003479, -1.00898397, 0.955070972,
        1.27714193, -0.876320958, 0.935670018,
        1.39914298, -0.932439029, 1.04155207,
        1.48326302, -1.06166697, 1.107669,
        1.62379503, -1.02818704, 1.01949298,
        1.75134897, -0.933269978, 0.963078022,
        1.90926898, -0.993497968, 0.93809998,
        -0.109610997, -0.734063983, 2.05281591,
        0.00741299987, -0.852885008, 2.106879,
        0.168146998, -0.792096019, 2.10718799,
        -2.46625519, -0.921522021, 1.00215602,
        0.33614099, -0.820053041, 2.10706806,
        -1.76119208, -2.72959805, -0.12818101,
        -2.31192899, -0.837137997, 1.00718701,
        0.510398984, -0.84048295, 2.09868002,
        -1.60188913, -2.70308399, -0.206760004,
        0.681125998, -0.868449032, 2.10043192,
        -1.46919298, -2.74299312, -0.0995430052,
        -2.14421701, -0.793935061, 1.0299809,
        -1.29943204, -2.74245882, -0.144243002,
        -1.98004496, -0.834314942, 1.05068398,
        -1.12917304, -2.73978615, -0.097190991,
        -1.78735507, -0.798200965, 1.00005007,
        -0.944982052, -2.71817398, -0.0890160054,
        -1.63005602, -0.817674041, 0.908789992,
        -1.46807098, -0.865857005, 0.924681008,
        -1.31359804, -0.808073997, 0.989562035,
        -1.11544204, -0.808983028, 1.0206151,
        -0.948101997, -0.798168004, 0.993795037,
        -0.844743013, -0.895461023, 1.08606899,
        -0.672599971, -0.866109014, 0.997938037,
        0.808146, -2.6565032, -0.148259997,
        -0.541043997, -0.797423959, 1.07066393,
        0.965448022, -2.714607, -0.112911001,
        -0.391571999, -0.897252023, 1.0431509,
        1.13470793, -2.68901396, -0.147558004,
        -0.252213001, -0.825824976, 1.105425,
        -0.0980129987, -0.858621001, 1.05657601,
        0.049203001, -0.929090977, 1.06544399,
        0.193217993, -0.860946, 0.993299961,
        0.355764002, -0.815454006, 0.993858039,
        0.518328011, -0.817443013, 0.988763988,
        0.681894004, -0.836562037, 0.948956966,
        0.964434028, -0.841310978, 0.970562935,
        1.10389197, -0.784341037, 0.889304996,
        1.21263301, -0.754199982, 1.02865803,
        1.38403201, -0.762930036, 1.01361299,
        1.55869794, -0.873986959, 1.03282499,
        1.70613599, -0.783900023, 1.017501,
        1.87631106, -0.838814974, 1.02637196,
        2.03898907, -0.882239938, 0.985314012,
        0.0542849973, -0.667466998, 2.06806517,
        0.261555016, -0.649464011, 2.06861401,
        0.435201019, -0.685140014, 2.07584095,
        -1.83868504, -2.57950497, -0.0666659996,
        -1.67849398, -2.56054783, -0.136527002,
        -1.494012, -2.57181001, -0.154356003,
        -1.23321593, -2.58014393, -0.129021004,
        -1.05856502, -2.59871387, -0.155534998,
        -0.959619045, -2.48688602, -0.0802859962,
        -2.54705095, -0.732107997, 0.976691961,
        -0.826731026, -2.57788205, -0.0235440005,
        -2.4162178, -0.712992013, 1.09149003,
        -0.659372985, -2.57462406, -0.0525690019,
        -2.24397588, -0.670596004, 1.09463704,
        -0.564236999, -2.43753314, -0.00906299986,
        -2.15290213, -0.654645026, 0.943560004,
        -0.479247004, -2.57905197, -0.0681959987,
        -1.991184, -0.689388037, 0.962319016,
        -0.306465, -2.56195807, -0.0820830017,
        -1.83343506, -0.652064979, 0.928050041,
        -0.133212, -2.55663919, -0.0948660001,
        -1.67004013, -0.669084013, 0.977000952,
        -0.249594003, -2.68179607, 1.93991697,
        0.0313709974, -2.55428696, -0.145670995,
        -1.49962795, -0.697538972, 0.95263803,
        0.239772007, -2.55041981, -0.187307999,
        -1.34370601, -0.60194397, 0.989910007,
        0.385728002, -2.55223203, -0.0808560029,
        -1.20412803, -0.673092008, 0.939441025,
        0.559260011, -2.54278493, -0.113931,
        -1.03268397, -0.670646966, 1.07207096,
        0.733223975, -2.51212192, -0.0959610045,
        -0.839805007, -0.675639033, 0.970394969,
        0.894579053, -2.50386906, -0.156138003,
        -0.682599008, -0.701804996, 1.04312396,
        1.06473303, -2.52889204, -0.142587006,
        -0.527511001, -0.627740979, 1.05604196,
        1.23079193, -2.54865003, -0.167856008,
        -0.38953802, -0.72953999, 1.06454706,
        -0.241277993, -0.655116022, 1.05206096,
        -0.0917489976, -0.702864051, 0.993914962,
        0.152472004, -0.696851969, 0.98466301,
        0.314787, -0.658958972, 0.997997999,
        0.471152991, -0.635802031, 0.943542004,
        0.597446978, -0.685467005, 1.03527296,
        0.732002974, -0.667493999, 0.951303005,
        0.871827006, -0.695592046, 1.03399205,
        0.968021989, -0.673143029, 0.902979016,
        1.14441001, -0.629768968, 0.935253024,
        1.30282807, -0.620895028, 0.899481058,
        1.45642793, -0.614297986, 0.980789959,
        1.61441994, -0.636798024, 1.04427302,
        1.829247, -0.703608036, 0.932721019,
        2.008605, -0.709239006, 0.964913964,
        -0.488153994, -2.57440495, 1.99640393,
        -0.354413986, -2.55474281, 1.88631892,
        -0.227043003, -2.50753188, 1.99702501,
        -0.0874620005, -2.61018896, 1.93806005,
        -1.57824302, -2.42486691, -0.0958530009,
        -1.41077101, -2.417454, -0.158775002,
        -1.12587297, -2.44997692, -0.0990569964,
        -1.00339496, -2.35056305, -0.158009991,
        -2.51970911, -0.500154018, 1.01135707,
        -0.816425979, -2.41564202, -0.128381997,
        -2.36127305, -0.553641021, 1.04908204,
        -0.703104019, -2.33933711, -0.00998700038,
        -2.24808002, -0.516650975, 0.928371012,
        -0.498959988, -2.28671098, -0.00217500003,
        -2.11698604, -0.511310995, 1.03520405,
        -0.486122966, -2.42131495, -0.159668997,
        -1.95228004, -0.540777028, 1.02290702,
        -0.382838964, -2.41155601, -0.0328589976,
        -1.78517103, -0.521721005, 1.00898707,
        -0.219792008, -2.40128112, -0.0885839984,
        -1.619712, -0.50789398, 0.982643962,
        -0.0631829947, -2.41317892, -0.163374007,
        -1.47728097, -0.535992026, 1.06415403,
        0.131255999, -2.4172802, -0.16703999,
        -1.29049492, -0.470624983, 1.10988605,
        -1.21296597, -0.500823021, 0.95799005,
        0.329690993, -2.41336799, -0.176876992,
        -1.04704809, -0.534722984, 0.96747005,
        0.483168006, -2.39159393, -0.0622979999,
        -0.858512998, -0.468365997, 0.920354962,
        0.627665997, -2.43383694, 0.00753299985,
        -0.747377992, -0.54409498, 1.02924001,
        0.792198062, -2.36721897, -0.171584994,
        -0.512795985, -0.476811022, 0.975701988,
        0.993287981, -2.40924907, -0.0502500013,
        -0.373098016, -0.547311008, 1.04389191,
        1.17280793, -2.40662408, -0.0942149907,
        -0.215277001, -0.481860012, 1.06189799,
        -0.406811982, -2.40042305, 1.96410608,
        1.34129095, -2.41951799, -0.149351999,
        -0.242342994, -2.31131411, 1.96236014,
        -0.0705959946, -0.537693024, 0.99713099,
        -0.0888570026, -2.40749121, 1.94402397,
        0.0828419998, -0.561794996, 1.05342603,
        0.191480994, -0.454281002, 0.901218057,
        0.346242011, -0.512106001, 0.920141995,
        0.575181007, -0.518382013, 0.995918989,
        0.728009999, -0.464459985, 0.944768965,
        0.860691011, -0.552852035, 0.943239033,
        1.02673793, -0.515717983, 0.931173027,
        1.1886301, -0.46903497, 0.965550005,
        1.35641098, -0.478716016, 0.975252032,
        1.52202308, -0.460862994, 0.950616002,
        1.682127, -0.507362962, 0.940521002,
        1.81585801, -0.490620017, 1.04155207,
        1.97352898, -0.53905201, 0.993681014,
        -1.31677198, -2.27358007, -0.130607992,
        -1.15641594, -2.27458501, -0.194420993,
        -1.04405403, -2.21099687, -0.0737099946,
        -0.867375016, -2.28481197, -0.231303006,
        -0.735113978, -2.25428391, -0.145034999,
        -0.591021001, -2.18211889, -0.0935910046,
        -2.39145899, -0.400350004, 0.951593995,
        -0.394550979, -2.28128099, -0.143078998,
        -2.26059294, -0.418052971, 1.06428003,
        -0.233606994, -2.23292708, -0.125387996,
        -2.13102293, -0.346818, 0.984216034,
        -0.0793469995, -2.27447104, -0.0606539994,
        -1.98318291, -0.403991997, 0.932844043,
        0.0764279962, -2.23954487, -0.0959549993,
        -1.708992, -0.359676003, 1.00891805,
        0.236276999, -2.29692006, -0.109145999,
        -1.54271102, -0.359055012, 0.972986937,
        0.380232006, -2.25506711, -0.198903009,
        -1.38520503, -0.418250978, 0.97992301,
        0.519161999, -2.19574809, -0.124781996,
        -1.24463999, -0.335274011, 0.955103993,
        0.650165975, -2.29182005, -0.103244998,
        -1.13727295, -0.392168999, 1.06542897,
        0.784319997, -2.15668201, -0.0890219957,
        -0.978125989, -0.387282014, 1.0158689,
        0.908084989, -2.27294087, -0.109625995,
        -0.825971961, -0.32217899, 0.988796949,
        1.07255101, -2.26792192, -0.0743250027,
        -0.701699972, -0.391958982, 1.08065104,
        1.23547506, -2.25517201, -0.0505260006,
        -0.516870022, -0.316781998, 0.924023986,
        1.35638106, -2.21282101, -0.152226001,
        -0.362019002, -0.375479996, 0.986633956,
        1.54553413, -2.22266102, -0.165270001,
        -0.201344997, -0.324276, 1.01781595,
        -0.0635010004, -0.401646018, 1.09686303,
        0.0758280009, -0.398667008, 1.00645804,
        0.243452996, -0.363968998, 1.05327892,
        0.450188994, -0.401322007, 0.988649964,
        0.598446012, -0.365721017, 0.922332048,
        0.765513003, -0.307866007, 0.903720021,
        0.905550003, -0.40377897, 0.884603977,
        0.923877001, -0.237129003, 0.896210968,
        1.07104802, -0.357225001, 0.900596976,
        1.24634695, -0.329183996, 0.905379057,
        0.186852008, -2.01337194, 1.95308697,
        1.41054296, -0.325194001, 0.945270002,
        0.331856996, -2.108109, 1.97016299,
        1.55603993, -0.318228006, 1.02899098,
        0.497211009, -2.0625, 2.02086306,
        1.72661996, -0.348488986, 1.02288306,
        0.676473022, -2.13953114, 1.96420205,
        1.90191901, -0.358478993, 0.967055976,
        0.845718026, -2.10110998, 1.91196907,
        -1.32955801, -2.10212398, -0.0968430042,
        -1.17393899, -2.09825706, -0.182130009,
        -1.05970502, -2.04566693, -0.0688650012,
        -0.891833961, -2.0386529, -0.095739007,
        -2.43439507, -0.247059017, 1.01546407,
        -0.730196953, -2.08832097, -0.136568993,
        -2.26555204, -0.252959996, 1.01054704,
        -0.561077952, -2.02930188, -0.153363004,
        -2.13006592, -0.184587002, 0.932657957,
        -0.430832982, -2.12321997, -0.101594999,
        -1.95383692, -0.252824992, 0.993225038,
        -0.274812013, -2.06047487, -0.115974002,
        -1.8334949, -0.168996006, 0.906672001,
        -0.163008004, -2.12865591, -0.014703,
        -1.62680697, -0.212414995, 1.02316797,
        0.0126510002, -2.06665492, -0.074496001,
        -1.42105496, -0.248961002, 1.00601697,
        0.147237003, -2.12547588, 0.00819300022,
        -1.26771307, -0.175211996, 0.989786983,
        0.298817992, -2.12398505, -0.0649919957,
        0.0503670014, -1.91065502, 1.93889403,
        0.443055034, -2.04831314, -0.126201004,
        0.187088996, -1.85347795, 2.03566813,
        0.651176989, -2.09148002, -0.169367999,
        0.337514997, -1.939008, 2.00084686,
        0.877707005, -2.00094891, -0.111815996,
        -1.08182406, -0.245778009, 0.992612958,
        0.490263015, -1.90680289, 1.9368,
        0.971220016, -2.12979889, -0.0682739988,
        -0.93572998, -0.22355099, 1.07119203,
        0.646580994, -1.96947908, 1.99263287,
        1.13341808, -2.10970783, -0.0600179955,
        0.822075009, -1.92326999, 1.96943998,
        -0.757452011, -0.235397995, 1.11189306,
        1.29570603, -2.09548497, -0.0267390013,
        -0.593825996, -0.268548012, 1.068138,
        1.41847801, -2.05138803, -0.129885003,
        -0.549003005, -0.153524995, 0.945896983,
        1.58655906, -2.06565309, -0.0841289982,
        -0.387320995, -0.199331999, 0.923318982,
        1.75898695, -2.06552386, -0.100832999,
        -0.251376003, -0.165846005, 1.01847005,
        1.94171095, -2.12151313, -0.104310006,
        -0.100961998, -0.231792003, 1.11355793,
        0.0356430002, -0.218832001, 1.01387095,
        0.218052, -0.188502014, 1.06351793,
        0.372671992, -0.259142995, 1.0342021,
        0.539798975, -0.266544014, 1.04648697,
        0.634766996, -0.199613988, 0.924780011,
        0.794313073, -0.143598005, 0.942450047,
        1.01058304, -0.236747995, 1.03736997,
        1.12641895, -0.203538001, 0.920718074,
        1.293432, -0.211295992, 1.00116003,
        1.52406907, -0.211716011, 0.887282968,
        1.66134906, -0.195066005, 0.978618026,
        1.82836795, -0.205338001, 1.0246141,
        -0.0897209942, -1.81118393, 1.92733788,
        0.0482669994, -1.74708605, 2.02158308,
        0.197910011, -1.71192598, 1.91384387,
        0.347835004, -1.80185103, 1.90678501,
        0.502472997, -1.73813987, 1.92205203,
        0.635942996, -1.83359408, 1.89808798,
        -1.390167, -1.94492388, -0.0580319986,
        0.839216948, -1.73105097, 2.02349997,
        -1.21507192, -1.96385407, -0.0705749989,
        -1.00121403, -1.90952086, -0.130100995,
        -2.43158102, -0.0694350004, 1.02641392,
        -0.849300027, -1.87230599, -0.0851700008,
        -2.28299999, -0.0960180014, 0.940311074,
        -2.13964796, -0.014661001, 0.915602982,
        -0.698612988, -1.92709208, -0.0767759979,
        -1.99312806, -0.0927570015, 0.963180006,
        -0.551238, -1.94001293, -0.00663300045,
        -1.8109529, -0.0458550006, 1.03062892,
        -0.413999975, -1.95216894, -0.0963810012,
        -1.64826298, -0.0652410015, 1.11356401,
        -0.282584995, -1.90005302, -0.188529015,
        -1.48978209, -0.0912359953, 1.036044,
        -0.133259997, -1.97306108, -0.0855839998,
        -1.28373301, -0.012041999, 0.954078019,
        -0.00439799996, -1.93015194, -0.17089799,
        -1.13712907, -0.0894659981, 0.927498043,
        0.140009999, -2.00745296, -0.182154,
        -1.05719995, -0.0725219995, 1.07919598,
        0.294135004, -1.96902299, -0.129005998,
        -0.830814004, -0.102389999, 1.04502296,
        0.429690003, -1.87551606, -0.154178992,
        -0.666195035, -0.107637003, 1.05395699,
        0.581357956, -1.94379008, -0.136070997,
        -0.58118099, 0.0132689998, 0.961788058,
        0.832013965, -1.85155499, -0.0580319986,
        -0.416945994, -0.0474420041, 1.00452304,
        -0.280824006, -0.0419519991, 0.916907966,
        0.992214024, -1.89908695, -0.0269850008,
        -0.122115001, -0.0466259979, 0.967094958,
        1.15614307, -1.940274, -0.0430800021,
        0.0278550014, -0.0515550002, 1.02790499,
        1.32937503, -1.904706, -0.126647994,
        -0.0950490087, -1.638942, 1.96254301,
        1.49786401, -1.92029107, -0.0535500012,
        0.273977995, -0.017151, 0.897647977,
        1.66719604, -1.93842912, -0.192459002,
        0.349119008, -0.101061001, 1.01267707,
        0.0713969991, -1.578426, 1.98872995,
        1.80988503, -1.8981781, -0.104435995,
        0.518760026, -0.103296004, 1.009758,
        0.226725012, -1.53814209, 1.93392897,
        0.668273985, -0.0403590016, 0.979133964,
        0.362357974, -1.64200211, 1.93916392,
        0.823224068, 0.0115470001, 1.01288402,
        0.950201988, -0.0899939984, 0.995580018,
        0.519042015, -1.57367992, 1.94370294,
        1.10480702, -0.0311729982, 0.994511962,
        0.660429001, -1.67111397, 1.920012,
        1.24156499, -0.0863789991, 0.92355907,
        0.884559035, -1.54529691, 2.02133083,
        1.405653, -0.0555180013, 0.942170978,
        1.557513, -0.0615810007, 1.01973605,
        1.00249505, -1.64015698, 1.93842912,
        1.72845602, -0.0538560003, 1.04704809,
        -2.58013201, 0.0475260019, 0.987143993,
        -1.35376799, -1.80530405, -0.155249998,
        -2.414397, 0.0968879908, 1.00490403,
        -1.22861397, -1.76928592, -0.0428429991,
        -2.25018001, 0.0538260005, 1.0307281,
        -1.10162401, -1.78406703, -0.153890997,
        -2.11445999, 0.142563, 0.962162971,
        -0.935531974, -1.76232898, -0.176864997,
        -1.95921898, 0.0576150008, 1.03951204,
        -0.707399964, -1.767591, 0.00926099997,
        -1.80711901, 0.118935004, 0.971567988,
        -1.56647408, 0.0801059976, 1.06994402,
        -0.536934018, -1.77759004, -0.00649200007,
        -1.47061205, 0.0416280031, 0.937764049,
        -0.397772968, -1.67939401, -0.00532200001,
        -1.33927202, 0.144261003, 0.965852976,
        -0.261123002, -1.76429701, -0.0718140006,
        -0.210714012, -1.492998, 1.93621194,
        -1.14375305, 0.061191, 1.00962007,
        -0.0616289973, -1.47871804, 2.02661395,
        -0.135050997, -1.81600809, -0.177071989,
        0.0958889946, -1.43078995, 1.89350104,
        -1.01410496, 0.167006999, 1.0199759,
        0.0459209979, -1.78369796, -0.115979999,
        0.237093002, -1.37105703, 1.96968591,
        -0.923289061, 0.0304079987, 1.02909005,
        0.225156009, -1.81409705, -0.131744996,
        0.381401986, -1.474998, 1.97204113,
        -0.751893044, 0.0359399989, 0.999276042,
        0.367175996, -1.72610402, -0.141027004,
        0.541056037, -1.40950501, 1.91690397,
        -0.505190969, 0.160806, 0.978683949,
        0.710232019, -1.496997, 1.92532206,
        -0.366030008, 0.103509009, 1.059672,
        0.864138007, -1.40914202, 1.91790295,
        0.557828963, -1.79877305, -0.230282992,
        1.03027201, -1.4645071, 1.96240807,
        -0.211320013, 0.106821001, 0.931901932,
        0.687873006, -1.80812693, -0.131721005,
        -0.0805319995, 0.199761003, 0.978527963,
        0.794111967, -1.67780709, -0.127604991,
        0.159431994, 0.0407910012, 1.01349604,
        0.951783061, -1.73879409, -0.0949470028,
        0.324456006, 0.0647789985, 1.03289402,
        1.09052396, -1.82357705, -0.152271003,
        0.439338028, 0.01143, 0.921693027,
        1.25072706, -1.75108802, -0.132452995,
        0.589137018, 0.0891989991, 0.909629941,
        1.413396, -1.77319193, -0.20024699,
        0.711035967, 0.135249004, 1.01415598,
        1.57626891, -1.79175305, -0.154778987,
        0.864072025, 0.212855995, 1.04401207,
        1.74710107, -1.73840714, -0.141764998,
        0.977421045, 0.0892499983, 0.996174037,
        1.1233139, 0.110877, 1.08167696,
        1.263798, 0.0675690025, 0.977409005,
        1.42146897, 0.0738900006, 1.04955304,
        1.58922601, 0.0955289975, 1.08920407,
        -0.294434994, -1.34038198, 1.90341902,
        -0.161375999, -1.33340096, 2.02366209,
        0.0257520005, -1.28328001, 1.93498802,
        0.286469996, -1.21321797, 1.98576307,
        0.425240993, -1.31107497, 1.99814701,
        0.550431013, -1.24152601, 1.90484095,
        0.736316979, -1.36227596, 1.81375802,
        -2.71025085, 0.178356007, 1.00742102,
        0.865197062, -1.25575197, 1.84072208,
        1.0218749, -1.30857003, 1.90011597,
        -2.53882504, 0.187332004, 1.084512,
        1.19382298, -1.357005, 1.910133,
        -2.39398789, 0.258774012, 1.04437196,
        -2.23139691, 0.226545006, 1.04574299,
        -2.10473394, 0.333512992, 0.993791938,
        -1.63944006, -1.61413193, -0.157058999,
        -1.99278009, 0.224559009, 1.04918396,
        -1.48439407, -1.68644691, -0.121514998,
        -1.83360291, 0.277832985, 1.02581096,
        -1.33735204, -1.63395905, -0.0375120007,
        -1.19514, -1.62847185, -0.144485995,
        -1.66842008, 0.228221983, 1.009341,
        -1.02720904, -1.63895702, -0.114147007,
        -1.50398707, 0.211857006, 0.956463039,
        -0.865839005, -1.58111107, -0.154709995,
        -1.31281495, 0.306446999, 0.935837984,
        -0.712089002, -1.6181941, -0.0844080001,
        -1.17389703, 0.225870013, 0.979860067,
        -0.549594045, -1.61398792, -0.0380880013,
        -0.942494988, 0.300599992, 0.936870039,
        -0.837491989, 0.185052007, 1.04069996,
        -0.407559037, -1.51325989, -0.0280560013,
        -0.675632954, 0.185984999, 0.994938016,
        -0.273720026, -1.59993303, -0.0875280052,
        -0.468944997, 0.327062994, 0.971657991,
        -0.150468007, -1.64215803, -0.190268993,
        -0.329921991, 0.229544997, 0.957005978,
        0.0186570007, -1.62160492, -0.115178995,
        -0.187412992, 0.303075016, 0.906875968,
        0.228659987, -1.646523, -0.0836579949,
        0.0026250002, 0.34384501, 1.00755596,
        0.376176, -1.56387591, -0.101402998,
        -0.388464034, -1.19178009, 1.87983906,
        0.0826079994, 0.180429012, 1.06684804,
        0.518549979, -1.64725208, -0.160901994,
        0.299427003, 0.229994997, 1.04037607,
        -0.116235003, -1.18652999, 1.94477701,
        0.765065968, -1.52700591, -0.195174009,
        0.126255006, -1.16889596, 1.99809301,
        0.425981998, 0.172974005, 0.944357991,
        0.943494022, -1.58390093, -0.169442996,
        0.56190002, 0.251064003, 0.889148951,
        0.280692011, -1.04358292, 1.99353313,
        0.986001015, -1.59354591, 0.00360299973,
        0.699146986, 0.298803002, 0.969134927,
        1.10100293, -1.65418804, -0.109305002,
        0.816386998, 0.370269001, 1.07312095,
        0.433340997, -1.13109601, 1.972929,
        1.28421605, -1.59597301, -0.194402993,
        1.04314494, 0.250245005, 1.01884794,
        0.602084994, -1.10932493, 1.99773312,
        1.24722898, 0.224114984, 1.03768206,
        1.4975791, -1.63083601, -0.136238992,
        0.708963037, -1.18475401, 1.87567496,
        1.43849707, 0.240164995, 1.09927499,
        1.62194085, -1.68766201, -0.0299249999,
        0.839208007, -1.13967896, 1.97773194,
        1.55103898, 0.212760001, 0.963117003,
        1.77730203, -1.61717415, -0.0111659998,
        0.997898936, -1.19077194, 2.02600503,
        1.89528894, -1.64025307, -0.138464987,
        1.15409696, -1.18858206, 1.94955587,
        -2.76777601, 0.347988009, 0.966140985,
        -2.603616, 0.329463005, 1.023579,
        -1.97777104, -1.46125507, -0.0962700024,
        -2.43474007, 0.415922999, 1.075683,
        -1.79975104, -1.56232786, -0.108120002,
        -2.30890512, 0.384975016, 0.968979001,
        -1.66188288, -1.53681898, 0.00101999997,
        -2.17189193, 0.483516008, 1.00566602,
        -1.51118112, -1.52415597, -0.0807510018,
        -1.94648409, 0.41386798, 1.04484606,
        -1.35366607, -1.49299502, -0.134091005,
        -1.75088704, 0.41565299, 0.98557198,
        -0.415176004, -1.01913309, 1.90443599,
        -1.58249402, 0.371316016, 0.967491031,
        -1.142295, -1.46330702, -0.133676991,
        -0.250445992, -1.07784295, 1.89674699,
        -1.42857301, 0.420911998, 0.926247001,
        -0.102498002, -1.02035701, 1.96830297,
        -1.267887, 0.447999001, 1.01796293,
        -0.988107026, -1.49187899, -0.0574770011,
        -1.08234906, 0.368022025, 1.01970601,
        0.0299879983, -1.09157705, 1.88694906,
        0.120045006, -0.990527987, 1.99239898,
        -0.817178965, 0.385757983, 1.02907801,
        0.34652099, -0.893756986, 1.94863808,
        -0.643305004, 0.358013988, 1.00129199,
        0.491934001, -0.969188929, 1.98311114,
        -0.86304307, -1.412166, -0.132510006,
        0.745338023, -1.00732493, 1.915272,
        -0.713535011, -1.44768, -0.0560459979,
        -0.161826, 0.404387981, 1.04675996,
        0.889266014, -0.979200006, 2.02746892,
        -0.0449519977, 0.497595012, 0.947153986,
        1.03535104, -1.033746, 1.95912886,
        0.0731189996, 0.491255999, 1.0812,
        -0.548004031, -1.42930508, -0.0398459993,
        1.202685, -1.0289371, 1.89086699,
        -0.425909996, -1.38694501, -0.143291995,
        0.297123015, 0.391578019, 1.06820107,
        -0.275501996, -1.43833804, -0.113252997,
        0.439002037, 0.341648996, 0.979901969,
        -0.124254003, -1.51725304, -0.0688979998,
        0.588245988, 0.420653999, 1.01211894,
        0.0120000001, -1.46667302, -0.159908995,
        0.742772996, 0.472847998, 0.94905901,
        0.174465001, -1.48811698, -0.107597999,
        0.88204205, 0.456821978, 0.851016045,
        0.965337038, 0.395321965, 0.99059999,
        0.320775002, -1.41147304, -0.0592410006,
        1.11584699, 0.48743999, 0.979187965,
        0.51353699, -1.46708405, -0.0951690003,
        1.35776699, 0.354461998, 0.990996003,
        0.684270024, -1.41194701, -0.0945719928,
        0.888339043, -1.41700196, -0.148994997,
        1.04653502, -1.46771097, -0.095292002,
        1.21243191, -1.502496, -0.0663719997,
        1.36809301, -1.46227193, -0.111332998,
        1.52586007, -1.46441996, -0.174788997,
        1.67333102, -1.56125093, -0.142775998,
        1.78870487, -1.45649695, -0.0755189955,
        1.95592499, -1.49354398, -0.0607260019,
        -0.356573999, -0.854909956, 1.94122803,
        -0.184248, -0.868206024, 1.96838999,
        -0.00474000024, -0.883298993, 1.94059503,
        0.184457988, -0.838946939, 1.94230807,
        0.329852998, -0.727917016, 1.93449903,
        -2.73604512, 0.499449015, 1.05321002,
        0.492287993, -0.77078104, 1.93785906,
        -2.57014203, 0.496989012, 1.03443003,
        0.630939007, -0.868427992, 1.936584,
        -2.471946, 0.634235978, 1.03708804,
        0.834051013, -0.816300035, 2.03181005,
        -2.32670403, 0.547511995, 1.046175,
        0.995175004, -0.80726999, 1.95019507,
        -2.17311001, 0.643182039, 1.05169499,
        -2.02090192, 0.56874299, 1.02860999,
        -1.84855199, 0.554300964, 1.016886,
        -1.65749109, 0.550841987, 1.02556491,
        -1.42120194, 0.58031702, 0.922034979,
        -1.25244904, 0.589448988, 0.928697944,
        -1.09750509, 0.535769999, 0.983267963,
        -2.06169891, -1.32499504, -0.183777004,
        0.235659003, 0.547919989, 1.05974996,
        -1.90074897, -1.30484104, -0.135498002,
        0.37620002, 0.600917995, 0.971166015,
        -1.78606796, -1.40012407, -0.0610140041,
        0.476561964, 0.485001028, 0.892179012,
        -1.63862693, -1.36403394, 0.0215670001,
        0.641247034, 0.62392199, 0.93868804,
        -1.47701097, -1.36005902, -0.0606600009,
        0.809244037, 0.625604987, 0.880511999,
        -1.31568599, -1.32695699, -0.13529101,
        0.952287018, 0.564818978, 0.962630987,
        -1.19054401, -1.25321102, -0.0465600006,
        -1.02377391, -1.348611, -0.136875004,
        -0.893499017, -1.25206804, -0.176247001,
        -0.787358999, -1.29568803, -0.0355740003,
        -0.623613, -1.27809894, -0.058290001,
        -0.461742014, -1.23208201, -0.083397001,
        -0.306078017, -1.26706207, -0.150251999,
        -0.158322006, -1.32618308, -0.0911429971,
        -0.0315060019, -1.31849408, -0.196052998,
        -0.256200016, -0.708095968, 1.93932903,
        0.177098989, -1.32045603, -0.0434520021,
        -0.116565004, -0.599390984, 1.94217896,
        0.281598002, -1.27891803, -0.165962994,
        0.471269965, -1.28977799, -0.0844889954,
        0.00571499998, -0.715380013, 1.91434801,
        0.650774956, -1.24711204, -0.114390001,
        0.165387005, -0.671247005, 1.93162203,
        0.903260946, -1.27522492, -0.0606900007,
        0.384095997, -0.544332027, 1.99466109,
        1.0526309, -1.29731107, -0.131045997,
        0.563444972, -0.588447034, 2.00714993,
        -2.67287993, 0.666191995, 1.05271804,
        1.18455899, -1.33831191, -0.0291900001,
        0.692597985, -0.708669007, 2.02368593,
        -2.46833396, 0.797268033, 0.989466012,
        0.864120007, -0.664596021, 1.95615005,
        1.31698501, -1.27823997, -0.109245002,
        1.03025401, -0.647459984, 1.87467909,
        -2.32669783, 0.725453973, 1.06077302,
        1.47209406, -1.32776403, -0.0889769942,
        -2.17076707, 0.808877945, 1.05003297,
        -2.04463196, 0.732639015, 0.966740966,
        1.63332295, -1.37793601, -0.0668490008,
        -1.76153088, 0.700806022, 0.993834019,
        -1.55051994, 0.691505969, 0.98674196,
        1.76220298, -1.32469499, 0.0221219994,
        -1.36177206, 0.72124505, 0.973887026,
        1.93128598, -1.33442998, -0.133535996,
        -1.18750799, 0.734246969, 0.993735015,
        -2.30069113, -1.08645606, -0.0700290054,
        -2.17909789, -1.20051908, -0.140934005,
        0.0460620001, -0.531561017, 1.93070698,
        -2.00908208, -1.17667496, -0.107451007,
        0.218982011, -0.508436978, 1.93831193,
        -1.76256299, -1.17367792, -0.14316,
        -1.62714291, -1.20943797, -0.0489419997,
        0.405449986, -0.451892972, 1.85722494,
        -1.49958599, -1.10952592, -0.106805995,
        0.578307033, -0.476417989, 1.87353897,
        0.724527001, -0.560100019, 1.93204808,
        -2.613276, 0.95233798, 0.991178989,
        -1.34312105, -1.170753, -0.0704789981,
        -2.45731211, 0.944652021, 1.07604301,
        -1.20470405, -1.11929703, -0.158580005,
        -1.05208504, -1.18728602, -0.127976999,
        -2.317662, 0.877056003, 0.977052033,
        -0.92296797, -1.08772802, -0.16406399,
        -2.01329088, 0.883706927, 1.04759097,
        -0.737276971, -1.14679193, -0.0874349996,
        -1.89182997, 0.804558039, 0.955170035,
        -0.527141988, -1.080549, -0.116052002,
        -1.74068689, 0.885641992, 0.934508979,
        -1.57580101, 0.84671998, 0.909584999,
        -0.371739, -1.11110091, -0.17058,
        -1.46154594, 0.845517039, 1.03761303,
        -0.201875985, -1.14211798, -0.174329996,
        -1.29709506, 0.867635965, 1.00923896,
        -0.0448019989, -1.16174698, -0.218171999,
        0.0715740025, -1.21515894, -0.115587004,
        0.20529601, -1.13343, -0.148272008,
        0.360590994, -1.14944696, -0.082283996,
        0.526262999, -1.13144398, -0.113067001,
        0.685241997, -1.08424199, -0.14182201,
        0.841302037, -1.11431706, -0.0412259996,
        1.01366997, -1.14316797, -0.0468420014,
        1.17374098, -1.17428708, -0.0900719985,
        1.31887496, -1.11872101, -0.168893993,
        1.43878508, -1.16333103, -0.0598349981,
        1.59799814, -1.21198201, -0.0758219957,
        1.77148497, -1.19372094, -0.0734160021,
        1.87801504, -1.17938399, -0.197043002,
        -2.5324769, 1.11031497, 0.974327981,
        -2.43425703, 0.985536039, 0.909117043,
        -2.26423192, 1.02553201, 0.908336997,
        -2.25250196, -0.970319986, -0.196590006,
        -2.01824999, 1.05324006, 1.04396701,
        -2.10002708, -1.04089797, -0.150075004,
        -1.89491701, 0.976004958, 0.954614997,
        -1.74722099, 1.05793798, 0.946514964,
        -1.88222694, -1.06882203, -0.0955200046,
        -1.50438309, 0.990051031, 0.967725039,
        -1.72612202, -1.06557298, -0.0231269989,
        -1.33475697, 1.04158807, 0.967269063,
        -1.64162099, -1.03982401, -0.172149003,
        -1.49313307, -0.947555959, -0.0902850032,
        -1.33899903, -1.00654805, -0.133745998,
        -1.18316698, -0.944891989, -0.0989219993,
        -1.03201795, -0.966081023, -0.15264,
        -0.892032027, -0.884883046, -0.133724988,
        -0.672080994, -0.995514035, -0.0736410022,
        -0.552438021, -0.914537966, -0.159960002,
        -0.399843037, -0.958802998, -0.117153004,
        -0.238721997, -0.991905034, -0.110268004,
        -0.0805469975, -1.01648104, -0.031454999,
        0.0483420007, -1.05005097, -0.135642007,
        0.191666991, -0.983546972, -0.0841590017,
        0.318744004, -1.01585102, -0.189702004,
        0.477753013, -0.982649982, -0.161036998,
        0.60462904, -0.961719036, -0.0504330024,
        0.77641201, -0.960314989, -0.0710220039,
        -2.66033411, 1.22688007, 0.934692025,
        0.941601038, -0.956303954, -0.0949229971,
        -2.36355019, 1.14650106, 0.967343926,
        1.09808099, -1.01157296, -0.110975996,
        -2.19152689, 1.14237309, 1.013358,
        1.25542498, -1.01048994, -0.0546749979,
        -2.01171017, 1.21506, 1.07829607,
        1.46020198, -1.00819492, -0.118797004,
        -1.8644731, 1.12639797, 1.04571593,
        1.61849999, -1.05467403, -0.146733001,
        1.77888298, -1.05422997, -0.168347999,
        1.95419407, -1.02309299, -0.150702,
        -1.62586498, 1.17296398, 0.933039069,
        -1.45888805, 1.15146303, 0.915915012,
        -1.38995695, 1.19007599, 1.07340896,
        -2.28170991, -0.800907016, -0.155663997,
        -2.12842202, -0.865521073, -0.112908006,
        -1.97081101, -0.929751039, -0.0977580026,
        -1.80178499, -0.92117095, -0.126771003,
        -1.65241492, -0.916467011, -0.0532590002,
        -1.54421401, -0.790004969, -0.120365992,
        -1.38474, -0.846168041, -0.169263005,
        -1.22073603, -0.829028964, -0.214902014,
        -1.04770207, -0.797033966, -0.151385993,
        -0.831972003, -0.744735003, -0.184076995,
        -0.709581017, -0.852725983, -0.153074995,
        -0.561569989, -0.758249998, -0.100520998,
        -0.431237996, -0.816923976, 0.00597000029,
        -0.279372007, -0.829485059, -0.0720060021,
        -0.115100995, -0.866021991, -0.110814005,
        0.0501030013, -0.891764998, -0.064643994,
        -2.54363108, 1.3291409, 1.02321601,
        0.167135999, -0.830477953, -0.167427003,
        -1.67478299, -2.67537594, 1.61739898,
        -2.37178802, 1.30304098, 1.02569699,
        0.40584898, -0.845027983, -0.107528999,
        -2.17538095, 1.30693793, 1.06770897,
        -1.50870001, -2.71371603, 1.55915701,
        0.549849033, -0.797235012, -0.0337649994,
        -2.01286507, 1.38215995, 1.09970403,
        -1.42408502, -2.68414497, 1.71535492,
        0.698444963, -0.821487069, -0.0925830007,
        -1.93964386, 1.337448, 0.940970957,
        -1.24830604, -2.6879909, 1.68644106,
        -1.79096103, 1.23278999, 0.929993987,
        0.856659055, -0.798129022, -0.114794999,
        -0.97221297, -2.67129612, 1.62435603,
        -1.52192712, 1.29021895, 1.00423503,
        1.01859593, -0.800661027, -0.0865290016,
        -1.33854604, 1.29364491, 0.934199989,
        1.17619491, -0.852975011, -0.117527992,
        -0.713535011, -2.69007301, 1.68589807,
        1.34954405, -0.886281013, -0.116772003,
        -0.529121995, -2.69084406, 1.69794595,
        1.52018702, -0.865143061, -0.0429899991,
        0.0254819989, -2.69198108, 1.66722298,
        1.64390111, -0.886983037, -0.150665998,
        0.167994007, -2.68861508, 1.55314493,
        1.815588, -0.897174001, -0.148121998,
        0.326007009, -2.69049287, 1.64364886,
        1.9793849, -0.846698999, -0.123915002,
        0.505506039, -2.69213104, 1.60280991,
        0.677469015, -2.68794012, 1.66074908,
        0.857348979, -2.68403387, 1.63961101,
        -2.03972387, 0.170150995, 1.95395994,
        -1.86123896, 0.212939993, 1.948704,
        -2.25053406, 1.46060705, 1.02605999,
        -2.08387208, 1.49712598, 0.986598015,
        -2.20929289, -0.682394981, -0.0518999994,
        -1.90665007, 1.49737501, 1.01710498,
        -2.10907793, -0.713703036, -0.178713009,
        -1.76635802, 1.40574002, 0.93660897,
        -1.99537206, -0.770882964, -0.0473579988,
        -1.60030794, 1.48629594, 1.001019,
        -1.42812896, 1.43656504, 0.99948895,
        -1.87554312, -0.775394976, -0.164202005,
        -1.67308497, -2.49784517, 1.61140501,
        -1.71132612, -0.773958027, -0.124632001,
        -1.48928094, -2.50598693, 1.58816409,
        -1.53678012, -0.613193989, -0.161805004,
        -1.32679796, -2.5465889, 1.61726999,
        -1.15499401, -2.548944, 1.64539194,
        -1.40040898, -0.691646993, -0.104105994,
        -0.995024979, -2.49719095, 1.64254498,
        -1.25112903, -0.66515696, -0.178916991,
        -0.812789977, -2.54157591, 1.66948199,
        -1.04912996, -0.652593017, -0.0587879978,
        -0.56873697, -2.49724793, 1.69775999,
        -0.873098969, -0.618440986, -0.062199004,
        -2.19600296, 0.294333011, 1.93332601,
        -0.480854988, -2.57501698, 1.57399201,
        -0.726243019, -0.718713045, -0.0534510016,
        -2.0371139, 0.341952026, 1.99539006,
        -0.602583051, -0.602352023, -0.0819690004,
        -0.326117992, -2.65665007, 1.599015,
        -1.87385392, 0.40110898, 1.95744002,
        -0.441711009, -0.646824002, -0.117504001,
        -0.324491978, -0.679466963, 0.00561000034,
        -0.148766994, -2.68778419, 1.61404502,
        -0.161076009, -0.70460701, -0.0752249956,
        -0.0670439973, -2.53449297, 1.64287198,
        -0.0160680003, -0.703944027, 0.00815400016,
        0.100209005, -2.53859687, 1.60676098,
        0.136559993, -0.74377501, -0.0287370011,
        0.258572996, -2.50191903, 1.55622303,
        0.28836599, -0.724631965, -0.118898995,
        0.419367015, -2.54322004, 1.62788701,
        0.435182989, -0.684881985, -0.0612059981,
        0.589053035, -2.53631711, 1.58874297,
        0.625766993, -0.684414029, -0.14802599,
        0.751968026, -2.567976, 1.54849195,
        0.789018035, -0.633551955, -0.133083001,
        0.917856038, -2.53564501, 1.56445491,
        1.04044795, -2.47375202, 1.67314804,
        0.966156006, -0.640484989, -0.134117991,
        1.18930197, -2.52804613, 1.59383404,
        1.13296807, -0.675852001, -0.0846690014,
        1.27659607, -0.750360012, -0.0355979986,
        1.43203807, -0.70639801, -0.0449640006,
        1.58400297, -0.715707004, -0.110165998,
        1.749228, -0.745185018, -0.126902997,
        1.92050993, -0.680052042, -0.150324002,
        -2.34958196, 0.533393979, 1.94237995,
        -2.1887908, 0.466652989, 1.96876812,
        -2.01970816, 0.513651013, 1.95785999,
        -1.87405801, 0.558906019, 1.864398,
        -2.35982394, -0.579038978, -0.0710669979,
        -2.19635987, -0.518166006, -0.103277996,
        -1.99370098, -0.611612976, -0.0978330076,
        -1.82556295, -0.579855025, -0.107013002,
        -1.62614393, -2.34556484, 1.53766501,
        -1.69372511, -0.631695032, -0.217871994,
        -1.49540997, -2.34850192, 1.66399503,
        -1.551543, -0.44917202, -0.228762001,
        -1.30165505, -0.571035028, -0.0493410006,
        -1.34505606, -2.28617692, 1.59272695,
        -1.14896095, -0.520166993, -0.0700829998,
        -1.23473704, -2.397048, 1.67209804,
        -0.994724989, -0.507332981, -0.114551991,
        -1.049649, -2.32693505, 1.588485,
        -0.862611055, -0.453069001, -0.0212789997,
        -0.736299038, -2.37481499, 1.68651605,
        -0.70521903, -0.471807003, -0.107058004,
        -0.554853022, -2.353935, 1.60486507,
        -0.543927014, -0.456404984, -0.153363004,
        -0.43316102, -0.504182994, -0.0333569981,
        -0.375200987, -2.44094706, 1.59159303,
        -0.21392101, -2.43613195, 1.63598406,
        -0.257174999, -0.554001033, -0.078873001,
        -0.105474003, -0.557007015, 0.000477000023,
        0.0110609997, -2.38264799, 1.69882202,
        0.0448380001, -0.57497102, -0.0704339966,
        0.173973009, -2.40139794, 1.66312504,
        0.336156011, -2.38150501, 1.64909697,
        0.203558981, -0.593540967, -0.0102479998,
        0.492884994, -2.39321995, 1.58622301,
        0.334400982, -0.559710026, -0.111432001,
        -2.21582699, 0.650838017, 1.96727407,
        0.496068001, -0.589694977, -0.178040996,
        0.578580022, -2.42241597, 1.72844696,
        -2.05234194, 0.704129994, 1.91514897,
        0.720014989, -2.52852011, 1.72430098,
        0.70281899, -0.482877016, -0.0539069995,
        0.869213998, -2.43778205, 1.69945192,
        0.885674953, -0.502995014, -0.0758400038,
        1.06993496, -0.504894018, -0.107792996,
        0.973428011, -2.30194807, 1.66568089,
        1.21269298, -0.48920399, -0.0168810003,
        1.16501701, -2.35746908, 1.62538195,
        1.30406094, -0.605195999, -0.108851999,
        1.36522806, -0.548025012, 0.0404549986,
        1.62758696, -0.497354984, -0.0549210012,
        1.77453899, -0.570900023, -0.121569,
        -2.32032895, -0.396533966, -0.0800759941,
        -2.17889118, -0.341628015, -0.174239993,
        -1.99022102, -0.438062966, -0.0882389992,
        -1.82893205, -0.38628602, -0.116877005,
        -1.68479097, -0.480021, -0.126947999,
        -1.54627514, -0.395624995, -0.0627510026,
        -1.42401898, -0.341865003, -0.159908995,
        -0.537624002, -2.18179798, 1.64288402,
        -1.28864706, -0.404889017, -0.082773,
        -0.395604014, -2.27153707, 1.60874999,
        -0.276885003, -2.30096388, 1.71294904,
        -1.09915507, -0.389703035, -0.178994998,
        -0.102444001, -2.25100207, 1.66240501,
        -0.927539945, -0.363581985, -0.154311001,
        0.140160009, -2.2795949, 1.77164102,
        -0.764567971, -0.342608988, -0.188046008,
        0.282351017, -2.20905304, 1.69484401,
        0.420176983, -2.24364614, 1.60787392,
        0.573819041, -2.24806499, 1.68558908,
        -0.634164035, -0.329418004, -0.0697889999,
        0.732620955, -2.34506989, 1.75283098,
        -0.466466993, -0.336230993, -0.0597900003,
        -0.313109994, -0.393015027, -0.089387998,
        0.820937991, -2.22238803, 1.63686013,
        0.96925503, -2.14744186, 1.58513999,
        -0.148014009, -0.429939032, -0.109589994,
        1.11210907, -2.19261885, 1.658355,
        0.0189270005, -0.418887019, -0.134511009,
        0.179406002, -0.48863098, -0.137345999,
        0.365660995, -0.407754004, -0.0474810004,
        0.53905201, -0.436094999, -0.112155005,
        0.672342002, -0.320775002, -0.109923005,
        0.834441066, -0.338970006, -0.0684179962,
        1.00072801, -0.371762991, -0.0330630019,
        1.15852499, -0.353748024, -0.103629,
        1.35122705, -0.423525006, -0.0791160017,
        1.5065279, -0.38894701, -0.138965994,
        1.6749661, -0.365951985, -0.170742005,
        1.84320295, -0.399731994, -0.121065006,
        -2.25920391, -0.219729006, -0.0662249997,
        -2.09054708, -0.25337401, -0.0475049987,
        -0.271715999, -2.15296507, 1.63873208,
        -1.96214998, -0.278402984, -0.159705013,
        0.0215009991, -2.15653205, 1.73507702,
        -1.78057802, -0.230967015, -0.198897004,
        -1.61212492, -0.294638991, -0.171765,
        0.160652995, -2.093961, 1.66747189,
        -1.50314403, -0.196263, -0.0806910023,
        0.315452993, -2.05868101, 1.61577308,
        -1.35264301, -0.255167991, -0.0292290002,
        0.439755023, -2.128968, 1.72096801,
        -1.19339693, -0.269424021, -0.101645999,
        0.589083016, -2.05910707, 1.67294407,
        0.712074041, -2.16824698, 1.75314593,
        0.865116, -2.02218914, 1.57734597,
        -1.03001702, -0.241889983, -0.113345996,
        1.00751698, -1.98921597, 1.66383004,
        -0.925886989, -0.297654003, 0.00555900019,
        -0.782778025, -0.236442, -0.0584429987,
        1.16306996, -1.98165298, 1.59142792,
        -0.63934505, -0.171491995, -0.120917991,
        1.31700003, -2.06308508, 1.61365807,
        -0.354981005, -0.161742002, -0.0511649996,
        -0.192981005, -0.276740998, -0.0592950024,
        -0.0445739999, -0.200594991, -0.106304996,
        0.096183002, -0.287048995, -0.0710730031,
        0.252620995, -0.172347009, -0.104240999,
        0.392688006, -0.275714993, -0.152429998,
        0.521459997, -0.284294993, -0.0461400002,
        0.622326016, -0.156197995, -0.0951299965,
        0.793289959, -0.174396008, -0.103823997,
        0.954326987, -0.255182981, -0.147287995,
        1.11167705, -0.222308993, -0.193259999,
        1.23716104, -0.200163007, -0.0819030032,
        1.39609206, -0.255926996, -0.100782007,
        1.56200409, -0.234449983, -0.102051005,
        1.73633099, -0.212402999, -0.113255993,
        -0.272292018, -1.98577785, 1.66934395,
        -0.125925004, -2.07878709, 1.6980269,
        -2.12957716, -0.112421997, -0.132060006,
        0.049575001, -1.95582294, 1.63940096,
        -1.970016, -0.131118, -0.0621509999,
        0.209223002, -1.92459905, 1.68872094,
        0.443072975, -1.96805692, 1.67155802,
        -1.81689, -0.0768930018, -0.118152,
        0.576638997, -1.88075399, 1.63294208,
        -1.675107, -0.167267993, -0.079020001,
        -1.57245004, -0.0441239998, -0.120213002,
        0.722060978, -1.97559309, 1.63027787,
        -1.40108395, -0.0656429976, -0.133680001,
        0.84432596, -1.83329093, 1.64717698,
        0.998261929, -1.84655106, 1.74931204,
        -1.2531991, -0.118035004, -0.0643379986,
        1.15306497, -1.84004402, 1.67947197,
        -1.08837903, -0.089982003, -0.0543750003,
        -0.917787015, -0.130308002, -0.0233880002,
        1.303002, -1.92232203, 1.72069502,
        -0.803081989, -0.0827040002, -0.143637002,
        1.43957996, -1.92759895, 1.60757113,
        -0.515694022, -0.0873539969, -0.0438180007,
        -0.370674014, 0.00383099983, -0.0723720044,
        -0.198893994, -0.120227993, -0.110457003,
        -0.0602250025, -0.0428729989, -0.170370013,
        0.0815249979, -0.122207999, -0.0203940012,
        0.140328005, -0.0427949987, -0.156654,
        0.308181018, -0.0233430006, -0.160247996,
        0.452603996, -0.124655999, -0.0991230011,
        0.669842958, 0.000230999984, -0.119994,
        0.84582901, -0.00141300005, -0.123836994,
        0.949106991, -0.120753005, -0.0560160019,
        1.15667999, -0.0633089989, -0.186003,
        1.28726995, -0.0219930001, -0.093497999,
        1.44393301, -0.0872040018, -0.120992996,
        1.62287402, -0.0785219967, -0.149903998,
        -0.257124007, -1.81385994, 1.69433105,
        -0.117968991, -1.91095495, 1.65684593,
        -0.0135239996, -1.78731608, 1.62937212,
        0.253104001, -1.76301003, 1.59894598,
        0.408123016, -1.8256979, 1.58164501,
        0.533864975, -1.71815991, 1.61477101,
        0.691248, -1.75909495, 1.62227404,
        0.798735023, -1.67879999, 1.72005892,
        0.959589005, -1.68521094, 1.77319193,
        -2.03026509, 0.0369689986, -0.126975,
        1.24254894, -1.70502901, 1.61477709,
        -1.87762809, 0.103661999, -0.0790650025,
        1.40943897, -1.76205587, 1.67406607,
        -1.71012306, 0.0585839972, -0.0978270024,
        1.54272294, -1.79007304, 1.56285906,
        -1.52415013, 0.097574994, -0.187884003,
        -1.41982794, 0.091659002, -0.0642540008,
        -1.26275396, 0.0544140041, -0.0785909966,
        -1.10380507, 0.0888149962, -0.0954150036,
        -0.946520984, 0.131981999, -0.0672210008,
        -0.795266986, 0.0740730017, -0.0893820003,
        -0.582530975, 0.141516, -0.105558001,
        -0.433754981, 0.198101997, -0.0358229987,
        -0.287054986, 0.171209991, -0.118331999,
        -0.112938002, 0.116789997, -0.164634004,
        0.0279209986, 0.0580019988, -0.0731370002,
        0.187568992, 0.114156, -0.104846999,
        0.335678995, 0.142022997, -0.201983988,
        0.466547996, 0.0236460008, -0.188801989,
        0.575949013, 0.13972801, -0.122237995,
        0.751541972, 0.138512999, -0.0624030009,
        1.02085495, 0.0193409994, -0.0958949924,
        1.16761506, 0.0974249989, -0.126929998,
        1.41366899, 0.0783929974, -0.175058991,
        1.55827498, 0.0652769953, -0.0742800012,
        -0.306432009, -1.64731801, 1.682073,
        -0.149094, -1.68115807, 1.61823606,
        0.00181200006, -1.64258409, 1.53740394,
        0.150747001, -1.62964487, 1.62338996,
        0.379307985, -1.67245495, 1.65571213,
        0.481601983, -1.56605709, 1.58215809,
        -2.16097808, 0.208359003, -0.105027005,
        0.661365032, -1.59499788, 1.64510107,
        -1.99538708, 0.212877005, -0.158105999,
        0.820347011, -1.54510498, 1.5967021,
        -1.82459402, 0.241443008, -0.165233999,
        -1.70986497, 0.224916011, -0.0443249978,
        0.979830027, -1.54811406, 1.66418695,
        -1.55560505, 0.246909007, -0.112116002,
        1.174317, -1.56292498, 1.69647896,
        -1.3563211, 0.231660008, -0.138026997,
        1.34955299, -1.59759593, 1.69853687,
        -1.19203794, 0.220310986, -0.159507006,
        1.51143599, -1.6233449, 1.61623502,
        -1.03127694, 0.265763998, -0.127959013,
        -0.869814038, 0.298524022, -0.0620459989,
        -0.717173994, 0.220530003, -0.0545639992,
        -0.55538702, 0.309588015, -0.127101004,
        -0.39073801, 0.355544984, -0.0480959974,
        -0.24594, 0.333081007, -0.143886,
        -0.0986940041, 0.277337998, -0.207432002,
        0.0419970006, 0.217355996, -0.124476001,
        0.203637004, 0.24742499, -0.205841988,
        0.375759006, 0.31149599, -0.269877017,
        0.509343028, 0.299594998, -0.156104997,
        0.699407995, 0.218004003, -0.205208987,
        0.861092985, 0.238440007, -0.148752004,
        1.02134705, 0.188778013, -0.123573005,
        1.15325093, 0.249228001, -0.0208919998,
        1.322142, 0.221607, -0.119462997,
        -0.400920033, -1.523646, 1.58988905,
        -0.238664985, -1.50199199, 1.63187099,
        -0.0701490045, -1.50448203, 1.60677004,
        0.0740640014, -1.49371195, 1.69172692,
        0.207852006, -1.46577001, 1.60035586,
        0.349901974, -1.50192904, 1.66836905,
        0.477996022, -1.408512, 1.62552285,
        0.613655984, -1.47523201, 1.53732896,
        0.769155025, -1.38581991, 1.64677799,
        0.925632, -1.40169299, 1.57341909,
        -2.09475613, 0.370545, -0.134754002,
        1.08659697, -1.42231202, 1.62930298,
        1.26855302, -1.46417403, 1.59558606,
        1.43649006, -1.45646703, 1.64262009,
        -1.92288601, 0.386040032, -0.164372995,
        -1.81212294, 0.363830984, -0.0342629999,
        -1.68441606, 0.347691, -0.166817993,
        -1.45818591, 0.385713011, -0.133235991,
        -1.285653, 0.387144029, -0.178185001,
        -1.10989499, 0.413381994, -0.195767999,
        -0.931748986, 0.388743013, -0.204108,
        -0.854570985, 0.467123985, -0.065595001,
        -0.695562005, 0.395081997, -0.0599370003,
        -0.0848309994, 0.387528002, -0.0751110017,
        0.0806280002, 0.387125999, -0.141180009,
        0.243840009, 0.416163027, -0.205511987,
        0.404048979, 0.446000993, -0.140055001,
        0.57731998, 0.458315969, -0.123465002,
        0.74495399, 0.492276013, -0.0927660018,
        0.892853975, 0.409178972, -0.148001999,
        1.06494594, 0.366845995, -0.107219994,
        -1.33581901, -1.27180207, 1.616961,
        -1.166538, -1.30473304, 1.61143792,
        -0.992642999, -1.337901, 1.61655593,
        -0.443274021, -1.35341704, 1.63289094,
        -0.29697001, -1.37588096, 1.54089296,
        -0.157503009, -1.35341394, 1.63790393,
        0.00586199993, -1.35153902, 1.56961799,
        0.133793995, -1.33585203, 1.68087602,
        0.310730994, -1.33094096, 1.67102098,
        0.432978004, -1.26665103, 1.56430793,
        0.604521036, -1.31286299, 1.57824302,
        0.748100996, -1.24648798, 1.54595399,
        1.02561605, -1.25216699, 1.56439805,
        1.18917894, -1.31220901, 1.56274199,
        1.34879696, -1.31217301, 1.61024094,
        1.51597786, -1.29442203, 1.65092087,
        -2.02587295, 0.531183004, -0.164669991,
        -1.93856096, 0.482739031, -0.0175140016,
        -1.78384209, 0.493337989, -0.166368008,
        -1.60550404, 0.501260996, -0.136997998,
        -1.66028094, -1.13817, 1.61824799,
        -1.498137, -1.20539093, 1.63958395,
        -1.36633205, -1.10480094, 1.58063102,
        -1.21960497, -1.14261293, 1.66977906,
        -1.06131303, -1.17026401, 1.59625506,
        -0.885834038, -1.18257296, 1.62277198,
        -0.384155989, -1.08066607, 1.616238,
        -2.07769513, 0.697118998, -0.132207006,
        -0.258960009, -1.21989, 1.59226799,
        -1.88636088, 0.643620014, -0.16731301,
        -0.0953460038, -1.18227303, 1.65255594,
        -1.70625591, 0.652716041, -0.159359992,
        0.0689729974, -1.19683504, 1.60250092,
        -1.53953397, 0.66841495, -0.106310993,
        0.209813982, -1.192101, 1.70463586,
        0.371408999, -1.14980102, 1.66535997,
        0.548117995, -1.17557693, 1.65363002,
        0.67317301, -1.09368896, 1.57570505,
        0.823706985, -1.10493302, 1.64283299,
        0.990056992, -1.12297499, 1.67612708,
        1.139346, -1.11526203, 1.58763909,
        1.28516102, -1.16154909, 1.66834795,
        1.43925595, -1.16246998, 1.74485397,
        1.59904504, -1.13908803, 1.62202799,
        -2.0981102, 0.869352043, -0.0899280012,
        -1.940238, 0.811442971, -0.138668999,
        -1.76582408, 0.819938958, -0.138689995,
        -1.59499788, 0.834540009, -0.102341995,
        -1.78949094, -1.02336597, 1.64484894,
        -1.65230107, -0.91109097, 1.68366003,
        -1.52007902, -1.02821398, 1.64210391,
        -1.35461402, -0.981329978, 1.70137787,
        -1.17314696, -0.974858999, 1.69901705,
        -1.01911199, -1.00458598, 1.62066293,
        -0.84077704, -1.001055, 1.64895594,
        -0.654218972, -0.946269035, 1.59862196,
        -0.507189035, -0.985668004, 1.70520008,
        -0.366981, -0.905207992, 1.62900305,
        -0.214752004, -1.05828607, 1.62574804,
        -0.0484500006, -1.01134205, 1.63786805,
        0.0855059996, -1.07440805, 1.72355103,
        0.247163996, -1.03076398, 1.70724607,
        0.440910012, -0.898358941, 1.55884802,
        0.576969028, -0.971346021, 1.7018249,
        0.752606988, -0.95233202, 1.63896012,
        0.904919982, -0.97102499, 1.71309292,
        1.04956508, -0.970710039, 1.63711202,
        1.19374204, -0.948828042, 1.56339002,
        1.34076297, -0.959559023, 1.63997698,
        1.49634302, -1.00707304, 1.68986702,
        1.6434691, -0.968429983, 1.59247506,
        -2.16839099, 1.026021, -0.0503339991,
        -1.95485401, 0.993434966, -0.150767997,
        -1.76820612, 1.00054801, -0.131807998,
        -1.819839, -0.850244999, 1.66311002,
        -1.69398594, -0.818201959, 1.54226112,
        -1.48296893, -0.859625995, 1.67517006,
        -1.40033698, -0.775029063, 1.54564214,
        -1.2687, -0.844617009, 1.63407302,
        -1.06922102, -0.836763024, 1.6584239,
        -0.786432028, -0.834366024, 1.64355898,
        -0.617708981, -0.787499964, 1.6704421,
        -0.452165991, -0.761462927, 1.62793207,
        -0.284346014, -0.762012005, 1.57866597,
        -0.198576003, -0.89388001, 1.65696895,
        -0.0368429981, -0.841035008, 1.67747688,
        0.118565999, -0.909996033, 1.67037296,
        0.263016015, -0.83454299, 1.62596405,
        0.395705998, -0.745362043, 1.58049297,
        0.514878035, -0.817664981, 1.68359709,
        0.674960971, -0.777324021, 1.68235195,
        0.77401495, -0.805679977, 1.54788601,
        0.949815035, -0.834335983, 1.58166313,
        1.13932204, -0.832436979, 1.67664289,
        1.30140007, -0.796043992, 1.62784505,
        1.46851206, -0.847082973, 1.62669587,
        1.63101602, -0.789884984, 1.60727406,
        -2.13950682, 1.18332005, -0.130430996,
        -1.87245297, 1.15603197, -0.200825989,
        -1.66275311, 1.150437, -0.122676,
        -1.83149409, -0.644610047, 1.61492991,
        -1.68858314, -0.738332987, 1.69811404,
        -1.556427, -0.715656042, 1.58907294,
        -1.422732, -0.695168972, 1.69998908,
        -1.250247, -0.675902963, 1.67068195,
        -1.07952297, -0.661109984, 1.64185202,
        -0.912606001, -0.71765697, 1.6151371,
        -0.741891026, -0.663233995, 1.67351997,
        -0.539973021, -0.622536004, 1.69599903,
        -0.410466015, -0.602169037, 1.59237909,
        -0.159015, -0.727514982, 1.68741012,
        -0.0179550014, -0.702030003, 1.588323,
        0.123284996, -0.736739993, 1.66798496,
        0.274935007, -0.659397006, 1.66334105,
        0.498467982, -0.651239991, 1.66737306,
        0.610607982, -0.545313001, 1.716645,
        0.707666993, -0.636102021, 1.60077596,
        0.876567006, -0.673083007, 1.62415802,
        1.02970195, -0.690245986, 1.53516603,
        1.18024504, -0.679164052, 1.61477995,
        1.33996797, -0.632930994, 1.58316898,
        1.49928904, -0.678884983, 1.6590631,
        -2.16586208, 1.35903001, -0.111719996,
        -2.00303102, 1.29715204, -0.17266199,
        -1.68980992, 1.36757994, -0.103734002,
        -1.67814302, -0.571482003, 1.64551806,
        -1.50683999, -0.549359977, 1.64493608,
        -1.35145199, -0.477822006, 1.61708093,
        -1.18198204, -0.51323998, 1.65215707,
        -1.01198399, -0.497273982, 1.61076593,
        -0.831393003, -0.526862979, 1.60985088,
        -0.660305977, -0.503019035, 1.65166497,
        -0.489677966, -0.461907029, 1.64008498,
        -0.319265991, -0.458733022, 1.67677796,
        -0.256590009, -0.607805967, 1.63383007,
        -0.10035, -0.569349051, 1.64664912,
        0.0650340021, -0.568650007, 1.63975501,
        0.22101599, -0.500144958, 1.63248897,
        0.382227004, -0.584645987, 1.55328608,
        0.511376977, -0.493454993, 1.58369994,
        0.679553986, -0.472359002, 1.57718396,
        0.825177073, -0.513674974, 1.66549492,
        0.97578001, -0.529530048, 1.53399587,
        1.18349397, -0.514064968, 1.59780598,
        1.32581699, -0.497504979, 1.69965601,
        1.47150302, -0.51177001, 1.60082996,
        -2.14298105, 1.53647399, -0.115878001,
        -1.93925107, 1.46660995, -0.134369999,
        -1.77191114, 1.53566694, -0.142430991,
        -1.00199997, 1.42084205, -0.125109002,
        -0.82149601, 1.398615, -0.132090002,
        -0.645801008, 1.44614697, -0.148047,
        -1.61211598, -0.409094989, 1.61778295,
        -1.43850899, -0.325707018, 1.59007812,
        -0.576170981, -0.324285001, 1.58846688,
        -0.388154984, -0.311141998, 1.61242795,
        -0.209693998, -0.327168018, 1.64149499,
        -0.0567749999, -0.408374995, 1.66911006,
        0.0786540061, -0.414813012, 1.56227994,
        0.200286001, -0.326678991, 1.64782798,
        0.361886978, -0.398292005, 1.60581899,
        0.536927998, -0.327519, 1.58653498,
        0.695526004, -0.33048901, 1.67745602,
        0.884894967, -0.378893971, 1.57256389,
        1.06226397, -0.391362011, 1.58994591,
        1.208799, -0.367151976, 1.69165206,
        1.35918593, -0.356904, 1.59345603,
        -1.98945594, 1.62515402, -0.0631259978,
        -1.14452994, 1.5373981, -0.122400001,
        -0.978258014, 1.60255504, -0.14745,
        -0.802674055, 1.57845604, -0.101781003,
        -0.623049021, 1.61108708, -0.0732930005,
        -0.480645001, 1.53212392, -0.159258008,
        -0.328184992, 1.53231597, -0.0539490022,
        -0.175329, 1.640064, -0.0630030036,
        -0.300471008, -0.164991006, 1.56594908,
        -0.119618997, -0.182837993, 1.59171903,
        0.0316049978, -0.264297009, 1.64382899,
        0.229427993, -0.15339601, 1.64805603,
        0.388487995, -0.237111002, 1.66936803,
        0.63429898, -0.188726991, 1.59569097,
        0.808112979, -0.219827995, 1.59572387,
        0.975080967, -0.239816993, 1.64110494,
        1.14870906, -0.227364004, 1.60075498,
        -1.13649607, 1.81005299, -0.100317001,
        -0.998384953, 1.771065, -0.21629101,
        -0.838829994, 1.80531597, -0.133865997,
        -2.25601792, -0.0808830038, 1.61590195,
        -0.676892996, 1.74027908, -0.188228995,
        -2.08013105, -0.0896460041, 1.63776004,
        -0.516170979, 1.75694704, -0.04899,
        -0.33612901, 1.727988, -0.050160002,
        0.0592890009, -0.0958169997, 1.607301,
        0.211374015, 0.00934499968, 1.58001602,
        0.460950017, -0.0489239991, 1.61223602,
        0.636195004, -0.0181649998, 1.576002,
        -0.980966985, 1.96929896, -0.176862001,
        -0.757335067, 1.9947691, -0.128559008,
        -0.634622991, 1.89548707, -0.0378209986,
        -2.57185507, 0.0750420019, 1.66557288,
        -2.43476701, -0.0390449986, 1.62749398,
        -2.35943699, 0.142004997, 1.62619793,
        -2.12671208, 0.0746940002, 1.65544486,
        -1.95962405, 0.0255570002, 1.69811106,
        -1.78622699, 0.0587850027, 1.70911813,
        -0.875295043, 2.12787008, -0.0799859986,
        -0.574268997, 2.06437802, -0.0819839984,
        -2.68322396, 0.201944992, 1.61202598,
        -2.5110178, 0.230865002, 1.60821295,
        -2.38333201, 0.303993016, 1.69360793,
        -2.22392392, 0.198458999, 1.71775794,
        -2.01615906, 0.198887989, 1.61680806,
        -1.83792007, 0.218289018, 1.61474097,
        -1.67543101, 0.16302, 1.60621214,
        -0.718115985, 2.22608709, -0.0773610026,
        -2.67718506, 0.376092017, 1.64045691,
        -0.540315032, 2.23766398, -0.0250350013,
        -2.48463011, 0.413103014, 1.61348414,
        -2.32380295, 0.46311903, 1.66268396,
        -2.23615503, 0.329235017, 1.60701907,
        -2.09238005, 0.322044015, 1.69618797,
        -1.94115591, 0.356463015, 1.61993694,
        -1.72727108, 0.342477024, 1.65780902,
        -1.57182288, 0.335049003, 1.57209301,
        -2.60177088, 0.535748959, 1.65964794,
        -2.4446578, 0.580853999, 1.61575806,
        -2.20963788, 0.645936012, 1.63852501,
        -2.15116215, 0.477680981, 1.65451205,
        -1.81426191, 0.470892012, 1.57725298,
        -1.64461505, 0.489051014, 1.61257195,
        -2.51377201, 0.68560797, 1.74363899,
        -2.3686018, 0.734511018, 1.634781,
        -2.1359849, 0.806913018, 1.63342202,
        -2.03800488, 0.604101002, 1.62575698,
        -1.870821, 0.62865901, 1.5954299,
        -1.66606498, 0.644273996, 1.53335404,
        -2.54446793, 0.802757978, 1.61751294,
        -2.45073891, 0.948354006, 1.64218497,
        -2.28735304, 0.888320982, 1.65597606,
        -1.96040404, 0.775581002, 1.59500992,
        -1.76886296, 0.768950939, 1.60568714,
        -2.36316299, 1.08692396, 1.58004606,
        -2.14850712, 1.00868106, 1.60120487,
        -1.98332095, 0.947240949, 1.60121107,
        -1.81080604, 0.933404982, 1.64965487,
        -2.21342087, 1.17699003, 1.59925497,
        -2.04835486, 1.15671599, 1.65011394,
        -1.88642406, 1.09164298, 1.64730597
    };
    std::memcpy(bunny.data(), buff, sizeof(buff));
    return bunny;
}
