// Copyright 2016 Kitware, Inc.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

extern crate chrono;
use self::chrono::{DateTime, UTC};

extern crate gitlab;
use self::gitlab::webhooks::*;

extern crate kitware_git;
use self::kitware_git::{CommitId, Identity};

extern crate kitware_workflow;
use self::kitware_workflow::host::{HostedCommit, HostedMergeRequest};

use super::super::super::common::traits::*;

pub struct GitlabPush {
}

impl GitlabPush {
    pub fn new(attrs: PushHook) -> Self {
        unimplemented!()
    }
}

impl PushInfo for GitlabPush {
    fn as_hosted(&self) -> &HostedCommit {
        unimplemented!()
    }

    fn project(&self) -> &ProjectInfo {
        unimplemented!()
    }

    fn author(&self) -> &Identity {
        unimplemented!()
    }

    fn refname(&self) -> &str {
        unimplemented!()
    }

    fn date(&self) -> &DateTime<UTC> {
        unimplemented!()
    }
}

pub struct GitlabMergeRequest {
}

impl GitlabMergeRequest {
    pub fn new(attrs: MergeRequestHookAttrs) -> Self {
        unimplemented!()
    }
}

impl MergeRequestInfo for GitlabMergeRequest {
    fn as_hosted(&self) -> &HostedMergeRequest {
        unimplemented!()
    }

    fn is_open(&self) -> bool {
        unimplemented!()
    }

    fn id(&self) -> u64 {
        unimplemented!()
    }

    fn check_status(&self) -> CheckStatus {
        unimplemented!()
    }

    fn author(&self) -> &Identity {
        unimplemented!()
    }

    fn author_access(&self) -> u64 {
        unimplemented!()
    }

    fn source_project(&self) -> &ProjectInfo {
        unimplemented!()
    }

    fn source_branch(&self) -> &str {
        unimplemented!()
    }

    fn source_branch_oldsha(&self) -> &Option<CommitId> {
        unimplemented!()
    }

    fn source_branch_sha(&self) -> &CommitId {
        unimplemented!()
    }

    fn date(&self) -> &DateTime<UTC> {
        unimplemented!()
    }

    fn target_project(&self) -> &ProjectInfo {
        unimplemented!()
    }

    fn target_branch(&self) -> &str {
        unimplemented!()
    }
}

pub struct GitlabNote {
    content: String,
    created_at: DateTime<UTC>,
    author: Identity,
    username: String,
    author_access: u64,
}

impl GitlabNote {
    pub fn new(attrs: NoteHookAttrs) -> Self {
        unimplemented!()
    }
}

impl NoteInfo for GitlabNote {
    fn content(&self) -> &str {
        &self.content
    }

    fn date(&self) -> &DateTime<UTC> {
        &self.created_at
    }

    fn author(&self) -> &Identity {
        &self.author
    }

    fn username(&self) -> &str {
        &self.username
    }

    fn author_access(&self) -> u64 {
        self.author_access
    }
}

pub struct GitlabMergeRequestNote {
    mr: GitlabMergeRequest,
    note: GitlabNote,
}

impl GitlabMergeRequestNote {
    pub fn new(mr_attrs: MergeRequestHookAttrs, note_attrs: NoteHookAttrs) -> Self {
        GitlabMergeRequestNote {
            mr: GitlabMergeRequest::new(mr_attrs),
            note: GitlabNote::new(note_attrs),
        }
    }
}

impl MergeRequestNoteInfo for GitlabMergeRequestNote {
    fn merge_request(&self) -> &MergeRequestInfo {
        &self.mr
    }

    fn note(&self) -> &NoteInfo {
        &self.note
    }
}
