// Copyright 2016 Kitware, Inc.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

extern crate gitlab;
use self::gitlab::Gitlab;

extern crate json_job_dispatch;
use self::json_job_dispatch::Handler;

extern crate kitware_workflow;
use self::kitware_workflow::host::{GitlabService, HostingService};

extern crate serde_json;
use self::serde_json::Value;

use super::super::super::config::Host;

use std::rc::Rc;
use std::error::Error;

pub fn connect_to_host(url: &Option<String>, secrets: Value)
                       -> Result<Rc<HostingService>, Box<Error>> {
    let host = url.as_ref().map_or("gitlab.com", |u| u.as_str());
    let token = match secrets.pointer("/token").and_then(|t| t.as_string()) {
        Some(t) => t,
        None => return Err(unimplemented!()),
    };

    Ok(try!(Gitlab::new(host, token)
        .map(GitlabService::new)
        .map(|service| Rc::new(service) as Rc<HostingService>)))
}

pub fn create_handler(host: Host, name: &str) -> Result<Box<Handler>, Box<Error>> {
    unimplemented!()
}
