// Copyright 2016 Kitware, Inc.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

macro_rules! enum_serialize {
    ( $name:ident -> $desc:expr, $( $value:ident => $str:expr, )+ ) => {
        impl Deserialize for $name {
            fn deserialize<D: Deserializer>(deserializer: &mut D) -> Result<Self, D::Error> {
                let val = try!(String::deserialize(deserializer));

                match val.as_str() {
                    $( $str => Ok($name::$value), )*
                    _ => {
                        Err(D::Error::invalid_value(concat!("invalid ", $desc)))
                    },
                }
            }
        }
    };
}
