if (superbuild_is_64bit)
  set(tbb_archdir intel64)
else ()
  set(tbb_archdir ia32)
endif ()

if (MSVC10)
  set(tbb_vsdir vc10)
elseif (MSVC11)
  set(tbb_vsdir vc11)
elseif (MSVC12)
  set(tbb_vsdir vc12)
else ()
  message(FATAL_ERROR "tbb does not support your Visual Studio compiler; please use a system version.")
endif ()

set(tbb_libdir lib/${tbb_archdir}/${tbb_vsdir})
include(tbb.common)
