set(matplotlib_deps)
set(matplotlib_optional_deps)

# This logic is necessary to make the modules required on Windows since the
# prebuilt package assumes that these features are enabled.
set(matplotlib_deps_var)
if (WIN32)
  set(matplotlib_deps_var matplotlib_deps)
else ()
  set(matplotlib_deps_var matplotlib_optional_deps)
endif ()

list(APPEND "${matplotlib_deps_var}"
  pythondateutil
  pytz)

superbuild_add_project_python(matplotlib
  numpy png freetype zlib ${matplotlib_deps} pythonsetuptools
  DEPENDS_OPTIONAL cxx11 ${matplotlib_optional_deps}
  CAN_USE_SYSTEM)

superbuild_project_add_step(configure-setup.cfg
  COMMAND   "${CMAKE_COMMAND}"
            "-Dpatches_location:PATH=${CMAKE_CURRENT_LIST_DIR}/patches"
            "-Dsource_location:PATH=<SOURCE_DIR>"
            "-Dinstall_location:PATH=<INSTALL_DIR>"
            -P "${CMAKE_CURRENT_LIST_DIR}/scripts/matplotlib.patch.cmake"
  DEPENDEES configure
  DEPENDERS install
  COMMENT   ""
  WORKING_DIRECTORY <SOURCE_DIR>)
