include(RunCMake)

function (ln target source)
  execute_process(
    COMMAND "${CMAKE_COMMAND}" -E create_symlink
            "${target}"
            "${source}"
    OUTPUT_VARIABLE out
    ERROR_VARIABLE  err
    RESULT_VARIABLE res)

  if (res)
    message(FATAL_ERROR
      "Failed to create a symlink from ${source} -> ${target}: ${err}.")
  endif ()
endfunction ()

# This function assumes that ``${RunCMake_BINARY_DIR}/${name}/source`` and
# ``${RunCMake_BINARY_DIR}/${name}/binary`` are set up properly prior to
# calling it.
function (add_symlink_test name)
  # We can't have the infrastructure removing our tree with crafted symlinks.
  set(RunCMake_TEST_NO_CLEAN TRUE)

  configure_file(
    "${CMAKE_CURRENT_LIST_DIR}/CMakeLists.txt"
    "${RunCMake_BINARY_DIR}/${name}/source/CMakeLists.txt"
    COPYONLY)
  set(RunCMake_TEST_SOURCE_DIR "${RunCMake_BINARY_DIR}/${name}/source")
  set(RunCMake_TEST_BINARY_DIR "${RunCMake_BINARY_DIR}/${name}/binary")
  # Emulate a shell using this directory.
  set(ENV{PWD} "${RunCMake_TEST_BINARY_DIR}")
  set(RunCMake_TEST_OPTIONS
    "-Dinclude_dir:PATH=${CMAKE_CURRENT_LIST_DIR}")
  run_cmake("${name}_symlinks")
endfunction ()

# Create the following structure:
#
#   .../no/source
#   .../no/binary
#
# This is the base case.
file(MAKE_DIRECTORY "${RunCMake_BINARY_DIR}/no/source")
file(MAKE_DIRECTORY "${RunCMake_BINARY_DIR}/no/binary")
add_symlink_test(no)

# Create the following structure:
#
#   .../common_real/source
#   .../common_real/binary
#   .../common -> .../common_real
#
# In this case, CMake should act as if .../common *was* .../common_real for all
# computations except ``REALPATH``. This is necessary because the original use
# case for the translation map was to handle the case where a system would have
# a stable *symlink*, but not a stable target for that symlink. This usually
# occurs on supercomputers with a login node and home directories served over a
# network filesystem setup.
file(MAKE_DIRECTORY "${RunCMake_BINARY_DIR}/common_real/source")
ln("${RunCMake_BINARY_DIR}/common_real" "${RunCMake_BINARY_DIR}/common")
add_symlink_test(common)

# Create the following structure:
#
#   .../different_real/binary
#   .../different/source
#   .../different/binary -> .../different_real/binary
#
# In this case, CMake should use .../different_real/binary to compute paths.
file(MAKE_DIRECTORY "${RunCMake_BINARY_DIR}/different_real/binary")
file(MAKE_DIRECTORY "${RunCMake_BINARY_DIR}/different/source")
ln("${RunCMake_BINARY_DIR}/different_real/binary" "${RunCMake_BINARY_DIR}/different/binary")
add_symlink_test(different)

# Create the following structure:
#
#   .../sibling/source
#   .../sibling/binary_real
#   .../sibling/binary -> .../sibling/binary_real
#
# In this case, CMake should use .../sibling/binary_real to compute paths.
file(MAKE_DIRECTORY "${RunCMake_BINARY_DIR}/sibling/binary_real")
file(MAKE_DIRECTORY "${RunCMake_BINARY_DIR}/sibling/source")
ln("${RunCMake_BINARY_DIR}/sibling/binary_real" "${RunCMake_BINARY_DIR}/sibling/binary")
add_symlink_test(sibling)
