/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmCxxModuleDepfileParser_h
#define cmCxxModuleDepfileParser_h

#include <map>
#include <set>
#include <string>

struct cmSourceInfo
{
  // Set of provided and required modules.
  std::map<std::string, std::string> LogicalProvides;
  std::set<std::string> Provides;
  std::set<std::string> Requires;

  // Set of files included in the translation unit.
  std::set<std::string> Includes;
};

class cmCxxModuleDepfileParser {
public:
  static bool ParseGNU(std::string const& arg_pp, cmSourceInfo* info);
};

#endif
