/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmDepfileFormat_h
#define cmDepfileFormat_h

#include <map>
#include <string>
#include <vector>

struct cmSourceReqInfo {
  std::string Logical;
  std::string Filepath;
};

struct cmSourceInfo
{
  std::string PrimaryOutput;

  // Set of provided and required modules.
  std::vector<cmSourceReqInfo> Provides;
  std::vector<cmSourceReqInfo> Requires;

  // Set of files included in the translation unit.
  std::vector<std::string> Includes;
};

class cmDepfileFormat {
public:
  static bool ParseTrtbd(std::string const& arg_pp, cmSourceInfo* info);
  static bool WriteTrtbd(std::string const& path, std::string const& input, cmSourceInfo const& info);
};

#endif
