set(shared "${CMAKE_CURRENT_BINARY_DIR}/libshared${CMAKE_SHARED_LIBRARY_SUFFIX}")
set(module "${CMAKE_CURRENT_BINARY_DIR}/libmodule${CMAKE_SHARED_MODULE_SUFFIX}")
set(static "${CMAKE_CURRENT_BINARY_DIR}/libstatic${CMAKE_STATIC_LIBRARY_SUFFIX}")
set(import "${CMAKE_CURRENT_BINARY_DIR}/libimport${CMAKE_IMPORT_LIBRARY_SUFFIX}")
set(unknown "${CMAKE_CURRENT_BINARY_DIR}/libunknown.weird")

file(WRITE "${shared}" "")
file(WRITE "${module}" "")
file(WRITE "${static}" "")
file(WRITE "${import}" "")
file(WRITE "${unknown}" "")

include(CMakeDetectLibraryType)
cmake_detect_library_type(shared_detect PATH "${shared}")
cmake_detect_library_type(module_detect PATH "${module}")
cmake_detect_library_type(static_detect PATH "${static}")
cmake_detect_library_type(import_detect PATH "${import}")
cmake_detect_library_type(unknown_detect PATH "${unknown}")

# Modules and shared libraries cannot be discerned if they have the same
# extension as each other.
set(module_expected "MODULE")
if (CMAKE_SHARED_MODULE_SUFFIX STREQUAL CMAKE_SHARED_LIBRARY_SUFFIX)
  set(module_expected "SHARED")
endif ()

if (NOT shared_detect STREQUAL "SHARED")
  message(SEND_ERROR "failed to detect ${shared} as SHARED")
endif ()
if (NOT module_detect STREQUAL module_expected)
  message(SEND_ERROR "failed to detect ${module} as ${module_expected}")
endif ()
if (NOT static_detect STREQUAL "STATIC")
  message(SEND_ERROR "failed to detect ${static} as STATIC")
endif ()
if (CMAKE_IMPORT_LIBRARY_SUFFIX AND NOT import_detect STREQUAL "SHARED")
  message(SEND_ERROR "failed to detect ${import} as SHARED")
endif ()
if (NOT unknown_detect STREQUAL "UNKNOWN")
  message(SEND_ERROR "failed to detect ${unknown} as UNKNOWN")
endif ()
