include(Compiler/Clang)
__compiler_clang(C)

if(NOT CMAKE_C_COMPILER_VERSION VERSION_LESS 4.0)
  set(CMAKE_C90_STANDARD_COMPILE_OPTION "-std=c90")
  set(CMAKE_C90_EXTENSION_COMPILE_OPTION "-std=gnu90")

  set(CMAKE_C99_STANDARD_COMPILE_OPTION "-std=c99")
  set(CMAKE_C99_EXTENSION_COMPILE_OPTION "-std=gnu99")

  set(CMAKE_C11_STANDARD_COMPILE_OPTION "-std=c11")
  set(CMAKE_C11_EXTENSION_COMPILE_OPTION "-std=gnu11")
endif()

__compiler_check_default_language_standard(C 4.0 99)

macro(cmake_record_c_compile_features)
  set(_result 0)
  if (NOT CMAKE_C_COMPILER_VERSION VERSION_LESS 4.0)
    if (_result EQUAL 0)
      _record_compiler_features_c(11)
    endif()
    if (_result EQUAL 0)
      _record_compiler_features_c(99)
    endif()
    if (_result EQUAL 0)
      _record_compiler_features_c(90)
    endif()
  endif()
endmacro()
