set(variable "ON" CACHE BOOL "old docstring")

option(variable "new docstring" "OFF"
  TYPE STRING
  VALID_VALUES value1 value2
  ADVANCED
  DEFAULT)

get_property(value CACHE variable PROPERTY VALUE)
get_property(helpstring CACHE variable PROPERTY HELPSTRING)
get_property(type CACHE variable PROPERTY TYPE)
get_property(values CACHE variable PROPERTY VALUES)
get_property(advanced CACHE variable PROPERTY ADVANCED)
get_property(default CACHE variable PROPERTY DEFAULT)
get_property(defaulted CACHE variable PROPERTY DEFAULTED)

if (NOT value STREQUAL "ON")
  message(SEND_ERROR
    "'option' updated the value of an existing cache variable")
endif ()
if (NOT helpstring STREQUAL "new docstring")
  message(SEND_ERROR
    "'option' updated the helpstring of an existing typed cache variable")
endif ()
if (NOT type STREQUAL "STRING")
  message(SEND_ERROR
    "'option' updated the type of an existing typed cache variable")
endif ()
if (DEFINED values)
  message(SEND_ERROR
    "'option' updated the values of an existing typed cache variable")
endif ()
if (NOT advanced STREQUAL "ON")
  message(SEND_ERROR
    "'option' updated the advanced flag of an existing typed cache variable")
endif ()
if (NOT default STREQUAL "OFF")
  message(SEND_ERROR
    "'option' updated the default value of an existing typed cache variable")
endif ()
if (NOT defaulted STREQUAL "OFF")
  message(SEND_ERROR
    "'option' updated the defaulted value of an existing typed cache variable")
endif ()
