set(variable "ON" CACHE UNINITIALIZED "old docstring")

option(variable "new docstring" "OFF")

get_property(value CACHE variable PROPERTY VALUE)
get_property(helpstring CACHE variable PROPERTY HELPSTRING)
get_property(type CACHE variable PROPERTY TYPE)

if (NOT value STREQUAL "ON")
  message(SEND_ERROR
    "'option' updated the value of an existing cache variable")
endif ()
if (NOT helpstring STREQUAL "new docstring")
  message(SEND_ERROR
    "'option' did not update the helpstring of an existing uninitialized cache variable")
endif ()
if (NOT type STREQUAL "BOOL")
  message(SEND_ERROR
    "'option' did not update the type of an existing uninitialized cache variable")
endif ()
