include(RunCMake)

function(install_test test parallel install_arg)
  cmake_parse_arguments(ARGS "NINJA;TOUCH_CACHE" "VERIFY_SCRIPT" "" ${ARGN})
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${test}-install)
  set(RunCMake_TEST_OPTIONS -DINSTALL_PARALLEL=${parallel})
  set(RunCMake_TEST_OUTPUT_MERGE 1)
  if (NOT RunCMake_GENERATOR_IS_MULTI_CONFIG)
    list(APPEND RunCMake_TEST_OPTIONS -DCMAKE_BUILD_TYPE=Debug)
  endif()
  run_cmake(install)
  set(RunCMake_TEST_NO_CLEAN 1)
  if (ARGS_TOUCH_CACHE)
    run_cmake_command(${test}-touch
      ${CMAKE_COMMAND} -E touch ${RunCMake_TEST_BINARY_DIR}/CMakeFiles/cmake.check_cache)
  endif()
  if (ARGS_NINJA)
    run_cmake_command(${test}-install ${CMAKE_COMMAND} --build . --config Debug -t ${install_arg})
  else()
    run_cmake_command(${test}-install ${CMAKE_COMMAND} --install . -j ${install_arg})
  endif()
  set(RunCMake_TEST_COMMAND_WORKING_DIRECTORY ${RunCMake_SOURCE_DIR})
  if (ARGS_VERIFY_SCRIPT)
    run_cmake_command(${test}-verify-parallel
      ${CMAKE_COMMAND} -P ${ARGS_VERIFY_SCRIPT} ${RunCMake_TEST_BINARY_DIR}/.ninja_log)
endif()
endfunction()

install_test(parallel 1 4)
install_test(no-parallel 0 4)
install_test(out-of-date-json 1 4 TOUCH_CACHE)

if(RunCMake_GENERATOR MATCHES "Ninja")
  install_test(ninja-parallel 1 install/parallel VERIFY_SCRIPT check-parallel.cmake NINJA)
  install_test(ninja-no-parallel 0 install VERIFY_SCRIPT check-single.cmake NINJA)
endif()
