include(RunCMake)

################################################################################
# Test design:
#
# Since modifying `CMakeCache.txt` files is difficult from this side, each test
# first runs a `-prepare` test that does nothing (the `CMakeLists.txt` no-ops
# these tests). The cache manipulation to perform the actual test should occur
# in a `${name}-prepare.cmake` script.
#
# There is a `RunCMake_test_var` variable set up by the main project to work
# with. Its written value is `ON`.
################################################################################

function (run_cmake_cache_load name)
  set(RunCMake_TEST_SOURCE_DIR "${CMAKE_CURRENT_LIST_DIR}")
  set(RunCMake_TEST_BINARY_DIR "${RunCMake_BINARY_DIR}/${name}-build")

  run_cmake("${name}-prepare" -DRunCMake_preparation=1)
  include("${CMAKE_CURRENT_LIST_DIR}/${name}-prepare.cmake")
  run_cmake("${name}")
endfunction ()

run_cmake_cache_load(DefaultedProperty)
run_cmake_cache_load(DefaultedWithChange)
run_cmake_cache_load(DefaultedWithoutDefault)
run_cmake_cache_load(DefaultProperty)
run_cmake_cache_load(OnlyDefault)
run_cmake_cache_load(OnlyDefaulted)
