option(cache "docs" OFF)
set_property(CACHE cache PROPERTY DEFAULT "default")
set_property(CACHE cache PROPERTY VALUE "via_set")

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "via_set")
  message(FATAL_ERROR
    "The cache value should be updated when setting the 'VALUE' property")
endif ()

set_property(CACHE cache PROPERTY DEFAULTED "1")
set_property(CACHE cache PROPERTY DEFAULT "updated_default")

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "updated_default")
  message(FATAL_ERROR
    "The cache value should be updated to the new default when 'DEFAULTED'")
endif ()

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "updated_default")
  message(FATAL_ERROR
    "The cache value should be updated to the new default when 'DEFAULTED'")
endif ()

set_property(CACHE cache APPEND PROPERTY DEFAULT "appended")

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "updated_default;appended")
  message(FATAL_ERROR
    "The cache value should be updated to the new default when 'DEFAULTED'")
endif ()

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "updated_default;appended")
  message(FATAL_ERROR
    "The cache value should be updated to the new default when 'DEFAULTED'")
endif ()

set_property(CACHE cache APPEND_STRING PROPERTY DEFAULT "_by_string")

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "updated_default;appended_by_string")
  message(FATAL_ERROR
    "The cache value should be updated to the new default when 'DEFAULTED'")
endif ()

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "updated_default;appended_by_string")
  message(FATAL_ERROR
    "The cache value should be updated to the new default when 'DEFAULTED'")
endif ()

set_property(CACHE cache PROPERTY DEFAULT)

get_property(cache_value CACHE cache PROPERTY VALUE)
if (NOT cache_value STREQUAL "")
  message(FATAL_ERROR
    "The cache value should be empty")
endif ()

set(cache "local")

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "local")
  message(FATAL_ERROR
    "The cache value should be masked by a local variable")
endif ()
