option(cache "docs" OFF)
set_property(CACHE cache PROPERTY DEFAULT "default")
set_property(CACHE cache PROPERTY VALUE "via_set")

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "via_set")
  message(FATAL_ERROR
    "The cache value should be updated when setting the 'VALUE' property")
endif ()

set_property(CACHE cache PROPERTY DEFAULTED "0")
set_property(CACHE cache PROPERTY DEFAULT "updated_default")

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "via_set")
  message(FATAL_ERROR
    "The cache value should be preserved after setting the 'DEFAULTED' "
    "property to 'false'")
endif ()

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "via_set")
  message(FATAL_ERROR
    "The cache value should be preserved after setting the 'DEFAULTED' "
    "property to 'false'")
endif ()

set(cache "local")

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "local")
  message(FATAL_ERROR
    "The cache value should be masked by a local variable")
endif ()
