option(cache "docs" OFF)
set_property(CACHE cache PROPERTY DEFAULT "default")
set_property(CACHE cache PROPERTY DEFAULTED "1")

unset(cache CACHE)

if (DEFINED cache)
  message(FATAL_ERROR
    "A defaulted cache variable should be undefined after 'unset(CACHE)'")
endif ()

get_property(cache_value CACHE cache PROPERTY VALUE)
if (DEFINED cache_value)
  message(FATAL_ERROR
    "The cache value should be undefined")
endif ()

set(cache "local")

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "local")
  message(FATAL_ERROR
    "The cache value should be masked by a local variable")
endif ()
