option(cache "docs" OFF)
set_property(CACHE cache PROPERTY DEFAULT "default")
set_property(CACHE cache PROPERTY DEFAULTED "1")

set_property(CACHE cache APPEND_STRING PROPERTY VALUE "_string_appended")

get_property(is_defaulted CACHE cache PROPERTY DEFAULTED)
if (is_defaulted)
  message(FATAL_ERROR
    "The 'DEFAULTED' property should be unset after setting the value")
endif ()

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "default_string_appended")
  message(FATAL_ERROR
    "The cache value should the newly set value")
endif ()

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "default_string_appended")
  message(FATAL_ERROR
    "The cache value should the newly set value")
endif ()

set(cache "local")

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "local")
  message(FATAL_ERROR
    "The cache value should be masked by a local variable")
endif ()
