option(cache "docs" OFF)
set_property(CACHE cache PROPERTY DEFAULT "1")
set_property(CACHE cache PROPERTY DEFAULT "2")

get_property(default CACHE cache PROPERTY DEFAULT)
if (NOT default STREQUAL "2")
  message(FATAL_ERROR
    "The 'DEFAULT' property should be '2'")
endif ()

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "OFF")
  message(FATAL_ERROR
    "The cache value should be unchanged after setting the 'DEFAULT' property")
endif ()

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "OFF")
  message(FATAL_ERROR
    "The cache value should be unchanged after setting the 'DEFAULT' property")
endif ()

set(cache "local")

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "local")
  message(FATAL_ERROR
    "The cache value should be masked by a local variable")
endif ()
