option(cache "docs" OFF)
set_property(CACHE cache PROPERTY DEFAULT "1")
set_property(CACHE cache PROPERTY DEFAULT)

get_property(is_set CACHE cache PROPERTY DEFAULT SET)
if (is_set)
  message(FATAL_ERROR
    "The 'DEFAULT' property should be unset for new cache variables")
endif ()

set(cache_value "$CACHE{cache}")
if (NOT cache_value STREQUAL "OFF")
  message(FATAL_ERROR
    "The cache value should be unchanged after unsetting the 'DEFAULT' property")
endif ()

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "OFF")
  message(FATAL_ERROR
    "The cache value should be unchanged after unsetting the 'DEFAULT' property")
endif ()

set(cache "local")

set(cache_value "${cache}")
if (NOT cache_value STREQUAL "local")
  message(FATAL_ERROR
    "The cache value should be masked by a local variable")
endif ()
