<?xml version="1.0"?>
<SMTK_AttributeResource Version="3">

  <Definitions>

    <!-- Many types of anatomical relationships exist, but they all inherit a common base. -->
    <AttDef Type="relation" BaseType="">
    </AttDef>

    <!-- Inheritance (is-a) relations -->
    <AttDef Type="inheritance" BaseType="relation">
    </AttDef>

    <!-- Composition (has-a with possession) relations -->
    <AttDef Type="composition" BaseType="relation">
    </AttDef>

    <!-- Aggregation (has-a without possession; an aggreations of references) relations -->
    <AttDef Type="aggregation" BaseType="relation">
    </AttDef>

    <!-- Instantiation (token-type) relations -->
    <AttDef Type="instantiation" BaseType="relation">
    </AttDef>

    <!-- Geometric relations -->
    <AttDef Type="geometric" BaseType="relation">
    </AttDef>

    <!-- Geometric proximity -->
    <AttDef Type="proximal" BaseType="geometric">
    </AttDef>

    <!-- Geometric anchor (more than just proximal; non-empty shared boundary) -->
    <AttDef Type="attachment" BaseType="proximal">
    </AttDef>

    <!-- Mechanical adhesion (more than just geometric; shared boundary with a strength) -->
    <AttDef Type="adhesion" BaseType="attachment">
    </AttDef>

    <AttDef Type="surface adhesion" BaseType="adhesion">

      <AssociationsDef Name="surface" NumberOfRequiredValues="1" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="face"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

      <ItemDefinitions>
        <Double Name="yield strength">
          <BriefDescription>
              The maximum shear stress that may exist on the boundary before local failure.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Double>
      </ItemDefinitions>

    </AttDef>

    <AttDef Type="curve adhesion" BaseType="adhesion">

      <AssociationsDef Name="curve" NumberOfRequiredValues="1" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="edge"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

      <ItemDefinitions>
        <Double Name="yield strength">
          <BriefDescription>
              The maximum force per unit length that may exist on the boundary before local failure.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Double>
      </ItemDefinitions>

    </AttDef>

    <AttDef Type="point adhesion" BaseType="adhesion">

      <AssociationsDef Name="point" NumberOfRequiredValues="1" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="vertex"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

      <ItemDefinitions>
        <Double Name="yield strength">
          <BriefDescription>
              The maximum force that may exist on the attachment point before failure.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Double>
      </ItemDefinitions>

    </AttDef>


    <!-- Geometric contact (more than just proximal; non-empty shared boundary) -->
    <AttDef Type="contact" BaseType="proximal">
    </AttDef>

    <!-- Mechanical sliding contact (more than just geometric; shared boundary with stiction) -->
    <AttDef Type="sliding contact" BaseType="contact">

      <AssociationsDef Name="surface" NumberOfRequiredValues="1" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="face"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

      <ItemDefinitions>

        <Double Name="static friction coefficient">
          <BriefDescription>
              The static coefficient of friction.
              This is the ratio of tangential to normal stress above which sliding occurs.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

        <Double Name="dynamic friction coefficient">
          <BriefDescription>
              The dynamic coefficient of friction.
              This is the ratio of tangential to normal stress while sliding occurs.
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

      </ItemDefinitions>

    </AttDef>

  </Definitions>

</SMTK_AttributeResource>
