import sh
import os
import subprocess
from lxml import etree
from lxml.etree import tostring
from dateutil import parser
import datetime
import dateutil
import json
import coloredlogs, logging
import re
from hashlib import sha256

class BibManager:

	def __init__(self):
		self._srcPath = os.path.dirname(os.path.abspath(__file__))
		self._gitInstance = sh.git.bake(_cwd=self._srcPath)
	
	def _loggerInit(self):
		self._logger = logging.getLogger(__name__)
		coloredlogs.install(level='DEBUG')

	def _listCollections(self):
		collections = self._runCommand(['python3', '{}/bib_gen.py'.format(self._srcPath), '--list_collections'])
		collections = json.loads(collections)
		return collections

	def _runCommand(self, command):
		output = subprocess.check_output(command, cwd=self._srcPath, universal_newlines=True)
		return output

	def _needsToBeUpdated(self, name):
		if os.path.isfile('{}/../team/{}.html'.format(self._srcPath, name)):
			with open('{}/../team/{}.html'.format(self._srcPath, name)) as f:
				try:
					html = f.read()
					tree = etree.HTML(html)
					elements = tree.xpath('//ol[@class="kwbib"]')
					if len(elements) > 0:
						element = elements[0]
						ol = tostring(element)
						hashString = sha256(ol).hexdigest()
						print(hashString)
						print("\n")

						return False
					else:
						return True
				except Exception as e:
					return True
		else:
			return True

	def _updateHtml(self, name):
		with open('{}/../team/{}.html'.format(self._srcPath, name), 'w') as f:
			html = self._runCommand(['python3', '{}/bib_gen.py'.format(self._srcPath), '--html={}'.format(name)])
			f.write(html)
			self._logger.info('[{}] has been updated'.format(name))

	def _getGitBranch(self):
		branchOutput = str(self._gitInstance.branch())
		s = re.search(r'(?<=\* )[\S]+', branchOutput, flags=0)
		ansi_escape = re.compile(r'\x1B\[[0-?]*[ -/]*[@-~]')
		branch = str(s.group())
		branch = ansi_escape.sub('', branch)
		return branch

	def _gitInit(self):
		branch = self._getGitBranch()

		self._gitInstance.config("user.email", "riley.johnson@kitware.com")
		self._gitInstance.config("user.name", "riley.johnson")

		print(self._gitInstance.status())

		self._gitInstance.pull("origin {}".format(branch))

	def _updateCollections(self):
		collections = self._listCollections()
		for collection in collections:
			self._needsToBeUpdated(collection)
			

	def start(self):
		#self._gitInit()
		self._loggerInit()
		self._updateCollections()

bibManager = BibManager()

bibManager.start()