# this example shows how to enable arrays
import asyncio

from async_paraview.services import ParaT, PipelineBuilder, PropertyManager

from vtk.util.misc import vtkGetDataRoot
import os.path

async def get_information(App,proxy):
    pm = PropertyManager()
    di = proxy.GetDataInformation()
    if App.num_ranks() == 1:
        di = proxy.GetDataInformation()
    else:
        di = proxy.GetDataInformation()
        di = await pm.GatherInformation(proxy,root_only=False)
    return di


async def main():
    App = ParaT()
    session = await App.initialize()

    builder = PipelineBuilder(session)
    pm = PropertyManager()

    dataToLoad = os.path.join(vtkGetDataRoot(), "Testing/Data/cgns_np01/fluid.cgns")

    reader = await builder.CreateProxy(
        "sources",
        "CGNSSeriesReader",
        FileName=dataToLoad,
    )

    status = await pm.UpdateInformation(reader)
    status = await pm.UpdatePipeline(reader)
    print(pm.GetValues(reader))
    assert pm.GetValues(reader)["PointArrayInfo"] == ["Dof-Displacement", "0"]
    assert pm.GetValues(reader)["CellArrayInfo"] == ["Velocity", "0"]
    # enable array
    pm.SetValues(reader, CellArrayStatus=["Velocity", "1"], force_push=True)
    status = await pm.UpdateInformation(reader)
    status = await pm.UpdatePipeline(reader)
    # check that array is enabled
    assert pm.GetValues(reader)["CellArrayInfo"] == ["Velocity", "1"]
    # verify that the data is there
    info = await get_information(App, reader)
    assert info.GetPointDataInformation().GetNumberOfArrays() == 0
    assert info.GetCellDataInformation().GetNumberOfArrays() == 1
    assert info.GetCellDataInformation().GetArrayInformation(0).GetName() == "Velocity"
    assert (
        info.GetCellDataInformation().GetArrayInformation(0).GetNumberOfComponents()
        == 3
    )

    c2p = await builder.CreateProxy(
        "filters",
        "CellDataToPointData",
        Input=reader,
    )
    status = await pm.UpdatePipeline(c2p, 0)
    # verify that c2p has the proper arrays
    assert status
    info = await get_information(App,c2p)
    assert info.GetPointDataInformation().GetNumberOfArrays() == 1
    assert info.GetCellDataInformation().GetNumberOfArrays() == 0
    assert info.GetPointDataInformation().GetArrayInformation(0).GetName() == "Velocity"
    assert (
        info.GetPointDataInformation().GetArrayInformation(0).GetNumberOfComponents()
        == 3
    )

    tracer = await builder.CreateProxy(
        "filters",
        "StreamTracer",
        Input=c2p,
        SelectInputVectors=["", "", "", "0", "Velocity"],
        IntegrationDirection=2,
    )
    seeds = pm.GetValues(tracer)["Source"]
    pm.SetValues(
        seeds,
        Point1=[0, 0, 0],
        Point2=[0.03, 0.06, 0.01],
        Resolution=1000,
        force_push=True
    )
    await pm.UpdatePipeline(seeds)
    await pm.UpdatePipeline(tracer, 0)

    info = await get_information(App,tracer)
    assert info.GetNumberOfPoints() == 4466

    await App.close(session)


asyncio.run(main())
