cmake_minimum_required(VERSION 3.12)

# In order to use a new superbuild, please copy the item from the date stamped
# directory into the `keep` directory. This ensure that new versions will not
# be removed by the uploader script and preserve them for debugging in the
# future.

set(data_host "https://data.kitware.com")

# Determine the tarball to download.
# 20211110 — improved SMTK python bindings
if ("$ENV{CMAKE_CONFIGURATION}" MATCHES "vs2019")
  set(file_item "618b490e2fa25629b97c53bf")
  set(file_hash "f2ae30eb56565dc4b2a857707d3373944696e6297adf3fae4e8458bd06fef1b5eb701fa3ce80523e60815f9b26a703c62a820e06da0e350e6a374233a84c4620")
elseif ("$ENV{CMAKE_CONFIGURATION}" MATCHES "macos")
  set(file_item "618b3fe22fa25629b97bafee")
  set(file_hash "118f523e7997c9785643e5e2d6cc533fd8d7d20d4242cae9e957844bcdae2f3d7025ef2e24a7d92c554b8e230275afb69d2eef3ad426e1231dabd0a2a3271315")
else ()
  message(FATAL_ERROR
    "Unknown build to use for the superbuild")
endif ()

# Ensure we have a hash to verify.
if (NOT DEFINED file_item OR NOT DEFINED file_hash)
  message(FATAL_ERROR
    "Unknown file and hash for the superbuild")
endif ()

# Download the file.
file(DOWNLOAD
  "${data_host}/api/v1/item/${file_item}/download"
  ".gitlab/superbuild.tar.gz"
  STATUS download_status
  EXPECTED_HASH "SHA512=${file_hash}")

# Check the download status.
list(GET download_status 0 res)
if (res)
  list(GET download_status 1 err)
  message(FATAL_ERROR
    "Failed to download superbuild.tar.gz: ${err}")
endif ()

# Extract the file.
execute_process(
  COMMAND
    "${CMAKE_COMMAND}"
    -E tar
    xf ".gitlab/superbuild.tar.gz"
  RESULT_VARIABLE res
  ERROR_VARIABLE err
  ERROR_STRIP_TRAILING_WHITESPACE)
if (res)
  message(FATAL_ERROR
    "Failed to extract superbuild.tar.gz: ${err}")
endif ()
