/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseComponentGeometryNode;

public abstract class BaseLineSet
extends BaseComponentGeometryNode {
    protected static final int FIELD_VERTEXCOUNT = 11;
    private static final int LAST_VERTEXCOUNT_INDEX = 11;
    private static final int NUM_FIELDS = 12;
    private static final String BAD_COUNT_MSG = "Line count values less that 2 are not permitted. Offending value found at index: ";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int[] vfVertexCount = FieldConstants.EMPTY_MFINT32;
    protected int numVertexCount;

    protected BaseLineSet() {
        super("LineSet");
        this.hasChanged = new boolean[12];
    }

    protected BaseLineSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("vertexCount");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfVertexCount = new int[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfVertexCount, 0, vRMLFieldData.numElements);
                this.numVertexCount = vRMLFieldData.numElements;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean isLightingEnabled() {
        return false;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.intArrayValue = this.vfVertexCount;
                vRMLFieldData.dataType = (short)9;
                vRMLFieldData.numElements = this.numVertexCount;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        switch (n) {
            case 11: {
                vRMLNodeType.setValue(n2, this.vfVertexCount, this.numVertexCount);
                break;
            }
            default: {
                super.sendRoute(d, n, vRMLNodeType, n2);
            }
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 11: {
                this.setVertexCount(nArray, n2);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    protected void setVertexCount(int[] nArray, int n) throws InvalidFieldValueException {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 2) continue;
            throw new InvalidFieldValueException(BAD_COUNT_MSG + i);
        }
        if (this.vfVertexCount.length < n) {
            this.vfVertexCount = new int[n];
        }
        System.arraycopy(nArray, 0, this.vfVertexCount, 0, n);
        this.numVertexCount = n;
        if (!this.inSetup) {
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    static {
        nodeFields = new int[]{1, 2, 0};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(36);
        BaseLineSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseLineSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseLineSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseLineSet.fieldDecl[11] = new VRMLFieldDeclaration(3, "MFInt32", "vertexCount");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(1);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(11);
        fieldMap.put("vertexCount", n);
        fieldMap.put("set_vertexCount", n);
        fieldMap.put("vertexCount_changed", n);
    }
}

