/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.hanim;

import java.util.HashMap;
import org.j3d.geom.hanim.HAnimFactory;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.geom.hanim.HAnimSite;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLHAnimNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;

public abstract class BaseHAnimSite
extends BaseGroupingNode
implements VRMLHAnimNodeType {
    protected static final int FIELD_CENTER = 6;
    protected static final int FIELD_ROTATION = 7;
    protected static final int FIELD_SCALE = 8;
    protected static final int FIELD_SCALE_ORIENTATION = 9;
    protected static final int FIELD_TRANSLATION = 10;
    protected static final int FIELD_NAME = 11;
    protected static final int LAST_SITE_INDEX = 11;
    protected static final int NUM_FIELDS = 12;
    private static final float ZEROEPS = 1.0E-4f;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfCenter;
    protected float[] vfRotation;
    protected float[] vfScale;
    protected float[] vfScaleOrientation;
    protected float[] vfTranslation;
    protected String vfName;
    protected HAnimSite hanimImpl;
    protected HAnimFactory hanimFactory;

    public BaseHAnimSite() {
        super("HAnimSite");
        this.hasChanged = new boolean[12];
        this.vfCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfRotation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfScale = new float[]{1.0f, 1.0f, 1.0f};
        this.vfScaleOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfTranslation = new float[]{0.0f, 0.0f, 0.0f};
    }

    public BaseHAnimSite(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("rotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRotation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfRotation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfRotation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfRotation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("scale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScale[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScale[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScale[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("scaleOrientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScaleOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScaleOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScaleOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfScaleOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("translation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTranslation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfTranslation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfTranslation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("name");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setHAnimFactory(HAnimFactory hAnimFactory) {
        this.hanimFactory = hAnimFactory;
        this.hanimImpl = hAnimFactory.createSite();
        this.hanimImpl.setName(this.vfName);
        this.hanimImpl.setCenter(this.vfCenter);
        this.hanimImpl.setScale(this.vfScale);
        this.hanimImpl.setRotation(this.vfRotation);
        this.hanimImpl.setTranslation(this.vfTranslation);
        this.hanimImpl.setScaleOrientation(this.vfScaleOrientation);
    }

    public HAnimObject getHAnimObject() {
        return this.hanimImpl;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        vRMLFieldData.numElements = 1;
        vRMLFieldData.dataType = (short)11;
        switch (n) {
            case 6: {
                vRMLFieldData.floatArrayValue = this.vfCenter;
                break;
            }
            case 7: {
                vRMLFieldData.floatArrayValue = this.vfRotation;
                break;
            }
            case 8: {
                vRMLFieldData.floatArrayValue = this.vfScale;
                break;
            }
            case 9: {
                vRMLFieldData.floatArrayValue = this.vfScaleOrientation;
                break;
            }
            case 10: {
                vRMLFieldData.floatArrayValue = this.vfTranslation;
                break;
            }
            case 11: {
                vRMLFieldData.stringValue = this.vfName;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfRotation, 4);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfScale, 3);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfScaleOrientation, 4);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfTranslation, 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseHAnimSite.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setCenter(fArray);
                break;
            }
            case 7: {
                this.setRotation(fArray);
                break;
            }
            case 8: {
                this.setScale(fArray);
                break;
            }
            case 9: {
                this.setScaleOrientation(fArray);
                break;
            }
            case 10: {
                this.setTranslation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 11: {
                this.vfName = string;
                if (this.inSetup) break;
                this.hanimImpl.setName(this.vfName);
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setRotation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Rotation value null");
        }
        this.vfRotation[0] = fArray[0];
        this.vfRotation[1] = fArray[1];
        this.vfRotation[2] = fArray[2];
        this.vfRotation[3] = fArray[3];
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    public void setTranslation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Translation value null");
        }
        this.vfTranslation[0] = fArray[0];
        this.vfTranslation[1] = fArray[1];
        this.vfTranslation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    public void setScale(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale value null");
        }
        this.vfScale[0] = fArray[0];
        this.vfScale[1] = fArray[1];
        this.vfScale[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public void setScaleOrientation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale Orientation value null");
        }
        this.vfScaleOrientation[0] = fArray[0];
        this.vfScaleOrientation[1] = fArray[1];
        this.vfScaleOrientation[2] = fArray[2];
        this.vfScaleOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public void setCenter(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Center value null");
        }
        this.vfCenter[0] = fArray[0];
        this.vfCenter[1] = fArray[1];
        this.vfCenter[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(12);
        BaseHAnimSite.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseHAnimSite.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseHAnimSite.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseHAnimSite.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseHAnimSite.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseHAnimSite.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseHAnimSite.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "center");
        BaseHAnimSite.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFRotation", "rotation");
        BaseHAnimSite.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "scale");
        BaseHAnimSite.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFRotation", "scaleOrientation");
        BaseHAnimSite.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        BaseHAnimSite.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFString", "name");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("center", n);
        fieldMap.put("set_center", n);
        fieldMap.put("center_changed", n);
        n = new Integer(7);
        fieldMap.put("rotation", n);
        fieldMap.put("set_rotation", n);
        fieldMap.put("rotation_changed", n);
        n = new Integer(8);
        fieldMap.put("scale", n);
        fieldMap.put("set_scale", n);
        fieldMap.put("scale_changed", n);
        n = new Integer(9);
        fieldMap.put("scaleOrientation", n);
        fieldMap.put("set_scaleOrientation", n);
        fieldMap.put("scaleOrientation_changed", n);
        n = new Integer(10);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
        n = new Integer(11);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
    }
}

