//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2014 Sandia Corporation.
//  Copyright 2014 UT-Battelle, LLC.
//  Copyright 2014 Los Alamos National Security.
//
//  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
//  the U.S. Government retains certain rights in this software.
//
//  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
//  Laboratory (LANL), the U.S. Government retains certain rights in
//  this software.
//============================================================================
// **** DO NOT EDIT THIS FILE!!! ****
// This file is automatically generated by WorkletInvokeFunctorDetail.h.in

// Technically speaking, we can implement this functionality with some clever
// use of FunctionInterface rather than using pyexpander to make variadic
// code. However, this code is probably more friendly to compilers. I expect
// it to compiler faster and optimize better.

#ifndef vtk_m_exec_internal_WorkletInvokeFunctorDetail_h
#define vtk_m_exec_internal_WorkletInvokeFunctorDetail_h

#if !defined(vtk_m_exec_internal_WorkletInvokeFunctor_h) && !defined(VTKM_TEST_HEADER_BUILD)
#error WorkletInvokeFunctorDetail.h must be included from WorkletInvokeFunctor.h
#endif

#include <vtkm/internal/FunctionInterface.h>
#include <vtkm/internal/Invocation.h>

#include <vtkm/exec/arg/Fetch.h>

#if VTKM_MAX_FUNCTION_PARAMETERS != 10
#error Mismatch of maximum parameters between FunctionInterfaceDatailPre.h.in and WorkletInvokeFunctorDetail.h.in
#endif


namespace vtkm {
namespace exec {
namespace internal {
namespace detail {

/// A helper class that takes an \c Invocation object and an index to a
/// parameter in the ExecutionSignature and finds the \c Fetch type valid for
/// that parameter.
template<typename Invocation, vtkm::IdComponent ExecutionParameterIndex>
struct InvocationToFetch
{
private:
  typedef typename Invocation::ExecutionInterface::
      template ParameterType<ExecutionParameterIndex>::type
        ExecutionSignatureTag;

  // Expected fields from ExecutionSignatureTag. If these do not exist in
  // ExecutionSignatureTag, then something that is not really an execution
  // signature tag was used in an ExecutionSignature.
  static const vtkm::IdComponent ControlParameterIndex =
      ExecutionSignatureTag::INDEX;
  typedef typename ExecutionSignatureTag::AspectTag AspectTag;

  // Find the fetch tag from the control signature tag pointed to by
  // ParameterIndex.
  typedef typename Invocation::ControlInterface ControlInterface;
  typedef typename ControlInterface::
      template ParameterType<ControlParameterIndex>::type ControlSignatureTag;
  typedef typename ControlSignatureTag::FetchTag FetchTag;

public:
  typedef vtkm::exec::arg::Fetch<
      FetchTag,AspectTag,Invocation,ControlParameterIndex> type;
};

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  worklet(p1);

  fetch1.Store(index, invocation, p1);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  worklet(p1,p2);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2,P3)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2,P3)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2,p3));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2,P3)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2,P3)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  worklet(p1,p2,p3);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2,P3,P4)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2,P3,P4)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2,p3,p4));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2,P3,P4)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2,P3,P4)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  worklet(p1,p2,p3,p4);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2,p3,p4,p5));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  worklet(p1,p2,p3,p4,p5);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2,p3,p4,p5,p6));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  worklet(p1,p2,p3,p4,p5,p6);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,7>::type FetchType7;
  FetchType7 fetch7;
  typename FetchType7::ValueType p7 = fetch7.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2,p3,p4,p5,p6,p7));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
  fetch7.Store(index, invocation, p7);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6,P7)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6,P7)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,7>::type FetchType7;
  FetchType7 fetch7;
  typename FetchType7::ValueType p7 = fetch7.Load(index, invocation);

  worklet(p1,p2,p3,p4,p5,p6,p7);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
  fetch7.Store(index, invocation, p7);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,7>::type FetchType7;
  FetchType7 fetch7;
  typename FetchType7::ValueType p7 = fetch7.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,8>::type FetchType8;
  FetchType8 fetch8;
  typename FetchType8::ValueType p8 = fetch8.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2,p3,p4,p5,p6,p7,p8));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
  fetch7.Store(index, invocation, p7);
  fetch8.Store(index, invocation, p8);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6,P7,P8)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6,P7,P8)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,7>::type FetchType7;
  FetchType7 fetch7;
  typename FetchType7::ValueType p7 = fetch7.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,8>::type FetchType8;
  FetchType8 fetch8;
  typename FetchType8::ValueType p8 = fetch8.Load(index, invocation);

  worklet(p1,p2,p3,p4,p5,p6,p7,p8);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
  fetch7.Store(index, invocation, p7);
  fetch8.Store(index, invocation, p8);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,7>::type FetchType7;
  FetchType7 fetch7;
  typename FetchType7::ValueType p7 = fetch7.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,8>::type FetchType8;
  FetchType8 fetch8;
  typename FetchType8::ValueType p8 = fetch8.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,9>::type FetchType9;
  FetchType9 fetch9;
  typename FetchType9::ValueType p9 = fetch9.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2,p3,p4,p5,p6,p7,p8,p9));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
  fetch7.Store(index, invocation, p7);
  fetch8.Store(index, invocation, p8);
  fetch9.Store(index, invocation, p9);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6,P7,P8,P9)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6,P7,P8,P9)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,7>::type FetchType7;
  FetchType7 fetch7;
  typename FetchType7::ValueType p7 = fetch7.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,8>::type FetchType8;
  FetchType8 fetch8;
  typename FetchType8::ValueType p8 = fetch8.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,9>::type FetchType9;
  FetchType9 fetch9;
  typename FetchType9::ValueType p9 = fetch9.Load(index, invocation);

  worklet(p1,p2,p3,p4,p5,p6,p7,p8,p9);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
  fetch7.Store(index, invocation, p7);
  fetch8.Store(index, invocation, p8);
  fetch9.Store(index, invocation, p9);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,7>::type FetchType7;
  FetchType7 fetch7;
  typename FetchType7::ValueType p7 = fetch7.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,8>::type FetchType8;
  FetchType8 fetch8;
  typename FetchType8::ValueType p8 = fetch8.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,9>::type FetchType9;
  FetchType9 fetch9;
  typename FetchType9::ValueType p9 = fetch9.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,10>::type FetchType10;
  FetchType10 fetch10;
  typename FetchType10::ValueType p10 = fetch10.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,0>::type ReturnFetchType;
  typedef typename ReturnFetchType::ValueType ReturnValueType;
  ReturnFetchType returnFetch;
  ReturnValueType r = ReturnValueType(worklet(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10));

  returnFetch.Store(index, invocation, r);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
  fetch7.Store(index, invocation, p7);
  fetch8.Store(index, invocation, p8);
  fetch9.Store(index, invocation, p9);
  fetch10.Store(index, invocation, p10);
}

template<typename WorkletType,
         typename ParameterInterface,
         typename ControlInterface,
         vtkm::IdComponent InputDomainIndex,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_EXEC_EXPORT
void DoWorkletInvokeFunctor(
      const WorkletType &worklet,
      const vtkm::internal::Invocation<
        ParameterInterface,
        ControlInterface,
        vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)>,
        InputDomainIndex> &invocation,
      vtkm::Id index)
{
  typedef vtkm::internal::Invocation<
      ParameterInterface,
      ControlInterface,
      vtkm::internal::FunctionInterface<void(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)>,
      InputDomainIndex> Invocation;

  typedef typename InvocationToFetch<Invocation,1>::type FetchType1;
  FetchType1 fetch1;
  typename FetchType1::ValueType p1 = fetch1.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,2>::type FetchType2;
  FetchType2 fetch2;
  typename FetchType2::ValueType p2 = fetch2.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,3>::type FetchType3;
  FetchType3 fetch3;
  typename FetchType3::ValueType p3 = fetch3.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,4>::type FetchType4;
  FetchType4 fetch4;
  typename FetchType4::ValueType p4 = fetch4.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,5>::type FetchType5;
  FetchType5 fetch5;
  typename FetchType5::ValueType p5 = fetch5.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,6>::type FetchType6;
  FetchType6 fetch6;
  typename FetchType6::ValueType p6 = fetch6.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,7>::type FetchType7;
  FetchType7 fetch7;
  typename FetchType7::ValueType p7 = fetch7.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,8>::type FetchType8;
  FetchType8 fetch8;
  typename FetchType8::ValueType p8 = fetch8.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,9>::type FetchType9;
  FetchType9 fetch9;
  typename FetchType9::ValueType p9 = fetch9.Load(index, invocation);

  typedef typename InvocationToFetch<Invocation,10>::type FetchType10;
  FetchType10 fetch10;
  typename FetchType10::ValueType p10 = fetch10.Load(index, invocation);

  worklet(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10);

  fetch1.Store(index, invocation, p1);
  fetch2.Store(index, invocation, p2);
  fetch3.Store(index, invocation, p3);
  fetch4.Store(index, invocation, p4);
  fetch5.Store(index, invocation, p5);
  fetch6.Store(index, invocation, p6);
  fetch7.Store(index, invocation, p7);
  fetch8.Store(index, invocation, p8);
  fetch9.Store(index, invocation, p9);
  fetch10.Store(index, invocation, p10);
}


}
}
}
} // namespace vtkm::exec::internal::detail

#endif //vtk_m_exec_internal_WorkletInvokeFunctorDetail_h
