//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2014 Sandia Corporation.
//  Copyright 2014 UT-Battelle, LLC.
//  Copyright 2014 Los Alamos National Security.
//
//  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
//  the U.S. Government retains certain rights in this software.
//
//  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
//  Laboratory (LANL), the U.S. Government retains certain rights in
//  this software.
//============================================================================
// **** DO NOT EDIT THIS FILE!!! ****
// This file is automatically generated by FunctionInterfaceDetailPre.h.in

#ifndef vtk_m_internal_FunctionInterfaceDetailPre_h
#define vtk_m_internal_FunctionInterfaceDetailPre_h

#if !defined(vtk_m_internal_FunctionInterface_h) && !defined(VTKM_TEST_HEADER_BUILD)
#error FunctionInterfaceDetailPre.h must be included from FunctionInterface.h
#endif

#include <vtkm/Types.h>
#include <vtkm/internal/IndexTag.h>

VTKM_THIRDPARTY_PRE_INCLUDE
#include <boost/function_types/function_type.hpp>
#include <boost/mpl/at.hpp>
VTKM_THIRDPARTY_POST_INCLUDE

#define VTKM_MAX_FUNCTION_PARAMETERS 10


namespace vtkm {
namespace internal {

/// This struct is used internally by FunctionInterface to store the return
/// value of a function. There is a special implementation for a return type of
/// void, which stores nothing.
///
template<typename T>
struct FunctionInterfaceReturnContainer {
  T Value;
  static const bool VALID = true;
};

template<>
struct FunctionInterfaceReturnContainer<void> {
  // Nothing to store for void return.
  static const bool VALID = false;
};

namespace detail {

//============================================================================

// This templated class contains the state of parameters. If you get a compiler
// error stating that this class is not specialized, that probably means that
// you are using FunctionInterface with an unsupported number of arguments.
template<typename FunctionSignature>
struct ParameterContainer;

template<typename R>
struct ParameterContainer<R()> {
};

template<typename R,
         typename P1>
struct ParameterContainer<R(P1)> {
  P1 Parameter1;
};

template<typename R,
         typename P1,
         typename P2>
struct ParameterContainer<R(P1,P2)> {
  P1 Parameter1;
  P2 Parameter2;
};

template<typename R,
         typename P1,
         typename P2,
         typename P3>
struct ParameterContainer<R(P1,P2,P3)> {
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
};

template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
struct ParameterContainer<R(P1,P2,P3,P4)> {
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
};

template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
struct ParameterContainer<R(P1,P2,P3,P4,P5)> {
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
};

template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
struct ParameterContainer<R(P1,P2,P3,P4,P5,P6)> {
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
};

template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
struct ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> {
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
};

template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
struct ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> {
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
};

template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
struct ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> {
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
};

template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
struct ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> {
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
};


//============================================================================

template<int ParameterIndex, typename FunctionSignature>
struct ParameterContainerAccess;

template<typename FunctionSignature>
struct ParameterContainerAccess<1, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 1>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter1;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter1 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<2, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 2>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter2;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter2 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<3, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 3>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter3;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter3 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<4, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 4>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter4;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter4 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<5, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 5>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter5;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter5 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<6, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 6>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter6;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter6 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<7, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 7>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter7;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter7 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<8, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 8>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter8;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter8 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<9, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 9>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter9;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter9 = value;
  }
};

template<typename FunctionSignature>
struct ParameterContainerAccess<10, FunctionSignature> {
  typedef typename boost::mpl::at_c<
        boost::function_types::components<FunctionSignature>, 10>::type
      ParameterType;

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  ParameterType
  GetParameter(const ParameterContainer<FunctionSignature> &parameters) {
    return parameters.Parameter10;
  }

  VTKM_SUPPRESS_EXEC_WARNINGS
  VTKM_EXEC_CONT_EXPORT
  static
  void SetParameter(ParameterContainer<FunctionSignature> &parameters,
                    const ParameterType &value) {
    parameters.Parameter10 = value;
  }
};


//============================================================================

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R()> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  (void) parameters;
  result.Value = transform(f());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor
         >
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void()> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  (void) parameters;
  (void) transform;
  f();
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R()> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  (void) parameters;
  result.Value = transform(f());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor
         >
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void()> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  (void) parameters;
  (void) transform;
  f();
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R()> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  (void) parameters;
  result.Value = transform(f());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor
         >
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void()> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  (void) parameters;
  (void) transform;
  f();
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R()> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  (void) parameters;
  result.Value = transform(f());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor
         >
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void()> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  (void) parameters;
  (void) transform;
  f();
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2,P3)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2,P3)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2,P3)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2,P3)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8),
                             transform(parameters.Parameter9)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8),
    transform(parameters.Parameter9));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8),
                             transform(parameters.Parameter9)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8),
    transform(parameters.Parameter9));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8),
                             transform(parameters.Parameter9)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8),
    transform(parameters.Parameter9));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8),
                             transform(parameters.Parameter9)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8),
    transform(parameters.Parameter9));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8),
                             transform(parameters.Parameter9),
                             transform(parameters.Parameter10)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_CONT_EXPORT
void DoInvokeCont(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8),
    transform(parameters.Parameter9),
    transform(parameters.Parameter10));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8),
                             transform(parameters.Parameter9),
                             transform(parameters.Parameter10)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_CONT_EXPORT
void DoInvokeCont(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8),
    transform(parameters.Parameter9),
    transform(parameters.Parameter10));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8),
                             transform(parameters.Parameter9),
                             transform(parameters.Parameter10)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      const Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8),
    transform(parameters.Parameter9),
    transform(parameters.Parameter10));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> &parameters,
      FunctionInterfaceReturnContainer<R> &result,
      const TransformFunctor &transform)
{
  result.Value = transform(f(
                             transform(parameters.Parameter1),
                             transform(parameters.Parameter2),
                             transform(parameters.Parameter3),
                             transform(parameters.Parameter4),
                             transform(parameters.Parameter5),
                             transform(parameters.Parameter6),
                             transform(parameters.Parameter7),
                             transform(parameters.Parameter8),
                             transform(parameters.Parameter9),
                             transform(parameters.Parameter10)));
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename TransformFunctor,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_EXEC_EXPORT
void DoInvokeExec(
      Functor &f,
      ParameterContainer<void(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> &parameters,
      FunctionInterfaceReturnContainer<void> &,
      const TransformFunctor &transform)
{
  f(
    transform(parameters.Parameter1),
    transform(parameters.Parameter2),
    transform(parameters.Parameter3),
    transform(parameters.Parameter4),
    transform(parameters.Parameter5),
    transform(parameters.Parameter6),
    transform(parameters.Parameter7),
    transform(parameters.Parameter8),
    transform(parameters.Parameter9),
    transform(parameters.Parameter10));
}


//============================================================================

template<typename OriginalSignature, typename Transform>
struct FunctionInterfaceStaticTransformType;

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename TransformedR>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR()> &originalParameters,
      ParameterContainer<TransformedR()> &transformedParameters)
{
  (void)transform;
  (void)originalParameters;
  (void)transformedParameters;
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename TransformedR>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR()> &originalParameters,
      ParameterContainer<TransformedR()> &transformedParameters)
{
  (void)transform;
  (void)originalParameters;
  (void)transformedParameters;
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename TransformedR,
         typename TransformedP1>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename TransformedR,
         typename TransformedP1>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename OriginalP6,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5,
         typename TransformedP6>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5,OriginalP6)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5,TransformedP6)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
  transformedParameters.Parameter6 =
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename OriginalP6,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5,
         typename TransformedP6>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5,OriginalP6)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5,TransformedP6)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
  transformedParameters.Parameter6 =
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename OriginalP6,
         typename OriginalP7,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5,
         typename TransformedP6,
         typename TransformedP7>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5,OriginalP6,OriginalP7)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5,TransformedP6,TransformedP7)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
  transformedParameters.Parameter6 =
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>());
  transformedParameters.Parameter7 =
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename OriginalP6,
         typename OriginalP7,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5,
         typename TransformedP6,
         typename TransformedP7>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5,OriginalP6,OriginalP7)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5,TransformedP6,TransformedP7)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
  transformedParameters.Parameter6 =
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>());
  transformedParameters.Parameter7 =
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename OriginalP6,
         typename OriginalP7,
         typename OriginalP8,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5,
         typename TransformedP6,
         typename TransformedP7,
         typename TransformedP8>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5,OriginalP6,OriginalP7,OriginalP8)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5,TransformedP6,TransformedP7,TransformedP8)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
  transformedParameters.Parameter6 =
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>());
  transformedParameters.Parameter7 =
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>());
  transformedParameters.Parameter8 =
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename OriginalP6,
         typename OriginalP7,
         typename OriginalP8,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5,
         typename TransformedP6,
         typename TransformedP7,
         typename TransformedP8>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5,OriginalP6,OriginalP7,OriginalP8)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5,TransformedP6,TransformedP7,TransformedP8)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
  transformedParameters.Parameter6 =
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>());
  transformedParameters.Parameter7 =
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>());
  transformedParameters.Parameter8 =
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename OriginalP6,
         typename OriginalP7,
         typename OriginalP8,
         typename OriginalP9,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5,
         typename TransformedP6,
         typename TransformedP7,
         typename TransformedP8,
         typename TransformedP9>
VTKM_CONT_EXPORT
void DoStaticTransformCont(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5,OriginalP6,OriginalP7,OriginalP8,OriginalP9)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5,TransformedP6,TransformedP7,TransformedP8,TransformedP9)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
  transformedParameters.Parameter6 =
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>());
  transformedParameters.Parameter7 =
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>());
  transformedParameters.Parameter8 =
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>());
  transformedParameters.Parameter9 =
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Transform,
         typename OriginalR,
         typename OriginalP1,
         typename OriginalP2,
         typename OriginalP3,
         typename OriginalP4,
         typename OriginalP5,
         typename OriginalP6,
         typename OriginalP7,
         typename OriginalP8,
         typename OriginalP9,
         typename TransformedR,
         typename TransformedP1,
         typename TransformedP2,
         typename TransformedP3,
         typename TransformedP4,
         typename TransformedP5,
         typename TransformedP6,
         typename TransformedP7,
         typename TransformedP8,
         typename TransformedP9>
VTKM_EXEC_EXPORT
void DoStaticTransformExec(
      const Transform &transform,
      const ParameterContainer<OriginalR(OriginalP1,OriginalP2,OriginalP3,OriginalP4,OriginalP5,OriginalP6,OriginalP7,OriginalP8,OriginalP9)> &originalParameters,
      ParameterContainer<TransformedR(TransformedP1,TransformedP2,TransformedP3,TransformedP4,TransformedP5,TransformedP6,TransformedP7,TransformedP8,TransformedP9)> &transformedParameters)
{
  transformedParameters.Parameter1 =
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>());
  transformedParameters.Parameter2 =
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>());
  transformedParameters.Parameter3 =
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>());
  transformedParameters.Parameter4 =
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>());
  transformedParameters.Parameter5 =
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>());
  transformedParameters.Parameter6 =
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>());
  transformedParameters.Parameter7 =
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>());
  transformedParameters.Parameter8 =
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>());
  transformedParameters.Parameter9 =
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>());
}


//============================================================================

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R()> &parameters)
{
  (void)f;
  (void)parameters;
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R()> &parameters)
{
  (void)f;
  (void)parameters;
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R()> &parameters)
{
  (void)f;
  (void)parameters;
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R()> &parameters)
{
  (void)f;
  (void)parameters;
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1,P2)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1,P2)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1,P2)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1,P2)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5,P6)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5,P6)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
  f(parameters.Parameter8, vtkm::internal::IndexTag<8>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
  f(parameters.Parameter8, vtkm::internal::IndexTag<8>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
  f(parameters.Parameter8, vtkm::internal::IndexTag<8>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
  f(parameters.Parameter8, vtkm::internal::IndexTag<8>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
  f(parameters.Parameter8, vtkm::internal::IndexTag<8>());
  f(parameters.Parameter9, vtkm::internal::IndexTag<9>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_CONT_EXPORT
void DoForEachCont(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
  f(parameters.Parameter8, vtkm::internal::IndexTag<8>());
  f(parameters.Parameter9, vtkm::internal::IndexTag<9>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      const ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
  f(parameters.Parameter8, vtkm::internal::IndexTag<8>());
  f(parameters.Parameter9, vtkm::internal::IndexTag<9>());
}

VTKM_SUPPRESS_EXEC_WARNINGS
template<typename Functor,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_EXPORT
void DoForEachExec(
      const Functor &f,
      ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> &parameters)
{
  f(parameters.Parameter1, vtkm::internal::IndexTag<1>());
  f(parameters.Parameter2, vtkm::internal::IndexTag<2>());
  f(parameters.Parameter3, vtkm::internal::IndexTag<3>());
  f(parameters.Parameter4, vtkm::internal::IndexTag<4>());
  f(parameters.Parameter5, vtkm::internal::IndexTag<5>());
  f(parameters.Parameter6, vtkm::internal::IndexTag<6>());
  f(parameters.Parameter7, vtkm::internal::IndexTag<7>());
  f(parameters.Parameter8, vtkm::internal::IndexTag<8>());
  f(parameters.Parameter9, vtkm::internal::IndexTag<9>());
}


} // namespace detail

}
} // namespace vtkm::internal

#endif //vtk_m_internal_FunctionInterfaceDetailPre_h
