#!/usr/bin/env python
"""
ckwg +31
Copyright 2017 by Kitware, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Kitware, Inc. nor the names of any contributors may be used
   to endorse or promote products derived from this software without specific
   prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==============================================================================

Library handling imagery simulation.

"""
from __future__ import division, print_function
import wx
from wxpython_gui.system_control_panel.gui import MainFrame
import rospy

def main():
    node_name = 'system_gui'
    name_space = rospy.get_namespace()

    topic_names = {}

    # --------------------- Remote Image Server Topics -----------------------
    topic_names['rgb_image_topic'] = '/image_raw'
    topic_names['rgb_analytics_image_topic'] = '/rgb/segmented'

    topic_names['rgb_genicam_get_service_topic'] = '/rc_genicam_camera/get_genicam_parameter'
    topic_names['rgb_genicam_set_service_topic'] = '/rc_genicam_camera/set_genicam_parameter'
    # ------------------------------------------------------------------------

    # ------------------------ Archive Service Topics ------------------------
    topic_names['archive_srv'] = '/set_archiving'
    # ------------------------------------------------------------------------

    # ------------------------ Exposure Value Topics -------------------------
    topic_names['rgb_exposure'] = '/rgb_driver/exposure'
    # ------------------------------------------------------------------------

    # --------------------------- DiagnosticStatus ---------------------------
    topic_names['ptp_health_ins'] = '/ptp_health/ins'
    topic_names['ptp_health_nmea'] = '/ptp_health/nmea'
    topic_names['ptp_health_pps'] = '/ptp_health/pps'
    topic_names['ptp_health_ptp'] = '/ptp_health/ptp'
    # ------------------------------------------------------------------------

    # --------------------------- Disk Space Topics --------------------------
    topic_names['disk_space'] = '/disk_free_bytes'
    # ------------------------------------------------------------------------

    topic_names['det_topic1'] = ''.join([name_space,
                                         'sprokit_detector_adapter/detections_out'])

    topic_names['nav_sat_fix_topic'] = '/an_device/NavSatFix'
    topic_names['imu_fix_topic'] = '/an_device/Imu'
    topic_names['nav_filter_status_topic'] = '/an_device/FilterStatus'

    window_title = 'System Control Panel'

    app = wx.App(False)
    frame = MainFrame(node_name, topic_names, False, window_title)
    frame.Show(True)
    app.MainLoop()

if __name__ == '__main__':
    main()
