#! /usr/bin/python
"""
ckwg +31
Copyright 2018 by Kitware, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Kitware, Inc. nor the names of any contributors may be used
   to endorse or promote products derived from this software without specific
   prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==============================================================================

"""
from __future__ import division, print_function
import numpy as np
import os
import cv2
import subprocess
import matplotlib.pyplot as plt
import glob


image_in_dir = '/home/user/adapt_ws/data/2021-06-23-16-51-24/images0'
image_out_dir = '/home/user/adapt_ws/data/2021-06-23-16-51-24_rs/images0'
line_read_first = 3648

# Negative indicates reading from bottom to top.
line_read_speed = -72960    # lines/s

num_segments = 10

img_fnames = glob.glob('%s/*.png' % image_in_dir)
img_fnames = sorted(img_fnames)

try:
    os.makedirs(image_out_dir)
except (OSError, IOError):
    pass

for i, img_fname in enumerate(img_fnames):
    t = float(os.path.splitext(os.path.split(img_fname)[1])[0])/1000000
    img = cv2.imread(img_fname)
    row_range = np.linspace(0, img.shape[0], num_segments + 1)
    row_range = np.round(row_range).astype(np.int)
    for k in range(num_segments):
        center_row = (row_range[k] + row_range[k+1])/2
        tk = t + (line_read_first - center_row)/line_read_speed
        fname_out = '%s/%i.png' % (image_out_dir, int(np.round(tk*1000000)))
        img_out = np.zeros_like(img)
        img_out[row_range[k]:row_range[k+1], :, :] = img[row_range[k]:row_range[k+1], :, :]
        cv2.imwrite(fname_out, img_out)