#!/usr/bin/env python
"""
ckwg +31
Copyright 2019 by Kitware, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Kitware, Inc. nor the names of any contributors may be used
   to endorse or promote products derived from this software without specific
   prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==============================================================================

"""
from __future__ import division, print_function
import os
import numpy as np
import cv2
import StringIO
from PIL import Image as PILImage

# ROS imports
from rosbag import Bag
from cv_bridge import CvBridge


bridge = CvBridge()


bag_fname = '/home/user/adapt_ws/data/2021-06-23-16-51-24.bag'
imagery_topic = '/image_raw'
imu_topic = '/an_device/Imu'
gps_topic = ' /an_device/NavSatFix'
filter_status_topic = '/an_device/FilterStatus'
ins_system_status_topic = '/an_device/SystemStatus'
out_dir = os.path.splitext(bag_fname)[0]


image_dir = '%s/images' % out_dir
try:
    os.makedirs(image_dir)
except (IOError, OSError):
    pass


msgs = {}
images =  {}
system_status = {}
filter_status = {}
topics = set()
with Bag(bag_fname, 'r') as ib:
    for topic, msg, t in ib:
        topics.add(topic)

        if topic == ins_system_status_topic:
            system_status[t.to_sec()] = msg
            continue

        if topic == filter_status_topic:
            filter_status[t.to_sec()] = msg
            continue

        try:
            t = msg.header.stamp.to_sec()
        except AttributeError:
            continue

        if topic == imagery_topic:
            if hasattr(msg, 'format'):
                sio = StringIO.StringIO(msg.data)
                im = PILImage.open( sio )
                image = np.array( im )
            else:
                image = bridge.imgmsg_to_cv2(msg, "rgb8")

            frame_id = msg.header.frame_id

            images[t] = image[-100:, : ,:]

            fname = '%s/%i.png' % (image_dir, int(np.round(t*1000000)))
            #cv2.imwrite(fname, image[:, :, ::-1])
        else:
            if topic not in msgs:
                msgs[topic] = {}

            msgs[topic][t] = msg