#!/bin/bash
# Determine dirname of this file/directory
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
SESSION="adapt_ptp"
source /home/adapt/adapt_ros_ws/devel/setup.bash

# change the ethernet settings to make sure we get the best rates:
# jumbo frames:
sudo ifconfig eth0 mtu 9000
# increase max recv buffer size:
sudo sysctl -w net.core.rmem_max=33554432
sudo sysctl -w net.core.netdev_max_backlog=2000
sudo sysctl -w net.core.netdev_budget=600

# check for device existance: ptp0, gps, spatial, pps
if [[ $(ls /dev/ | grep 'pps') = 'pps0' ]]; then
  echo "Found /dev/pps0!"
else
  echo "!!!!!!!!!! ERROR: no pps in /dev/"
  exit 1
fi
if [[ $(ls /dev/ | grep 'gps') = 'gps' ]]; then
  echo "Found /dev/gps!"
else
  echo "!!!!!!!!!! ERROR: no gps in /dev/"
  exit 1
fi
if [[ $(ls /dev/ | grep 'spatial') = 'spatial' ]]; then
  echo "Found /dev/spatial!"
else
  echo "!!!!!!!!!! ERROR: no spatial in /dev/ - check udev rules"
  exit 1
fi

# change permissions on the devices needed
sudo chown root:dialout /dev/pps0
sudo chown root:dialout /dev/gps
sudo chown root:dialout /dev/spatial
sudo chmod a+r /dev/pps0
sudo chmod a+r /dev/gps
sudo chmod a+r /dev/spatial

# read some of the gps device
check_gps="head /dev/gps"
output=$(eval "$check_gps")
echo "GPS info: $output"
if [[ "$output" == *"\$GP"* ]]; then
  echo "Successfully read GPS NMEA info!"
else
  echo "GPS is not sending NMEA info to /dev/gps - check udev rules"
  exit 1
fi

# check for the PPS signal coming in
check_pps="dmesg --ctime | grep capture | head -10"
output=$(eval "$check_pps")
echo "dmesg - should see PPS every second: $output"
if [[ "$output" == *"pps pps0: capture assert"* ]]; then
  echo "pps events coming in - read above and make sure it is only once per second"
else
  echo "Not seeing the 1PPS messages :("
  exit 1
fi

sudo systemctl stop systemd-timesyncd.service
sudo systemctl disable systemd-timesyncd.service


# catch exiting the tmux session
trap "{
        echo Stopping TMUX Session;
        tmux kill-session -t ${SESSION};
        exit 0;
      }" EXIT

echo "$(date) Starting ${SESSION}"
tmux new-session -d -s $SESSION

i=0

echo "Starting gpsd."
tmux select-window -t $SESSION:${i}
tmux rename-window -t $SESSION:${i} 'gpsd'
tmux send-keys "ptp/10_gpsd.sh" C-m
i=$((i+1))

sleep 15

echo "Re-starting time server."
tmux new-window -t $SESSION:${i} -n "timeserver"
tmux send-keys "ptp/20_timeServer.sh" C-m
i=$((i+1))

sleep 10

echo "Starting ptp."
tmux new-window -t $SESSION:${i} -n 'ptp'
tmux send-keys "ptp/30_ptp4l.sh" C-m
i=$((i+1))

sleep 1

# change permissions on the PTP device
sudo chown root:dialout /dev/ptp0
sudo chmod a+r /dev/ptp0

echo "You should now be able to run cgps and ptp/4watch_chronyd.sh."
echo 'note: this requires sudo for some commands'
echo 'you may need to edit /etc/sudoers and add:'
echo 'Defaults:yourlogin !tty_tickets'
echo '--------------------------------------'
echo "Running, press C^c to exit..."

sleep infinity
