/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLFontStyleNodeType;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.renderer.common.nodes.text.DefaultFontStyle;

public abstract class BaseText
extends AbstractNode
implements VRMLTextNodeType {
    private static final String ANTIALIAS_PROP = "org.web3d.vrml.nodes.fontstyle.font.antialiased";
    private static final String FONTSTYLE_PROTO_MSG = "Proto does not describe a Text object";
    private static final String FONTSTYLE_NODE_MSG = "Node does not describe a Text object";
    private static final Color CLEAR_COLOR = Color.black;
    private static final Color TEXT_COLOR = Color.white;
    private static final boolean ANTIALIAS;
    protected static final int FIELD_STRING = 1;
    protected static final int FIELD_FONTSTYLE = 2;
    protected static final int FIELD_LENGTH = 3;
    protected static final int FIELD_MAXEXTENT = 4;
    protected static final int FIELD_SOLID = 5;
    protected static final int LAST_TEXT_INDEX = 5;
    protected static final int NUM_FIELDS = 6;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected String[] vfString;
    protected int numString;
    protected VRMLFontStyleNodeType vfFontStyle;
    protected VRMLProtoInstance pFontStyle;
    protected float[] vfLength;
    protected int numLength;
    protected float vfMaxExtent;
    protected boolean vfSolid;
    private final boolean needsTexture;
    private BufferedImage currentImage;
    protected BufferedImage texturedImage;
    protected int imgWidth;
    protected int imgHeight;
    protected int usedPixelWidth;
    protected int usedPixelHeight;
    protected int linePixelHeight;
    protected int linePixelSpacing;
    private String[] orderedText;
    protected TextLayout[] layouts;

    protected BaseText(boolean bl) {
        super("Text");
        this.hasChanged = new boolean[6];
        this.needsTexture = bl;
        this.vfSolid = true;
        this.vfString = FieldConstants.EMPTY_MFSTRING;
        this.vfLength = FieldConstants.EMPTY_MFFLOAT;
    }

    protected BaseText(VRMLNodeType vRMLNodeType, boolean bl) {
        this(bl);
        this.checkNodeType(vRMLNodeType);
        this.vfSolid = ((VRMLGeometryNodeType)vRMLNodeType).isSolid();
        try {
            int n = vRMLNodeType.getFieldIndex("string");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfString = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfString, 0, vRMLFieldData.numElements);
            }
            this.numString = vRMLFieldData.numElements;
            n = vRMLNodeType.getFieldIndex("length");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfLength = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfLength, 0, vRMLFieldData.numElements);
                this.numLength = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("maxExtent");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxExtent = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return false;
    }

    public boolean hasLocalColorAlpha() {
        return false;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getNumSets() {
        return 0;
    }

    public boolean isSolid() {
        return this.vfSolid;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public void setFontStyle(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLFontStyleNodeType vRMLFontStyleNodeType;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLFontStyleNodeType = (VRMLFontStyleNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pFontStyle = (VRMLProtoInstance)vRMLNodeType;
            int[] nArray = vRMLNodeType.getSecondaryType();
            boolean bl = false;
            for (int i = 0; i < nArray.length && !bl; ++i) {
                if (nArray[i] != 19) continue;
                bl = true;
            }
            if (!bl) {
                throw new InvalidFieldValueException(FONTSTYLE_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLFontStyleNodeType)) {
                throw new InvalidFieldValueException(FONTSTYLE_NODE_MSG);
            }
            this.pFontStyle = null;
            vRMLFontStyleNodeType = (VRMLFontStyleNodeType)vRMLNodeType;
        }
        this.vfFontStyle = vRMLFontStyleNodeType;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public VRMLNodeType getFontStyle() {
        if (this.pFontStyle != null) {
            return this.pFontStyle;
        }
        return this.vfFontStyle;
    }

    public void setText(String[] stringArray) {
        if (stringArray == null) {
            this.numString = 0;
        } else {
            if (this.vfString == null || this.vfString.length < stringArray.length) {
                this.vfString = new String[stringArray.length];
            }
            this.numString = stringArray.length;
            System.arraycopy(stringArray, 0, this.vfString, 0, this.numString);
        }
        if (!this.inSetup) {
            this.updateTexture();
        }
        this.hasChanged[1] = true;
        this.fireFieldChanged(1);
    }

    public String[] getText() {
        String[] stringArray;
        if (this.numString != this.vfString.length) {
            stringArray = new String[this.numString];
            System.arraycopy(this.vfString, 0, stringArray, 0, this.numString);
        } else {
            stringArray = this.vfString;
        }
        return stringArray;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pFontStyle != null) {
            this.pFontStyle.setupFinished();
        } else if (this.vfFontStyle != null) {
            this.vfFontStyle.setupFinished();
        }
        if (this.needsTexture) {
            this.currentImage = new BufferedImage(1, 1, 10);
            this.texturedImage = new BufferedImage(1, 1, 10);
            this.imgWidth = 1;
            this.imgHeight = 1;
            this.updateTexture();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 21;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        switch (n) {
            case 1: {
                vRMLFieldData.stringArrayValue = this.vfString;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.numString;
                break;
            }
            case 2: {
                vRMLFieldData.nodeValue = this.pFontStyle != null ? this.pFontStyle : this.vfFontStyle;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 3: {
                vRMLFieldData.floatArrayValue = this.vfLength;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.vfLength == null ? 0 : this.vfLength.length;
                break;
            }
            case 4: {
                vRMLFieldData.floatValue = this.vfMaxExtent;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 5: {
                if (this.vrmlMajorVersion < 3) {
                    throw new InvalidFieldException("Field solid not defined for VRML97");
                }
                vRMLFieldData.booleanValue = this.vfSolid;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfString, this.numString);
                    break;
                }
                case 2: {
                    if (this.pFontStyle != null) {
                        vRMLNodeType.setValue(n2, this.pFontStyle);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfFontStyle);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfLength, this.numLength);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfMaxExtent);
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Text sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Text sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                if (this.vrmlMajorVersion < 3) {
                    throw new InvalidFieldException("Field solid not defined for VRML97");
                }
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field:  solid");
                }
                this.vfSolid = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.vfMaxExtent = f;
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                if (n2 > this.vfLength.length) {
                    this.vfLength = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfLength, 0, n2);
                this.numLength = n2;
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setText(new String[]{string});
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setText(stringArray);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setFontStyle(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void textUpdated(boolean bl) {
    }

    private void updateTexture() {
        double d;
        int n;
        boolean bl;
        if (this.numString == 0) {
            return;
        }
        if (!this.needsTexture) {
            return;
        }
        Graphics2D graphics2D = this.currentImage.createGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        VRMLFontStyleNodeType vRMLFontStyleNodeType = this.vfFontStyle == null ? DefaultFontStyle.getDefaultFontStyle() : this.vfFontStyle;
        Font font = vRMLFontStyleNodeType.getFont();
        float f = vRMLFontStyleNodeType.getSpacing();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ANTIALIAS ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.layouts = new TextLayout[this.vfString.length];
        Rectangle2D rectangle2D = font.getMaxCharBounds(fontRenderContext);
        boolean bl2 = bl = this.vfFontStyle == null || this.vfFontStyle.isTopToBottom();
        this.layouts[0] = bl ? (this.vfString[0].length() == 0 ? new TextLayout(" ", font, fontRenderContext) : new TextLayout(this.vfString[0], font, fontRenderContext)) : (this.vfString[0].length() == 0 ? new TextLayout(" ", font, fontRenderContext) : new TextLayout(this.vfString[this.numString - 1], font, fontRenderContext));
        Rectangle2D rectangle2D2 = this.layouts[0].getBounds();
        int n2 = (int)rectangle2D.getHeight();
        int n3 = (int)rectangle2D2.getWidth();
        int n4 = (int)((float)(n2 * this.numString) + (float)n2 * f * (float)(this.numString - 1));
        if (bl) {
            for (n = 1; n < this.numString; ++n) {
                if (this.vfString[n].length() == 0) {
                    this.layouts[n] = new TextLayout(" ", font, fontRenderContext);
                    continue;
                }
                this.layouts[n] = new TextLayout(this.vfString[n], font, fontRenderContext);
                rectangle2D2 = this.layouts[n].getBounds();
                d = rectangle2D2.getWidth();
                if (!(d > (double)n3)) continue;
                n3 = (int)d;
            }
        } else {
            for (n = 1; n < this.numString; ++n) {
                if (this.vfString[this.numString - n - 1].length() == 0) {
                    this.layouts[n] = new TextLayout(" ", font, fontRenderContext);
                    continue;
                }
                this.layouts[n] = new TextLayout(this.vfString[this.numString - n - 1], font, fontRenderContext);
                rectangle2D2 = this.layouts[n].getBounds();
                d = rectangle2D2.getWidth();
                if (!(d > (double)n3)) continue;
                n3 = (int)d;
            }
        }
        this.usedPixelHeight = n4;
        this.usedPixelWidth = n3;
        this.linePixelHeight = n2;
        this.linePixelSpacing = (int)((float)n2 * f);
        if (n3 > 1024) {
            System.out.println("Clamping len to 1024, was: " + n3);
            n3 = 512;
        }
        if (n4 > 1024) {
            System.out.println("Clamping height to 512 was: " + n4);
            n4 = 512;
        }
        if (n3 < 0) {
            n3 = 1;
        }
        if (n4 < 0) {
            n4 = 1;
        }
        int n5 = this.smallestPower(n3);
        int n6 = this.smallestPower(n4);
        boolean bl3 = false;
        if (this.imgWidth < n5 || this.imgHeight < n4) {
            n4 = this.smallestPower(n4);
            this.currentImage = new BufferedImage(n5, n6, 10);
            this.imgWidth = n5;
            this.imgHeight = n6;
            bl3 = true;
            graphics2D = this.currentImage.createGraphics();
        }
        graphics2D.setColor(CLEAR_COLOR);
        graphics2D.fillRect(0, 0, this.imgWidth, this.imgHeight);
        graphics2D.setColor(TEXT_COLOR);
        switch (vRMLFontStyleNodeType.getHorizontalJustification()) {
            case 1: 
            case 4: {
                rectangle2D2 = this.layouts[this.numString - 1].getBounds();
                float f2 = this.imgHeight;
                this.layouts[this.numString - 1].draw(graphics2D, 0.0f, f2);
                for (n = this.numString - 2; n >= 0; --n) {
                    f2 = (float)this.imgHeight - (float)n2 * f * (float)(this.numString - n - 1);
                    rectangle2D2 = this.layouts[n].getBounds();
                    this.layouts[n].draw(graphics2D, (float)rectangle2D2.getX(), f2 -= this.layouts[n].getDescent());
                }
                break;
            }
            case 3: {
                rectangle2D2 = this.layouts[this.numString - 1].getBounds();
                float f3 = (float)this.imgHeight - this.layouts[this.numString - 1].getDescent();
                float f4 = (float)(this.usedPixelWidth >> 1) - (float)rectangle2D2.getWidth() / 2.0f;
                this.layouts[this.numString - 1].draw(graphics2D, f4, f3);
                for (n = this.numString - 2; n >= 0; --n) {
                    f3 = (float)this.imgHeight - (float)n2 * f * (float)(this.numString - n - 1);
                    rectangle2D2 = this.layouts[n].getBounds();
                    f4 = (float)(this.usedPixelWidth >> 1) - (float)rectangle2D2.getWidth() / 2.0f;
                    this.layouts[n].draw(graphics2D, f4, f3 -= this.layouts[n].getDescent());
                }
                break;
            }
            case 2: {
                rectangle2D2 = this.layouts[this.numString - 1].getBounds();
                float f5 = (float)this.usedPixelWidth - (float)rectangle2D2.getWidth();
                float f6 = (float)this.imgHeight - this.layouts[this.numString - 1].getDescent();
                this.layouts[this.numString - 1].draw(graphics2D, f5, f6);
                for (n = this.numString - 2; n >= 0; --n) {
                    f6 = (float)this.imgHeight - (float)n2 * f * (float)(this.numString - n - 1);
                    rectangle2D2 = this.layouts[n].getBounds();
                    f5 = (float)this.usedPixelWidth - (float)rectangle2D2.getWidth();
                    this.layouts[n].draw(graphics2D, f5, f6 -= this.layouts[n].getDescent());
                }
                break;
            }
        }
        graphics2D.dispose();
        BufferedImage bufferedImage = this.currentImage;
        this.currentImage = this.texturedImage;
        this.texturedImage = bufferedImage;
        this.textUpdated(bl3);
    }

    private int smallestPower(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    static {
        nodeFields = new int[]{2, 0};
        fieldDecl = new VRMLFieldDeclaration[6];
        fieldMap = new HashMap(18);
        BaseText.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseText.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFString", "string");
        BaseText.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "fontStyle");
        BaseText.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFFloat", "length");
        BaseText.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "maxExtent");
        BaseText.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("string", n);
        fieldMap.put("set_string", n);
        fieldMap.put("string_changed", n);
        n = new Integer(2);
        fieldMap.put("fontStyle", n);
        fieldMap.put("set_fontStyle", n);
        fieldMap.put("fontStyle_changed", n);
        n = new Integer(3);
        fieldMap.put("length", n);
        fieldMap.put("set_length", n);
        fieldMap.put("length_changed", n);
        n = new Integer(4);
        fieldMap.put("maxExtent", n);
        fieldMap.put("set_maxExtent", n);
        fieldMap.put("maxExtent_changed", n);
        fieldMap.put("solid", new Integer(5));
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(Boolean.getBoolean(BaseText.ANTIALIAS_PROP));
            }
        });
        ANTIALIAS = bl;
    }
}

