// Copyright (c) Kitware, Inc. All rights reserved. See license.md for details.
#ifndef smtk_session_aeva_Resource_h
#define smtk_session_aeva_Resource_h
/*!\file */

#include "smtk/session/aeva/Session.h"
#include "smtk/resource/DerivedFrom.h"
#include "smtk/model/Resource.h"
#include "smtk/resource/Manager.h"

#include "smtk/session/aeva/Exports.h"

namespace smtk
{
namespace session
{
namespace aeva
{

class SMTKAEVASESSION_EXPORT Resource
  : public smtk::resource::DerivedFrom<Resource, smtk::model::Resource>
{
public:
  smtkTypeMacro(smtk::session::aeva::Resource);
  smtkSuperclassMacro(smtk::resource::DerivedFrom<Resource, smtk::model::Resource>);
  smtkSharedPtrCreateMacro(smtk::resource::Resource);

  virtual ~Resource();

  const Session::Ptr& session() const { return m_session; }
  void setSession(const Session::Ptr&);


protected:
  Resource(const smtk::common::UUID&, smtk::resource::Manager::Ptr manager = nullptr);
  Resource(smtk::resource::Manager::Ptr manager = nullptr);

  Session::Ptr m_session;

  // map of ITK* -> UUID
  // map of UUID -> ITK*
  // set of ITK*

  // There is a public smtk::model::Resource addVolume and returns a EntityRef and ask it for the UUID via entity()
};

} // namespace aeva
} // namespace session
} // namespace smtk
#endif // smtk_session_aeva_Resource_h
