<?xml version="1.0"?>
<SMTK_AttributeResource Version="3">
  <Categories>
  </Categories>

  <Definitions>

    <AttDef Type="rank 2 tensor function" BaseType="">
      <ItemDefinitions>
        <String Name="tensor type">
          <ChildrenDefinitions>
            <String Name="general functions" NumberOfRequiredValues="9"/>
            <String Name="symmetric functions" NumberOfRequiredValues="6"/>
            <String Name="diagonal functions" NumberOfRequiredValues="3"/>
          </ChildrenDefinitions>
          <DiscreteInfo>
            <Structure>
              <Value Enum="general">general</Value>
              <Items><Item>general functions</Item></Items>
              <Value Enum="symmetric">symmetric</Value>
              <Items><Item>symmetric functions</Item></Items>
              <Value Enum="diagonal">diagonal</Value>
              <Items><Item>diagonal functions</Item></Items>
            </Structure>
          </DiscreteInfo>
        </String>
      </ItemDefinitions>
    </AttDef>

    <AttDef Type="cauchy-green deformation tensor" BaseType="">

      <ItemDefinitions>
        <String
          Name="type"
          NumberOfRequiredValues="1"
        >
          <ChildrenDefinitions>

            <Double
              Name="b"
              Label="B"
              NumberOfRequiredValues="9"
            >
              <ExpressionType>rank 2 tensor function</ExpressionType>
            </Double>
            <String
              Name="field name"
              NumberOfRequiredValues="1"
            />
            <Component Name="field source" NumberOfRequiredValues="1" Extensible="true">
              <Accepts>
                <Resource Name="smtk::model::Resource" Filter="volume"/>
                <Resource Name="smtk::mesh::Resource" Filter="any"/>
              </Accepts>
            </Component>

          </ChildrenDefinitions>
          <DiscreteInfo DefaultIndex="0">

            <Structure>
              <Value Enum="constant">constant</Value>
              <BriefDescription>
                  The deformation tensor is constant over space or
                  an analytical function of spatial coordinates.
              </BriefDescription>
              <Items><Item>b</Item></Items>
            </Structure>

            <Structure>
              <Value Enum="field">field</Value>
              <BriefDescription>
                  The deformation tensor is provided by field data
                  accompanying the model.
              </BriefDescription>
              <Items>
                <Item>field source</Item>
                <Item>field name</Item>
              </Items>
            </Structure>

          </DiscreteInfo>
        </String>
      </ItemDefinitions>

    </AttDef>

    <AttDef Type="material" BaseType="" Abstract="true">

        <AssociationsDef Name="anatomical volume" >
          <Accepts>
            <Resource Name="smtk::attribute::Resource" Filter="attribute[type='anatomical volume']"/>
          </Accepts>
        </AssociationsDef>

      <ItemDefinitions>
      </ItemDefinitions>

    </AttDef>

    <AttDef Type="solid" BaseType="material" Version="0" Unique="true">
      <ItemDefinitions>

        <!-- Solids have a density.  -->
        <Double
          Name="density"
          Label="ρ"
        >
          <BriefDescription>
            Density of the solid material (mass per unit volume).
          </BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Double>

        <!-- Solids have an initial strain.  -->
        <Double
          Name="initial strain"
          Label="ε0"
        >
          <BriefDescription>
            Initial strain of the material (length per unit length).
            This quantity is signed (negative in the case of compression).
          </BriefDescription>
        </Double>

      </ItemDefinitions>
    </AttDef>

    <AttDef Type="neo-hookean solid" BaseType="solid" Version="0" Unique="true">
      <BriefDescription>
        Neo-Hookean models only accumulate strain energy along
        the principal direction of the deformation tensor.
      </BriefDescription>
      <ItemDefinitions>

        <Component
          Name="strain tensor"
          Label="f"
          NumberOfRequiredValues="0"
          MaximumNumberOfValues="1"
          Extensible="true"
        >
          <BriefDescription>
            Anisotropic fiber orientation tensor.
          </BriefDescription>
          <Accepts>
            <Resource Name="smtk::attribute::Resource" Filter="attribute[type='cauchy-green deformation tensor']"/>
          </Accepts>
        </Component>

        <Double
          Name="c1"
          Label="C1"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

      </ItemDefinitions>
    </AttDef>

    <AttDef Type="mooney-rivlin solid" BaseType="neo-hookean solid" Version="0" Unique="true">
      <BriefDescription>
        Mooney-Rivlin solids accumulate strain energy along two
        highest principal directions of the deformation tensor.
      </BriefDescription>
      <ItemDefinitions>

        <Double
          Name="c2"
          Label="C2"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

      </ItemDefinitions>
    </AttDef>

    <AttDef Type="trans iso mooney-rivlin solid" BaseType="mooney-rivlin solid" Version="0" Unique="true">
      <ItemDefinitions>

        <Double
          Name="c3"
          Label="C3"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

        <Double
          Name="c4"
          Label="C4"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

        <Double
          Name="c5"
          Label="C5"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

        <Double
          Name="lambda max"
          Label="λ_max"
        >
          <RangeInfo>
            <Min Inclusive="true">0</Min>
          </RangeInfo>
        </Double>

      </ItemDefinitions>
    </AttDef>

  </Definitions>

  <Attributes>
  </Attributes>

</SMTK_AttributeResource>
