<?xml version="1.0"?>
<SMTK_AttributeResource Version="3">

  <Definitions>

    <!-- Many types of anatomical features exist, but they all inherit a common base. -->
    <AttDef Type="anatomical feature" BaseType="">
    </AttDef>

    <!-- Volumetric anatomical features are regions of space.
         This type of feature is usually a tissue but
         might also include cavities (e.g., nasal cavities).
         You may think of these features as labels that segment a volume.
      -->
    <AttDef Type="anatomical volume" BaseType="anatomical feature" Unique="true">

      <AssociationsDef Name="geometry" Extensible="true">
        <Accepts>
          <Resource Name="smtk::model::Resource" Filter="volume"/>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
          <Resource Name="smtk::session::mesh::Resource" Filter="*"/>
        </Accepts>
      </AssociationsDef>

    </AttDef>

    <AttDef Type="cavity" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002553</BriefDescription>
    </AttDef>

    <AttDef Type="implant" BaseType="anatomical volume">
      <!-- Note there is no uberon entry for implants. -->
      <BriefDescription> http://purl.obolibrary.org/obo/NCIT_C41075</BriefDescription>
    </AttDef>

    <AttDef Type="bone tissue" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002481</BriefDescription>
    </AttDef>

    <AttDef Type="cartilage tissue" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002418</BriefDescription>
    </AttDef>

    <AttDef Type="ligament" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000211</BriefDescription>
    </AttDef>

    <AttDef Type="muscle tissue" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002385</BriefDescription>
    </AttDef>

    <AttDef Type="tendon" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000043</BriefDescription>
    </AttDef>

    <AttDef Type="neural tissue" BaseType="anatomical volume">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0003714</BriefDescription>
    </AttDef>

    <!--
      Organs are collections of tissues in functional relationships.

      Organs may collect multiple types of tissue and may also include cavities.
      Organs also have relationships; these may be internal (i.e., between
      tissues and cavities collected within the organ) or external (i.e., with
      other organs and their constituents).
      -->
    <AttDef Type="organ" BaseType="anatomical feature" Unique="true">

      <AssociationsDef Name="tissues" NumberOfRequiredValues="1" Extensible="true">
        <Accepts>
          <Resource Name="smtk::mesh::Resource" Filter="*"/>
          <Resource Name="smtk::session::mesh::Resource" Filter="*"/>
          <!-- <Resource Name="smtk::attribute::Resource" Filter="attribute[type='tissue']"/ -->
        </Accepts>
      </AssociationsDef>

    </AttDef>

    <AttDef Type="femur" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000981</BriefDescription>
      <!--
        TODO: Femurs have (see https://en.wikipedia.org/wiki/File:Knee_diagram.svg):
        + a surface attachment between bone and articular cartilage
        + a (point/curve/surface?) attachement to the LCL, MCL, PCL, and ACL
        TODO: Should we create left and right femur instances? Just have an int/string item on the femur
        indicating which side of the median/midsagittal plane the femur lies?
        TODO: Should the femur contain both bone and articular cartilage?
      -->
    </AttDef>

    <AttDef Type="tibia" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000979</BriefDescription>
    </AttDef>

    <AttDef Type="fibula" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0001446</BriefDescription>
    </AttDef>

    <AttDef Type="patella" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0002446</BriefDescription>
    </AttDef>

    <AttDef Type="anterior cruciate ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0003671</BriefDescription>
    </AttDef>

    <AttDef Type="posterior cruciate ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0003680</BriefDescription>
    </AttDef>

    <AttDef Type="anterolateral ligament of knee" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0014899</BriefDescription>
    </AttDef>

    <AttDef Type="patellar ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0003676</BriefDescription>
    </AttDef>

    <!-- Uberon does not appear to have these ligaments (or they are named differently)
    <AttDef Type="medial collateral ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_xxxxxxx</BriefDescription>
    </AttDef>

    <AttDef Type="lateral collateral ligament" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_xxxxxxx</BriefDescription>
    </AttDef>
    -->

    <AttDef Type="quadriceps tendon" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0014848</BriefDescription>
    </AttDef>

    <AttDef Type="quadriceps femoris" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0001377</BriefDescription>
    </AttDef>

    <AttDef Type="femur cartilage element" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0010129</BriefDescription>
    </AttDef>

    <AttDef Type="patella cartilage element" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0012080</BriefDescription>
    </AttDef>

    <AttDef Type="meniscus" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_0000387</BriefDescription>
    </AttDef>

    <!-- Template for organ
    <AttDef Type="xxx" BaseType="organ">
      <BriefDescription>http://purl.obolibrary.org/obo/UBERON_xxxxxxx</BriefDescription>
    </AttDef>
    -->

  </Definitions>

  <Prerequisites>
    <!-- Individual bones must be labeled as bone tissue. -->
    <Rule Type="femur"><Def>bone tissue</Def></Rule>
    <Rule Type="fibula"><Def>bone tissue</Def></Rule>
    <Rule Type="tibia"><Def>bone tissue</Def></Rule>
    <Rule Type="patella"><Def>bone tissue</Def></Rule>

    <!-- Individual ligaments must be labeled as ligament. -->
    <Rule Type="anterior cruciate ligament"><Def>ligament</Def></Rule>
    <Rule Type="posterior cruciate ligament"><Def>ligament</Def></Rule>
    <Rule Type="anterolateral ligament of knee"><Def>ligament</Def></Rule>
    <Rule Type="patellar ligament"><Def>ligament</Def></Rule>

    <!-- Individual tendons must be labeled as tendon. -->
    <Rule Type="quadriceps tendon"><Def>tendon</Def></Rule>

    <!-- Individual muscles must be labeled as muscle tissue. -->
    <Rule Type="quadriceps femoris"><Def>muscle tissue</Def></Rule>

    <!-- Individual cartilage must be labeled as cartilage tissue. -->
    <Rule Type="femur cartilage element"><Def>cartilage tissue</Def></Rule>
    <Rule Type="meniscus"><Def>cartilage tissue</Def></Rule>
    <Rule Type="patella cartilage element"><Def>cartilage tissue</Def></Rule>

    <!-- Individual nerves must be labeled as neural tissue. -->
    <!-- Rule Type="xxx"><Def>neural tissue</Def></Rule -->
  </Prerequisites>

  <Attributes>
        <Att Name="bone tissue" Type="bone tissue" />
        <Att Name="muscle tissue" Type="muscle tissue" />
        <Att Name="cartilage tissue" Type="cartilage tissue" />
        <Att Name="ligament" Type="ligament" />
        <Att Name="tendon" Type="tendon" />
        <Att Name="neural tissue" Type="neural tissue" />

        <Att Name="anterior cruciate ligament, left" Type="anterior cruciate ligament"/>
        <Att Name="anterior cruciate ligament, right" Type="anterior cruciate ligament"/>
        <Att Name="anterolateral ligament of knee, left" Type="anterolateral ligament of knee"/>
        <Att Name="anterolateral ligament of knee, right" Type="anterolateral ligament of knee"/>
        <Att Name="femur, left" Type="femur"/>
        <Att Name="femur, right" Type="femur"/>
        <Att Name="femur cartilage element, left" Type="femur cartilage element"/>
        <Att Name="femur cartilage element, right" Type="femur cartilage element"/>
        <Att Name="fibula, left" Type="fibula"/>
        <Att Name="fibula, right" Type="fibula"/>
        <Att Name="meniscus, left" Type="meniscus"/>
        <Att Name="meniscus, right" Type="meniscus"/>
        <Att Name="patella, left" Type="patella"/>
        <Att Name="patella, right" Type="patella"/>
        <Att Name="patella cartilage element, left" Type="patella cartilage element"/>
        <Att Name="patella cartilage element, right" Type="patella cartilage element"/>
        <Att Name="patellar ligament, left" Type="patellar ligament"/>
        <Att Name="patellar ligament, right" Type="patellar ligament"/>
        <Att Name="posterior cruciate ligament, left" Type="posterior cruciate ligament"/>
        <Att Name="posterior cruciate ligament, right" Type="posterior cruciate ligament"/>
        <Att Name="quadriceps tendon, left" Type="quadriceps tendon"/>
        <Att Name="quadriceps tendon, right" Type="quadriceps tendon"/>
        <Att Name="quadriceps femoris, left" Type="quadriceps femoris"/>
        <Att Name="quadriceps femoris, right" Type="quadriceps femoris"/>
        <Att Name="tibia, left" Type="tibia"/>
        <Att Name="tibia, right" Type="tibia"/>
  </Attributes>

</SMTK_AttributeResource>
