/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmUtilitySourceCommand_h
#define cmUtilitySourceCommand_h

#include <cmConfigure.h>
#include <string>
#include <vector>

#include "cmCommand.h"
#include "cmTypeMacro.h"

class cmExecutionStatus;

class cmUtilitySourceCommand : public cmCommand
{
public:
  cmCommand* Clone() CM_OVERRIDE { return new cmUtilitySourceCommand; }
  bool InitialPass(std::vector<std::string> const& args,
                   cmExecutionStatus& status) CM_OVERRIDE;
  std::string GetName() const CM_OVERRIDE { return "utility_source"; }
};

#endif
