cmake_minimum_required(VERSION 3.1 FATAL_ERROR)

include(RunCMake)
include("${RunCMake_SOURCE_DIR}/CPackTestHelpers.cmake")

# run_cpack_test args: TEST_NAME "GENERATORS" RUN_CMAKE_BUILD_STEP "PACKAGING_TYPES"
run_cpack_test(CUSTOM_NAMES "RPM;DEB" true "COMPONENT")
run_cpack_test(DEBUGINFO "RPM" true "COMPONENT")
run_cpack_test(DEPENDENCIES "RPM;DEB" true "COMPONENT")
run_cpack_test(DIST "RPM" false "MONOLITHIC")
run_cpack_test(EMPTY_DIR "RPM;DEB;TGZ" true "MONOLITHIC;COMPONENT")
run_cpack_test(EXTRA "DEB" false "COMPONENT")
run_cpack_test(GENERATE_SHLIBS "DEB" true "COMPONENT")
run_cpack_test(GENERATE_SHLIBS_LDCONFIG "DEB" true "COMPONENT")
run_cpack_test(INSTALL_SCRIPTS "RPM" false "COMPONENT")
run_cpack_test(LONG_FILENAMES "DEB" false "MONOLITHIC")
run_cpack_test_subtests(MAIN_COMPONENT "invalid;found" "RPM" false "COMPONENT")
run_cpack_test(MINIMAL "RPM;DEB;TGZ" false "MONOLITHIC")
run_cpack_test_subtests(PACKAGE_CHECKSUM "invalid;MD5;SHA1;SHA224;SHA256;SHA384;SHA512" "TGZ" false "MONOLITHIC")
run_cpack_test(PARTIALLY_RELOCATABLE_WARNING "RPM" false "COMPONENT")
run_cpack_test(PER_COMPONENT_FIELDS "RPM;DEB" false "COMPONENT")
run_cpack_test_subtests(SINGLE_DEBUGINFO "no_main_component;one_component;one_component_main;no_debuginfo;one_component_no_debuginfo;no_components;valid" "RPM" true "CUSTOM")
run_cpack_source_test(SOURCE_PACKAGE "RPM")
run_cpack_test(SUGGESTS "RPM" false "MONOLITHIC")
