include(RunCMake)

run_cmake(BadSourceExpression1)
run_cmake(BadSourceExpression2)
run_cmake(BadSourceExpression3)
run_cmake(BadObjSource1)
run_cmake(BadObjSource2)
run_cmake(Export)
run_cmake(Import)
run_cmake(Install)
run_cmake(LinkObjLHS)
run_cmake(LinkObjRHS1)
run_cmake(LinkObjRHS2)
run_cmake(MissingSource)
run_cmake(ObjWithObj)
run_cmake(PostBuild)
run_cmake(PreBuild)
run_cmake(PreLink)

function(run_Dependencies)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/Dependencies-build)
  set(RunCMake_TEST_NO_CLEAN 1)

  file(REMOVE_RECURSE "${RunCMake_TEST_BINARY_DIR}")
  file(MAKE_DIRECTORY "${RunCMake_TEST_BINARY_DIR}")

  if(RunCMake_GENERATOR STREQUAL "Borland Makefiles" OR
      RunCMake_GENERATOR STREQUAL "Watcom WMake")
    set(fs_delay 3)
  else()
    set(fs_delay 1.125)
  endif()

  run_cmake_command(Dependencies-build ${CMAKE_COMMAND} -E copy ${RunCMake_SOURCE_DIR}/depends_obj1.c ${RunCMake_TEST_BINARY_DIR}/depends_obj.c)
  run_cmake(Dependencies)
  run_cmake_command(Dependencies-build ${CMAKE_COMMAND} --build . --config Debug)
  run_cmake_command(Dependencies-build ${CMAKE_COMMAND} -E sleep ${fs_delay})
  run_cmake_command(Dependencies-build ${CMAKE_COMMAND} -E copy ${RunCMake_SOURCE_DIR}/depends_obj0.c ${RunCMake_TEST_BINARY_DIR}/depends_obj.c)
  run_cmake_command(Dependencies-build ${CMAKE_COMMAND} --build . --config Debug)
  run_cmake_command(Dependencies-build ${CMAKE_CTEST_COMMAND} -C Debug -V)
endfunction()

run_Dependencies()
