/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCPackIFWCommon.h"

#include "cmCPackGenerator.h"
#include "cmCPackIFWGenerator.h"
#include "cmCPackLog.h" // IWYU pragma: keep
#include "cmSystemTools.h"
#include "cmTimestamp.h"
#include "cmVersionConfig.h"
#include "cmXMLWriter.h"

#include <sstream>

cmCPackIFWCommon::cmCPackIFWCommon()
  : Generator(CM_NULLPTR)
{
}

const char* cmCPackIFWCommon::GetOption(const std::string& op) const
{
  return this->Generator ? this->Generator->cmCPackGenerator::GetOption(op)
                         : CM_NULLPTR;
}

bool cmCPackIFWCommon::IsOn(const std::string& op) const
{
  return this->Generator ? this->Generator->cmCPackGenerator::IsOn(op) : false;
}

bool cmCPackIFWCommon::IsSetToOff(const std::string& op) const
{
  return this->Generator ? this->Generator->cmCPackGenerator::IsSetToOff(op)
                         : false;
}

bool cmCPackIFWCommon::IsSetToEmpty(const std::string& op) const
{
  return this->Generator ? this->Generator->cmCPackGenerator::IsSetToEmpty(op)
                         : false;
}

bool cmCPackIFWCommon::IsVersionLess(const char* version)
{
  if (!this->Generator) {
    return false;
  }

  return cmSystemTools::VersionCompare(
    cmSystemTools::OP_LESS, this->Generator->FrameworkVersion.data(), version);
}

bool cmCPackIFWCommon::IsVersionGreater(const char* version)
{
  if (!this->Generator) {
    return false;
  }

  return cmSystemTools::VersionCompare(
    cmSystemTools::OP_GREATER, this->Generator->FrameworkVersion.data(),
    version);
}

bool cmCPackIFWCommon::IsVersionEqual(const char* version)
{
  if (!this->Generator) {
    return false;
  }

  return cmSystemTools::VersionCompare(
    cmSystemTools::OP_EQUAL, this->Generator->FrameworkVersion.data(),
    version);
}

void cmCPackIFWCommon::WriteGeneratedByToStrim(cmXMLWriter& xout)
{
  if (!this->Generator) {
    return;
  }

  std::ostringstream comment;
  comment << "Generated by CPack " << CMake_VERSION << " IFW generator "
          << "for QtIFW ";
  if (this->IsVersionEqual("1.9.9")) {
    comment << "less 2.0";
  } else {
    comment << this->Generator->FrameworkVersion;
  }
  comment << " tools at " << cmTimestamp().CurrentTime("", true);
  xout.Comment(comment.str().c_str());
}
