// ***************************************************************************
//
// Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit;

import java.util.Vector;
import java.lang.Integer;
import java.lang.Double;

// ****************************************************************************
// Class: PickAttributes
//
// Purpose:
//    This class contains attributes used for pick.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class PickAttributes extends AttributeSubject
{
    private static int PickAttributes_numAdditionalAtts = 77;

    // Enum values
    public final static int PICKTYPE_ZONE = 0;
    public final static int PICKTYPE_NODE = 1;
    public final static int PICKTYPE_CURVEZONE = 2;
    public final static int PICKTYPE_CURVENODE = 3;
    public final static int PICKTYPE_DOMAINZONE = 4;
    public final static int PICKTYPE_DOMAINNODE = 5;
    public final static int PICKTYPE_ZONELABEL = 6;
    public final static int PICKTYPE_NODELABEL = 7;

    public final static int COORDINATETYPE_XY = 0;
    public final static int COORDINATETYPE_RZ = 1;
    public final static int COORDINATETYPE_ZR = 2;

    public final static int TIMECURVETYPE_SINGLE_Y_AXIS = 0;
    public final static int TIMECURVETYPE_MULTIPLE_Y_AXES = 1;


    public PickAttributes()
    {
        super(PickAttributes_numAdditionalAtts);

        variables = new Vector();
        variables.addElement(new String("default"));
        showIncidentElements = true;
        showNodeId = true;
        showNodeDomainLogicalCoords = false;
        showNodeBlockLogicalCoords = false;
        showNodePhysicalCoords = false;
        showZoneId = true;
        showZoneDomainLogicalCoords = false;
        showZoneBlockLogicalCoords = false;
        clearWindow = false;
        pickLetter = new String("");
        fulfilled = false;
        pickType = PICKTYPE_ZONE;
        domain = -1;
        elementNumber = -1;
        incidentElements = new Vector();
        cellCoordinates = new Vector();
        timeStep = -1;
        dimension = -1;
        databaseName = new String("");
        activeVariable = new String("");
        pickPoint = new double[3];
        pickPoint[0] = 0;
        pickPoint[1] = 0;
        pickPoint[2] = 0;
        cellPoint = new double[3];
        cellPoint[0] = 0;
        cellPoint[1] = 0;
        cellPoint[2] = 0;
        nodePoint = new double[3];
        nodePoint[0] = 0;
        nodePoint[1] = 0;
        nodePoint[2] = 0;
        plotBounds = new Vector();
        rayPoint1 = new double[3];
        rayPoint1[0] = 0;
        rayPoint1[1] = 0;
        rayPoint1[2] = 0;
        rayPoint2 = new double[3];
        rayPoint2[0] = 0;
        rayPoint2[1] = 0;
        rayPoint2[2] = 0;
        meshInfo = new String("");
        realElementNumber = -1;
        realIncidentElements = new Vector();
        pnodeCoords = new Vector();
        dnodeCoords = new Vector();
        bnodeCoords = new Vector();
        dzoneCoords = new Vector();
        bzoneCoords = new Vector();
        needTransformMessage = false;
        varInfo = new Vector();
        invalidVars = new Vector();
        doTimeCurve = false;
        errorMessage = new String("");
        error = false;
        matSelected = false;
        needActualCoords = false;
        conciseOutput = false;
        showTimeStep = true;
        showMeshName = true;
        blockPieceName = new String("");
        groupPieceName = new String("");
        ghosts = new Vector();
        includeGhosts = false;
        elementIsGhost = false;
        requiresGlyphPick = false;
        locationSuccessful = false;
        useLabelAsPickLetter = false;
        showGlobalIds = false;
        globalElement = -1;
        globalIncidentElements = new Vector();
        elementIsGlobal = false;
        showPickLetter = true;
        hasRangeOutput = false;
        rangeOutput = new MapNode();
        elementLabel = new String("");
        reusePickLetter = false;
        ghostType = 0;
        hasMixedGhostTypes = -1;
        linesData = false;
        showPickHighlight = false;
        notifyEnabled = true;
        inputTopoDim = -1;
        meshCoordType = COORDINATETYPE_XY;
        createSpreadsheet = false;
        subsetName = new String("");
        floatFormat = new String("%g");
        timePreserveCoord = true;
        timeCurveType = TIMECURVETYPE_SINGLE_Y_AXIS;
        timeOptions = new MapNode();
        plotRequested = new MapNode();
    }

    public PickAttributes(int nMoreFields)
    {
        super(PickAttributes_numAdditionalAtts + nMoreFields);

        variables = new Vector();
        variables.addElement(new String("default"));
        showIncidentElements = true;
        showNodeId = true;
        showNodeDomainLogicalCoords = false;
        showNodeBlockLogicalCoords = false;
        showNodePhysicalCoords = false;
        showZoneId = true;
        showZoneDomainLogicalCoords = false;
        showZoneBlockLogicalCoords = false;
        clearWindow = false;
        pickLetter = new String("");
        fulfilled = false;
        pickType = PICKTYPE_ZONE;
        domain = -1;
        elementNumber = -1;
        incidentElements = new Vector();
        cellCoordinates = new Vector();
        timeStep = -1;
        dimension = -1;
        databaseName = new String("");
        activeVariable = new String("");
        pickPoint = new double[3];
        pickPoint[0] = 0;
        pickPoint[1] = 0;
        pickPoint[2] = 0;
        cellPoint = new double[3];
        cellPoint[0] = 0;
        cellPoint[1] = 0;
        cellPoint[2] = 0;
        nodePoint = new double[3];
        nodePoint[0] = 0;
        nodePoint[1] = 0;
        nodePoint[2] = 0;
        plotBounds = new Vector();
        rayPoint1 = new double[3];
        rayPoint1[0] = 0;
        rayPoint1[1] = 0;
        rayPoint1[2] = 0;
        rayPoint2 = new double[3];
        rayPoint2[0] = 0;
        rayPoint2[1] = 0;
        rayPoint2[2] = 0;
        meshInfo = new String("");
        realElementNumber = -1;
        realIncidentElements = new Vector();
        pnodeCoords = new Vector();
        dnodeCoords = new Vector();
        bnodeCoords = new Vector();
        dzoneCoords = new Vector();
        bzoneCoords = new Vector();
        needTransformMessage = false;
        varInfo = new Vector();
        invalidVars = new Vector();
        doTimeCurve = false;
        errorMessage = new String("");
        error = false;
        matSelected = false;
        needActualCoords = false;
        conciseOutput = false;
        showTimeStep = true;
        showMeshName = true;
        blockPieceName = new String("");
        groupPieceName = new String("");
        ghosts = new Vector();
        includeGhosts = false;
        elementIsGhost = false;
        requiresGlyphPick = false;
        locationSuccessful = false;
        useLabelAsPickLetter = false;
        showGlobalIds = false;
        globalElement = -1;
        globalIncidentElements = new Vector();
        elementIsGlobal = false;
        showPickLetter = true;
        hasRangeOutput = false;
        rangeOutput = new MapNode();
        elementLabel = new String("");
        reusePickLetter = false;
        ghostType = 0;
        hasMixedGhostTypes = -1;
        linesData = false;
        showPickHighlight = false;
        notifyEnabled = true;
        inputTopoDim = -1;
        meshCoordType = COORDINATETYPE_XY;
        createSpreadsheet = false;
        subsetName = new String("");
        floatFormat = new String("%g");
        timePreserveCoord = true;
        timeCurveType = TIMECURVETYPE_SINGLE_Y_AXIS;
        timeOptions = new MapNode();
        plotRequested = new MapNode();
    }

    public PickAttributes(PickAttributes obj)
    {
        super(obj);

        int i;

        variables = new Vector(obj.variables.size());
        for(i = 0; i < obj.variables.size(); ++i)
            variables.addElement(new String((String)obj.variables.elementAt(i)));

        showIncidentElements = obj.showIncidentElements;
        showNodeId = obj.showNodeId;
        showNodeDomainLogicalCoords = obj.showNodeDomainLogicalCoords;
        showNodeBlockLogicalCoords = obj.showNodeBlockLogicalCoords;
        showNodePhysicalCoords = obj.showNodePhysicalCoords;
        showZoneId = obj.showZoneId;
        showZoneDomainLogicalCoords = obj.showZoneDomainLogicalCoords;
        showZoneBlockLogicalCoords = obj.showZoneBlockLogicalCoords;
        clearWindow = obj.clearWindow;
        pickLetter = new String(obj.pickLetter);
        fulfilled = obj.fulfilled;
        pickType = obj.pickType;
        domain = obj.domain;
        elementNumber = obj.elementNumber;
        incidentElements = new Vector();
        for(i = 0; i < obj.incidentElements.size(); ++i)
        {
            Integer iv = (Integer)obj.incidentElements.elementAt(i);
            incidentElements.addElement(new Integer(iv.intValue()));
        }
        cellCoordinates = new Vector(obj.cellCoordinates.size());
        for(i = 0; i < obj.cellCoordinates.size(); ++i)
        {
            Double dv = (Double)obj.cellCoordinates.elementAt(i);
            cellCoordinates.addElement(new Double(dv.doubleValue()));
        }

        timeStep = obj.timeStep;
        dimension = obj.dimension;
        databaseName = new String(obj.databaseName);
        activeVariable = new String(obj.activeVariable);
        pickPoint = new double[3];
        pickPoint[0] = obj.pickPoint[0];
        pickPoint[1] = obj.pickPoint[1];
        pickPoint[2] = obj.pickPoint[2];

        cellPoint = new double[3];
        cellPoint[0] = obj.cellPoint[0];
        cellPoint[1] = obj.cellPoint[1];
        cellPoint[2] = obj.cellPoint[2];

        nodePoint = new double[3];
        nodePoint[0] = obj.nodePoint[0];
        nodePoint[1] = obj.nodePoint[1];
        nodePoint[2] = obj.nodePoint[2];

        plotBounds = new Vector(obj.plotBounds.size());
        for(i = 0; i < obj.plotBounds.size(); ++i)
        {
            Double dv = (Double)obj.plotBounds.elementAt(i);
            plotBounds.addElement(new Double(dv.doubleValue()));
        }

        rayPoint1 = new double[3];
        rayPoint1[0] = obj.rayPoint1[0];
        rayPoint1[1] = obj.rayPoint1[1];
        rayPoint1[2] = obj.rayPoint1[2];

        rayPoint2 = new double[3];
        rayPoint2[0] = obj.rayPoint2[0];
        rayPoint2[1] = obj.rayPoint2[1];
        rayPoint2[2] = obj.rayPoint2[2];

        meshInfo = new String(obj.meshInfo);
        realElementNumber = obj.realElementNumber;
        realIncidentElements = new Vector();
        for(i = 0; i < obj.realIncidentElements.size(); ++i)
        {
            Integer iv = (Integer)obj.realIncidentElements.elementAt(i);
            realIncidentElements.addElement(new Integer(iv.intValue()));
        }
        pnodeCoords = new Vector(obj.pnodeCoords.size());
        for(i = 0; i < obj.pnodeCoords.size(); ++i)
            pnodeCoords.addElement(new String((String)obj.pnodeCoords.elementAt(i)));

        dnodeCoords = new Vector(obj.dnodeCoords.size());
        for(i = 0; i < obj.dnodeCoords.size(); ++i)
            dnodeCoords.addElement(new String((String)obj.dnodeCoords.elementAt(i)));

        bnodeCoords = new Vector(obj.bnodeCoords.size());
        for(i = 0; i < obj.bnodeCoords.size(); ++i)
            bnodeCoords.addElement(new String((String)obj.bnodeCoords.elementAt(i)));

        dzoneCoords = new Vector(obj.dzoneCoords.size());
        for(i = 0; i < obj.dzoneCoords.size(); ++i)
            dzoneCoords.addElement(new String((String)obj.dzoneCoords.elementAt(i)));

        bzoneCoords = new Vector(obj.bzoneCoords.size());
        for(i = 0; i < obj.bzoneCoords.size(); ++i)
            bzoneCoords.addElement(new String((String)obj.bzoneCoords.elementAt(i)));

        needTransformMessage = obj.needTransformMessage;
        // *** Copy the varInfo field ***
        varInfo = new Vector(obj.varInfo.size());
        for(i = 0; i < obj.varInfo.size(); ++i)
        {
            PickVarInfo oldObj = (PickVarInfo)obj.varInfo.elementAt(i);
            varInfo.addElement(new PickVarInfo(oldObj));
        }

        invalidVars = new Vector(obj.invalidVars.size());
        for(i = 0; i < obj.invalidVars.size(); ++i)
            invalidVars.addElement(new String((String)obj.invalidVars.elementAt(i)));

        doTimeCurve = obj.doTimeCurve;
        errorMessage = new String(obj.errorMessage);
        error = obj.error;
        matSelected = obj.matSelected;
        needActualCoords = obj.needActualCoords;
        conciseOutput = obj.conciseOutput;
        showTimeStep = obj.showTimeStep;
        showMeshName = obj.showMeshName;
        blockPieceName = new String(obj.blockPieceName);
        groupPieceName = new String(obj.groupPieceName);
        ghosts = new Vector();
        for(i = 0; i < obj.ghosts.size(); ++i)
        {
            Integer iv = (Integer)obj.ghosts.elementAt(i);
            ghosts.addElement(new Integer(iv.intValue()));
        }
        includeGhosts = obj.includeGhosts;
        elementIsGhost = obj.elementIsGhost;
        requiresGlyphPick = obj.requiresGlyphPick;
        locationSuccessful = obj.locationSuccessful;
        useLabelAsPickLetter = obj.useLabelAsPickLetter;
        showGlobalIds = obj.showGlobalIds;
        globalElement = obj.globalElement;
        globalIncidentElements = new Vector();
        for(i = 0; i < obj.globalIncidentElements.size(); ++i)
        {
            Integer iv = (Integer)obj.globalIncidentElements.elementAt(i);
            globalIncidentElements.addElement(new Integer(iv.intValue()));
        }
        elementIsGlobal = obj.elementIsGlobal;
        showPickLetter = obj.showPickLetter;
        hasRangeOutput = obj.hasRangeOutput;
        rangeOutput = new MapNode(obj.rangeOutput);
        elementLabel = new String(obj.elementLabel);
        reusePickLetter = obj.reusePickLetter;
        ghostType = obj.ghostType;
        hasMixedGhostTypes = obj.hasMixedGhostTypes;
        linesData = obj.linesData;
        showPickHighlight = obj.showPickHighlight;
        notifyEnabled = obj.notifyEnabled;
        inputTopoDim = obj.inputTopoDim;
        meshCoordType = obj.meshCoordType;
        createSpreadsheet = obj.createSpreadsheet;
        subsetName = new String(obj.subsetName);
        floatFormat = new String(obj.floatFormat);
        timePreserveCoord = obj.timePreserveCoord;
        timeCurveType = obj.timeCurveType;
        timeOptions = new MapNode(obj.timeOptions);
        plotRequested = new MapNode(obj.plotRequested);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return PickAttributes_numAdditionalAtts;
    }

    public boolean equals(PickAttributes obj)
    {
        int i;

        // Compare the elements in the variables vector.
        boolean variables_equal = (obj.variables.size() == variables.size());
        for(i = 0; (i < variables.size()) && variables_equal; ++i)
        {
            // Make references to String from Object.
            String variables1 = (String)variables.elementAt(i);
            String variables2 = (String)obj.variables.elementAt(i);
            variables_equal = variables1.equals(variables2);
        }
        // Compare the elements in the incidentElements vector.
        boolean incidentElements_equal = (obj.incidentElements.size() == incidentElements.size());
        for(i = 0; (i < incidentElements.size()) && incidentElements_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer incidentElements1 = (Integer)incidentElements.elementAt(i);
            Integer incidentElements2 = (Integer)obj.incidentElements.elementAt(i);
            incidentElements_equal = incidentElements1.equals(incidentElements2);
        }
        // Compare the elements in the cellCoordinates vector.
        boolean cellCoordinates_equal = (obj.cellCoordinates.size() == cellCoordinates.size());
        for(i = 0; (i < cellCoordinates.size()) && cellCoordinates_equal; ++i)
        {
            // Make references to Double from Object.
            Double cellCoordinates1 = (Double)cellCoordinates.elementAt(i);
            Double cellCoordinates2 = (Double)obj.cellCoordinates.elementAt(i);
            cellCoordinates_equal = cellCoordinates1.equals(cellCoordinates2);
        }
        // Compare the pickPoint arrays.
        boolean pickPoint_equal = true;
        for(i = 0; i < 3 && pickPoint_equal; ++i)
            pickPoint_equal = (pickPoint[i] == obj.pickPoint[i]);

        // Compare the cellPoint arrays.
        boolean cellPoint_equal = true;
        for(i = 0; i < 3 && cellPoint_equal; ++i)
            cellPoint_equal = (cellPoint[i] == obj.cellPoint[i]);

        // Compare the nodePoint arrays.
        boolean nodePoint_equal = true;
        for(i = 0; i < 3 && nodePoint_equal; ++i)
            nodePoint_equal = (nodePoint[i] == obj.nodePoint[i]);

        // Compare the elements in the plotBounds vector.
        boolean plotBounds_equal = (obj.plotBounds.size() == plotBounds.size());
        for(i = 0; (i < plotBounds.size()) && plotBounds_equal; ++i)
        {
            // Make references to Double from Object.
            Double plotBounds1 = (Double)plotBounds.elementAt(i);
            Double plotBounds2 = (Double)obj.plotBounds.elementAt(i);
            plotBounds_equal = plotBounds1.equals(plotBounds2);
        }
        // Compare the rayPoint1 arrays.
        boolean rayPoint1_equal = true;
        for(i = 0; i < 3 && rayPoint1_equal; ++i)
            rayPoint1_equal = (rayPoint1[i] == obj.rayPoint1[i]);

        // Compare the rayPoint2 arrays.
        boolean rayPoint2_equal = true;
        for(i = 0; i < 3 && rayPoint2_equal; ++i)
            rayPoint2_equal = (rayPoint2[i] == obj.rayPoint2[i]);

        // Compare the elements in the realIncidentElements vector.
        boolean realIncidentElements_equal = (obj.realIncidentElements.size() == realIncidentElements.size());
        for(i = 0; (i < realIncidentElements.size()) && realIncidentElements_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer realIncidentElements1 = (Integer)realIncidentElements.elementAt(i);
            Integer realIncidentElements2 = (Integer)obj.realIncidentElements.elementAt(i);
            realIncidentElements_equal = realIncidentElements1.equals(realIncidentElements2);
        }
        // Compare the elements in the pnodeCoords vector.
        boolean pnodeCoords_equal = (obj.pnodeCoords.size() == pnodeCoords.size());
        for(i = 0; (i < pnodeCoords.size()) && pnodeCoords_equal; ++i)
        {
            // Make references to String from Object.
            String pnodeCoords1 = (String)pnodeCoords.elementAt(i);
            String pnodeCoords2 = (String)obj.pnodeCoords.elementAt(i);
            pnodeCoords_equal = pnodeCoords1.equals(pnodeCoords2);
        }
        // Compare the elements in the dnodeCoords vector.
        boolean dnodeCoords_equal = (obj.dnodeCoords.size() == dnodeCoords.size());
        for(i = 0; (i < dnodeCoords.size()) && dnodeCoords_equal; ++i)
        {
            // Make references to String from Object.
            String dnodeCoords1 = (String)dnodeCoords.elementAt(i);
            String dnodeCoords2 = (String)obj.dnodeCoords.elementAt(i);
            dnodeCoords_equal = dnodeCoords1.equals(dnodeCoords2);
        }
        // Compare the elements in the bnodeCoords vector.
        boolean bnodeCoords_equal = (obj.bnodeCoords.size() == bnodeCoords.size());
        for(i = 0; (i < bnodeCoords.size()) && bnodeCoords_equal; ++i)
        {
            // Make references to String from Object.
            String bnodeCoords1 = (String)bnodeCoords.elementAt(i);
            String bnodeCoords2 = (String)obj.bnodeCoords.elementAt(i);
            bnodeCoords_equal = bnodeCoords1.equals(bnodeCoords2);
        }
        // Compare the elements in the dzoneCoords vector.
        boolean dzoneCoords_equal = (obj.dzoneCoords.size() == dzoneCoords.size());
        for(i = 0; (i < dzoneCoords.size()) && dzoneCoords_equal; ++i)
        {
            // Make references to String from Object.
            String dzoneCoords1 = (String)dzoneCoords.elementAt(i);
            String dzoneCoords2 = (String)obj.dzoneCoords.elementAt(i);
            dzoneCoords_equal = dzoneCoords1.equals(dzoneCoords2);
        }
        // Compare the elements in the bzoneCoords vector.
        boolean bzoneCoords_equal = (obj.bzoneCoords.size() == bzoneCoords.size());
        for(i = 0; (i < bzoneCoords.size()) && bzoneCoords_equal; ++i)
        {
            // Make references to String from Object.
            String bzoneCoords1 = (String)bzoneCoords.elementAt(i);
            String bzoneCoords2 = (String)obj.bzoneCoords.elementAt(i);
            bzoneCoords_equal = bzoneCoords1.equals(bzoneCoords2);
        }
        // Compare the elements in the varInfo vector.
        boolean varInfo_equal = (obj.varInfo.size() == varInfo.size());
        for(i = 0; (i < varInfo.size()) && varInfo_equal; ++i)
        {
            // Make references to PickVarInfo from Object.
            PickVarInfo varInfo1 = (PickVarInfo)varInfo.elementAt(i);
            PickVarInfo varInfo2 = (PickVarInfo)obj.varInfo.elementAt(i);
            varInfo_equal = varInfo1.equals(varInfo2);
        }
        // Compare the elements in the invalidVars vector.
        boolean invalidVars_equal = (obj.invalidVars.size() == invalidVars.size());
        for(i = 0; (i < invalidVars.size()) && invalidVars_equal; ++i)
        {
            // Make references to String from Object.
            String invalidVars1 = (String)invalidVars.elementAt(i);
            String invalidVars2 = (String)obj.invalidVars.elementAt(i);
            invalidVars_equal = invalidVars1.equals(invalidVars2);
        }
        // Compare the elements in the ghosts vector.
        boolean ghosts_equal = (obj.ghosts.size() == ghosts.size());
        for(i = 0; (i < ghosts.size()) && ghosts_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer ghosts1 = (Integer)ghosts.elementAt(i);
            Integer ghosts2 = (Integer)obj.ghosts.elementAt(i);
            ghosts_equal = ghosts1.equals(ghosts2);
        }
        // Compare the elements in the globalIncidentElements vector.
        boolean globalIncidentElements_equal = (obj.globalIncidentElements.size() == globalIncidentElements.size());
        for(i = 0; (i < globalIncidentElements.size()) && globalIncidentElements_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer globalIncidentElements1 = (Integer)globalIncidentElements.elementAt(i);
            Integer globalIncidentElements2 = (Integer)obj.globalIncidentElements.elementAt(i);
            globalIncidentElements_equal = globalIncidentElements1.equals(globalIncidentElements2);
        }
        // Create the return value
        return (variables_equal &&
                (showIncidentElements == obj.showIncidentElements) &&
                (showNodeId == obj.showNodeId) &&
                (showNodeDomainLogicalCoords == obj.showNodeDomainLogicalCoords) &&
                (showNodeBlockLogicalCoords == obj.showNodeBlockLogicalCoords) &&
                (showNodePhysicalCoords == obj.showNodePhysicalCoords) &&
                (showZoneId == obj.showZoneId) &&
                (showZoneDomainLogicalCoords == obj.showZoneDomainLogicalCoords) &&
                (showZoneBlockLogicalCoords == obj.showZoneBlockLogicalCoords) &&
                (clearWindow == obj.clearWindow) &&
                (pickLetter.equals(obj.pickLetter)) &&
                (fulfilled == obj.fulfilled) &&
                (pickType == obj.pickType) &&
                (domain == obj.domain) &&
                (elementNumber == obj.elementNumber) &&
                incidentElements_equal &&
                cellCoordinates_equal &&
                (timeStep == obj.timeStep) &&
                (dimension == obj.dimension) &&
                (databaseName.equals(obj.databaseName)) &&
                (activeVariable.equals(obj.activeVariable)) &&
                pickPoint_equal &&
                cellPoint_equal &&
                nodePoint_equal &&
                plotBounds_equal &&
                rayPoint1_equal &&
                rayPoint2_equal &&
                (meshInfo.equals(obj.meshInfo)) &&
                (realElementNumber == obj.realElementNumber) &&
                realIncidentElements_equal &&
                pnodeCoords_equal &&
                dnodeCoords_equal &&
                bnodeCoords_equal &&
                dzoneCoords_equal &&
                bzoneCoords_equal &&
                (needTransformMessage == obj.needTransformMessage) &&
                varInfo_equal &&
                invalidVars_equal &&
                (doTimeCurve == obj.doTimeCurve) &&
                (errorMessage.equals(obj.errorMessage)) &&
                (error == obj.error) &&
                (matSelected == obj.matSelected) &&
                (needActualCoords == obj.needActualCoords) &&
                (conciseOutput == obj.conciseOutput) &&
                (showTimeStep == obj.showTimeStep) &&
                (showMeshName == obj.showMeshName) &&
                (blockPieceName.equals(obj.blockPieceName)) &&
                (groupPieceName.equals(obj.groupPieceName)) &&
                ghosts_equal &&
                (includeGhosts == obj.includeGhosts) &&
                (elementIsGhost == obj.elementIsGhost) &&
                (requiresGlyphPick == obj.requiresGlyphPick) &&
                (locationSuccessful == obj.locationSuccessful) &&
                (useLabelAsPickLetter == obj.useLabelAsPickLetter) &&
                (showGlobalIds == obj.showGlobalIds) &&
                (globalElement == obj.globalElement) &&
                globalIncidentElements_equal &&
                (elementIsGlobal == obj.elementIsGlobal) &&
                (showPickLetter == obj.showPickLetter) &&
                (hasRangeOutput == obj.hasRangeOutput) &&
                (rangeOutput.equals(obj.rangeOutput)) &&
                (elementLabel.equals(obj.elementLabel)) &&
                (reusePickLetter == obj.reusePickLetter) &&
                (ghostType == obj.ghostType) &&
                (hasMixedGhostTypes == obj.hasMixedGhostTypes) &&
                (linesData == obj.linesData) &&
                (showPickHighlight == obj.showPickHighlight) &&
                (notifyEnabled == obj.notifyEnabled) &&
                (inputTopoDim == obj.inputTopoDim) &&
                (meshCoordType == obj.meshCoordType) &&
                (createSpreadsheet == obj.createSpreadsheet) &&
                (subsetName.equals(obj.subsetName)) &&
                (floatFormat.equals(obj.floatFormat)) &&
                (timePreserveCoord == obj.timePreserveCoord) &&
                (timeCurveType == obj.timeCurveType) &&
                (timeOptions.equals(obj.timeOptions)) &&
                (plotRequested.equals(obj.plotRequested)));
    }

    // Property setting methods
    public void SetVariables(Vector variables_)
    {
        variables = variables_;
        Select(0);
    }

    public void SetShowIncidentElements(boolean showIncidentElements_)
    {
        showIncidentElements = showIncidentElements_;
        Select(1);
    }

    public void SetShowNodeId(boolean showNodeId_)
    {
        showNodeId = showNodeId_;
        Select(2);
    }

    public void SetShowNodeDomainLogicalCoords(boolean showNodeDomainLogicalCoords_)
    {
        showNodeDomainLogicalCoords = showNodeDomainLogicalCoords_;
        Select(3);
    }

    public void SetShowNodeBlockLogicalCoords(boolean showNodeBlockLogicalCoords_)
    {
        showNodeBlockLogicalCoords = showNodeBlockLogicalCoords_;
        Select(4);
    }

    public void SetShowNodePhysicalCoords(boolean showNodePhysicalCoords_)
    {
        showNodePhysicalCoords = showNodePhysicalCoords_;
        Select(5);
    }

    public void SetShowZoneId(boolean showZoneId_)
    {
        showZoneId = showZoneId_;
        Select(6);
    }

    public void SetShowZoneDomainLogicalCoords(boolean showZoneDomainLogicalCoords_)
    {
        showZoneDomainLogicalCoords = showZoneDomainLogicalCoords_;
        Select(7);
    }

    public void SetShowZoneBlockLogicalCoords(boolean showZoneBlockLogicalCoords_)
    {
        showZoneBlockLogicalCoords = showZoneBlockLogicalCoords_;
        Select(8);
    }

    public void SetClearWindow(boolean clearWindow_)
    {
        clearWindow = clearWindow_;
        Select(9);
    }

    public void SetPickLetter(String pickLetter_)
    {
        pickLetter = pickLetter_;
        Select(10);
    }

    public void SetFulfilled(boolean fulfilled_)
    {
        fulfilled = fulfilled_;
        Select(11);
    }

    public void SetPickType(int pickType_)
    {
        pickType = pickType_;
        Select(12);
    }

    public void SetDomain(int domain_)
    {
        domain = domain_;
        Select(13);
    }

    public void SetElementNumber(int elementNumber_)
    {
        elementNumber = elementNumber_;
        Select(14);
    }

    public void SetIncidentElements(Vector incidentElements_)
    {
        incidentElements = incidentElements_;
        Select(15);
    }

    public void SetCellCoordinates(Vector cellCoordinates_)
    {
        cellCoordinates = cellCoordinates_;
        Select(16);
    }

    public void SetTimeStep(int timeStep_)
    {
        timeStep = timeStep_;
        Select(17);
    }

    public void SetDimension(int dimension_)
    {
        dimension = dimension_;
        Select(18);
    }

    public void SetDatabaseName(String databaseName_)
    {
        databaseName = databaseName_;
        Select(19);
    }

    public void SetActiveVariable(String activeVariable_)
    {
        activeVariable = activeVariable_;
        Select(20);
    }

    public void SetPickPoint(double[] pickPoint_)
    {
        pickPoint[0] = pickPoint_[0];
        pickPoint[1] = pickPoint_[1];
        pickPoint[2] = pickPoint_[2];
        Select(21);
    }

    public void SetPickPoint(double e0, double e1, double e2)
    {
        pickPoint[0] = e0;
        pickPoint[1] = e1;
        pickPoint[2] = e2;
        Select(21);
    }

    public void SetCellPoint(double[] cellPoint_)
    {
        cellPoint[0] = cellPoint_[0];
        cellPoint[1] = cellPoint_[1];
        cellPoint[2] = cellPoint_[2];
        Select(22);
    }

    public void SetCellPoint(double e0, double e1, double e2)
    {
        cellPoint[0] = e0;
        cellPoint[1] = e1;
        cellPoint[2] = e2;
        Select(22);
    }

    public void SetNodePoint(double[] nodePoint_)
    {
        nodePoint[0] = nodePoint_[0];
        nodePoint[1] = nodePoint_[1];
        nodePoint[2] = nodePoint_[2];
        Select(23);
    }

    public void SetNodePoint(double e0, double e1, double e2)
    {
        nodePoint[0] = e0;
        nodePoint[1] = e1;
        nodePoint[2] = e2;
        Select(23);
    }

    public void SetPlotBounds(Vector plotBounds_)
    {
        plotBounds = plotBounds_;
        Select(24);
    }

    public void SetRayPoint1(double[] rayPoint1_)
    {
        rayPoint1[0] = rayPoint1_[0];
        rayPoint1[1] = rayPoint1_[1];
        rayPoint1[2] = rayPoint1_[2];
        Select(25);
    }

    public void SetRayPoint1(double e0, double e1, double e2)
    {
        rayPoint1[0] = e0;
        rayPoint1[1] = e1;
        rayPoint1[2] = e2;
        Select(25);
    }

    public void SetRayPoint2(double[] rayPoint2_)
    {
        rayPoint2[0] = rayPoint2_[0];
        rayPoint2[1] = rayPoint2_[1];
        rayPoint2[2] = rayPoint2_[2];
        Select(26);
    }

    public void SetRayPoint2(double e0, double e1, double e2)
    {
        rayPoint2[0] = e0;
        rayPoint2[1] = e1;
        rayPoint2[2] = e2;
        Select(26);
    }

    public void SetMeshInfo(String meshInfo_)
    {
        meshInfo = meshInfo_;
        Select(27);
    }

    public void SetRealElementNumber(int realElementNumber_)
    {
        realElementNumber = realElementNumber_;
        Select(28);
    }

    public void SetRealIncidentElements(Vector realIncidentElements_)
    {
        realIncidentElements = realIncidentElements_;
        Select(29);
    }

    public void SetPnodeCoords(Vector pnodeCoords_)
    {
        pnodeCoords = pnodeCoords_;
        Select(30);
    }

    public void SetDnodeCoords(Vector dnodeCoords_)
    {
        dnodeCoords = dnodeCoords_;
        Select(31);
    }

    public void SetBnodeCoords(Vector bnodeCoords_)
    {
        bnodeCoords = bnodeCoords_;
        Select(32);
    }

    public void SetDzoneCoords(Vector dzoneCoords_)
    {
        dzoneCoords = dzoneCoords_;
        Select(33);
    }

    public void SetBzoneCoords(Vector bzoneCoords_)
    {
        bzoneCoords = bzoneCoords_;
        Select(34);
    }

    public void SetNeedTransformMessage(boolean needTransformMessage_)
    {
        needTransformMessage = needTransformMessage_;
        Select(35);
    }

    public void SetInvalidVars(Vector invalidVars_)
    {
        invalidVars = invalidVars_;
        Select(37);
    }

    public void SetDoTimeCurve(boolean doTimeCurve_)
    {
        doTimeCurve = doTimeCurve_;
        Select(38);
    }

    public void SetErrorMessage(String errorMessage_)
    {
        errorMessage = errorMessage_;
        Select(39);
    }

    public void SetError(boolean error_)
    {
        error = error_;
        Select(40);
    }

    public void SetMatSelected(boolean matSelected_)
    {
        matSelected = matSelected_;
        Select(41);
    }

    public void SetNeedActualCoords(boolean needActualCoords_)
    {
        needActualCoords = needActualCoords_;
        Select(42);
    }

    public void SetConciseOutput(boolean conciseOutput_)
    {
        conciseOutput = conciseOutput_;
        Select(43);
    }

    public void SetShowTimeStep(boolean showTimeStep_)
    {
        showTimeStep = showTimeStep_;
        Select(44);
    }

    public void SetShowMeshName(boolean showMeshName_)
    {
        showMeshName = showMeshName_;
        Select(45);
    }

    public void SetBlockPieceName(String blockPieceName_)
    {
        blockPieceName = blockPieceName_;
        Select(46);
    }

    public void SetGroupPieceName(String groupPieceName_)
    {
        groupPieceName = groupPieceName_;
        Select(47);
    }

    public void SetGhosts(Vector ghosts_)
    {
        ghosts = ghosts_;
        Select(48);
    }

    public void SetIncludeGhosts(boolean includeGhosts_)
    {
        includeGhosts = includeGhosts_;
        Select(49);
    }

    public void SetElementIsGhost(boolean elementIsGhost_)
    {
        elementIsGhost = elementIsGhost_;
        Select(50);
    }

    public void SetRequiresGlyphPick(boolean requiresGlyphPick_)
    {
        requiresGlyphPick = requiresGlyphPick_;
        Select(51);
    }

    public void SetLocationSuccessful(boolean locationSuccessful_)
    {
        locationSuccessful = locationSuccessful_;
        Select(52);
    }

    public void SetUseLabelAsPickLetter(boolean useLabelAsPickLetter_)
    {
        useLabelAsPickLetter = useLabelAsPickLetter_;
        Select(53);
    }

    public void SetShowGlobalIds(boolean showGlobalIds_)
    {
        showGlobalIds = showGlobalIds_;
        Select(54);
    }

    public void SetGlobalElement(int globalElement_)
    {
        globalElement = globalElement_;
        Select(55);
    }

    public void SetGlobalIncidentElements(Vector globalIncidentElements_)
    {
        globalIncidentElements = globalIncidentElements_;
        Select(56);
    }

    public void SetElementIsGlobal(boolean elementIsGlobal_)
    {
        elementIsGlobal = elementIsGlobal_;
        Select(57);
    }

    public void SetShowPickLetter(boolean showPickLetter_)
    {
        showPickLetter = showPickLetter_;
        Select(58);
    }

    public void SetHasRangeOutput(boolean hasRangeOutput_)
    {
        hasRangeOutput = hasRangeOutput_;
        Select(59);
    }

    public void SetRangeOutput(MapNode rangeOutput_)
    {
        rangeOutput = rangeOutput_;
        Select(60);
    }

    public void SetElementLabel(String elementLabel_)
    {
        elementLabel = elementLabel_;
        Select(61);
    }

    public void SetReusePickLetter(boolean reusePickLetter_)
    {
        reusePickLetter = reusePickLetter_;
        Select(62);
    }

    public void SetGhostType(int ghostType_)
    {
        ghostType = ghostType_;
        Select(63);
    }

    public void SetHasMixedGhostTypes(int hasMixedGhostTypes_)
    {
        hasMixedGhostTypes = hasMixedGhostTypes_;
        Select(64);
    }

    public void SetLinesData(boolean linesData_)
    {
        linesData = linesData_;
        Select(65);
    }

    public void SetShowPickHighlight(boolean showPickHighlight_)
    {
        showPickHighlight = showPickHighlight_;
        Select(66);
    }

    public void SetNotifyEnabled(boolean notifyEnabled_)
    {
        notifyEnabled = notifyEnabled_;
        Select(67);
    }

    public void SetInputTopoDim(int inputTopoDim_)
    {
        inputTopoDim = inputTopoDim_;
        Select(68);
    }

    public void SetMeshCoordType(int meshCoordType_)
    {
        meshCoordType = meshCoordType_;
        Select(69);
    }

    public void SetCreateSpreadsheet(boolean createSpreadsheet_)
    {
        createSpreadsheet = createSpreadsheet_;
        Select(70);
    }

    public void SetSubsetName(String subsetName_)
    {
        subsetName = subsetName_;
        Select(71);
    }

    public void SetFloatFormat(String floatFormat_)
    {
        floatFormat = floatFormat_;
        Select(72);
    }

    public void SetTimePreserveCoord(boolean timePreserveCoord_)
    {
        timePreserveCoord = timePreserveCoord_;
        Select(73);
    }

    public void SetTimeCurveType(int timeCurveType_)
    {
        timeCurveType = timeCurveType_;
        Select(74);
    }

    public void SetTimeOptions(MapNode timeOptions_)
    {
        timeOptions = timeOptions_;
        Select(75);
    }

    public void SetPlotRequested(MapNode plotRequested_)
    {
        plotRequested = plotRequested_;
        Select(76);
    }

    // Property getting methods
    public Vector   GetVariables() { return variables; }
    public boolean  GetShowIncidentElements() { return showIncidentElements; }
    public boolean  GetShowNodeId() { return showNodeId; }
    public boolean  GetShowNodeDomainLogicalCoords() { return showNodeDomainLogicalCoords; }
    public boolean  GetShowNodeBlockLogicalCoords() { return showNodeBlockLogicalCoords; }
    public boolean  GetShowNodePhysicalCoords() { return showNodePhysicalCoords; }
    public boolean  GetShowZoneId() { return showZoneId; }
    public boolean  GetShowZoneDomainLogicalCoords() { return showZoneDomainLogicalCoords; }
    public boolean  GetShowZoneBlockLogicalCoords() { return showZoneBlockLogicalCoords; }
    public boolean  GetClearWindow() { return clearWindow; }
    public String   GetPickLetter() { return pickLetter; }
    public boolean  GetFulfilled() { return fulfilled; }
    public int      GetPickType() { return pickType; }
    public int      GetDomain() { return domain; }
    public int      GetElementNumber() { return elementNumber; }
    public Vector   GetIncidentElements() { return incidentElements; }
    public Vector   GetCellCoordinates() { return cellCoordinates; }
    public int      GetTimeStep() { return timeStep; }
    public int      GetDimension() { return dimension; }
    public String   GetDatabaseName() { return databaseName; }
    public String   GetActiveVariable() { return activeVariable; }
    public double[] GetPickPoint() { return pickPoint; }
    public double[] GetCellPoint() { return cellPoint; }
    public double[] GetNodePoint() { return nodePoint; }
    public Vector   GetPlotBounds() { return plotBounds; }
    public double[] GetRayPoint1() { return rayPoint1; }
    public double[] GetRayPoint2() { return rayPoint2; }
    public String   GetMeshInfo() { return meshInfo; }
    public int      GetRealElementNumber() { return realElementNumber; }
    public Vector   GetRealIncidentElements() { return realIncidentElements; }
    public Vector   GetPnodeCoords() { return pnodeCoords; }
    public Vector   GetDnodeCoords() { return dnodeCoords; }
    public Vector   GetBnodeCoords() { return bnodeCoords; }
    public Vector   GetDzoneCoords() { return dzoneCoords; }
    public Vector   GetBzoneCoords() { return bzoneCoords; }
    public boolean  GetNeedTransformMessage() { return needTransformMessage; }
    public Vector   GetVarInfo() { return varInfo; }
    public Vector   GetInvalidVars() { return invalidVars; }
    public boolean  GetDoTimeCurve() { return doTimeCurve; }
    public String   GetErrorMessage() { return errorMessage; }
    public boolean  GetError() { return error; }
    public boolean  GetMatSelected() { return matSelected; }
    public boolean  GetNeedActualCoords() { return needActualCoords; }
    public boolean  GetConciseOutput() { return conciseOutput; }
    public boolean  GetShowTimeStep() { return showTimeStep; }
    public boolean  GetShowMeshName() { return showMeshName; }
    public String   GetBlockPieceName() { return blockPieceName; }
    public String   GetGroupPieceName() { return groupPieceName; }
    public Vector   GetGhosts() { return ghosts; }
    public boolean  GetIncludeGhosts() { return includeGhosts; }
    public boolean  GetElementIsGhost() { return elementIsGhost; }
    public boolean  GetRequiresGlyphPick() { return requiresGlyphPick; }
    public boolean  GetLocationSuccessful() { return locationSuccessful; }
    public boolean  GetUseLabelAsPickLetter() { return useLabelAsPickLetter; }
    public boolean  GetShowGlobalIds() { return showGlobalIds; }
    public int      GetGlobalElement() { return globalElement; }
    public Vector   GetGlobalIncidentElements() { return globalIncidentElements; }
    public boolean  GetElementIsGlobal() { return elementIsGlobal; }
    public boolean  GetShowPickLetter() { return showPickLetter; }
    public boolean  GetHasRangeOutput() { return hasRangeOutput; }
    public MapNode  GetRangeOutput() { return rangeOutput; }
    public String   GetElementLabel() { return elementLabel; }
    public boolean  GetReusePickLetter() { return reusePickLetter; }
    public int      GetGhostType() { return ghostType; }
    public int      GetHasMixedGhostTypes() { return hasMixedGhostTypes; }
    public boolean  GetLinesData() { return linesData; }
    public boolean  GetShowPickHighlight() { return showPickHighlight; }
    public boolean  GetNotifyEnabled() { return notifyEnabled; }
    public int      GetInputTopoDim() { return inputTopoDim; }
    public int      GetMeshCoordType() { return meshCoordType; }
    public boolean  GetCreateSpreadsheet() { return createSpreadsheet; }
    public String   GetSubsetName() { return subsetName; }
    public String   GetFloatFormat() { return floatFormat; }
    public boolean  GetTimePreserveCoord() { return timePreserveCoord; }
    public int      GetTimeCurveType() { return timeCurveType; }
    public MapNode  GetTimeOptions() { return timeOptions; }
    public MapNode  GetPlotRequested() { return plotRequested; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteStringVector(variables);
        if(WriteSelect(1, buf))
            buf.WriteBool(showIncidentElements);
        if(WriteSelect(2, buf))
            buf.WriteBool(showNodeId);
        if(WriteSelect(3, buf))
            buf.WriteBool(showNodeDomainLogicalCoords);
        if(WriteSelect(4, buf))
            buf.WriteBool(showNodeBlockLogicalCoords);
        if(WriteSelect(5, buf))
            buf.WriteBool(showNodePhysicalCoords);
        if(WriteSelect(6, buf))
            buf.WriteBool(showZoneId);
        if(WriteSelect(7, buf))
            buf.WriteBool(showZoneDomainLogicalCoords);
        if(WriteSelect(8, buf))
            buf.WriteBool(showZoneBlockLogicalCoords);
        if(WriteSelect(9, buf))
            buf.WriteBool(clearWindow);
        if(WriteSelect(10, buf))
            buf.WriteString(pickLetter);
        if(WriteSelect(11, buf))
            buf.WriteBool(fulfilled);
        if(WriteSelect(12, buf))
            buf.WriteInt(pickType);
        if(WriteSelect(13, buf))
            buf.WriteInt(domain);
        if(WriteSelect(14, buf))
            buf.WriteInt(elementNumber);
        if(WriteSelect(15, buf))
            buf.WriteIntVector(incidentElements);
        if(WriteSelect(16, buf))
            buf.WriteDoubleVector(cellCoordinates);
        if(WriteSelect(17, buf))
            buf.WriteInt(timeStep);
        if(WriteSelect(18, buf))
            buf.WriteInt(dimension);
        if(WriteSelect(19, buf))
            buf.WriteString(databaseName);
        if(WriteSelect(20, buf))
            buf.WriteString(activeVariable);
        if(WriteSelect(21, buf))
            buf.WriteDoubleArray(pickPoint);
        if(WriteSelect(22, buf))
            buf.WriteDoubleArray(cellPoint);
        if(WriteSelect(23, buf))
            buf.WriteDoubleArray(nodePoint);
        if(WriteSelect(24, buf))
            buf.WriteDoubleVector(plotBounds);
        if(WriteSelect(25, buf))
            buf.WriteDoubleArray(rayPoint1);
        if(WriteSelect(26, buf))
            buf.WriteDoubleArray(rayPoint2);
        if(WriteSelect(27, buf))
            buf.WriteString(meshInfo);
        if(WriteSelect(28, buf))
            buf.WriteInt(realElementNumber);
        if(WriteSelect(29, buf))
            buf.WriteIntVector(realIncidentElements);
        if(WriteSelect(30, buf))
            buf.WriteStringVector(pnodeCoords);
        if(WriteSelect(31, buf))
            buf.WriteStringVector(dnodeCoords);
        if(WriteSelect(32, buf))
            buf.WriteStringVector(bnodeCoords);
        if(WriteSelect(33, buf))
            buf.WriteStringVector(dzoneCoords);
        if(WriteSelect(34, buf))
            buf.WriteStringVector(bzoneCoords);
        if(WriteSelect(35, buf))
            buf.WriteBool(needTransformMessage);
        if(WriteSelect(36, buf))
        {
            buf.WriteInt(varInfo.size());
            for(int i = 0; i < varInfo.size(); ++i)
            {
                PickVarInfo tmp = (PickVarInfo)varInfo.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(37, buf))
            buf.WriteStringVector(invalidVars);
        if(WriteSelect(38, buf))
            buf.WriteBool(doTimeCurve);
        if(WriteSelect(39, buf))
            buf.WriteString(errorMessage);
        if(WriteSelect(40, buf))
            buf.WriteBool(error);
        if(WriteSelect(41, buf))
            buf.WriteBool(matSelected);
        if(WriteSelect(42, buf))
            buf.WriteBool(needActualCoords);
        if(WriteSelect(43, buf))
            buf.WriteBool(conciseOutput);
        if(WriteSelect(44, buf))
            buf.WriteBool(showTimeStep);
        if(WriteSelect(45, buf))
            buf.WriteBool(showMeshName);
        if(WriteSelect(46, buf))
            buf.WriteString(blockPieceName);
        if(WriteSelect(47, buf))
            buf.WriteString(groupPieceName);
        if(WriteSelect(48, buf))
            buf.WriteIntVector(ghosts);
        if(WriteSelect(49, buf))
            buf.WriteBool(includeGhosts);
        if(WriteSelect(50, buf))
            buf.WriteBool(elementIsGhost);
        if(WriteSelect(51, buf))
            buf.WriteBool(requiresGlyphPick);
        if(WriteSelect(52, buf))
            buf.WriteBool(locationSuccessful);
        if(WriteSelect(53, buf))
            buf.WriteBool(useLabelAsPickLetter);
        if(WriteSelect(54, buf))
            buf.WriteBool(showGlobalIds);
        if(WriteSelect(55, buf))
            buf.WriteInt(globalElement);
        if(WriteSelect(56, buf))
            buf.WriteIntVector(globalIncidentElements);
        if(WriteSelect(57, buf))
            buf.WriteBool(elementIsGlobal);
        if(WriteSelect(58, buf))
            buf.WriteBool(showPickLetter);
        if(WriteSelect(59, buf))
            buf.WriteBool(hasRangeOutput);
        if(WriteSelect(60, buf))
            rangeOutput.Write(buf);
        if(WriteSelect(61, buf))
            buf.WriteString(elementLabel);
        if(WriteSelect(62, buf))
            buf.WriteBool(reusePickLetter);
        if(WriteSelect(63, buf))
            buf.WriteInt(ghostType);
        if(WriteSelect(64, buf))
            buf.WriteInt(hasMixedGhostTypes);
        if(WriteSelect(65, buf))
            buf.WriteBool(linesData);
        if(WriteSelect(66, buf))
            buf.WriteBool(showPickHighlight);
        if(WriteSelect(67, buf))
            buf.WriteBool(notifyEnabled);
        if(WriteSelect(68, buf))
            buf.WriteInt(inputTopoDim);
        if(WriteSelect(69, buf))
            buf.WriteInt(meshCoordType);
        if(WriteSelect(70, buf))
            buf.WriteBool(createSpreadsheet);
        if(WriteSelect(71, buf))
            buf.WriteString(subsetName);
        if(WriteSelect(72, buf))
            buf.WriteString(floatFormat);
        if(WriteSelect(73, buf))
            buf.WriteBool(timePreserveCoord);
        if(WriteSelect(74, buf))
            buf.WriteInt(timeCurveType);
        if(WriteSelect(75, buf))
            timeOptions.Write(buf);
        if(WriteSelect(76, buf))
            plotRequested.Write(buf);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetVariables(buf.ReadStringVector());
            break;
        case 1:
            SetShowIncidentElements(buf.ReadBool());
            break;
        case 2:
            SetShowNodeId(buf.ReadBool());
            break;
        case 3:
            SetShowNodeDomainLogicalCoords(buf.ReadBool());
            break;
        case 4:
            SetShowNodeBlockLogicalCoords(buf.ReadBool());
            break;
        case 5:
            SetShowNodePhysicalCoords(buf.ReadBool());
            break;
        case 6:
            SetShowZoneId(buf.ReadBool());
            break;
        case 7:
            SetShowZoneDomainLogicalCoords(buf.ReadBool());
            break;
        case 8:
            SetShowZoneBlockLogicalCoords(buf.ReadBool());
            break;
        case 9:
            SetClearWindow(buf.ReadBool());
            break;
        case 10:
            SetPickLetter(buf.ReadString());
            break;
        case 11:
            SetFulfilled(buf.ReadBool());
            break;
        case 12:
            SetPickType(buf.ReadInt());
            break;
        case 13:
            SetDomain(buf.ReadInt());
            break;
        case 14:
            SetElementNumber(buf.ReadInt());
            break;
        case 15:
            SetIncidentElements(buf.ReadIntVector());
            break;
        case 16:
            SetCellCoordinates(buf.ReadDoubleVector());
            break;
        case 17:
            SetTimeStep(buf.ReadInt());
            break;
        case 18:
            SetDimension(buf.ReadInt());
            break;
        case 19:
            SetDatabaseName(buf.ReadString());
            break;
        case 20:
            SetActiveVariable(buf.ReadString());
            break;
        case 21:
            SetPickPoint(buf.ReadDoubleArray());
            break;
        case 22:
            SetCellPoint(buf.ReadDoubleArray());
            break;
        case 23:
            SetNodePoint(buf.ReadDoubleArray());
            break;
        case 24:
            SetPlotBounds(buf.ReadDoubleVector());
            break;
        case 25:
            SetRayPoint1(buf.ReadDoubleArray());
            break;
        case 26:
            SetRayPoint2(buf.ReadDoubleArray());
            break;
        case 27:
            SetMeshInfo(buf.ReadString());
            break;
        case 28:
            SetRealElementNumber(buf.ReadInt());
            break;
        case 29:
            SetRealIncidentElements(buf.ReadIntVector());
            break;
        case 30:
            SetPnodeCoords(buf.ReadStringVector());
            break;
        case 31:
            SetDnodeCoords(buf.ReadStringVector());
            break;
        case 32:
            SetBnodeCoords(buf.ReadStringVector());
            break;
        case 33:
            SetDzoneCoords(buf.ReadStringVector());
            break;
        case 34:
            SetBzoneCoords(buf.ReadStringVector());
            break;
        case 35:
            SetNeedTransformMessage(buf.ReadBool());
            break;
        case 36:
            {
                int len = buf.ReadInt();
                varInfo.clear();
                for(int j = 0; j < len; ++j)
                {
                    PickVarInfo tmp = new PickVarInfo();
                    tmp.Read(buf);
                    varInfo.addElement(tmp);
                }
            }
            Select(36);
            break;
        case 37:
            SetInvalidVars(buf.ReadStringVector());
            break;
        case 38:
            SetDoTimeCurve(buf.ReadBool());
            break;
        case 39:
            SetErrorMessage(buf.ReadString());
            break;
        case 40:
            SetError(buf.ReadBool());
            break;
        case 41:
            SetMatSelected(buf.ReadBool());
            break;
        case 42:
            SetNeedActualCoords(buf.ReadBool());
            break;
        case 43:
            SetConciseOutput(buf.ReadBool());
            break;
        case 44:
            SetShowTimeStep(buf.ReadBool());
            break;
        case 45:
            SetShowMeshName(buf.ReadBool());
            break;
        case 46:
            SetBlockPieceName(buf.ReadString());
            break;
        case 47:
            SetGroupPieceName(buf.ReadString());
            break;
        case 48:
            SetGhosts(buf.ReadIntVector());
            break;
        case 49:
            SetIncludeGhosts(buf.ReadBool());
            break;
        case 50:
            SetElementIsGhost(buf.ReadBool());
            break;
        case 51:
            SetRequiresGlyphPick(buf.ReadBool());
            break;
        case 52:
            SetLocationSuccessful(buf.ReadBool());
            break;
        case 53:
            SetUseLabelAsPickLetter(buf.ReadBool());
            break;
        case 54:
            SetShowGlobalIds(buf.ReadBool());
            break;
        case 55:
            SetGlobalElement(buf.ReadInt());
            break;
        case 56:
            SetGlobalIncidentElements(buf.ReadIntVector());
            break;
        case 57:
            SetElementIsGlobal(buf.ReadBool());
            break;
        case 58:
            SetShowPickLetter(buf.ReadBool());
            break;
        case 59:
            SetHasRangeOutput(buf.ReadBool());
            break;
        case 60:
            rangeOutput.Read(buf);
            break;
        case 61:
            SetElementLabel(buf.ReadString());
            break;
        case 62:
            SetReusePickLetter(buf.ReadBool());
            break;
        case 63:
            SetGhostType(buf.ReadInt());
            break;
        case 64:
            SetHasMixedGhostTypes(buf.ReadInt());
            break;
        case 65:
            SetLinesData(buf.ReadBool());
            break;
        case 66:
            SetShowPickHighlight(buf.ReadBool());
            break;
        case 67:
            SetNotifyEnabled(buf.ReadBool());
            break;
        case 68:
            SetInputTopoDim(buf.ReadInt());
            break;
        case 69:
            SetMeshCoordType(buf.ReadInt());
            break;
        case 70:
            SetCreateSpreadsheet(buf.ReadBool());
            break;
        case 71:
            SetSubsetName(buf.ReadString());
            break;
        case 72:
            SetFloatFormat(buf.ReadString());
            break;
        case 73:
            SetTimePreserveCoord(buf.ReadBool());
            break;
        case 74:
            SetTimeCurveType(buf.ReadInt());
            break;
        case 75:
            timeOptions.Read(buf);
            break;
        case 76:
            plotRequested.Read(buf);
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringVectorToString("variables", variables, indent) + "\n";
        str = str + boolToString("showIncidentElements", showIncidentElements, indent) + "\n";
        str = str + boolToString("showNodeId", showNodeId, indent) + "\n";
        str = str + boolToString("showNodeDomainLogicalCoords", showNodeDomainLogicalCoords, indent) + "\n";
        str = str + boolToString("showNodeBlockLogicalCoords", showNodeBlockLogicalCoords, indent) + "\n";
        str = str + boolToString("showNodePhysicalCoords", showNodePhysicalCoords, indent) + "\n";
        str = str + boolToString("showZoneId", showZoneId, indent) + "\n";
        str = str + boolToString("showZoneDomainLogicalCoords", showZoneDomainLogicalCoords, indent) + "\n";
        str = str + boolToString("showZoneBlockLogicalCoords", showZoneBlockLogicalCoords, indent) + "\n";
        str = str + boolToString("clearWindow", clearWindow, indent) + "\n";
        str = str + stringToString("pickLetter", pickLetter, indent) + "\n";
        str = str + boolToString("fulfilled", fulfilled, indent) + "\n";
        str = str + indent + "pickType = ";
        if(pickType == PICKTYPE_ZONE)
            str = str + "PICKTYPE_ZONE";
        if(pickType == PICKTYPE_NODE)
            str = str + "PICKTYPE_NODE";
        if(pickType == PICKTYPE_CURVEZONE)
            str = str + "PICKTYPE_CURVEZONE";
        if(pickType == PICKTYPE_CURVENODE)
            str = str + "PICKTYPE_CURVENODE";
        if(pickType == PICKTYPE_DOMAINZONE)
            str = str + "PICKTYPE_DOMAINZONE";
        if(pickType == PICKTYPE_DOMAINNODE)
            str = str + "PICKTYPE_DOMAINNODE";
        if(pickType == PICKTYPE_ZONELABEL)
            str = str + "PICKTYPE_ZONELABEL";
        if(pickType == PICKTYPE_NODELABEL)
            str = str + "PICKTYPE_NODELABEL";
        str = str + "\n";
        str = str + intToString("domain", domain, indent) + "\n";
        str = str + intToString("elementNumber", elementNumber, indent) + "\n";
        str = str + intVectorToString("incidentElements", incidentElements, indent) + "\n";
        str = str + doubleVectorToString("cellCoordinates", cellCoordinates, indent) + "\n";
        str = str + intToString("timeStep", timeStep, indent) + "\n";
        str = str + intToString("dimension", dimension, indent) + "\n";
        str = str + stringToString("databaseName", databaseName, indent) + "\n";
        str = str + stringToString("activeVariable", activeVariable, indent) + "\n";
        str = str + doubleArrayToString("pickPoint", pickPoint, indent) + "\n";
        str = str + doubleArrayToString("cellPoint", cellPoint, indent) + "\n";
        str = str + doubleArrayToString("nodePoint", nodePoint, indent) + "\n";
        str = str + doubleVectorToString("plotBounds", plotBounds, indent) + "\n";
        str = str + doubleArrayToString("rayPoint1", rayPoint1, indent) + "\n";
        str = str + doubleArrayToString("rayPoint2", rayPoint2, indent) + "\n";
        str = str + stringToString("meshInfo", meshInfo, indent) + "\n";
        str = str + intToString("realElementNumber", realElementNumber, indent) + "\n";
        str = str + intVectorToString("realIncidentElements", realIncidentElements, indent) + "\n";
        str = str + stringVectorToString("pnodeCoords", pnodeCoords, indent) + "\n";
        str = str + stringVectorToString("dnodeCoords", dnodeCoords, indent) + "\n";
        str = str + stringVectorToString("bnodeCoords", bnodeCoords, indent) + "\n";
        str = str + stringVectorToString("dzoneCoords", dzoneCoords, indent) + "\n";
        str = str + stringVectorToString("bzoneCoords", bzoneCoords, indent) + "\n";
        str = str + boolToString("needTransformMessage", needTransformMessage, indent) + "\n";
        str = str + indent + "varInfo = {\n";
        for(int i = 0; i < varInfo.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)varInfo.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < varInfo.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + stringVectorToString("invalidVars", invalidVars, indent) + "\n";
        str = str + boolToString("doTimeCurve", doTimeCurve, indent) + "\n";
        str = str + stringToString("errorMessage", errorMessage, indent) + "\n";
        str = str + boolToString("error", error, indent) + "\n";
        str = str + boolToString("matSelected", matSelected, indent) + "\n";
        str = str + boolToString("needActualCoords", needActualCoords, indent) + "\n";
        str = str + boolToString("conciseOutput", conciseOutput, indent) + "\n";
        str = str + boolToString("showTimeStep", showTimeStep, indent) + "\n";
        str = str + boolToString("showMeshName", showMeshName, indent) + "\n";
        str = str + stringToString("blockPieceName", blockPieceName, indent) + "\n";
        str = str + stringToString("groupPieceName", groupPieceName, indent) + "\n";
        str = str + intVectorToString("ghosts", ghosts, indent) + "\n";
        str = str + boolToString("includeGhosts", includeGhosts, indent) + "\n";
        str = str + boolToString("elementIsGhost", elementIsGhost, indent) + "\n";
        str = str + boolToString("requiresGlyphPick", requiresGlyphPick, indent) + "\n";
        str = str + boolToString("locationSuccessful", locationSuccessful, indent) + "\n";
        str = str + boolToString("useLabelAsPickLetter", useLabelAsPickLetter, indent) + "\n";
        str = str + boolToString("showGlobalIds", showGlobalIds, indent) + "\n";
        str = str + intToString("globalElement", globalElement, indent) + "\n";
        str = str + intVectorToString("globalIncidentElements", globalIncidentElements, indent) + "\n";
        str = str + boolToString("elementIsGlobal", elementIsGlobal, indent) + "\n";
        str = str + boolToString("showPickLetter", showPickLetter, indent) + "\n";
        str = str + boolToString("hasRangeOutput", hasRangeOutput, indent) + "\n";
        str = str + indent + "rangeOutput = " + rangeOutput.toString(indent);
        str = str + stringToString("elementLabel", elementLabel, indent) + "\n";
        str = str + boolToString("reusePickLetter", reusePickLetter, indent) + "\n";
        str = str + intToString("ghostType", ghostType, indent) + "\n";
        str = str + intToString("hasMixedGhostTypes", hasMixedGhostTypes, indent) + "\n";
        str = str + boolToString("linesData", linesData, indent) + "\n";
        str = str + boolToString("showPickHighlight", showPickHighlight, indent) + "\n";
        str = str + boolToString("notifyEnabled", notifyEnabled, indent) + "\n";
        str = str + intToString("inputTopoDim", inputTopoDim, indent) + "\n";
        str = str + indent + "meshCoordType = ";
        if(meshCoordType == COORDINATETYPE_XY)
            str = str + "COORDINATETYPE_XY";
        if(meshCoordType == COORDINATETYPE_RZ)
            str = str + "COORDINATETYPE_RZ";
        if(meshCoordType == COORDINATETYPE_ZR)
            str = str + "COORDINATETYPE_ZR";
        str = str + "\n";
        str = str + boolToString("createSpreadsheet", createSpreadsheet, indent) + "\n";
        str = str + stringToString("subsetName", subsetName, indent) + "\n";
        str = str + stringToString("floatFormat", floatFormat, indent) + "\n";
        str = str + boolToString("timePreserveCoord", timePreserveCoord, indent) + "\n";
        str = str + indent + "timeCurveType = ";
        if(timeCurveType == TIMECURVETYPE_SINGLE_Y_AXIS)
            str = str + "TIMECURVETYPE_SINGLE_Y_AXIS";
        if(timeCurveType == TIMECURVETYPE_MULTIPLE_Y_AXES)
            str = str + "TIMECURVETYPE_MULTIPLE_Y_AXES";
        str = str + "\n";
        str = str + indent + "timeOptions = " + timeOptions.toString(indent);
        str = str + indent + "plotRequested = " + plotRequested.toString(indent);
        return str;
    }

    // Attributegroup convenience methods
    public void AddVarInfo(PickVarInfo obj)
    {
        varInfo.addElement(new PickVarInfo(obj));
        Select(36);
    }

    public void ClearVarInfos()
    {
        varInfo.clear();
        Select(36);
    }

    public void RemoveVarInfo(int index)
    {
        if(index >= 0 && index < varInfo.size())
        {
            varInfo.remove(index);
            Select(36);
        }
    }

    public int GetNumVarInfos()
    {
        return varInfo.size();
    }

    public PickVarInfo GetVarInfo(int i)
    {
        PickVarInfo tmp = (PickVarInfo)varInfo.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector   variables; // vector of String objects
    private boolean  showIncidentElements;
    private boolean  showNodeId;
    private boolean  showNodeDomainLogicalCoords;
    private boolean  showNodeBlockLogicalCoords;
    private boolean  showNodePhysicalCoords;
    private boolean  showZoneId;
    private boolean  showZoneDomainLogicalCoords;
    private boolean  showZoneBlockLogicalCoords;
    private boolean  clearWindow;
    private String   pickLetter;
    private boolean  fulfilled;
    private int      pickType;
    private int      domain;
    private int      elementNumber;
    private Vector   incidentElements; // vector of Integer objects
    private Vector   cellCoordinates; // vector of Double objects
    private int      timeStep;
    private int      dimension;
    private String   databaseName;
    private String   activeVariable;
    private double[] pickPoint;
    private double[] cellPoint;
    private double[] nodePoint;
    private Vector   plotBounds; // vector of Double objects
    private double[] rayPoint1;
    private double[] rayPoint2;
    private String   meshInfo;
    private int      realElementNumber;
    private Vector   realIncidentElements; // vector of Integer objects
    private Vector   pnodeCoords; // vector of String objects
    private Vector   dnodeCoords; // vector of String objects
    private Vector   bnodeCoords; // vector of String objects
    private Vector   dzoneCoords; // vector of String objects
    private Vector   bzoneCoords; // vector of String objects
    private boolean  needTransformMessage;
    private Vector   varInfo; // vector of PickVarInfo objects
    private Vector   invalidVars; // vector of String objects
    private boolean  doTimeCurve;
    private String   errorMessage;
    private boolean  error;
    private boolean  matSelected;
    private boolean  needActualCoords;
    private boolean  conciseOutput;
    private boolean  showTimeStep;
    private boolean  showMeshName;
    private String   blockPieceName;
    private String   groupPieceName;
    private Vector   ghosts; // vector of Integer objects
    private boolean  includeGhosts;
    private boolean  elementIsGhost;
    private boolean  requiresGlyphPick;
    private boolean  locationSuccessful;
    private boolean  useLabelAsPickLetter;
    private boolean  showGlobalIds;
    private int      globalElement;
    private Vector   globalIncidentElements; // vector of Integer objects
    private boolean  elementIsGlobal;
    private boolean  showPickLetter;
    private boolean  hasRangeOutput;
    private MapNode  rangeOutput;
    private String   elementLabel;
    private boolean  reusePickLetter;
    private int      ghostType;
    private int      hasMixedGhostTypes;
    private boolean  linesData;
    private boolean  showPickHighlight;
    private boolean  notifyEnabled;
    private int      inputTopoDim;
    private int      meshCoordType;
    private boolean  createSpreadsheet;
    private String   subsetName;
    private String   floatFormat;
    private boolean  timePreserveCoord;
    private int      timeCurveType;
    private MapNode  timeOptions;
    private MapNode  plotRequested;
}

