/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ViewerClientInformationElement.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ViewerClientInformationElement::ViewerClientInformationElement
//
// Purpose: 
//   Init utility for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewerClientInformationElement::Init()
{
    isRaw = false;
    windowId = -1;

    ViewerClientInformationElement::SelectAll();
}

// ****************************************************************************
// Method: ViewerClientInformationElement::ViewerClientInformationElement
//
// Purpose: 
//   Copy utility for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewerClientInformationElement::Copy(const ViewerClientInformationElement &obj)
{
    data = obj.data;
    rawData = obj.rawData;
    format = obj.format;
    isRaw = obj.isRaw;
    windowId = obj.windowId;

    ViewerClientInformationElement::SelectAll();
}

// Type map format string
const char *ViewerClientInformationElement::TypeMapFormatString = VIEWERCLIENTINFORMATIONELEMENT_TMFS;
const AttributeGroup::private_tmfs_t ViewerClientInformationElement::TmfsStruct = {VIEWERCLIENTINFORMATIONELEMENT_TMFS};


// ****************************************************************************
// Method: ViewerClientInformationElement::ViewerClientInformationElement
//
// Purpose: 
//   Default constructor for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientInformationElement::ViewerClientInformationElement() : 
    AttributeSubject(ViewerClientInformationElement::TypeMapFormatString)
{
    ViewerClientInformationElement::Init();
}

// ****************************************************************************
// Method: ViewerClientInformationElement::ViewerClientInformationElement
//
// Purpose: 
//   Constructor for the derived classes of ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientInformationElement::ViewerClientInformationElement(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewerClientInformationElement::Init();
}

// ****************************************************************************
// Method: ViewerClientInformationElement::ViewerClientInformationElement
//
// Purpose: 
//   Copy constructor for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientInformationElement::ViewerClientInformationElement(const ViewerClientInformationElement &obj) : 
    AttributeSubject(ViewerClientInformationElement::TypeMapFormatString)
{
    ViewerClientInformationElement::Copy(obj);
}

// ****************************************************************************
// Method: ViewerClientInformationElement::ViewerClientInformationElement
//
// Purpose: 
//   Copy constructor for derived classes of the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientInformationElement::ViewerClientInformationElement(const ViewerClientInformationElement &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewerClientInformationElement::Copy(obj);
}

// ****************************************************************************
// Method: ViewerClientInformationElement::~ViewerClientInformationElement
//
// Purpose: 
//   Destructor for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientInformationElement::~ViewerClientInformationElement()
{
    // nothing here
}

// ****************************************************************************
// Method: ViewerClientInformationElement::operator = 
//
// Purpose: 
//   Assignment operator for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientInformationElement& 
ViewerClientInformationElement::operator = (const ViewerClientInformationElement &obj)
{
    if (this == &obj) return *this;

    ViewerClientInformationElement::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ViewerClientInformationElement::operator == 
//
// Purpose: 
//   Comparison operator == for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientInformationElement::operator == (const ViewerClientInformationElement &obj) const
{
    // Create the return value
    return ((data == obj.data) &&
            (rawData == obj.rawData) &&
            (format == obj.format) &&
            (isRaw == obj.isRaw) &&
            (windowId == obj.windowId));
}

// ****************************************************************************
// Method: ViewerClientInformationElement::operator != 
//
// Purpose: 
//   Comparison operator != for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientInformationElement::operator != (const ViewerClientInformationElement &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ViewerClientInformationElement::TypeName
//
// Purpose: 
//   Type name method for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ViewerClientInformationElement::TypeName() const
{
    return "ViewerClientInformationElement";
}

// ****************************************************************************
// Method: ViewerClientInformationElement::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientInformationElement::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ViewerClientInformationElement *tmp = (const ViewerClientInformationElement *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ViewerClientInformationElement::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewerClientInformationElement::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ViewerClientInformationElement(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ViewerClientInformationElement::NewInstance
//
// Purpose: 
//   NewInstance method for the ViewerClientInformationElement class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewerClientInformationElement::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ViewerClientInformationElement(*this);
    else
        retval = new ViewerClientInformationElement;

    return retval;
}

// ****************************************************************************
// Method: ViewerClientInformationElement::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewerClientInformationElement::SelectAll()
{
    Select(ID_data,     (void *)&data);
    Select(ID_rawData,  (void *)&rawData);
    Select(ID_format,   (void *)&format);
    Select(ID_isRaw,    (void *)&isRaw);
    Select(ID_windowId, (void *)&windowId);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerClientInformationElement::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientInformationElement::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ViewerClientInformationElement defaultObject;
    bool addToParent = false;
    // Create a node for ViewerClientInformationElement.
    DataNode *node = new DataNode("ViewerClientInformationElement");

    if(completeSave || !FieldsEqual(ID_data, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("data", data));
    }

    if(completeSave || !FieldsEqual(ID_rawData, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("rawData", rawData));
    }

    if(completeSave || !FieldsEqual(ID_format, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("format", format));
    }

    if(completeSave || !FieldsEqual(ID_isRaw, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("isRaw", isRaw));
    }

    if(completeSave || !FieldsEqual(ID_windowId, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("windowId", windowId));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ViewerClientInformationElement::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewerClientInformationElement::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ViewerClientInformationElement");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("data")) != 0)
        SetData(node->AsString());
    if((node = searchNode->GetNode("rawData")) != 0)
        SetRawData(node->AsUnsignedCharVector());
    if((node = searchNode->GetNode("format")) != 0)
        SetFormat(node->AsInt());
    if((node = searchNode->GetNode("isRaw")) != 0)
        SetIsRaw(node->AsBool());
    if((node = searchNode->GetNode("windowId")) != 0)
        SetWindowId(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerClientInformationElement::SetData(const std::string &data_)
{
    data = data_;
    Select(ID_data, (void *)&data);
}

void
ViewerClientInformationElement::SetRawData(const unsignedCharVector &rawData_)
{
    rawData = rawData_;
    Select(ID_rawData, (void *)&rawData);
}

void
ViewerClientInformationElement::SetFormat(int format_)
{
    format = format_;
    Select(ID_format, (void *)&format);
}

void
ViewerClientInformationElement::SetIsRaw(bool isRaw_)
{
    isRaw = isRaw_;
    Select(ID_isRaw, (void *)&isRaw);
}

void
ViewerClientInformationElement::SetWindowId(int windowId_)
{
    windowId = windowId_;
    Select(ID_windowId, (void *)&windowId);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
ViewerClientInformationElement::GetData() const
{
    return data;
}

std::string &
ViewerClientInformationElement::GetData()
{
    return data;
}

const unsignedCharVector &
ViewerClientInformationElement::GetRawData() const
{
    return rawData;
}

unsignedCharVector &
ViewerClientInformationElement::GetRawData()
{
    return rawData;
}

int
ViewerClientInformationElement::GetFormat() const
{
    return format;
}

bool
ViewerClientInformationElement::GetIsRaw() const
{
    return isRaw;
}

int
ViewerClientInformationElement::GetWindowId() const
{
    return windowId;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerClientInformationElement::SelectData()
{
    Select(ID_data, (void *)&data);
}

void
ViewerClientInformationElement::SelectRawData()
{
    Select(ID_rawData, (void *)&rawData);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerClientInformationElement::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewerClientInformationElement::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_data:     return "data";
    case ID_rawData:  return "rawData";
    case ID_format:   return "format";
    case ID_isRaw:    return "isRaw";
    case ID_windowId: return "windowId";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewerClientInformationElement::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ViewerClientInformationElement::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_data:     return FieldType_string;
    case ID_rawData:  return FieldType_ucharVector;
    case ID_format:   return FieldType_int;
    case ID_isRaw:    return FieldType_bool;
    case ID_windowId: return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ViewerClientInformationElement::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewerClientInformationElement::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_data:     return "string";
    case ID_rawData:  return "ucharVector";
    case ID_format:   return "int";
    case ID_isRaw:    return "bool";
    case ID_windowId: return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewerClientInformationElement::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientInformationElement::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ViewerClientInformationElement &obj = *((const ViewerClientInformationElement*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_data:
        {  // new scope
        retval = (data == obj.data);
        }
        break;
    case ID_rawData:
        {  // new scope
        retval = (rawData == obj.rawData);
        }
        break;
    case ID_format:
        {  // new scope
        retval = (format == obj.format);
        }
        break;
    case ID_isRaw:
        {  // new scope
        retval = (isRaw == obj.isRaw);
        }
        break;
    case ID_windowId:
        {  // new scope
        retval = (windowId == obj.windowId);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

